// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanContentrelevancyMetrics_h
#define mozilla_GleanContentrelevancyMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace relevancy_classify {
  /**
   * generated from relevancy.classify.duration
   * Record the duration (in ms) of a successful classification.
   */
  constexpr impl::TimingDistributionMetric duration(4620);

  /**
   * generated from relevancy.classify.fail
   */
  struct FailExtra {
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record an event of a failed / aborted user interest classification.
   */
  constexpr impl::EventMetric<FailExtra> fail(4621);

  /**
   * generated from relevancy.classify.succeed
   */
  struct SucceedExtra {
    mozilla::Maybe<uint32_t> inputClassifiedSize;
    mozilla::Maybe<uint32_t> inputInconclusiveSize;
    mozilla::Maybe<uint32_t> inputSize;
    mozilla::Maybe<uint32_t> interestTop1Hits;
    mozilla::Maybe<uint32_t> interestTop2Hits;
    mozilla::Maybe<uint32_t> interestTop3Hits;
    mozilla::Maybe<uint32_t> outputInterestSize;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (inputClassifiedSize) {
        extraKeys.AppendElement()->AssignASCII("input_classified_size");
        extraValues.AppendElement()->AppendInt(inputClassifiedSize.value());
      }
      if (inputInconclusiveSize) {
        extraKeys.AppendElement()->AssignASCII("input_inconclusive_size");
        extraValues.AppendElement()->AppendInt(inputInconclusiveSize.value());
      }
      if (inputSize) {
        extraKeys.AppendElement()->AssignASCII("input_size");
        extraValues.AppendElement()->AppendInt(inputSize.value());
      }
      if (interestTop1Hits) {
        extraKeys.AppendElement()->AssignASCII("interest_top_1_hits");
        extraValues.AppendElement()->AppendInt(interestTop1Hits.value());
      }
      if (interestTop2Hits) {
        extraKeys.AppendElement()->AssignASCII("interest_top_2_hits");
        extraValues.AppendElement()->AppendInt(interestTop2Hits.value());
      }
      if (interestTop3Hits) {
        extraKeys.AppendElement()->AssignASCII("interest_top_3_hits");
        extraValues.AppendElement()->AppendInt(interestTop3Hits.value());
      }
      if (outputInterestSize) {
        extraKeys.AppendElement()->AssignASCII("output_interest_size");
        extraValues.AppendElement()->AppendInt(outputInterestSize.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record an event of a successful user interest classification.
   */
  constexpr impl::EventMetric<SucceedExtra> succeed(4622);
}

} // namespace mozilla::glean

#endif // mozilla_GleanContentrelevancyMetrics_h
