/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  Anonymous359,
  Anonymous213,
  Anonymous220,
  Anonymous142,
  URILoader,
  Anonymous272,
  Anonymous119,
  Anonymous029,
  Anonymous319,
  Anonymous369,
  Anonymous395,
  Anonymous253,
  Anonymous249,
  Anonymous136,
  Anonymous259,
  Anonymous123,
  Anonymous430,
  Anonymous046,
  Anonymous428,
  Anonymous422,
  Anonymous440,
  Anonymous051,
  Anonymous016,
  Anonymous177,
  Anonymous408,
  StreamConverter,
  Anonymous264,
  CORSPreflightCache,
  Anonymous009,
  CategoryManager,
  Anonymous083,
  Anonymous073,
  Anonymous174,
  Anonymous333,
  Anonymous092,
  Anonymous387,
  Anonymous299,
  ScriptSecurityManager,
  Anonymous195,
  Anonymous231,
  Anonymous417,
  Anonymous088,
  Anonymous011,
  BounceTrackingProtection,
  Anonymous281,
  Anonymous114,
  Anonymous411,
  Anonymous380,
  Anonymous169,
  NSSErrors,
  StringBundle,
  Anonymous241,
  Observer,
  Anonymous219,
  Anonymous108,
  Anonymous205,
  Anonymous339,
  Anonymous067,
  HttpActivityDistributor,
  Anonymous032,
  Anonymous262,
  Anonymous054,
  CaptivePortal,
  Anonymous401,
  Anonymous154,
  Anonymous206,
  Anonymous019,
  Anonymous410,
  AddonContentPolicy,
  Directory,
  Anonymous137,
  Anonymous121,
  Anonymous348,
  Anonymous162,
  Anonymous025,
  Anonymous216,
  Anonymous057,
  Anonymous321,
  Anonymous047,
  Anonymous302,
  Anonymous026,
  Anonymous305,
  Anonymous442,
  Anonymous132,
  ChromeRegistry,
  Anonymous099,
  Anonymous224,
  Anonymous399,
  Anonymous081,
  Anonymous248,
  Anonymous192,
  Anonymous061,
  Anonymous116,
  Anonymous265,
  Anonymous412,
  Anonymous087,
  Anonymous371,
  DBusHandlerApp,
  Anonymous202,
  Anonymous396,
  Anonymous247,
  Anonymous135,
  Anonymous297,
  Anonymous015,
  Anonymous343,
  Anonymous407,
  UUIDGenerator,
  Anonymous358,
  Anonymous403,
  Anonymous090,
  Anonymous107,
  Anonymous344,
  Anonymous300,
  Anonymous373,
  IDN,
  Anonymous150,
  Anonymous374,
  Anonymous084,
  Anonymous199,
  Anonymous432,
  Anonymous066,
  Anonymous172,
  Anonymous182,
  Anonymous258,
  Anonymous149,
  History,
  Anonymous117,
  Anonymous323,
  Anonymous164,
  Anonymous040,
  Anonymous144,
  Anonymous056,
  Anonymous379,
  Anonymous364,
  Preferences,
  Anonymous063,
  Anonymous152,
  Anonymous157,
  ProtocolProxy,
  Anonymous004,
  Anonymous287,
  Anonymous235,
  Anonymous233,
  Anonymous278,
  Anonymous183,
  Anonymous112,
  Anonymous022,
  Anonymous209,
  Anonymous062,
  Anonymous124,
  Anonymous329,
  Anonymous037,
  Anonymous336,
  Anonymous194,
  Anonymous179,
  Anonymous237,
  Anonymous423,
  Anonymous327,
  Anonymous429,
  Anonymous147,
  Anonymous433,
  Anonymous274,
  Anonymous221,
  Anonymous155,
  Anonymous109,
  Anonymous165,
  Anonymous161,
  Anonymous227,
  Anonymous236,
  Anonymous082,
  MimeHeaderParam,
  URLQueryStringStripper,
  Anonymous341,
  Anonymous397,
  IdentityCredentialStorageService,
  Anonymous386,
  Anonymous361,
  URIFixup,
  Anonymous234,
  Anonymous048,
  Anonymous044,
  Anonymous129,
  Anonymous006,
  NetworkErrorLogging,
  Anonymous431,
  Anonymous096,
  Anonymous001,
  Anonymous065,
  Anonymous053,
  Anonymous208,
  Anonymous003,
  CredentialChooserService,
  Anonymous212,
  Anonymous279,
  Anonymous254,
  Anonymous384,
  Anonymous060,
  Anonymous168,
  Anonymous189,
  Anonymous049,
  Anonymous176,
  Anonymous143,
  Alerts,
  Anonymous290,
  Anonymous187,
  Anonymous043,
  Anonymous215,
  Anonymous436,
  Anonymous052,
  UrlClassifierStreamUpdater,
  Anonymous340,
  Anonymous128,
  Anonymous245,
  Anonymous294,
  Anonymous218,
  Anonymous008,
  Anonymous193,
  XULRuntime,
  Anonymous261,
  Anonymous392,
  Anonymous356,
  Anonymous335,
  Anonymous093,
  Anonymous217,
  Anonymous315,
  CacheStorage,
  Anonymous317,
  Anonymous390,
  Anonymous283,
  Anonymous035,
  Anonymous288,
  Anonymous010,
  Anonymous078,
  Anonymous324,
  AppStartup,
  Anonymous140,
  IO,
  Anonymous376,
  Anonymous111,
  Anonymous191,
  FindService,
  Anonymous184,
  ContentSecurityManager,
  Anonymous251,
  PrivateAttribution,
  Anonymous211,
  Anonymous286,
  Anonymous268,
  Anonymous372,
  Anonymous106,
  Anonymous406,
  AlertNotification,
  EffectiveTLD,
  Anonymous352,
  TypeAheadFind,
  Anonymous171,
  Anonymous424,
  Anonymous439,
  Anonymous316,
  Anonymous255,
  Anonymous354,
  WindowWatcher,
  Anonymous086,
  Anonymous437,
  Anonymous225,
  Anonymous320,
  Anonymous250,
  Anonymous256,
  Anonymous141,
  Anonymous312,
  Anonymous210,
  Anonymous115,
  Anonymous349,
  RFPService,
  Anonymous138,
  Prefetch,
  Anonymous419,
  Anonymous328,
  Anonymous277,
  Anonymous103,
  Anonymous413,
  Anonymous228,
  Anonymous226,
  Anonymous072,
  Anonymous282,
  Anonymous338,
  Anonymous167,
  Anonymous242,
  Anonymous095,
  IdentityCredentialPromptService,
  Anonymous163,
  Anonymous100,
  Anonymous322,
  Anonymous070,
  Anonymous021,
  Anonymous414,
  Anonymous075,
  AsyncShutdown,
  TextToSubURI,
  Console,
  Anonymous064,
  HttpHandler,
  Anonymous230,
  Anonymous375,
  ApplicationReputation,
  Anonymous366,
  Anonymous069,
  Anonymous275,
  Anonymous405,
  Anonymous034,
  Anonymous188,
  Anonymous346,
  Anonymous400,
  nsIContentAnalysis,
  DocLoader,
  Anonymous091,
  Anonymous041,
  Anonymous020,
  Anonymous156,
  Anonymous012,
  Anonymous363,
  Anonymous266,
  Anonymous355,
  Anonymous045,
  Anonymous276,
  Anonymous263,
  Anonymous113,
  Anonymous042,
  SocketTransport,
  Anonymous160,
  NSSComponent,
  Anonymous238,
  Anonymous402,
  ExtensionPolicy,
  Anonymous271,
  Anonymous028,
  Anonymous145,
  Anonymous360,
  Anonymous039,
  PermissionManager,
  Anonymous307,
  Anonymous383,
  Anonymous148,
  Anonymous079,
  Anonymous289,
  Anonymous311,
  Anonymous388,
  Anonymous170,
  CookieBannerService,
  Anonymous326,
  Anonymous196,
  Anonymous214,
  Anonymous080,
  Anonymous345,
  Anonymous104,
  Anonymous385,
  Anonymous427,
  Anonymous441,
  UrlClassifierDB,
  Anonymous350,
  DNS,
  NSSCertificateDB,
  Anonymous002,
  Anonymous122,
  Anonymous404,
  Anonymous377,
  DownloadPlatform,
  Anonymous298,
  Anonymous200,
  Anonymous368,
  Anonymous292,
  Anonymous270,
  ServiceWorkerManager,
  Anonymous280,
  Anonymous332,
  UrlClassifierPrefixSet,
  Anonymous201,
  Anonymous000,
  Anonymous389,
  Anonymous331,
  Anonymous125,
  Anonymous085,
  Anonymous014,
  Predictor,
  Anonymous102,
  Anonymous273,
  Anonymous186,
  Anonymous257,
  UrlClassifierUtils,
  PlacesPreviewsHelper,
  Anonymous293,
  Anonymous367,
  StreamTransport,
  Anonymous260,
  Anonymous334,
  SystemInfo,
  Anonymous415,
  Anonymous398,
  Anonymous378,
  Anonymous139,
  Anonymous229,
  Anonymous005,
  Anonymous033,
  Anonymous068,
  Anonymous204,
  Anonymous426,
  Anonymous076,
  Anonymous118,
  Anonymous198,
  Anonymous313,
  Dashboard,
  Anonymous074,
  Anonymous409,
  Anonymous094,
  Anonymous013,
  Anonymous131,
  Anonymous098,
  Anonymous438,
  Anonymous151,
  Anonymous296,
  Anonymous434,
  Anonymous351,
  Anonymous309,
  Anonymous370,
  PageThumbsStorage,
  Anonymous146,
  Anonymous421,
  Anonymous024,
  Anonymous240,
  Anonymous304,
  Anonymous207,
  Anonymous030,
  Anonymous097,
  Anonymous175,
  Anonymous308,
  Anonymous031,
  Anonymous153,
  Anonymous330,
  AuthPromptAdapter,
  Anonymous365,
  Anonymous303,
  Anonymous394,
  ThirdPartyUtil,
  Anonymous017,
  Anonymous362,
  Anonymous181,
  GfxInfo,
  Anonymous036,
  Anonymous055,
  Anonymous133,
  FileProtocolHandler,
  Anonymous435,
  Anonymous391,
  Anonymous244,
  Anonymous190,
  Anonymous158,
  ExternalProtocolHandler,
  Anonymous101,
  RandomGenerator,
  Anonymous203,
  Anonymous301,
  Anonymous089,
  Anonymous134,
  Anonymous071,
  Anonymous126,
  Anonymous347,
  Anonymous159,
  SiteSecurity,
  Anonymous222,
  Anonymous381,
  Anonymous267,
  Anonymous185,
  Anonymous059,
  Anonymous166,
  Locale,
  Anonymous243,
  Anonymous310,
  Anonymous050,
  Anonymous197,
  Anonymous023,
  Anonymous393,
  Anonymous077,
  Anonymous295,
  Anonymous353,
  Anonymous306,
  Anonymous318,
  Anonymous420,
  Anonymous314,
  Anonymous357,
  Anonymous269,
  Anonymous180,
  Anonymous038,
  Anonymous130,
  Anonymous178,
  Anonymous252,
  Anonymous120,
  Anonymous173,
  Anonymous425,
  Anonymous027,
  Anonymous110,
  Anonymous058,
  Anonymous018,
  Anonymous342,
  Anonymous325,
  Anonymous127,
  Anonymous285,
  Anonymous291,
  Anonymous239,
  Anonymous007,
  WifiMonitor,
  Anonymous418,
  Anonymous382,
  Anonymous232,
  Anonymous105,
  Anonymous223,
  Anonymous284,
  Anonymous416,
  Anonymous246,
  Anonymous337,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace AuthPromptAdapter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AuthPromptAdapter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}
}  // namespace AuthPromptAdapter

namespace BounceTrackingProtection {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::BounceTrackingProtection);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::BounceTrackingProtection, aRv};
}
}  // namespace BounceTrackingProtection

namespace CORSPreflightCache {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CORSPreflightCache);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CORSPreflightCache, aRv};
}
}  // namespace CORSPreflightCache

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace CaptivePortal {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CaptivePortal);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CaptivePortal, aRv};
}
}  // namespace CaptivePortal

namespace CategoryManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CategoryManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}
}  // namespace CategoryManager

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace Console {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Console);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}
}  // namespace Console

namespace ContentSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ContentSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}
}  // namespace ContentSecurityManager

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace CredentialChooserService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CredentialChooserService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}
}  // namespace CredentialChooserService

namespace DBusHandlerApp {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DBusHandlerApp);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DBusHandlerApp, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DBusHandlerApp, aRv};
}
}  // namespace DBusHandlerApp

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Dashboard {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Dashboard);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}
}  // namespace Dashboard

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace EffectiveTLD {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::EffectiveTLD);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::EffectiveTLD, aRv};
}
}  // namespace EffectiveTLD

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FileProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FileProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FileProtocolHandler, aRv};
}
}  // namespace FileProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace HttpHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpHandler, aRv};
}
}  // namespace HttpHandler

namespace IDN {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IDN);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}
}  // namespace IDN

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace Locale {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Locale);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Locale, aRv};
}
}  // namespace Locale

namespace MimeHeaderParam {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::MimeHeaderParam);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}
}  // namespace MimeHeaderParam

namespace NSSCertificateDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSCertificateDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}
}  // namespace NSSCertificateDB

namespace NSSComponent {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSComponent);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}
}  // namespace NSSComponent

namespace NSSErrors {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSErrors);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}
}  // namespace NSSErrors

namespace NetworkErrorLogging {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NetworkErrorLogging);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NetworkErrorLogging, aRv};
}
}  // namespace NetworkErrorLogging

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PageThumbsStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PageThumbsStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}
}  // namespace PageThumbsStorage

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace PlacesPreviewsHelper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PlacesPreviewsHelper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}
}  // namespace PlacesPreviewsHelper

namespace Predictor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Predictor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Predictor, aRv};
}
}  // namespace Predictor

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace PrivateAttribution {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PrivateAttribution);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}
}  // namespace PrivateAttribution

namespace ProtocolProxy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ProtocolProxy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ProtocolProxy, aRv};
}
}  // namespace ProtocolProxy

namespace RFPService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RFPService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RFPService, aRv};
}
}  // namespace RFPService

namespace RandomGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RandomGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}
}  // namespace RandomGenerator

namespace ScriptSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ScriptSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}
}  // namespace ScriptSecurityManager

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SiteSecurity {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SiteSecurity);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}
}  // namespace SiteSecurity

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamConverter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamConverter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}
}  // namespace StreamConverter

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace SystemInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SystemInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}
}  // namespace SystemInfo

namespace TextToSubURI {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TextToSubURI);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}
}  // namespace TextToSubURI

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace WifiMonitor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WifiMonitor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WifiMonitor, aRv};
}
}  // namespace WifiMonitor

namespace WindowWatcher {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WindowWatcher);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}
}  // namespace WindowWatcher

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

namespace nsIContentAnalysis {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::nsIContentAnalysis);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}
}  // namespace nsIContentAnalysis

}  // namespace components

}  // namespace mozilla

#endif
