#ifndef DOM_WEBIDLPREFS_H_
#define DOM_WEBIDLPREFS_H_


namespace mozilla::dom {
enum class WebIDLPrefIndex : uint8_t {
  NoPref,
  // accessibility.ARIAElementReflection.enabled
  accessibility_ARIAElementReflection_enabled,
  // beacon.enabled
  beacon_enabled,
  // device.sensors.ambientLight.enabled
  device_sensors_ambientLight_enabled,
  // device.sensors.proximity.enabled
  device_sensors_proximity_enabled,
  // dom.battery.enabled
  dom_battery_enabled,
  // dom.capture.enabled
  dom_capture_enabled,
  // dom.cookieStore.enabled
  dom_cookieStore_enabled,
  // dom.cookieStore.manager.enabled
  dom_cookieStore_manager_enabled,
  // dom.customHighlightAPI.enabled
  dom_customHighlightAPI_enabled,
  // dom.details_group.enabled
  dom_details_group_enabled,
  // dom.dialog.light-dismiss.enabled
  dom_dialog_light_dismiss_enabled,
  // dom.element.blocking.enabled
  dom_element_blocking_enabled,
  // dom.element.dialog.request_close.enabled
  dom_element_dialog_request_close_enabled,
  // dom.element.invokers.enabled
  dom_element_invokers_enabled,
  // dom.enable_event_timing
  dom_enable_event_timing,
  // dom.enable_memory_stats
  dom_enable_memory_stats,
  // dom.enable_web_task_scheduling
  dom_enable_web_task_scheduling,
  // dom.event.pointer.rawupdate.enabled
  dom_event_pointer_rawupdate_enabled,
  // dom.events.asyncClipboard.clipboardItem
  dom_events_asyncClipboard_clipboardItem,
  // dom.events.script_execute.enabled
  dom_events_script_execute_enabled,
  // dom.fetchKeepalive.enabled
  dom_fetchKeepalive_enabled,
  // dom.forms.autocorrect
  dom_forms_autocorrect,
  // dom.fs.enabled
  dom_fs_enabled,
  // dom.gamepad.enabled
  dom_gamepad_enabled,
  // dom.gamepad.extensions.enabled
  dom_gamepad_extensions_enabled,
  // dom.gamepad.extensions.lightindicator
  dom_gamepad_extensions_lightindicator,
  // dom.gamepad.extensions.multitouch
  dom_gamepad_extensions_multitouch,
  // dom.gamepad.test.enabled
  dom_gamepad_test_enabled,
  // dom.hidden_until_found.enabled
  dom_hidden_until_found_enabled,
  // dom.indexedDB.experimental
  dom_indexedDB_experimental,
  // dom.media.autoplay-policy-detection.enabled
  dom_media_autoplay_policy_detection_enabled,
  // dom.mouse_capture.enabled
  dom_mouse_capture_enabled,
  // dom.netinfo.enabled
  dom_netinfo_enabled,
  // dom.origin_agent_cluster.enabled
  dom_origin_agent_cluster_enabled,
  // dom.performance.event_timing.enable_interactionid
  dom_performance_event_timing_enable_interactionid,
  // dom.performance.time_to_contentful_paint.enabled
  dom_performance_time_to_contentful_paint_enabled,
  // dom.performance.time_to_first_interactive.enabled
  dom_performance_time_to_first_interactive_enabled,
  // dom.performance.time_to_non_blank_paint.enabled
  dom_performance_time_to_non_blank_paint_enabled,
  // dom.pointer-lock.enabled
  dom_pointer_lock_enabled,
  // dom.push.enabled
  dom_push_enabled,
  // dom.screenwakelock.enabled
  dom_screenwakelock_enabled,
  // dom.security.credentialmanagement.identity.lightweight.enabled
  dom_security_credentialmanagement_identity_lightweight_enabled,
  // dom.security.featurePolicy.webidl.enabled
  dom_security_featurePolicy_webidl_enabled,
  // dom.security.sanitizer.enabled
  dom_security_sanitizer_enabled,
  // dom.security.trusted_types.enabled
  dom_security_trusted_types_enabled,
  // dom.select.showPicker.enabled
  dom_select_showPicker_enabled,
  // dom.serviceWorkers.navigationPreload.enabled
  dom_serviceWorkers_navigationPreload_enabled,
  // dom.shadowdom.selection_across_boundary_enabled
  dom_shadowdom_selection_across_boundary_enabled,
  // dom.storage.testing
  dom_storage_testing,
  // dom.storage_access.enabled
  dom_storage_access_enabled,
  // dom.storage_access.forward_declared.enabled
  dom_storage_access_forward_declared_enabled,
  // dom.svg.pathSegment.enabled
  dom_svg_pathSegment_enabled,
  // dom.testing.selection.GetRangesForInterval
  dom_testing_selection_GetRangesForInterval,
  // dom.textMetrics.actualBoundingBox.enabled
  dom_textMetrics_actualBoundingBox_enabled,
  // dom.textMetrics.baselines.enabled
  dom_textMetrics_baselines_enabled,
  // dom.textMetrics.emHeight.enabled
  dom_textMetrics_emHeight_enabled,
  // dom.textMetrics.fontBoundingBox.enabled
  dom_textMetrics_fontBoundingBox_enabled,
  // dom.text_fragments.create_text_fragment.enabled
  dom_text_fragments_create_text_fragment_enabled,
  // dom.text_fragments.enabled
  dom_text_fragments_enabled,
  // dom.vibrator.enabled
  dom_vibrator_enabled,
  // dom.viewTransitions.enabled
  dom_viewTransitions_enabled,
  // dom.vr.enabled
  dom_vr_enabled,
  // dom.vr.puppet.enabled
  dom_vr_puppet_enabled,
  // dom.vr.webxr.enabled
  dom_vr_webxr_enabled,
  // dom.webidl.test1
  dom_webidl_test1,
  // dom.webidl.test2
  dom_webidl_test2,
  // dom.webkitBlink.dirPicker.enabled
  dom_webkitBlink_dirPicker_enabled,
  // dom.webkitBlink.filesystem.enabled
  dom_webkitBlink_filesystem_enabled,
  // dom.webnotifications.actions.enabled
  dom_webnotifications_actions_enabled,
  // dom.webnotifications.requireinteraction.enabled
  dom_webnotifications_requireinteraction_enabled,
  // dom.webnotifications.silent.enabled
  dom_webnotifications_silent_enabled,
  // dom.webnotifications.vibrate.enabled
  dom_webnotifications_vibrate_enabled,
  // extensions.InstallTrigger.enabled
  extensions_InstallTrigger_enabled,
  // extensions.webidl-api.expose_mock_interface
  extensions_webidl_api_expose_mock_interface,
  // geo.enabled
  geo_enabled,
  // layout.accessiblecaret.magnifier.enabled
  layout_accessiblecaret_magnifier_enabled,
  // layout.css.anchor-positioning.enabled
  layout_css_anchor_positioning_enabled,
  // layout.css.animation-composition.enabled
  layout_css_animation_composition_enabled,
  // layout.css.contain-intrinsic-size.enabled
  layout_css_contain_intrinsic_size_enabled,
  // layout.css.convertFromNode.enabled
  layout_css_convertFromNode_enabled,
  // layout.css.field-sizing.enabled
  layout_css_field_sizing_enabled,
  // layout.css.font-palette.enabled
  layout_css_font_palette_enabled,
  // layout.css.font-variant-emoji.enabled
  layout_css_font_variant_emoji_enabled,
  // layout.css.font-variations.enabled
  layout_css_font_variations_enabled,
  // layout.css.grid-template-masonry-value.enabled
  layout_css_grid_template_masonry_value_enabled,
  // layout.css.hyphenate-limit-chars.enabled
  layout_css_hyphenate_limit_chars_enabled,
  // layout.css.initial-letter.enabled
  layout_css_initial_letter_enabled,
  // layout.css.moz-control-character-visibility.enabled
  layout_css_moz_control_character_visibility_enabled,
  // layout.css.moz-user-input.enabled
  layout_css_moz_user_input_enabled,
  // layout.css.osx-font-smoothing.enabled
  layout_css_osx_font_smoothing_enabled,
  // layout.css.overflow-clip-box.enabled
  layout_css_overflow_clip_box_enabled,
  // layout.css.overscroll-behavior.enabled
  layout_css_overscroll_behavior_enabled,
  // layout.css.prefixes.animations
  layout_css_prefixes_animations,
  // layout.css.prefixes.border-image
  layout_css_prefixes_border_image,
  // layout.css.prefixes.box-sizing
  layout_css_prefixes_box_sizing,
  // layout.css.prefixes.font-features
  layout_css_prefixes_font_features,
  // layout.css.prefixes.transforms
  layout_css_prefixes_transforms,
  // layout.css.prefixes.transitions
  layout_css_prefixes_transitions,
  // layout.css.properties-and-values.enabled
  layout_css_properties_and_values_enabled,
  // layout.css.scroll-anchoring.enabled
  layout_css_scroll_anchoring_enabled,
  // layout.css.scroll-driven-animations.enabled
  layout_css_scroll_driven_animations_enabled,
  // layout.css.size-adjust.enabled
  layout_css_size_adjust_enabled,
  // layout.css.text-wrap-balance.enabled
  layout_css_text_wrap_balance_enabled,
  // layout.css.transition-behavior.enabled
  layout_css_transition_behavior_enabled,
  // layout.css.zoom.enabled
  layout_css_zoom_enabled,
  // media.allowed-to-play.enabled
  media_allowed_to_play_enabled,
  // media.eme.hdcp-policy-check.enabled
  media_eme_hdcp_policy_check_enabled,
  // media.getdisplaymedia.enabled
  media_getdisplaymedia_enabled,
  // media.mediasource.enabled
  media_mediasource_enabled,
  // media.mediasource.experimental.enabled
  media_mediasource_experimental_enabled,
  // media.peerconnection.scripttransform.enabled
  media_peerconnection_scripttransform_enabled,
  // media.rvfc.enabled
  media_rvfc_enabled,
  // media.seekToNextFrame.enabled
  media_seekToNextFrame_enabled,
  // media.setsinkid.enabled
  media_setsinkid_enabled,
  // media.test.video-suspend
  media_test_video_suspend,
  // media.track.enabled
  media_track_enabled,
  // media.useAudioChannelService.testing
  media_useAudioChannelService_testing,
  // media.webspeech.synth.enabled
  media_webspeech_synth_enabled,
  // network.fetchpriority.enabled
  network_fetchpriority_enabled,
  // privacy.globalprivacycontrol.functionality.enabled
  privacy_globalprivacycontrol_functionality_enabled,
  // security.webauth.webauthn
  security_webauth_webauthn,
  // security.webauthn.enable_json_serialization_methods
  security_webauthn_enable_json_serialization_methods,
  // svg.SVGAElement.text.enabled
  svg_SVGAElement_text_enabled,
  // svg.context-properties.content.enabled
  svg_context_properties_content_enabled,
  // svg.nearestAndFarthestViewportElement.enabled
  svg_nearestAndFarthestViewportElement_enabled,
  // webgl.drawing_buffer_color_space
  webgl_drawing_buffer_color_space
};
typedef bool (*WebIDLPrefFunc)();
extern const WebIDLPrefFunc sWebIDLPrefs[127];
} // namespace mozilla::dom


#endif // DOM_WEBIDLPREFS_H_
