/* THIS FILE IS AUTOGENERATED FROM Element.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_ELEMENTBINDING_H_
#define DOM_ELEMENTBINDING_H_

#include "ShadowRootBinding.h"
#include "WindowBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/JSSlots.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ShadowRoot.h"
#include "mozilla/dom/UnionMember.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

struct CheckVisibilityOptionsAtoms;
class Element;
struct FocusOptionsAtoms;
struct GetHTMLOptionsAtoms;
struct NativePropertyHooks;
class OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString;
class ProtoAndIfaceCache;
struct ScrollIntoViewOptionsAtoms;
class ShadowRoot;
struct ShadowRootInitAtoms;
class TrustedHTML;
class TrustedScript;
class TrustedScriptURL;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class ScrollLogicalPosition : uint8_t {
  Start,
  Center,
  End,
  Nearest,
};

namespace binding_detail {
template <> struct EnumStrings<ScrollLogicalPosition> {
  static constexpr nsLiteralCString Values[4] {
    "start"_ns,
    "center"_ns,
    "end"_ns,
    "nearest"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ScrollLogicalPosition aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString& aUnion);


struct CheckVisibilityOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCheckOpacity;
  MOZ_INIT_OUTSIDE_CTOR bool mCheckVisibilityCSS;
  MOZ_INIT_OUTSIDE_CTOR bool mContentVisibilityAuto;
  MOZ_INIT_OUTSIDE_CTOR bool mFlush;
  MOZ_INIT_OUTSIDE_CTOR bool mOpacityProperty;
  MOZ_INIT_OUTSIDE_CTOR bool mVisibilityProperty;

  CheckVisibilityOptions();

  explicit inline CheckVisibilityOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CheckVisibilityOptions(CheckVisibilityOptions&& aOther) = default;

  explicit inline CheckVisibilityOptions(const CheckVisibilityOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  CheckVisibilityOptions&
  operator=(const CheckVisibilityOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, CheckVisibilityOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastCheckVisibilityOptions : public CheckVisibilityOptions
{
  inline FastCheckVisibilityOptions()
    : CheckVisibilityOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FocusOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mFocusVisible;
  MOZ_INIT_OUTSIDE_CTOR bool mPreventScroll;

  FocusOptions();

  explicit inline FocusOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FocusOptions(FocusOptions&& aOther) = default;

  explicit inline FocusOptions(const FocusOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  FocusOptions&
  operator=(const FocusOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, FocusOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastFocusOptions : public FocusOptions
{
  inline FastFocusOptions()
    : FocusOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GetHTMLOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mSerializableShadowRoots;
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningNonNull<mozilla::dom::ShadowRoot>> mShadowRoots;

  GetHTMLOptions();

  explicit inline GetHTMLOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GetHTMLOptions(GetHTMLOptions&& aOther) = default;

  explicit inline GetHTMLOptions(const GetHTMLOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mShadowRoots, "mShadowRoots", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mShadowRoots);
  }

  GetHTMLOptions&
  operator=(const GetHTMLOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, GetHTMLOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGetHTMLOptions : public GetHTMLOptions
{
  inline FastGetHTMLOptions()
    : GetHTMLOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ScrollIntoViewOptions : public ScrollOptions
{
  MOZ_INIT_OUTSIDE_CTOR ScrollLogicalPosition mBlock;
  MOZ_INIT_OUTSIDE_CTOR ScrollLogicalPosition mInline;

  ScrollIntoViewOptions();

  explicit inline ScrollIntoViewOptions(const FastDictionaryInitializer& )
    : ScrollOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ScrollIntoViewOptions(ScrollIntoViewOptions&& aOther) = default;

  explicit inline ScrollIntoViewOptions(const ScrollIntoViewOptions& aOther)
    : ScrollOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ScrollIntoViewOptions&
  operator=(const ScrollIntoViewOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ScrollIntoViewOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastScrollIntoViewOptions : public ScrollIntoViewOptions
{
  inline FastScrollIntoViewOptions()
    : ScrollIntoViewOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ShadowRootInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mClonable;
  MOZ_INIT_OUTSIDE_CTOR bool mDelegatesFocus;
  MOZ_INIT_OUTSIDE_CTOR ShadowRootMode mMode;
  MOZ_INIT_OUTSIDE_CTOR bool mSerializable;
  MOZ_INIT_OUTSIDE_CTOR SlotAssignmentMode mSlotAssignment;

  ShadowRootInit();

  explicit inline ShadowRootInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ShadowRootInit(ShadowRootInit&& aOther) = default;

  explicit inline ShadowRootInit(const ShadowRootInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ShadowRootInit&
  operator=(const ShadowRootInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, ShadowRootInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastShadowRootInit : public ShadowRootInit
{
  inline FastShadowRootInit()
    : ShadowRootInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class TrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedHTML,
    eTrustedScript,
    eTrustedScriptURL,
    eString
  };
public:
  enum class Type
  {
    eTrustedHTML = TypeOrUninit::eTrustedHTML,
    eTrustedScript = TypeOrUninit::eTrustedScript,
    eTrustedScriptURL = TypeOrUninit::eTrustedScriptURL,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::TrustedHTML> > mTrustedHTML;
    UnionMember<NonNull<mozilla::dom::TrustedScript> > mTrustedScript;
    UnionMember<NonNull<mozilla::dom::TrustedScriptURL> > mTrustedScriptURL;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  TrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString(const TrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString&) = delete;
  TrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString& operator=(const TrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString&) = delete;
public:
  explicit inline TrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString()
    : mType(eUninitialized)
  {
  }

  inline ~TrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedHTML>&
  RawSetAsTrustedHTML()
  {
    if (mType == eTrustedHTML) {
      return mValue.mTrustedHTML.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTrustedHTML;
    return mValue.mTrustedHTML.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedHTML>&
  SetAsTrustedHTML()
  {
    if (mType == eTrustedHTML) {
      return mValue.mTrustedHTML.Value();
    }
    Uninit();
    mType = eTrustedHTML;
    return mValue.mTrustedHTML.SetValue();
  }

  inline bool
  IsTrustedHTML() const
  {
    return mType == eTrustedHTML;
  }

  inline NonNull<mozilla::dom::TrustedHTML>&
  GetAsTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  inline mozilla::dom::TrustedHTML&
  GetAsTrustedHTML() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScript>&
  RawSetAsTrustedScript()
  {
    if (mType == eTrustedScript) {
      return mValue.mTrustedScript.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTrustedScript;
    return mValue.mTrustedScript.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScript>&
  SetAsTrustedScript()
  {
    if (mType == eTrustedScript) {
      return mValue.mTrustedScript.Value();
    }
    Uninit();
    mType = eTrustedScript;
    return mValue.mTrustedScript.SetValue();
  }

  inline bool
  IsTrustedScript() const
  {
    return mType == eTrustedScript;
  }

  inline NonNull<mozilla::dom::TrustedScript>&
  GetAsTrustedScript()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    return mValue.mTrustedScript.Value();
  }

  inline mozilla::dom::TrustedScript&
  GetAsTrustedScript() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    return mValue.mTrustedScript.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScriptURL>&
  RawSetAsTrustedScriptURL()
  {
    if (mType == eTrustedScriptURL) {
      return mValue.mTrustedScriptURL.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTrustedScriptURL;
    return mValue.mTrustedScriptURL.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::TrustedScriptURL>&
  SetAsTrustedScriptURL()
  {
    if (mType == eTrustedScriptURL) {
      return mValue.mTrustedScriptURL.Value();
    }
    Uninit();
    mType = eTrustedScriptURL;
    return mValue.mTrustedScriptURL.SetValue();
  }

  inline bool
  IsTrustedScriptURL() const
  {
    return mType == eTrustedScriptURL;
  }

  inline NonNull<mozilla::dom::TrustedScriptURL>&
  GetAsTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  inline mozilla::dom::TrustedScriptURL&
  GetAsTrustedScriptURL() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eTrustedHTML: {
        DestroyTrustedHTML();
        break;
      }
      case eTrustedScript: {
        DestroyTrustedScript();
        break;
      }
      case eTrustedScriptURL: {
        DestroyTrustedScriptURL();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToTrustedHTML(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedHTML(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    mValue.mTrustedHTML.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToTrustedScript(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScript(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTrustedScript()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    mValue.mTrustedScript.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToTrustedScriptURL(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScriptURL(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    mValue.mTrustedScriptURL.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eTrustedHTML,
    eTrustedScript,
    eTrustedScriptURL,
    eString
  };
public:
  enum class Type
  {
    eTrustedHTML = TypeOrUninit::eTrustedHTML,
    eTrustedScript = TypeOrUninit::eTrustedScript,
    eTrustedScriptURL = TypeOrUninit::eTrustedScriptURL,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::TrustedHTML> > mTrustedHTML;
    UnionMember<OwningNonNull<mozilla::dom::TrustedScript> > mTrustedScript;
    UnionMember<OwningNonNull<mozilla::dom::TrustedScriptURL> > mTrustedScriptURL;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString()
    : mType(eUninitialized)
  {
  }

  OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString(OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString&& aOther);

  explicit inline OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString(const OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedHTML>&
  RawSetAsTrustedHTML();

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedHTML>&
  SetAsTrustedHTML();

  inline bool
  IsTrustedHTML() const
  {
    return mType == eTrustedHTML;
  }

  inline OwningNonNull<mozilla::dom::TrustedHTML>&
  GetAsTrustedHTML()
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  inline OwningNonNull<mozilla::dom::TrustedHTML> const &
  GetAsTrustedHTML() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedHTML(), "Wrong type!");
    return mValue.mTrustedHTML.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScript>&
  RawSetAsTrustedScript();

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScript>&
  SetAsTrustedScript();

  inline bool
  IsTrustedScript() const
  {
    return mType == eTrustedScript;
  }

  inline OwningNonNull<mozilla::dom::TrustedScript>&
  GetAsTrustedScript()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    return mValue.mTrustedScript.Value();
  }

  inline OwningNonNull<mozilla::dom::TrustedScript> const &
  GetAsTrustedScript() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
    return mValue.mTrustedScript.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScriptURL>&
  RawSetAsTrustedScriptURL();

  [[nodiscard]] OwningNonNull<mozilla::dom::TrustedScriptURL>&
  SetAsTrustedScriptURL();

  inline bool
  IsTrustedScriptURL() const
  {
    return mType == eTrustedScriptURL;
  }

  inline OwningNonNull<mozilla::dom::TrustedScriptURL>&
  GetAsTrustedScriptURL()
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  inline OwningNonNull<mozilla::dom::TrustedScriptURL> const &
  GetAsTrustedScriptURL() const
  {
    MOZ_RELEASE_ASSERT(IsTrustedScriptURL(), "Wrong type!");
    return mValue.mTrustedScriptURL.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString&
  operator=(OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString&
  operator=(const OwningTrustedHTMLOrTrustedScriptOrTrustedScriptURLOrString& aOther);

private:
  bool
  TrySetToTrustedHTML(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedHTML(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTrustedHTML();

  bool
  TrySetToTrustedScript(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScript(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTrustedScript();

  bool
  TrySetToTrustedScriptURL(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTrustedScriptURL(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTrustedScriptURL();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


class BooleanOrScrollIntoViewOptions : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBoolean,
    eScrollIntoViewOptions
  };
public:
  enum class Type
  {
    eBoolean = TypeOrUninit::eBoolean,
    eScrollIntoViewOptions = TypeOrUninit::eScrollIntoViewOptions
  };

private:
  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<binding_detail::FastScrollIntoViewOptions > mScrollIntoViewOptions;

  };

  TypeOrUninit mType;
  Value mValue;

  BooleanOrScrollIntoViewOptions(const BooleanOrScrollIntoViewOptions&) = delete;
  BooleanOrScrollIntoViewOptions& operator=(const BooleanOrScrollIntoViewOptions&) = delete;
public:
  explicit inline BooleanOrScrollIntoViewOptions()
    : mType(eUninitialized)
  {
  }

  inline ~BooleanOrScrollIntoViewOptions()
  {
    Uninit();
  }

  [[nodiscard]] inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  [[nodiscard]] inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  [[nodiscard]] inline binding_detail::FastScrollIntoViewOptions&
  RawSetAsScrollIntoViewOptions()
  {
    if (mType == eScrollIntoViewOptions) {
      return mValue.mScrollIntoViewOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eScrollIntoViewOptions;
    return mValue.mScrollIntoViewOptions.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastScrollIntoViewOptions&
  SetAsScrollIntoViewOptions()
  {
    if (mType == eScrollIntoViewOptions) {
      return mValue.mScrollIntoViewOptions.Value();
    }
    Uninit();
    mType = eScrollIntoViewOptions;
    return mValue.mScrollIntoViewOptions.SetValue();
  }

  inline bool
  IsScrollIntoViewOptions() const
  {
    return mType == eScrollIntoViewOptions;
  }

  inline binding_detail::FastScrollIntoViewOptions&
  GetAsScrollIntoViewOptions()
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  inline const ScrollIntoViewOptions&
  GetAsScrollIntoViewOptions() const
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eScrollIntoViewOptions: {
        DestroyScrollIntoViewOptions();
        break;
      }
    }
  }

private:
  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToScrollIntoViewOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToScrollIntoViewOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyScrollIntoViewOptions()
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    mValue.mScrollIntoViewOptions.Destroy();
    mType = eUninitialized;
  }
};


class OwningBooleanOrScrollIntoViewOptions : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBoolean,
    eScrollIntoViewOptions
  };
public:
  enum class Type
  {
    eBoolean = TypeOrUninit::eBoolean,
    eScrollIntoViewOptions = TypeOrUninit::eScrollIntoViewOptions
  };

private:
  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<ScrollIntoViewOptions > mScrollIntoViewOptions;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningBooleanOrScrollIntoViewOptions()
    : mType(eUninitialized)
  {
  }

  OwningBooleanOrScrollIntoViewOptions(OwningBooleanOrScrollIntoViewOptions&& aOther);

  explicit inline OwningBooleanOrScrollIntoViewOptions(const OwningBooleanOrScrollIntoViewOptions& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningBooleanOrScrollIntoViewOptions()
  {
    Uninit();
  }

  [[nodiscard]] bool&
  RawSetAsBoolean();

  [[nodiscard]] bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  [[nodiscard]] ScrollIntoViewOptions&
  RawSetAsScrollIntoViewOptions();

  [[nodiscard]] ScrollIntoViewOptions&
  SetAsScrollIntoViewOptions();

  inline bool
  IsScrollIntoViewOptions() const
  {
    return mType == eScrollIntoViewOptions;
  }

  inline ScrollIntoViewOptions&
  GetAsScrollIntoViewOptions()
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  inline ScrollIntoViewOptions const &
  GetAsScrollIntoViewOptions() const
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningBooleanOrScrollIntoViewOptions&
  operator=(OwningBooleanOrScrollIntoViewOptions&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningBooleanOrScrollIntoViewOptions&
  operator=(const OwningBooleanOrScrollIntoViewOptions& aOther);

private:
  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();

  bool
  TrySetToScrollIntoViewOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToScrollIntoViewOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyScrollIntoViewOptions();
};


namespace Element_Binding {

  typedef mozilla::dom::Element NativeType;

  using ReflectedHTMLAttributeSlots = binding_detail::ReflectedHTMLAttributeSlots<(DOM_INSTANCE_RESERVED_SLOTS + 0), (DOM_EXPANDO_RESERVED_SLOTS + 0), 7>;

  bool
  Wrap(JSContext* aCx, mozilla::dom::Element* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedAriaControlsElementsValue(mozilla::dom::Element* aObject);

  void
  ClearCachedAriaDescribedByElementsValue(mozilla::dom::Element* aObject);

  void
  ClearCachedAriaDetailsElementsValue(mozilla::dom::Element* aObject);

  void
  ClearCachedAriaErrorMessageElementsValue(mozilla::dom::Element* aObject);

  void
  ClearCachedAriaFlowToElementsValue(mozilla::dom::Element* aObject);

  void
  ClearCachedAriaLabelledByElementsValue(mozilla::dom::Element* aObject);

  void
  ClearCachedAriaOwnsElementsValue(mozilla::dom::Element* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Element,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Element_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::ScrollLogicalPosition>
{
  static constexpr dom::ScrollLogicalPosition value = dom::ScrollLogicalPosition::Nearest;

  static_assert(static_cast<uint8_t>(dom::ScrollLogicalPosition::Start) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::ScrollLogicalPosition>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_ELEMENTBINDING_H_
