// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitMozappsUpdateSharedMetrics_h
#define mozilla_GleanToolkitMozappsUpdateSharedMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace update {
  /**
   * generated from update.bitshresult
   * If a BITS download fails on the Windows side (that is to say, BITS ecounters an error rather than Firefox failing to interact with BITS), it will likely give an hresult error indicating what happened. This probe reports those error codes to allow us to see if BITS is commonly failing on some systems. This probe is keyed on the type of update download, either "PARTIAL" or "COMPLETE". This metric was generated to correspond to the Legacy Telemetry scalar update.bitshresult.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> bitshresult(5883);

  /**
   * generated from update.move_result
   * Firefox keeps downloading updates in a different place from updates that are ready to install. Once the download completes, the resulting file has to be moved from the downloading update directory to the ready update directory. This probe counts the results that we get when attempting to perform this file move. Valid values for the keys for this probe are stored in the MOVE_RESULT_* values in UpdateTelemetry.sys.mjs. This metric was generated to correspond to the Legacy Telemetry scalar update.move_result.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> move_result(5884);

  /**
   * generated from update.no_window_auto_restarts
   * On macOS, all browser windows can be closed without exiting Firefox. If there is an update pending in that case, and we can install it silently, we restart automatically in order to do so. This probe counts the number of times the browser restarts to silently install a pending update. This metric was generated to correspond to the Legacy Telemetry scalar update.no_window_auto_restarts.
   */
  constexpr impl::CounterMetric no_window_auto_restarts(5885);

  /**
   * generated from update.suppress_prompts
   * When an update is available and app.update.auto is disabled, a popup is opened prompting the user to download and install the update. The pref app.update.suppressPrompts causes Firefox Nightly to wait up to 7 days before showing the prompt, instead showing a badge and banner in the meantime. It also prevents Nightly from showing update restart prompts, instead showing a badge and banner immediately. This value is set for the users who set this pref to true. This metric was generated to correspond to the Legacy Telemetry scalar update.suppress_prompts.
   */
  constexpr impl::BooleanMetric suppress_prompts(5886);

  /**
   * generated from update.version_pin
   * The AppUpdatePin Enterprise Policy controls the maximum version that the browser can update to. If the policy is set, this probe will report the policy's value. The possible policy values are "X." and "X.Y.", where X is the pinned major version and Y is the pinned minor version. This metric was generated to correspond to the Legacy Telemetry scalar update.version_pin.
   */
  constexpr impl::StringMetric version_pin(5887);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitMozappsUpdateSharedMetrics_h
