// META: script=/resources/testdriver.js?feature=bidi
// META: script=/resources/testdriver-vendor.js
// META: script=/common/gc.js
// META: script=/bluetooth/resources/bluetooth-test.js
// META: script=/bluetooth/resources/bluetooth-fake-devices.js
// META: timeout=long
// Generated by
// //bluetooth/bidi/generate.py
'use strict';
const test_desc = 'Characteristic gets removed. Reject with InvalidStateError.';
const expected = new DOMException(
    'GATT Characteristic no longer exists.', 'InvalidStateError');
let fake_peripheral, characteristic, fake_characteristic;

bluetooth_bidi_test(
    () =>
        getMeasurementIntervalCharacteristic()
            .then(
                _ => (
                    {fake_peripheral, characteristic, fake_characteristic} = _))
            .then(() => characteristic.getDescriptor(user_description.name))
            .then(
                () => null,
                (e) => assert_unreached('Caught error unexpectedly.', e))
            .then(() => fake_characteristic.remove())
            .then(
                () => assert_promise_rejects_with_message(
                    characteristic.writeValueWithoutResponse(new Uint8Array(1)),
                    expected)),
    test_desc);
