// For documentation of the format, see README in this directory.
var browserTests = [
["foo[bar]baz",
    [["inserttext","a"]],
    "fooa[]baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["inserttext",""]],
    "foo[]baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","\t"]],
    "foo\t[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","&"]],
    "foo&amp;[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","div"],["inserttext","\n"]],
    "<div>foo</div><div>{}bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","p"],["inserttext","\n"]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","div"],["inserttext","abc\ndef"]],
    "<div>fooabc</div><div>def[]bar</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["defaultparagraphseparator","p"],["inserttext","abc\ndef"]],
    "<p>fooabc</p><p>def[]bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","\u0007"]],
    "foo\u0007[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","<b>hi</b>"]],
    "foo&lt;b&gt;hi&lt;/b&gt;[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","<"]],
    "foo&lt;[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","&amp;"]],
    "foo&amp;amp;[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext"," "]],
    "foo []bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []bar",
    [["inserttext"," "]],
    ["foo&nbsp; bar", "foo &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[] bar",
    [["inserttext"," "]],
    ["foo&nbsp; bar", "foo &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo &nbsp;[]bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[] &nbsp;bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp; []bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[] bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]&nbsp; bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;[]bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]&nbsp;bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]&nbsp;&nbsp;bar",
    [["inserttext"," "]],
    ["foo &nbsp; bar", "foo&nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;        bar",
    [["inserttext"," "]],
    ["foo&nbsp; &nbsp; bar", "foo &nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo  []bar",
    [["inserttext"," "]],
    ["foo&nbsp; bar", "foo &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;&nbsp; &nbsp; bar",
    [["inserttext"," "]],
    ["foo &nbsp; &nbsp; &nbsp; bar", "foo&nbsp; &nbsp; &nbsp; &nbsp;bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["[]foo",
    [["inserttext"," "]],
    "&nbsp;foo",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["{}foo",
    [["inserttext"," "]],
    "&nbsp;foo",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]",
    [["inserttext"," "]],
    "foo&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo{}",
    [["inserttext"," "]],
    "foo&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]",
    [["inserttext"," "]],
    ["foo &nbsp;", "foo&nbsp;&nbsp;"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;{}",
    [["inserttext"," "]],
    ["foo &nbsp;", "foo&nbsp;&nbsp;"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;[]",
    [["inserttext"," "]],
    ["foo &nbsp;&nbsp;", "foo&nbsp; &nbsp;"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;{}",
    [["inserttext"," "]],
    ["foo &nbsp;&nbsp;", "foo&nbsp; &nbsp;"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
    [["inserttext"," "]],
    // It's fine to convert the last white-space of the Text to an NBSP for
    // optimizing the deletion handling of the following "bar".
    ["<b>foo </b>bar", "<b>foo&nbsp;</b>bar"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]<b>bar</b>",
    [["inserttext"," "]],
    // It's fine to convert the last white-space of the Text to an NBSP for
    // optimizing the deletion handling of the following <b>.
    ["foo <b>bar</b>", "foo&nbsp;<b>bar</b>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[] ",
    [["inserttext"," "]],
    "foo&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
[" foo   []   ",
    [["inserttext"," "]],
    " foo&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]<span> </span>",
    [["inserttext"," "]],
    // It's fine to delete the following invisible white-spaces.
    ["foo&nbsp;<span> </span>", "foo&nbsp;<span></span>", "foo&nbsp;"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]<span> </span> ",
    [["inserttext"," "]],
    // It's fine to delete the following invisible white-spaces.
    ["foo&nbsp;[]<span> </span> ", "foo&nbsp;<span></span>", "foo&nbsp;"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
[" []foo",
    [["inserttext"," "]],
    "&nbsp;foo",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["   []   foo ",
    [["inserttext"," "]],
    "&nbsp;foo ",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<span> </span>[]foo",
    [["inserttext"," "]],
    // It's fine to delete the preceding white-space
    ["<span> </span>&nbsp;foo", "<span></span>&nbsp;foo", "&nbsp;foo"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
[" <span> </span>[]foo",
    [["inserttext"," "]],
    // It's fine to delete the preceding white-space
    [" <span> </span>&nbsp;foo", "<span></span>&nbsp;foo", "&nbsp;foo"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["{}<br>",
    [["inserttext"," "]],
    "&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>{}<br>",
    [["inserttext"," "]],
    "<p>&nbsp;</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]<p>bar",
    [["inserttext"," "]],
    "<p>foo&nbsp;</p><p>bar</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo&nbsp;[]<p>bar",
    [["inserttext"," "]],
    ["<p>foo &nbsp;</p><p>bar</p>", "<p>foo&nbsp;&nbsp;</p><p>bar</p>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]<p>&nbsp;bar",
    [["inserttext"," "]],
    "<p>foo&nbsp;</p><p>&nbsp;bar</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[]bar</pre>",
    [["inserttext"," "]],
    "<pre>foo bar</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo []bar</pre>",
    [["inserttext"," "]],
    "<pre>foo  bar</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[] bar</pre>",
    [["inserttext"," "]],
    "<pre>foo  bar</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo &nbsp;[]bar</pre>",
    [["inserttext"," "]],
    "<pre>foo &nbsp; bar</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>[]foo</pre>",
    [["inserttext"," "]],
    "<pre> foo</pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[]</pre>",
    [["inserttext"," "]],
    "<pre>foo </pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre>foo&nbsp;[]</pre>",
    [["inserttext"," "]],
    "<pre>foo&nbsp; </pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<pre> foo   []   </pre>",
    [["inserttext"," "]],
    "<pre> foo       </pre>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo []bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo  bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[] bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo  bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo &nbsp;[]bar</div>",
    [["inserttext"," "]],
    ["<div style=\"white-space:pre\">foo &nbsp; bar</div>",
     "<div style=\"white-space:pre\">foo&nbsp; &nbsp;bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>[]foo</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\"> foo</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo&nbsp;[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\">foo&nbsp; </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre> foo   []   </div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre\"> foo       </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo []bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo  bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[] bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo [] bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo &nbsp;[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo &nbsp; bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>[]foo</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\"> []foo</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo&nbsp;[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\">foo&nbsp; []</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap> foo   []   </div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-wrap\"> foo       </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">foo bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo []bar</div>",
    [["inserttext"," "]],
    ["<div style=\"white-space:pre-line\">foo&nbsp; bar</div>",
     "<div style=\"white-space:pre-line\">foo &nbsp;bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[] bar</div>",
    [["inserttext"," "]],
    ["<div style=\"white-space:pre-line\">foo&nbsp; bar</div>",
     "<div style=\"white-space:pre-line\">foo &nbsp;bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo &nbsp;[]bar</div>",
    [["inserttext"," "]],
    ["<div style=\"white-space:pre-line\">foo &nbsp; bar</div>",
     "<div style=\"white-space:pre-line\">foo&nbsp; &nbsp;bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>[]foo</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">&nbsp;foo</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\">foo&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo&nbsp;[]</div>",
    [["inserttext"," "]],
    ["<div style=\"white-space:pre-line\">foo &nbsp;</div>",
     "<div style=\"white-space:pre-line\">foo&nbsp;&nbsp;</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line> foo   []   </div>",
    [["inserttext"," "]],
    "<div style=\"white-space:pre-line\"> foo&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]bar</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo []bar</div>",
    [["inserttext"," "]],
    ["<div style=\"white-space:nowrap\">foo&nbsp; bar</div>",
     "<div style=\"white-space:nowrap\">foo &nbsp;bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[] bar</div>",
    [["inserttext"," "]],
    ["<div style=\"white-space:nowrap\">foo&nbsp; bar</div>",
     "<div style=\"white-space:nowrap\">foo &nbsp;bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo &nbsp;[]bar</div>",
    [["inserttext"," "]],
    ["<div style=\"white-space:nowrap\">foo &nbsp; bar</div>",
     "<div style=\"white-space:nowrap\">foo&nbsp; &nbsp;bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>[]foo</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">&nbsp;foo</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo&nbsp;[]</div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\">foo &nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap> foo   []   </div>",
    [["inserttext"," "]],
    "<div style=\"white-space:nowrap\"> foo&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext"," "]],
    "http://a&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["ftp://a[]",
    [["inserttext"," "]],
    "ftp://a&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["quasit://a[]",
    [["inserttext"," "]],
    "quasit://a&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
[".x-++-.://a[]",
    [["inserttext"," "]],
    ".x-++-.://a&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["(http://a)[]",
    [["inserttext"," "]],
    "(http://a)&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["&lt;http://a>[]",
    [["inserttext"," "]],
    "&lt;http://a&gt;&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a![]",
    [["inserttext"," "]],
    "http://a!&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~http://a!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~[]",
    [["inserttext"," "]],
    "!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~http://a!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a!\"'(),-.:;&lt;>`[]",
    [["inserttext"," "]],
    "http://a!\"'(),-.:;&lt;&gt;`&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a#$%&amp;*+/=?^_|~[]",
    [["inserttext"," "]],
    "http://a#$%&amp;*+/=?^_|~&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["mailto:a[]",
    [["inserttext"," "]],
    "mailto:a&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["a@b[]",
    [["inserttext"," "]],
    "a@b&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["a@[]",
    [["inserttext"," "]],
    "a@&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["@b[]",
    [["inserttext"," "]],
    "@b&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["#@x[]",
    [["inserttext"," "]],
    "#@x&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["a@.[]",
    [["inserttext"," "]],
    "a@.&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~a@b!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~[]",
    [["inserttext"," "]],
    "!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~a@b!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>a@b</b>{}",
    [["inserttext"," "]],
    "<b>a@b</b>&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>a</b><i>@</i><u>b</u>{}",
    [["inserttext"," "]],
    "<b>a</b><i>@</i><u>b</u>&nbsp;",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["a@b<b>[]c</b>",
    [["inserttext"," "]],
    "a@b<b>&nbsp;c</b>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>a@b</p><p>[]c</p>",
    [["inserttext"," "]],
    "<p>a@b</p><p>&nbsp;c</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext","a"]],
    "http://aa[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext","\t"]],
    // XXX Do web developers want to insert a horizontal-tab as-is?
    "http://a\t",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext","\f"]],
    // XXX Do web developers want to insert a formfeed as-is?
    "http://a\f",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
    [["inserttext","\u00A0"]],
    "http://a&nbsp;[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]",
    [["inserttext","   "]],
    ["foo &nbsp;&nbsp;", "foo&nbsp; &nbsp;"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["inserttext","a"]],
    "fooa[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]",
    [["inserttext","a"]],
    "foo a[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo\u00A0[]",
    [["inserttext","a"]],
    "foo a[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]",
    [["inserttext","a"]],
    "<p>fooa[]</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo</p>{}",
    [["inserttext","a"]],
    "<p>foo</p>a[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>[]foo",
    [["inserttext","a"]],
    "<p>a[]foo</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>{}foo",
    [["inserttext","a"]],
    "<p>a[]foo</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["{}<p>foo",
    [["inserttext","a"]],
    // XXX The users probably cannot put caret before the first paragraph
    // with operations. So, only web developers can put caret to there only
    // with using Selection API.  Then, is this what the web developers actually
    // want?
    "a<p>foo</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo</p>{}<p>bar</p>",
    [["inserttext","a"]],
    // XXX The users probably cannot put caret between paragraphs with
    // operations. So, only web developers can put caret to there only with
    // using Selection API.  Then, is this what the web developers actually
    // want?
    "<p>foo</p>a[]<p>bar</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
    [["inserttext","a"]],
    "<b>fooa[]</b>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<b>foo</b>[]bar",
    [["inserttext","a"]],
    "<b>foo</b>a[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<b>{}</b>bar",
    [["inserttext","a"]],
    "foo<b>a[]</b>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<a>foo[]</a>bar",
    [["inserttext","a"]],
    "<a>fooa[]</a>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<a>foo</a>[]bar",
    [["inserttext","a"]],
    "<a>foo</a>a[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<a href=/>foo[]</a>bar",
    [["inserttext","a"]],
    "<a href=\"/\">fooa[]</a>bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<a href=/>foo</a>[]bar",
    [["inserttext","a"]],
    "<a href=\"/\">foo</a>a[]bar",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>b]ar",
    [["defaultparagraphseparator","div"],["inserttext","a"]],
    "<p>foa[]ar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>b]ar",
    [["defaultparagraphseparator","p"],["inserttext","a"]],
    "<p>foa[]ar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>bar<p>b]az",
    [["defaultparagraphseparator","div"],["inserttext","a"]],
    "<p>foa[]az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>bar<p>b]az",
    [["defaultparagraphseparator","p"],["inserttext","a"]],
    "<p>foa[]az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["{}<br>",
    [["inserttext","a"]],
    "a[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>{}<br>",
    [["inserttext","a"]],
    "<p>a[]</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p><span>{}<br></span>",
    [["inserttext","a"]],
    "<p><span>a[]</span></p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "<p>a[]baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "<p>a[]baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "<p>a[]baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "<p>a[]baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span></p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span></p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","true"],["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>quz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","false"],["inserttext","a"]],
    "<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>quz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["inserttext","a"]],
    "foo<b>a[]</b>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<i>[bar]</i>baz",
    [["inserttext","a"]],
    "foo<i>a[]</i>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<s>[bar]</s>baz",
    [["inserttext","a"]],
    "foo<s>a[]</s>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub>[bar]</sub>baz",
    [["inserttext","a"]],
    "foo<sub>a[]</sub>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sup>[bar]</sup>baz",
    [["inserttext","a"]],
    "foo<sup>a[]</sup>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<u>[bar]</u>baz",
    [["inserttext","a"]],
    "foo<u>a[]</u>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com>[bar]</a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font face=sans-serif>[bar]</font>baz",
    [["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=4>[bar]</font>baz",
    [["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=#0000FF>[bar]</font>baz",
    [["inserttext","a"]],
    "foo<font color=\"#0000FF\">a[]</font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<span style=background-color:#00FFFF>[bar]</span>baz",
    [["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=blue>[bar]</font></a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"blue\">a[]</font></a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=blue><a href=http://www.google.com>[bar]</a></font>baz",
    [["inserttext","a"]],
    "foo<font color=\"blue\"><a href=\"http://www.google.com\">a[]</a></font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=brown>[bar]</font></a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"brown\">a[]</font></a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=brown><a href=http://www.google.com>[bar]</a></font>baz",
    [["inserttext","a"]],
    "foo<font color=\"brown\"><a href=\"http://www.google.com\">a[]</a></font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=black>[bar]</font></a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"black\">a[]</font></a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><u>[bar]</u></a>baz",
    [["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><u>a[]</u></a>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<u><a href=http://www.google.com>[bar]</a></u>baz",
    [["inserttext","a"]],
    "foo<u><a href=\"http://www.google.com\">a[]</a></u>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=2>[bar]</font></sub>baz",
    [["inserttext","a"]],
    "foo<sub><font size=\"2\">a[]</font></sub>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=2><sub>[bar]</sub></font>baz",
    [["inserttext","a"]],
    "foo<font size=\"2\"><sub>a[]</sub></font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=3>[bar]</font></sub>baz",
    [["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=3><sub>[bar]</sub></font>baz",
    [["inserttext","a"]],
    "foo<font size=\"3\"><sub>a[]</sub></font>baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["[foo<b>bar]</b>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<b>bar]</b>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<i>bar]</i>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<i>bar]</i>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<s>bar]</s>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<s>bar]</s>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub>bar]</sub>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub>bar]</sub>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sup>bar]</sup>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sup>bar]</sup>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u>bar]</u>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u>bar]</u>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com>bar]</a>baz",
    [["inserttext","a"]],
    "a[]baz",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["[foo<font face=sans-serif>bar]</font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font face=sans-serif>bar]</font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=4>bar]</font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=4>bar]</font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=#0000FF>bar]</font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=#0000FF>bar]</font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<span style=background-color:#00FFFF>bar]</span>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<span style=background-color:#00FFFF>bar]</span>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=blue>bar]</font></a>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=blue>bar]</font></a>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=blue><a href=http://www.google.com>bar]</a></font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=blue><a href=http://www.google.com>bar]</a></font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=brown>bar]</font></a>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=brown>bar]</font></a>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=brown><a href=http://www.google.com>bar]</a></font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=brown><a href=http://www.google.com>bar]</a></font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=black>bar]</font></a>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=black>bar]</font></a>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><u>bar]</u></a>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><u>bar]</u></a>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u><a href=http://www.google.com>bar]</a></u>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u><a href=http://www.google.com>bar]</a></u>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=2>bar]</font></sub>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=2>bar]</font></sub>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=2><sub>bar]</sub></font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=2><sub>bar]</sub></font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=3>bar]</font></sub>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=3>bar]</font></sub>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=3><sub>bar]</sub></font>baz",
    [["stylewithcss","true"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=3><sub>bar]</sub></font>baz",
    [["stylewithcss","false"],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<b>[bar</b>baz]",
    [["inserttext","a"]],
    "foo<b>a[]</b>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<i>[bar</i>baz]",
    [["inserttext","a"]],
    "foo<i>a[]</i>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<s>[bar</s>baz]",
    [["inserttext","a"]],
    "foo<s>a[]</s>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub>[bar</sub>baz]",
    [["inserttext","a"]],
    "foo<sub>a[]</sub>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sup>[bar</sup>baz]",
    [["inserttext","a"]],
    "foo<sup>a[]</sup>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<u>[bar</u>baz]",
    [["inserttext","a"]],
    "foo<u>a[]</u>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com>[bar</a>baz]",
    [["inserttext","a"]],
    "fooa[]",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font face=sans-serif>[bar</font>baz]",
    [["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=4>[bar</font>baz]",
    [["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=#0000FF>[bar</font>baz]",
    [["inserttext","a"]],
    "foo<font color=\"#0000FF\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<span style=background-color:#00FFFF>[bar</span>baz]",
    [["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
// <a href> should always be removed if entirely replaced.
["foo<a href=http://www.google.com><font color=blue>[bar</font></a>baz]",
    [["inserttext","a"]],
    "foo<font color=\"blue\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=blue><a href=http://www.google.com>[bar</a></font>baz]",
    [["inserttext","a"]],
    "foo<font color=\"blue\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=brown>[bar</font></a>baz]",
    [["inserttext","a"]],
    "foo<font color=\"brown\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font color=brown><a href=http://www.google.com>[bar</a></font>baz]",
    [["inserttext","a"]],
    "foo<font color=\"brown\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=black>[bar</font></a>baz]",
    [["inserttext","a"]],
    "foo<font color=\"black\">a[]</font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><u>[bar</u></a>baz]",
    [["inserttext","a"]],
    "foo<u>a[]</u>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<u><a href=http://www.google.com>[bar</a></u>baz]",
    [["inserttext","a"]],
    "foo<u>a[]</u>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=2>[bar</font></sub>baz]",
    [["inserttext","a"]],
    "foo<sub><font size=\"2\">a[]</font></sub>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=2><sub>[bar</sub></font>baz]",
    [["inserttext","a"]],
    "foo<font size=\"2\"><sub>a[]</sub></font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=3>[bar</font></sub>baz]",
    [["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["foo<font size=3><sub>[bar</sub></font>baz]",
    [["inserttext","a"]],
    "foo<font size=\"3\"><sub>a[]</sub></font>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<blockquote><font color=blue>[foo]</font></blockquote>",
    [["inserttext","a"]],
    "<blockquote><font color=\"blue\">a[]</font></blockquote>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div>[] abc</div>",
    [["inserttext"," "]],
    "<div>&nbsp;abc</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div> []abc</div>",
    [["inserttext"," "]],
    "<div>&nbsp;abc</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div>[]  abc</div>",
    [["inserttext"," "]],
    "<div>&nbsp;abc</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div> [] abc</div>",
    [["inserttext"," "]],
    "<div>&nbsp;abc</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div>  []abc</div>",
    [["inserttext"," "]],
    "<div>&nbsp;abc</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div>abc[] </div>",
    [["inserttext"," "]],
    "<div>abc&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div>abc []</div>",
    [["inserttext"," "]],
    "<div>abc&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div>abc[]  </div>",
    [["inserttext"," "]],
    "<div>abc&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div>abc [] </div>",
    [["inserttext"," "]],
    "<div>abc&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div>abc  []</div>",
    [["inserttext"," "]],
    "<div>abc&nbsp;</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<br>{}",
    [["inserttext","a"]],
    "a",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["abc<br>{}",
    [["inserttext","d"]],
    "abcd",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["abc<br>{}<br>",
    [["inserttext","d"]],
    "abc<br>d",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<span contenteditable=false>abc</span><br>{}",
    [["inserttext","d"]],
    "<span contenteditable=\"false\">abc</span>d",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div contenteditable=false><span contenteditable><br>{}</span></div>",
    [["inserttext","a"]],
    "<div contenteditable=\"false\"><span contenteditable=\"\">a</span></div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div contenteditable=false><span contenteditable>abc<br>{}</span></div>",
    [["inserttext","d"]],
    "<div contenteditable=\"false\"><span contenteditable=\"\">abcd</span></div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]bar</div>",
    [["inserttext","    "]],
    "<div style=\"white-space:pre\">foo    bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]</div>",
    [["inserttext","    "]],
    "<div style=\"white-space:pre\">foo    </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]bar</div>",
    [["inserttext","    "]],
    "<div style=\"white-space:pre-wrap\">foo    bar</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]</div>",
    [["inserttext","    "]],
    "<div style=\"white-space:pre-wrap\">foo    </div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
// FYI: The white-space sequence different does not matter here.  It's tested
//      in white-spaces-after-execCommand-inserttext.tentative.html.
["<div style=white-space:pre-line>foo[]bar</div>",
    [["inserttext","    "]],
    ["<div style=\"white-space:pre-line\">foo &nbsp; &nbsp;bar</div>",
     "<div style=\"white-space:pre-line\">foo&nbsp; &nbsp; bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]</div>",
    [["inserttext","    "]],
    ["<div style=\"white-space:pre-line\">foo &nbsp; &nbsp;</div>",
     "<div style=\"white-space:pre-line\">foo&nbsp; &nbsp;&nbsp;</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]bar</div>",
    [["inserttext","    "]],
    ["<div style=\"white-space:nowrap\">foo &nbsp; &nbsp;bar</div>",
     "<div style=\"white-space:nowrap\">foo&nbsp; &nbsp; bar</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]</div>",
    [["inserttext","    "]],
    ["<div style=\"white-space:nowrap\">foo &nbsp; &nbsp;</div>",
     "<div style=\"white-space:nowrap\">foo&nbsp; &nbsp;&nbsp;</div>"],
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
// If selection is after a <br> element in a block and the <br> element follows
// last visible thing in the block, content should be inserted before the <br>
// element.
["<p>a<br>{}<span></span></p>",
    [["inserttext","b"]],
    "<p>ab<span></span></p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
// In these cases, the <span> element after <br> element is visible and is put in
// the second line and caret is in the second line.  Therefore, new text should
// be inserted into the second line.
["<p style=\"white-space:pre-wrap\">a<br>{}<span style=\"padding:1px\"></span></p>",
    [["inserttext","b"]],
    "<p style=\"white-space:pre-wrap\">a<br>b<span style=\"padding:1px\"></span></p>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
["<div style=\"white-space:pre-wrap\">a<br>{}<span style=\"padding:1px\"></span><p>c</p></div>",
    [["inserttext","b"]],
    "<div style=\"white-space:pre-wrap\">a<br>b<span style=\"padding:1px\"></span><p>c</p></div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
// Similar case if <br> follows last visible thing and is followed by invisible
// inline element and a block.  In this case, Chrome inserts text into the
// following block so that the expectation follows it.
["<div>a<br>{}<span></span><p>c</p></div>",
    [["inserttext","b"]],
    "<div>a<br><span></span><p>bc</p></div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],
// https://bugzilla.mozilla.org/show_bug.cgi?id=1785801
["<div>abc{</div><div>}efg</div>",
    [["inserttext", "d"]],
    "<div>abcdefg</div>",
    [true],
    {"inserttext":[false,false,"",false,false,""]}],

// Tests preserving inline style of the last visible thing in the selection
// for replacing text.
["<div>abc{<b><i>def</i></b>}ghi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"]],
    "<div>abc<b><i>def</i></b>ghi</div>",
    [true,true,true],
    {}],
["<div>abc<b><i>[def]</i></b>ghi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"]],
    "<div>abc<b><i>def</i></b>ghi</div>",
    [true,true,true],
    {}],
["<div>abc[<b><i>def]</i></b>ghi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"]],
    "<div>abc<b><i>def</i></b>ghi</div>",
    [true,true,true],
    {}],
["<div>abc<b><i>[def</i></b>]ghi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"]],
    "<div>abc<b><i>def</i></b>ghi</div>",
    [true,true,true],
    {}],
["<div>abc<b><i>[def</i></b>g]hi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"],["inserttext","g"]],
    "<div>abc<b><i>defg</i></b>hi</div>",
    [true,true,true,true],
    {}],
["<div>abc[<b><i>def</i></b>g]hi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"],["inserttext","g"]],
    "<div>abc<b><i>defg</i></b>hi</div>",
    [true,true,true,true],
    {}],
["<div>abc{<b><i>def</i></b>g]hi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"],["inserttext","g"]],
    "<div>abc<b><i>defg</i></b>hi</div>",
    [true,true,true,true],
    {}],
// Don't preserve inline styles if first content is <img> and it's replaced.
["<div>abc[<b><i><img src=\"/img/lion.svg\">de]f</i></b>ghi</div>",
    [["inserttext","d"],["inserttext","e"]],
    "<div>abcde<b><i>f</i></b>ghi</div>",
    [true,true],
    {}],
["<div>abc[<b><i><img src=\"/img/lion.svg\">def]</i></b>ghi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"]],
    "<div>abcdefghi</div>",
    [true,true,true],
    {}],
["<div>abc[<b><i><img src=\"/img/lion.svg\">def</i></b>]ghi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"]],
    "<div>abcdefghi</div>",
    [true,true,true],
    {}],
["<div>abc{<b><i><img src=\"/img/lion.svg\">def</i></b>]ghi</div>",
    [["inserttext","d"],["inserttext","e"],["inserttext","f"]],
    "<div>abcdefghi</div>",
    [true,true,true],
    {}],
// Don't preserve inline styles even if end boundary is styled.
["<div>ab[c<b><i>de]f</i></b>ghi</div>",
    [["inserttext","c"],["inserttext","d"],["inserttext","e"]],
    "<div>abcde<b><i>f</i></b>ghi</div>",
    [true,true,true],
    {}],
// But preserve inline styles if first content is styled.
["<div>abc[<b><i>de]f</i></b>ghi</div>",
    [["inserttext","d"],["inserttext","e"]],
    "<div>abc<b><i>def</i></b>ghi</div>",
    [true,true],
    {}],
["<div>abc{<b><i>de]f</i></b>ghi</div>",
    [["inserttext","d"],["inserttext","e"]],
    "<div>abc<b><i>def</i></b>ghi</div>",
    [true,true],
    {}],
// Don't preserve empty inline style, but preserve the following text style if first content is text
["<div>abc[<s></s><b><i>de]f</i></b>ghi</div>",
    [["inserttext","d"],["inserttext","e"]],
    ["<div>abc<b><i>def</i></b>ghi</div>",
     "<div>abc<s></s><b><i>def</i></b>ghi</div>"],
    [true,true],
    {}],
["<div>abc{<s></s><b><i>de]f</i></b>ghi</div>",
    [["inserttext","d"],["inserttext","e"]],
    ["<div>abc<b><i>def</i></b>ghi</div>",
     "<div>abc<s></s><b><i>def</i></b>ghi</div>"],
    [true,true],
    {}],
// Don't remove parent blocks of selection start to insert new text into the
// selection start container.
["<div>{abc</div><div>def</div>}",
    [["inserttext","g"],["inserttext","h"]],
    "<div>gh</div>",
    [true,true],
    {}],
["<div>abc</div><div>{def</div>}",
    [["inserttext","g"],["inserttext","h"]],
    "<div>abc</div><div>gh</div>",
    [true,true],
    {}],
["<div style=display:flex><span>{abc</span><span>def</span>}</div>",
    [["inserttext","g"],["inserttext","h"]],
    "<div style=\"display:flex\"><span>gh</span></div>",
    [true,true],
    {}],
["<div style=display:flex><span>abc</span><span>{def</span>}</div>",
    [["inserttext","g"],["inserttext","h"]],
    "<div style=\"display:flex\"><span>abc</span><span>gh</span></div>",
    [true,true],
    {}],
["<div style=display:grid><span>{abc</span><span>def</span>}</div>",
    [["inserttext","g"],["inserttext","h"]],
    "<div style=\"display:grid\"><span>gh</span></div>",
    [true,true],
    {}],
["<div style=display:grid><span>abc</span><span>{def</span>}</div>",
    [["inserttext","g"],["inserttext","h"]],
    "<div style=\"display:grid\"><span>abc</span><span>gh</span></div>",
    [true,true],
    {}],
// The inline style at selection start should be preserved for typed text.
["<div><b>{abc</b></div><div>def</div>}",
    [["inserttext","g"],["inserttext","h"]],
    "<div><b>gh</b></div>",
    [true,true],
    {}],
["<div>abc</div><div><b>{def</b></div>}",
    [["inserttext","g"],["inserttext","h"]],
    "<div>abc</div><div><b>gh</b></div>",
    [true,true],
    {}],
["<div style=display:flex><span><b>{abc</b></span><span>def</span>}</div>",
    [["inserttext","g"],["inserttext","h"]],
    "<div style=\"display:flex\"><span><b>gh</b></span></div>",
    [true,true],
    {}],
["<div style=display:flex><span>abc</span><span><b>{def</b></span>}</div>",
    [["inserttext","g"],["inserttext","h"]],
    "<div style=\"display:flex\"><span>abc</span><span><b>gh</b></span></div>",
    [true,true],
    {}],
["<div style=display:grid><span><b>{abc</b></span><span>def</span>}</div>",
    [["inserttext","g"],["inserttext","h"]],
    "<div style=\"display:grid\"><span><b>gh</b></span></div>",
    [true,true],
    {}],
["<div style=display:grid><span>abc</span><span><b>{def</b></span>}</div>",
    [["inserttext","g"],["inserttext","h"]],
    "<div style=\"display:grid\"><span>abc</span><span><b>gh</b></span></div>",
    [true,true],
    {}],

["<table><tr><td>a<td><b>[b</b><td><b>c</b><td><b>d]</b><td>e</table>",
    [["inserttext","B"]],
    "<table><tbody><tr><td>a</td><td><b>B</b></td><td><br></td><td><br></td><td>e</td></tr></tbody></table>",
    [true],
    {}],
["<table><tr><th>a<th><b>[b</b><th><b>c</b><th><b>d]</b><th>e</table>",
    [["inserttext","B"]],
    "<table><tbody><tr><th>a</th><th><b>B</b></th><th><br></th><th><br></th><th>e</th></tr></tbody></table>",
    [true],
    {}],

// The expectations of these flex item scenarios based on Chrome 142.
// Feel free to change them if it's discussed in the Editing WG.
["<div style=display:flex><span>[]abc</span><span>def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:flex\"><span>&nbsp;abc</span><span>def</span></div>",
    [true],
    {}],
["<div style=display:inline-flex><span>[]abc</span><span>def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:inline-flex\"><span>&nbsp;abc</span><span>def</span></div>",
    [true],
    {}],
["<div style=display:flex><span>abc[]</span><span>def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:flex\"><span>abc&nbsp;</span><span>def</span></div>",
    [true],
    {}],
["<div style=display:inline-flex><span>abc[]</span><span>def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:inline-flex\"><span>abc&nbsp;</span><span>def</span></div>",
    [true],
    {}],
["<div style=display:flex><span>abc</span><span>[]def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:flex\"><span>abc</span><span>&nbsp;def</span></div>",
    [true],
    {}],
["<div style=display:inline-flex><span>abc</span><span>[]def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:inline-flex\"><span>abc</span><span>&nbsp;def</span></div>",
    [true],
    {}],
["<div style=display:flex><span>abc</span><span>def[]</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:flex\"><span>abc</span><span>def&nbsp;</span></div>",
    [true],
    {}],
["<div style=display:inline-flex><span>abc</span><span>def[]</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:inline-flex\"><span>abc</span><span>def&nbsp;</span></div>",
    [true],
    {}],

// The expectations of these grid item scenarios based on Chrome 142.
// Feel free to change them if it's discussed in the Editing WG.
["<div style=display:grid><span>[]abc</span><span>def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:grid\"><span>&nbsp;abc</span><span>def</span></div>",
    [true],
    {}],
["<div style=display:inline-grid><span>[]abc</span><span>def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:inline-grid\"><span>&nbsp;abc</span><span>def</span></div>",
    [true],
    {}],
["<div style=display:grid><span>abc[]</span><span>def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:grid\"><span>abc&nbsp;</span><span>def</span></div>",
    [true],
    {}],
["<div style=display:inline-grid><span>abc[]</span><span>def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:inline-grid\"><span>abc&nbsp;</span><span>def</span></div>",
    [true],
    {}],
["<div style=display:grid><span>abc</span><span>[]def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:grid\"><span>abc</span><span>&nbsp;def</span></div>",
    [true],
    {}],
["<div style=display:inline-grid><span>abc</span><span>[]def</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:inline-grid\"><span>abc</span><span>&nbsp;def</span></div>",
    [true],
    {}],
["<div style=display:grid><span>abc</span><span>def[]</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:grid\"><span>abc</span><span>def&nbsp;</span></div>",
    [true],
    {}],
["<div style=display:inline-grid><span>abc</span><span>def[]</span></div>",
    [["inserttext"," "]],
    "<div style=\"display:inline-grid\"><span>abc</span><span>def&nbsp;</span></div>",
    [true],
    {}],
]
