// META: script=/resources/testdriver.js?feature=bidi
// META: script=/resources/testdriver-vendor.js
// META: script=/common/gc.js
// META: script=/bluetooth/resources/bluetooth-test.js
// META: script=/bluetooth/resources/bluetooth-fake-devices.js
// META: timeout=long
// Generated by
// //bluetooth/bidi/generate.py
'use strict';
const test_desc = 'Wrong Service name. Reject with TypeError.';
const expected = new DOMException(
    'Failed to execute \'getPrimaryServices\' on ' +
        '\'BluetoothRemoteGATTServer\': Invalid Service name: ' +
        '\'wrong_name\'. It must be a valid UUID alias (e.g. 0x1234), ' +
        'UUID (lowercase hex characters e.g. ' +
        '\'00001234-0000-1000-8000-00805f9b34fb\'), ' +
        'or recognized standard name from ' +
        'https://www.bluetooth.com/specifications/gatt/services' +
        ' e.g. \'alert_notification\'.',
    'TypeError');

bluetooth_bidi_test(
    () => getConnectedHealthThermometerDevice().then(
        ({device}) => assert_promise_rejects_with_message(
            device.gatt.getPrimaryServices('wrong_name'), expected,
            'Wrong Service name passed.')),
    test_desc);
