// META: title=test WebNN API element-wise sqrt operation
// META: global=window
// META: variant=?cpu
// META: variant=?gpu
// META: variant=?npu
// META: script=../resources/utils.js
// META: timeout=long

'use strict';

// https://www.w3.org/TR/webnn/#api-mlgraphbuilder-unary
// Compute the square root of the input tensor, element-wise.
//
// MLOperand sqrt(MLOperand input);


const getSqrtPrecisionTolerance = (graphResources) => {
  const toleranceValueDict = {float32: 1, float16: 1};
  const expectedDataType =
      getExpectedDataTypeOfSingleOutput(graphResources.expectedOutputs);
  return {metricType: 'ULP', value: toleranceValueDict[expectedDataType]};
};

const sqrtTests = [
  {
    'name': 'sqrt float32 0D scalar',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [4.0044636726379395],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [2.001115560531616],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'sqrt float32 1D constant tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.256007194519043,  7.786442279815674,   1.3684587478637695,
            8.05341625213623,   9.131288528442383,   8.52578067779541,
            4.870553493499756,  7.625959396362305,   2.705026865005493,
            8.709602355957031,  3.2687935829162598,  4.712882995605469,
            8.669181823730469,  8.829607009887695,   0.5529024600982666,
            7.958771228790283,  4.09640645980835,    7.919884204864502,
            4.424484729766846,  0.09894099831581116, 4.6900248527526855,
            1.5277378559112549, 5.929779529571533,   6.066471576690674
          ],
          'descriptor': {shape: [24], dataType: 'float32'},
          'constant': true
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693697690963745,  2.790419816970825,   1.1698113679885864,
            2.8378541469573975, 3.0218021869659424,  2.919893980026245,
            2.20693302154541,   2.7615139484405518,  1.644696593284607,
            2.9512035846710205, 1.8079805374145508,  2.170917510986328,
            2.944347381591797,  2.9714653491973877,  0.7435740828514099,
            2.821129322052002,  2.023958206176758,   2.8142287731170654,
            2.1034460067749023, 0.31454887986183167, 2.165646553039551,
            1.2360169887542725, 2.4351139068603516,  2.4630208015441895
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'sqrt float32 1D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.256007194519043,  7.786442279815674,   1.3684587478637695,
            8.05341625213623,   9.131288528442383,   8.52578067779541,
            4.870553493499756,  7.625959396362305,   2.705026865005493,
            8.709602355957031,  3.2687935829162598,  4.712882995605469,
            8.669181823730469,  8.829607009887695,   0.5529024600982666,
            7.958771228790283,  4.09640645980835,    7.919884204864502,
            4.424484729766846,  0.09894099831581116, 4.6900248527526855,
            1.5277378559112549, 5.929779529571533,   6.066471576690674
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693697690963745,  2.790419816970825,   1.1698113679885864,
            2.8378541469573975, 3.0218021869659424,  2.919893980026245,
            2.20693302154541,   2.7615139484405518,  1.644696593284607,
            2.9512035846710205, 1.8079805374145508,  2.170917510986328,
            2.944347381591797,  2.9714653491973877,  0.7435740828514099,
            2.821129322052002,  2.023958206176758,   2.8142287731170654,
            2.1034460067749023, 0.31454887986183167, 2.165646553039551,
            1.2360169887542725, 2.4351139068603516,  2.4630208015441895
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'sqrt float32 2D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.256007194519043,  7.786442279815674,   1.3684587478637695,
            8.05341625213623,   9.131288528442383,   8.52578067779541,
            4.870553493499756,  7.625959396362305,   2.705026865005493,
            8.709602355957031,  3.2687935829162598,  4.712882995605469,
            8.669181823730469,  8.829607009887695,   0.5529024600982666,
            7.958771228790283,  4.09640645980835,    7.919884204864502,
            4.424484729766846,  0.09894099831581116, 4.6900248527526855,
            1.5277378559112549, 5.929779529571533,   6.066471576690674
          ],
          'descriptor': {shape: [4, 6], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693697690963745,  2.790419816970825,   1.1698113679885864,
            2.8378541469573975, 3.0218021869659424,  2.919893980026245,
            2.20693302154541,   2.7615139484405518,  1.644696593284607,
            2.9512035846710205, 1.8079805374145508,  2.170917510986328,
            2.944347381591797,  2.9714653491973877,  0.7435740828514099,
            2.821129322052002,  2.023958206176758,   2.8142287731170654,
            2.1034460067749023, 0.31454887986183167, 2.165646553039551,
            1.2360169887542725, 2.4351139068603516,  2.4630208015441895
          ],
          'descriptor': {shape: [4, 6], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'sqrt float32 3D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.256007194519043,  7.786442279815674,   1.3684587478637695,
            8.05341625213623,   9.131288528442383,   8.52578067779541,
            4.870553493499756,  7.625959396362305,   2.705026865005493,
            8.709602355957031,  3.2687935829162598,  4.712882995605469,
            8.669181823730469,  8.829607009887695,   0.5529024600982666,
            7.958771228790283,  4.09640645980835,    7.919884204864502,
            4.424484729766846,  0.09894099831581116, 4.6900248527526855,
            1.5277378559112549, 5.929779529571533,   6.066471576690674
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693697690963745,  2.790419816970825,   1.1698113679885864,
            2.8378541469573975, 3.0218021869659424,  2.919893980026245,
            2.20693302154541,   2.7615139484405518,  1.644696593284607,
            2.9512035846710205, 1.8079805374145508,  2.170917510986328,
            2.944347381591797,  2.9714653491973877,  0.7435740828514099,
            2.821129322052002,  2.023958206176758,   2.8142287731170654,
            2.1034460067749023, 0.31454887986183167, 2.165646553039551,
            1.2360169887542725, 2.4351139068603516,  2.4630208015441895
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'sqrt float32 4D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.256007194519043,  7.786442279815674,   1.3684587478637695,
            8.05341625213623,   9.131288528442383,   8.52578067779541,
            4.870553493499756,  7.625959396362305,   2.705026865005493,
            8.709602355957031,  3.2687935829162598,  4.712882995605469,
            8.669181823730469,  8.829607009887695,   0.5529024600982666,
            7.958771228790283,  4.09640645980835,    7.919884204864502,
            4.424484729766846,  0.09894099831581116, 4.6900248527526855,
            1.5277378559112549, 5.929779529571533,   6.066471576690674
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693697690963745,  2.790419816970825,   1.1698113679885864,
            2.8378541469573975, 3.0218021869659424,  2.919893980026245,
            2.20693302154541,   2.7615139484405518,  1.644696593284607,
            2.9512035846710205, 1.8079805374145508,  2.170917510986328,
            2.944347381591797,  2.9714653491973877,  0.7435740828514099,
            2.821129322052002,  2.023958206176758,   2.8142287731170654,
            2.1034460067749023, 0.31454887986183167, 2.165646553039551,
            1.2360169887542725, 2.4351139068603516,  2.4630208015441895
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'sqrt float32 5D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.256007194519043,  7.786442279815674,   1.3684587478637695,
            8.05341625213623,   9.131288528442383,   8.52578067779541,
            4.870553493499756,  7.625959396362305,   2.705026865005493,
            8.709602355957031,  3.2687935829162598,  4.712882995605469,
            8.669181823730469,  8.829607009887695,   0.5529024600982666,
            7.958771228790283,  4.09640645980835,    7.919884204864502,
            4.424484729766846,  0.09894099831581116, 4.6900248527526855,
            1.5277378559112549, 5.929779529571533,   6.066471576690674
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693697690963745,  2.790419816970825,   1.1698113679885864,
            2.8378541469573975, 3.0218021869659424,  2.919893980026245,
            2.20693302154541,   2.7615139484405518,  1.644696593284607,
            2.9512035846710205, 1.8079805374145508,  2.170917510986328,
            2.944347381591797,  2.9714653491973877,  0.7435740828514099,
            2.821129322052002,  2.023958206176758,   2.8142287731170654,
            2.1034460067749023, 0.31454887986183167, 2.165646553039551,
            1.2360169887542725, 2.4351139068603516,  2.4630208015441895
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float32'}
        }
      }
    }
  },

  // float16 tests
  {
    'name': 'sqrt float16 0D scalar',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [4.00390625],
          'descriptor': {shape: [], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput':
            {'data': [2], 'descriptor': {shape: [], dataType: 'float16'}}
      }
    }
  },
  {
    'name': 'sqrt float16 1D constant tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.2578125,  7.78515625, 1.3681640625, 8.0546875,   9.1328125,
            8.5234375,  4.87109375, 7.625,        2.705078125, 8.7109375,
            3.26953125, 4.7109375,  8.671875,     8.828125,    0.552734375,
            7.95703125, 4.09765625, 7.91796875,   4.42578125,  0.09893798828125,
            4.69140625, 1.52734375, 5.9296875,    6.06640625
          ],
          'descriptor': {shape: [24], dataType: 'float16'},
          'constant': true
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693359375, 2.791015625, 1.169921875, 2.837890625, 3.021484375,
            2.919921875, 2.20703125,  2.76171875,  1.64453125,  2.951171875,
            1.80859375,  2.169921875, 2.9453125,   2.970703125, 0.74365234375,
            2.8203125,   2.0234375,   2.814453125, 2.103515625, 0.314453125,
            2.166015625, 1.236328125, 2.435546875, 2.462890625
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'sqrt float16 1D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.2578125,  7.78515625, 1.3681640625, 8.0546875,   9.1328125,
            8.5234375,  4.87109375, 7.625,        2.705078125, 8.7109375,
            3.26953125, 4.7109375,  8.671875,     8.828125,    0.552734375,
            7.95703125, 4.09765625, 7.91796875,   4.42578125,  0.09893798828125,
            4.69140625, 1.52734375, 5.9296875,    6.06640625
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693359375, 2.791015625, 1.169921875, 2.837890625, 3.021484375,
            2.919921875, 2.20703125,  2.76171875,  1.64453125,  2.951171875,
            1.80859375,  2.169921875, 2.9453125,   2.970703125, 0.74365234375,
            2.8203125,   2.0234375,   2.814453125, 2.103515625, 0.314453125,
            2.166015625, 1.236328125, 2.435546875, 2.462890625
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'sqrt float16 2D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.2578125,  7.78515625, 1.3681640625, 8.0546875,   9.1328125,
            8.5234375,  4.87109375, 7.625,        2.705078125, 8.7109375,
            3.26953125, 4.7109375,  8.671875,     8.828125,    0.552734375,
            7.95703125, 4.09765625, 7.91796875,   4.42578125,  0.09893798828125,
            4.69140625, 1.52734375, 5.9296875,    6.06640625
          ],
          'descriptor': {shape: [4, 6], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693359375, 2.791015625, 1.169921875, 2.837890625, 3.021484375,
            2.919921875, 2.20703125,  2.76171875,  1.64453125,  2.951171875,
            1.80859375,  2.169921875, 2.9453125,   2.970703125, 0.74365234375,
            2.8203125,   2.0234375,   2.814453125, 2.103515625, 0.314453125,
            2.166015625, 1.236328125, 2.435546875, 2.462890625
          ],
          'descriptor': {shape: [4, 6], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'sqrt float16 3D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.2578125,  7.78515625, 1.3681640625, 8.0546875,   9.1328125,
            8.5234375,  4.87109375, 7.625,        2.705078125, 8.7109375,
            3.26953125, 4.7109375,  8.671875,     8.828125,    0.552734375,
            7.95703125, 4.09765625, 7.91796875,   4.42578125,  0.09893798828125,
            4.69140625, 1.52734375, 5.9296875,    6.06640625
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693359375, 2.791015625, 1.169921875, 2.837890625, 3.021484375,
            2.919921875, 2.20703125,  2.76171875,  1.64453125,  2.951171875,
            1.80859375,  2.169921875, 2.9453125,   2.970703125, 0.74365234375,
            2.8203125,   2.0234375,   2.814453125, 2.103515625, 0.314453125,
            2.166015625, 1.236328125, 2.435546875, 2.462890625
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'sqrt float16 4D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.2578125,  7.78515625, 1.3681640625, 8.0546875,   9.1328125,
            8.5234375,  4.87109375, 7.625,        2.705078125, 8.7109375,
            3.26953125, 4.7109375,  8.671875,     8.828125,    0.552734375,
            7.95703125, 4.09765625, 7.91796875,   4.42578125,  0.09893798828125,
            4.69140625, 1.52734375, 5.9296875,    6.06640625
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693359375, 2.791015625, 1.169921875, 2.837890625, 3.021484375,
            2.919921875, 2.20703125,  2.76171875,  1.64453125,  2.951171875,
            1.80859375,  2.169921875, 2.9453125,   2.970703125, 0.74365234375,
            2.8203125,   2.0234375,   2.814453125, 2.103515625, 0.314453125,
            2.166015625, 1.236328125, 2.435546875, 2.462890625
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'sqrt float16 5D tensor',
    'graph': {
      'inputs': {
        'sqrtInput': {
          'data': [
            7.2578125,  7.78515625, 1.3681640625, 8.0546875,   9.1328125,
            8.5234375,  4.87109375, 7.625,        2.705078125, 8.7109375,
            3.26953125, 4.7109375,  8.671875,     8.828125,    0.552734375,
            7.95703125, 4.09765625, 7.91796875,   4.42578125,  0.09893798828125,
            4.69140625, 1.52734375, 5.9296875,    6.06640625
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'sqrt',
        'arguments': [{'input': 'sqrtInput'}],
        'outputs': 'sqrtOutput'
      }],
      'expectedOutputs': {
        'sqrtOutput': {
          'data': [
            2.693359375, 2.791015625, 1.169921875, 2.837890625, 3.021484375,
            2.919921875, 2.20703125,  2.76171875,  1.64453125,  2.951171875,
            1.80859375,  2.169921875, 2.9453125,   2.970703125, 0.74365234375,
            2.8203125,   2.0234375,   2.814453125, 2.103515625, 0.314453125,
            2.166015625, 1.236328125, 2.435546875, 2.462890625
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float16'}
        }
      }
    }
  }
];

webnn_conformance_test(
    sqrtTests, buildAndExecuteGraph, getSqrtPrecisionTolerance);
