// META: title=test WebNN API element-wise log operation
// META: global=window
// META: variant=?cpu
// META: variant=?gpu
// META: variant=?npu
// META: script=../resources/utils.js
// META: timeout=long

'use strict';

// https://www.w3.org/TR/webnn/#api-mlgraphbuilder-unary
// Compute the natural logarithm of the input tensor, element-wise.
//
// MLOperand log(MLOperand input);


const getLogPrecisionTolerance = () => {
  return {metricType: 'ULP', value: 8};
};

const logTests = [
  {
    'name': 'log float32 positive 0D scalar',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [63.82542037963867],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [4.15615177154541],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'log float32 positive 1D constant tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.82542037963867,  25.317724227905273, 96.44790649414062,
            40.91856384277344,  36.579071044921875, 57.81629943847656,
            10.057244300842285, 17.836828231811523, 50.79246520996094,
            83.860595703125,    12.065509796142578, 22.702478408813477,
            47.559814453125,    17.543880462646484, 32.65243911743164,
            20.353010177612305, 52.54472351074219,  45.608802795410156,
            30.385812759399414, 13.709558486938477, 10.396759986877441,
            50.840946197509766, 5.682034492492676,  94.02275848388672
          ],
          'descriptor': {shape: [24], dataType: 'float32'},
          'constant': true
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15615177154541,   3.2315046787261963, 4.569003105163574,
            3.7115838527679443, 3.5994763374328613, 4.057270526885986,
            2.308293104171753,  2.88126540184021,   3.927747964859009,
            4.4291558265686035, 2.4903509616851807, 3.122474193572998,
            3.861988067626953,  2.8647050857543945, 3.48591947555542,
            3.0132288932800293, 3.9616646766662598, 3.820100784301758,
            3.413975715637207,  2.618093252182007,  2.34149432182312,
            3.9287021160125732, 1.7373093366622925, 4.54353666305542
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'log float32 positive 1D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.82542037963867,  25.317724227905273, 96.44790649414062,
            40.91856384277344,  36.579071044921875, 57.81629943847656,
            10.057244300842285, 17.836828231811523, 50.79246520996094,
            83.860595703125,    12.065509796142578, 22.702478408813477,
            47.559814453125,    17.543880462646484, 32.65243911743164,
            20.353010177612305, 52.54472351074219,  45.608802795410156,
            30.385812759399414, 13.709558486938477, 10.396759986877441,
            50.840946197509766, 5.682034492492676,  94.02275848388672
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15615177154541,   3.2315046787261963, 4.569003105163574,
            3.7115838527679443, 3.5994763374328613, 4.057270526885986,
            2.308293104171753,  2.88126540184021,   3.927747964859009,
            4.4291558265686035, 2.4903509616851807, 3.122474193572998,
            3.861988067626953,  2.8647050857543945, 3.48591947555542,
            3.0132288932800293, 3.9616646766662598, 3.820100784301758,
            3.413975715637207,  2.618093252182007,  2.34149432182312,
            3.9287021160125732, 1.7373093366622925, 4.54353666305542
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'log float32 positive 2D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.82542037963867,  25.317724227905273, 96.44790649414062,
            40.91856384277344,  36.579071044921875, 57.81629943847656,
            10.057244300842285, 17.836828231811523, 50.79246520996094,
            83.860595703125,    12.065509796142578, 22.702478408813477,
            47.559814453125,    17.543880462646484, 32.65243911743164,
            20.353010177612305, 52.54472351074219,  45.608802795410156,
            30.385812759399414, 13.709558486938477, 10.396759986877441,
            50.840946197509766, 5.682034492492676,  94.02275848388672
          ],
          'descriptor': {shape: [4, 6], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15615177154541,   3.2315046787261963, 4.569003105163574,
            3.7115838527679443, 3.5994763374328613, 4.057270526885986,
            2.308293104171753,  2.88126540184021,   3.927747964859009,
            4.4291558265686035, 2.4903509616851807, 3.122474193572998,
            3.861988067626953,  2.8647050857543945, 3.48591947555542,
            3.0132288932800293, 3.9616646766662598, 3.820100784301758,
            3.413975715637207,  2.618093252182007,  2.34149432182312,
            3.9287021160125732, 1.7373093366622925, 4.54353666305542
          ],
          'descriptor': {shape: [4, 6], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'log float32 positive 3D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.82542037963867,  25.317724227905273, 96.44790649414062,
            40.91856384277344,  36.579071044921875, 57.81629943847656,
            10.057244300842285, 17.836828231811523, 50.79246520996094,
            83.860595703125,    12.065509796142578, 22.702478408813477,
            47.559814453125,    17.543880462646484, 32.65243911743164,
            20.353010177612305, 52.54472351074219,  45.608802795410156,
            30.385812759399414, 13.709558486938477, 10.396759986877441,
            50.840946197509766, 5.682034492492676,  94.02275848388672
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15615177154541,   3.2315046787261963, 4.569003105163574,
            3.7115838527679443, 3.5994763374328613, 4.057270526885986,
            2.308293104171753,  2.88126540184021,   3.927747964859009,
            4.4291558265686035, 2.4903509616851807, 3.122474193572998,
            3.861988067626953,  2.8647050857543945, 3.48591947555542,
            3.0132288932800293, 3.9616646766662598, 3.820100784301758,
            3.413975715637207,  2.618093252182007,  2.34149432182312,
            3.9287021160125732, 1.7373093366622925, 4.54353666305542
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'log float32 positive 4D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.82542037963867,  25.317724227905273, 96.44790649414062,
            40.91856384277344,  36.579071044921875, 57.81629943847656,
            10.057244300842285, 17.836828231811523, 50.79246520996094,
            83.860595703125,    12.065509796142578, 22.702478408813477,
            47.559814453125,    17.543880462646484, 32.65243911743164,
            20.353010177612305, 52.54472351074219,  45.608802795410156,
            30.385812759399414, 13.709558486938477, 10.396759986877441,
            50.840946197509766, 5.682034492492676,  94.02275848388672
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15615177154541,   3.2315046787261963, 4.569003105163574,
            3.7115838527679443, 3.5994763374328613, 4.057270526885986,
            2.308293104171753,  2.88126540184021,   3.927747964859009,
            4.4291558265686035, 2.4903509616851807, 3.122474193572998,
            3.861988067626953,  2.8647050857543945, 3.48591947555542,
            3.0132288932800293, 3.9616646766662598, 3.820100784301758,
            3.413975715637207,  2.618093252182007,  2.34149432182312,
            3.9287021160125732, 1.7373093366622925, 4.54353666305542
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'log float32 positive 5D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.82542037963867,  25.317724227905273, 96.44790649414062,
            40.91856384277344,  36.579071044921875, 57.81629943847656,
            10.057244300842285, 17.836828231811523, 50.79246520996094,
            83.860595703125,    12.065509796142578, 22.702478408813477,
            47.559814453125,    17.543880462646484, 32.65243911743164,
            20.353010177612305, 52.54472351074219,  45.608802795410156,
            30.385812759399414, 13.709558486938477, 10.396759986877441,
            50.840946197509766, 5.682034492492676,  94.02275848388672
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15615177154541,   3.2315046787261963, 4.569003105163574,
            3.7115838527679443, 3.5994763374328613, 4.057270526885986,
            2.308293104171753,  2.88126540184021,   3.927747964859009,
            4.4291558265686035, 2.4903509616851807, 3.122474193572998,
            3.861988067626953,  2.8647050857543945, 3.48591947555542,
            3.0132288932800293, 3.9616646766662598, 3.820100784301758,
            3.413975715637207,  2.618093252182007,  2.34149432182312,
            3.9287021160125732, 1.7373093366622925, 4.54353666305542
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float32'}
        }
      }
    }
  },

  // float16 tests
  {
    'name': 'log float16 positive 0D scalar',
    'graph': {
      'inputs': {
        'logInput':
            {'data': [63.8125], 'descriptor': {shape: [], dataType: 'float16'}}
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput':
            {'data': [4.15625], 'descriptor': {shape: [], dataType: 'float16'}}
      }
    }
  },
  {
    'name': 'log float16 positive 1D constant tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.8125,    25.3125,    96.4375,    40.90625,  36.59375,
            57.8125,    10.0546875, 17.84375,   50.78125,  83.875,
            12.0625,    22.703125,  47.5625,    17.546875, 32.65625,
            20.359375,  52.53125,   45.59375,   30.390625, 13.7109375,
            10.3984375, 50.84375,   5.68359375, 94
          ],
          'descriptor': {shape: [24], dataType: 'float16'},
          'constant': true
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15625,     3.23046875,  4.5703125,    3.7109375,   3.599609375,
            4.05859375,  2.30859375,  2.880859375,  3.927734375, 4.4296875,
            2.490234375, 3.123046875, 3.861328125,  2.865234375, 3.486328125,
            3.013671875, 3.9609375,   3.8203125,    3.4140625,   2.619140625,
            2.341796875, 3.9296875,   1.7373046875, 4.54296875
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'log float16 positive 1D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.8125,    25.3125,    96.4375,    40.90625,  36.59375,
            57.8125,    10.0546875, 17.84375,   50.78125,  83.875,
            12.0625,    22.703125,  47.5625,    17.546875, 32.65625,
            20.359375,  52.53125,   45.59375,   30.390625, 13.7109375,
            10.3984375, 50.84375,   5.68359375, 94
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15625,     3.23046875,  4.5703125,    3.7109375,   3.599609375,
            4.05859375,  2.30859375,  2.880859375,  3.927734375, 4.4296875,
            2.490234375, 3.123046875, 3.861328125,  2.865234375, 3.486328125,
            3.013671875, 3.9609375,   3.8203125,    3.4140625,   2.619140625,
            2.341796875, 3.9296875,   1.7373046875, 4.54296875
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'log float16 positive 2D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.8125,    25.3125,    96.4375,    40.90625,  36.59375,
            57.8125,    10.0546875, 17.84375,   50.78125,  83.875,
            12.0625,    22.703125,  47.5625,    17.546875, 32.65625,
            20.359375,  52.53125,   45.59375,   30.390625, 13.7109375,
            10.3984375, 50.84375,   5.68359375, 94
          ],
          'descriptor': {shape: [4, 6], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15625,     3.23046875,  4.5703125,    3.7109375,   3.599609375,
            4.05859375,  2.30859375,  2.880859375,  3.927734375, 4.4296875,
            2.490234375, 3.123046875, 3.861328125,  2.865234375, 3.486328125,
            3.013671875, 3.9609375,   3.8203125,    3.4140625,   2.619140625,
            2.341796875, 3.9296875,   1.7373046875, 4.54296875
          ],
          'descriptor': {shape: [4, 6], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'log float16 positive 3D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.8125,    25.3125,    96.4375,    40.90625,  36.59375,
            57.8125,    10.0546875, 17.84375,   50.78125,  83.875,
            12.0625,    22.703125,  47.5625,    17.546875, 32.65625,
            20.359375,  52.53125,   45.59375,   30.390625, 13.7109375,
            10.3984375, 50.84375,   5.68359375, 94
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15625,     3.23046875,  4.5703125,    3.7109375,   3.599609375,
            4.05859375,  2.30859375,  2.880859375,  3.927734375, 4.4296875,
            2.490234375, 3.123046875, 3.861328125,  2.865234375, 3.486328125,
            3.013671875, 3.9609375,   3.8203125,    3.4140625,   2.619140625,
            2.341796875, 3.9296875,   1.7373046875, 4.54296875
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'log float16 positive 4D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.8125,    25.3125,    96.4375,    40.90625,  36.59375,
            57.8125,    10.0546875, 17.84375,   50.78125,  83.875,
            12.0625,    22.703125,  47.5625,    17.546875, 32.65625,
            20.359375,  52.53125,   45.59375,   30.390625, 13.7109375,
            10.3984375, 50.84375,   5.68359375, 94
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15625,     3.23046875,  4.5703125,    3.7109375,   3.599609375,
            4.05859375,  2.30859375,  2.880859375,  3.927734375, 4.4296875,
            2.490234375, 3.123046875, 3.861328125,  2.865234375, 3.486328125,
            3.013671875, 3.9609375,   3.8203125,    3.4140625,   2.619140625,
            2.341796875, 3.9296875,   1.7373046875, 4.54296875
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'log float16 positive 5D tensor',
    'graph': {
      'inputs': {
        'logInput': {
          'data': [
            63.8125,    25.3125,    96.4375,    40.90625,  36.59375,
            57.8125,    10.0546875, 17.84375,   50.78125,  83.875,
            12.0625,    22.703125,  47.5625,    17.546875, 32.65625,
            20.359375,  52.53125,   45.59375,   30.390625, 13.7109375,
            10.3984375, 50.84375,   5.68359375, 94
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'log',
        'arguments': [{'input': 'logInput'}],
        'outputs': 'logOutput'
      }],
      'expectedOutputs': {
        'logOutput': {
          'data': [
            4.15625,     3.23046875,  4.5703125,    3.7109375,   3.599609375,
            4.05859375,  2.30859375,  2.880859375,  3.927734375, 4.4296875,
            2.490234375, 3.123046875, 3.861328125,  2.865234375, 3.486328125,
            3.013671875, 3.9609375,   3.8203125,    3.4140625,   2.619140625,
            2.341796875, 3.9296875,   1.7373046875, 4.54296875
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float16'}
        }
      }
    }
  }
];

webnn_conformance_test(
    logTests, buildAndExecuteGraph, getLogPrecisionTolerance);
