load(libdir + "asserts.js");

function test(src) {
  assertThrowsInstanceOf(() => eval(src), SyntaxError);
}

test('/(?<a>.)(?<a>.)/');
test('/((?<a>.)(?<a>.))/');
test('/(?<a>.)((?<a>.))/');
test('/((?<a>.))(?<a>.)/');
test('/(?<a>.)(?:.|(?<a>.)/');
test('/(?<a>.)(?:.|(?<a>.)/');
test('/(?<a>.)(?:(.)|(?<a>.)/');
test('/(?<a>.)(?:(?:.)|(?<a>.)/');
test('/(?<a>.)((?<a>.)|(?<b>.))/');
test('/(?<b>.)((?<a>.)|(?<b>.))/');
test('/((?<a>.)|(?<b>.))(?<a>.)/');
test('/((?<a>.)|(?<b>.))(?<b>.)/');
test('/((?<a>.)|((?<b>.)|(?<c>.))(?<b>.)/');
test('/((?<a>.)|((?<b>.)|(?<c>.))(?<c>.)/');
test('/x(?<a>.)((((?<a>.)|(?<a>.))|(?<a>.)|(?<a>.))|(?<a>.))|(?<a>.)y/');
test('/x((?<a>.)(((?<a>.)|(?<a>.))|(?<a>.)|(?<a>.))|(?<a>.))|(?<a>.)y/');
test('/x(((?<a>.)((?<a>.)|(?<a>.))|(?<a>.)|(?<a>.))|(?<a>.))|(?<a>.)y/');
test('/x((((?<a>.)(?<a>.)|(?<a>.))|(?<a>.)|(?<a>.))|(?<a>.))|(?<a>.)y/');
test('/x(?<a>.)|((?<a>.)|(?<a>.)|((?<a>.)|((?<a>.)|(?<a>.)(?<a>.))))y/');
test('/x(?<a>.)|((?<a>.)|(?<a>.)|((?<a>.)|((?<a>.)|(?<a>.))(?<a.)))y/');
test('/x(?<a>.)|((?<a>.)|(?<a>.)|((?<a>.)|((?<a>.)|(?<a>.)))(?<a>.))y/');
test('/x(?<a>.)|((?<a>.)|(?<a>.)|((?<a>.)|((?<a>.)|(?<a>.))))(?<a>.)y/');
