// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["bold",""]],
    "foo[]bar",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["bold",""]],
    "<p><span style=\"font-weight:bold\">[foo</span></p> <p><span style=\"font-weight:bold\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["bold",""]],
    "<p><b>[foo</b></p> <p><b>bar]</b></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:bold\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["bold",""]],
    "<b><span>[foo</span> <span>bar]</span></b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["bold",""]],
    "<p><span style=\"font-weight:bold\">[foo</span></p><p> <span style=\"font-weight:bold\"><span>bar</span></span> </p><p><span style=\"font-weight:bold\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["bold",""]],
    "<p><b>[foo</b></p><p> <b><span>bar</span></b> </p><p><b>baz]</b></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["bold",""]],
    "<p><span style=\"font-weight:bold\">[foo</span></p><p><span style=\"font-weight:bold\"><br></span></p><p><span style=\"font-weight:bold\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["bold",""]],
    "<p><b>[foo</b></p><p><b><br></b></p><p><b>bar]</b></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<b>foo[]bar</b>",
    [["bold",""]],
    "<b>foo[]bar</b>",
    [true],
    {"bold":[false,true,"",false,false,""]}],
["<i>foo[]bar</i>",
    [["bold",""]],
    "<i>foo[]bar</i>",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["<span>foo</span>{}<span>bar</span>",
    [["bold",""]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["<span>foo[</span><span>]bar</span>",
    [["bold",""]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>[bar]</b>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
    [["bold",""]],
    "foo<b>[barbaz]qoz</b>quz",
    [true],
    {"bold":[true,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">[bar</span><i><span style=\"font-weight:bold\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>[bar</b><i><b>baz]</b>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["bold",""]],
    "{<p></p><p> </p><p><span style=\"font-weight:bold\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["bold",""]],
    "{<p></p><p> </p><p><b>foo</b></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span contenteditable=false>[bar]</span>baz",
    [["bold",""]],
    "foo<span contenteditable=\"false\">[bar]</span>baz",
    [false],
    {"bold":[false,false,"",false,false,""]}],
["fo[o<span contenteditable=false>bar</span>b]az",
    [["stylewithcss","true"],["bold",""]],
    "fo<span style=\"font-weight:bold\">[o</span><span contenteditable=\"false\">bar</span><span style=\"font-weight:bold\">b]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["fo[o<span contenteditable=false>bar</span>b]az",
    [["stylewithcss","false"],["bold",""]],
    "fo<b>[o</b><span contenteditable=\"false\">bar</span><b>b]</b>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span contenteditable=false>ba[r</span>b]az",
    [["bold",""]],
    "foo<span contenteditable=\"false\">ba[r</span>b]az",
    [false],
    {"bold":[false,false,"",false,false,""]}],
["fo[o<span contenteditable=false>b]ar</span>baz",
    [["bold",""]],
    "fo[o<span contenteditable=\"false\">b]ar</span>baz",
    [false],
    {"bold":[false,false,"",false,false,""]}],
["fo[<b>o</b><span contenteditable=false>bar</span><b>b</b>]az",
    [["stylewithcss","true"],["bold",""]],
    "fo[o<span contenteditable=\"false\">bar</span>b]az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["fo[<b>o</b><span contenteditable=false>bar</span><b>b</b>]az",
    [["stylewithcss","false"],["bold",""]],
    "fo[o<span contenteditable=\"false\">bar</span>b]az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span contenteditable=false>foo<span contenteditable=true>[bar]</span>baz</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span contenteditable=\"false\">foo<span contenteditable=\"true\"><span style=\"font-weight:bold\">[bar]</span></span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span contenteditable=false>foo<span contenteditable=true>[bar]</span>baz</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span contenteditable=\"false\">foo<span contenteditable=\"true\"><b>[bar]</b></span>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span contenteditable=false>fo[o<span contenteditable=true>bar</span>b]az</span>",
    [["bold",""]],
    "<span contenteditable=\"false\">fo[o<span contenteditable=\"true\">bar</span>b]az</span>",
    [false],
    {"bold":[false,false,"",false,false,""]}],
["<span contenteditable=false>foo<span contenteditable=true>ba[r</span>b]az</span>",
    [["bold",""]],
    "<span contenteditable=\"false\">foo<span contenteditable=\"true\">ba[r</span>b]az</span>",
    [false],
    {"bold":[false,false,"",false,false,""]}],
["<span contenteditable=false>fo[o<span contenteditable=true>b]ar</span>baz</span>",
    [["bold",""]],
    "<span contenteditable=\"false\">fo[o<span contenteditable=\"true\">b]ar</span>baz</span>",
    [false],
    {"bold":[false,false,"",false,false,""]}],
["<span contenteditable=false>fo[<b>o<span contenteditable=true>bar</span>b</b>]az</span>",
    [["bold",""]],
    "<span contenteditable=\"false\">fo[<b>o<span contenteditable=\"true\">bar</span>b</b>]az</span>",
    [false],
    {"bold":[false,true,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["bold",""]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"font-weight:bold\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["bold",""]],
    "<table><tbody><tr><td>foo</td><td>b<b>[a]</b>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["bold",""]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"font-weight:bold\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["bold",""]],
    "<table><tbody><tr><td>foo</td>{<td><b>bar</b></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["bold",""]],
    "<table><tbody><tr>{<td><span style=\"font-weight:bold\">foo</span></td><td><span style=\"font-weight:bold\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["bold",""]],
    "<table><tbody><tr>{<td><b>foo</b></td><td><b>bar</b></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["bold",""]],
    "<table><tbody>{<tr><td><span style=\"font-weight:bold\">foo</span></td><td><span style=\"font-weight:bold\">bar</span></td><td><span style=\"font-weight:bold\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["bold",""]],
    "<table><tbody>{<tr><td><b>foo</b></td><td><b>bar</b></td><td><b>baz</b></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["bold",""]],
    "<table>{<tbody><tr><td><span style=\"font-weight:bold\">foo</span></td><td><span style=\"font-weight:bold\">bar</span></td><td><span style=\"font-weight:bold\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["bold",""]],
    "<table>{<tbody><tr><td><b>foo</b></td><td><b>bar</b></td><td><b>baz</b></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["bold",""]],
    "{<table><tbody><tr><td><span style=\"font-weight:bold\">foo</span></td><td><span style=\"font-weight:bold\">bar</span></td><td><span style=\"font-weight:bold\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["bold",""]],
    "{<table><tbody><tr><td><b>foo</b></td><td><b>bar</b></td><td><b>baz</b></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: bold\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: bold\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>bar</b>[baz]",
    [["bold",""]],
    "foo<b>bar[baz]</b>",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["[foo]<b>bar</b>baz",
    [["bold",""]],
    "<b>[foo]bar</b>baz",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<b>baz</b>",
    [["stylewithcss","true"],["bold",""]],
    "<b>foo</b><span style=\"font-weight:bold\">[bar]</span><b>baz</b>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<b>baz</b>",
    [["stylewithcss","false"],["bold",""]],
    "<b>foo[bar]baz</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
// Should not use the near <strong> as alternative container of <b> and
// <span style="font-weight: bold">.
["foo<strong>bar</strong>[baz]",
    [["bold",""]],
    "foo<strong>bar</strong><b>baz</b>",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["[foo]<strong>bar</strong>baz",
    [["bold",""]],
    "<b>foo</b><strong>bar</strong>baz",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["<strong>foo</strong>[bar]<strong>baz</strong>",
    [["bold",""]],
    "<strong>foo</strong><b>bar</b><strong>baz</strong>",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<strong>baz</strong>",
    [["bold",""]],
    "<b>foo[bar]</b><strong>baz</strong>",
    [true],
    {"bold":[false,false,"",false,true,""]}],
// Should not use the near <b> as alternative container of
// <span style="font-weight: bold">
["<strong>foo</strong>[bar]<b>baz</b>",
    [["stylewithcss","true"],["bold",""]],
    "<strong>foo</strong><span style=\"font-weight:bold\">bar</span><b>baz</b>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
// Should use the near <b> as new container
["<strong>foo</strong>[bar]<b>baz</b>",
    [["stylewithcss","false"],["bold",""]],
    "<strong>foo</strong><b>barbaz</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[<b>bar</b>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>bar</b>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>bar]</b>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>bar]</b>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar</b>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar</b>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo{<b></b>}baz",
    [["bold",""]],
    "foo{<b></b>}baz",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["foo{<i></i>}baz",
    [["bold",""]],
    "foo{<i></i>}baz",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["foo{<b><i></i></b>}baz",
    [["bold",""]],
    "foo{<b><i></i></b>}baz",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["foo{<i><b></b></i>}baz",
    [["bold",""]],
    "foo{<i><b></b></i>}baz",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["foo<strong>[bar]</strong>baz",
    [["bold",""]],
    "foo[bar]baz",
    [true],
    {"bold":[false,true,"",false,false,""]}],
["foo[<strong>bar</strong>]baz",
    [["bold",""]],
    "foo[bar]baz",
    [true],
    {"bold":[false,true,"",false,false,""]}],
["foo[<strong>bar]</strong>baz",
    [["bold",""]],
    "foo[bar]baz",
    [true],
    {"bold":[false,true,"",false,false,""]}],
["foo<strong>[bar</strong>]baz",
    [["bold",""]],
    "foo[bar]baz",
    [true],
    {"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: bold\">bar</span>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: bold\">bar</span>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: bold\">bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: bold\">bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: bold\">[bar</span>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: bold\">[bar</span>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<b>{<p>foo</p><p>bar</p>}<p>baz</p></b>",
    [["stylewithcss","true"],["bold",""]],
    "{<p>foo</p><p>bar</p>}<p><span style=\"font-weight:bold\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<b>{<p>foo</p><p>bar</p>}<p>baz</p></b>",
    [["stylewithcss","false"],["bold",""]],
    "{<p>foo</p><p>bar</p>}<p><b>baz</b></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<b><p>foo[<i>bar</i>}</p><p>baz</p></b>",
    [["stylewithcss","true"],["bold",""]],
    "<p><span style=\"font-weight:bold\">foo[</span><i>bar</i>}</p><p><span style=\"font-weight:bold\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<b><p>foo[<i>bar</i>}</p><p>baz</p></b>",
    [["stylewithcss","false"],["bold",""]],
    "<p><b>foo[</b><i>bar</i>}</p><p><b>baz</b></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo [bar <b>baz] qoz</b> quz sic",
    [["bold",""]],
    "foo <b>[bar baz] qoz</b> quz sic",
    [true],
    {"bold":[true,false,"",false,true,""]}],
["foo bar <b>baz [qoz</b> quz] sic",
    [["bold",""]],
    "foo bar <b>baz [qoz quz]</b> sic",
    [true],
    {"bold":[true,false,"",false,true,""]}],
["<b id=purple>bar [baz] qoz</b>",
    [["stylewithcss","true"],["bold",""]],
    "<span id=\"purple\"><span style=\"font-weight:bold\">bar </span>[baz]<span style=\"font-weight:bold\"> qoz</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<b id=purple>bar [baz] qoz</b>",
    [["stylewithcss","false"],["bold",""]],
    "<span id=\"purple\"><b>bar </b>[baz]<b> qoz</b></span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 100\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 100\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>[bar]</b>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 200\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 200\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>[bar]</b>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 300\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 300\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>[bar]</b>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 400\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 400\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>[bar]</b>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 500\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 500\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>[bar]</b>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 600\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 600\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 700\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 700\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 800\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 800\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 900\">[bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 900\">[bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 400\">[bar</span>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">[bar</span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 400\">[bar</span>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>[bar</b>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 700\">[bar</span>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 700\">[bar</span>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: 400\">bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[<span style=\"font-weight:bold\">bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo[<span style=\"font-weight: 400\">bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[<b>bar]</b>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[<span style=\"font-weight: 700\">bar]</span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: 700\">bar]</span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: 400\">bar</span>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[<span style=\"font-weight:bold\">bar</span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo[<span style=\"font-weight: 400\">bar</span>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[<b>bar</b>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[<span style=\"font-weight: 700\">bar</span>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: 700\">bar</span>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 100\">foo[bar]baz</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:100\">foo<span style=\"font-weight:bold\">[bar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 100\">foo[bar]baz</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:100\">foo<b>[bar]</b>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 400\">foo[bar]baz</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:400\">foo<span style=\"font-weight:bold\">[bar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 400\">foo[bar]baz</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:400\">foo<b>[bar]</b>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 700\">foo[bar]baz</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:700\">foo</span>[bar]<span style=\"font-weight:700\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 700\">foo[bar]baz</span>",
    [["stylewithcss","false"],["bold",""]],
    "<b>foo</b>[bar]<b>baz</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 900\">foo[bar]baz</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:900\">foo</span>[bar]<span style=\"font-weight:900\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 900\">foo[bar]baz</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:900\">foo</span>[bar]<span style=\"font-weight:900\">baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<span style=\"font-weight: 100\">foobar]baz</span>",
    [["stylewithcss","true"],["bold",""]],
    "{<span style=\"font-weight:100\"><span style=\"font-weight:bold\">foobar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["{<span style=\"font-weight: 100\">foobar]baz</span>",
    [["stylewithcss","false"],["bold",""]],
    "{<span style=\"font-weight:100\"><b>foobar]</b>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<span style=\"font-weight: 400\">foobar]baz</span>",
    [["stylewithcss","true"],["bold",""]],
    "{<span style=\"font-weight:400\"><span style=\"font-weight:bold\">foobar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["{<span style=\"font-weight: 400\">foobar]baz</span>",
    [["stylewithcss","false"],["bold",""]],
    "{<span style=\"font-weight:400\"><b>foobar]</b>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<span style=\"font-weight: 700\">foobar]baz</span>",
    [["stylewithcss","true"],["bold",""]],
    "{foobar]<span style=\"font-weight:700\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<span style=\"font-weight: 700\">foobar]baz</span>",
    [["stylewithcss","false"],["bold",""]],
    "{foobar]<b>baz</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<span style=\"font-weight: 900\">foobar]baz</span>",
    [["bold",""]],
    "{foobar]<span style=\"font-weight:900\">baz</span>",
    [true],
    {"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 100\">foo[barbaz</span>}",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:100\">foo<span style=\"font-weight:bold\">[barbaz</span></span>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 100\">foo[barbaz</span>}",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:100\">foo<b>[barbaz</b></span>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 400\">foo[barbaz</span>}",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:400\">foo<span style=\"font-weight:bold\">[barbaz</span></span>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 400\">foo[barbaz</span>}",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:400\">foo<b>[barbaz</b></span>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 700\">foo[barbaz</span>}",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:700\">foo</span>[barbaz}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 700\">foo[barbaz</span>}",
    [["stylewithcss","false"],["bold",""]],
    "<b>foo</b>[barbaz}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 900\">foo[barbaz</span>}",
    [["bold",""]],
    "<span style=\"font-weight:900\">foo</span>[barbaz}",
    [true],
    {"bold":[false,true,"",false,false,""]}],
["<h3>foo[bar]baz</h3>",
    [["stylewithcss","true"],["bold",""]],
    "<h3>foo<span style=\"font-weight:normal\">[bar]</span>baz</h3>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<h3>foo[bar]baz</h3>",
    [["stylewithcss","false"],["bold",""]],
    "<h3>foo<span style=\"font-weight:normal\">[bar]</span>baz</h3>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobar]baz</h3>",
    [["stylewithcss","true"],["bold",""]],
    "{<h3><span style=\"font-weight:normal\">foobar]</span>baz</h3>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobar]baz</h3>",
    [["stylewithcss","false"],["bold",""]],
    "{<h3><span style=\"font-weight:normal\">foobar]</span>baz</h3>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<h3>foo[barbaz</h3>}",
    [["stylewithcss","true"],["bold",""]],
    "<h3>foo<span style=\"font-weight:normal\">[barbaz</span></h3>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<h3>foo[barbaz</h3>}",
    [["stylewithcss","false"],["bold",""]],
    "<h3>foo<span style=\"font-weight:normal\">[barbaz</span></h3>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<h3>[foobarbaz]</h3>",
    [["stylewithcss","true"],["bold",""]],
    "<h3><span style=\"font-weight:normal\">[foobarbaz]</span></h3>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<h3>[foobarbaz]</h3>",
    [["stylewithcss","false"],["bold",""]],
    "<h3><span style=\"font-weight:normal\">[foobarbaz]</span></h3>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobarbaz]</h3>",
    [["stylewithcss","true"],["bold",""]],
    "{<h3><span style=\"font-weight:normal\">foobarbaz]</span></h3>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobarbaz]</h3>",
    [["stylewithcss","false"],["bold",""]],
    "{<h3><span style=\"font-weight:normal\">foobarbaz]</span></h3>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<h3>[foobarbaz</h3>}",
    [["stylewithcss","true"],["bold",""]],
    "<h3><span style=\"font-weight:normal\">[foobarbaz</span></h3>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<h3>[foobarbaz</h3>}",
    [["stylewithcss","false"],["bold",""]],
    "<h3><span style=\"font-weight:normal\">[foobarbaz</span></h3>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobarbaz</h3>}",
    [["stylewithcss","true"],["bold",""]],
    "{<h3><span style=\"font-weight:normal\">foobarbaz</span></h3>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobarbaz</h3>}",
    [["stylewithcss","false"],["bold",""]],
    "{<h3><span style=\"font-weight:normal\">foobarbaz</span></h3>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<b>foo<span style=\"font-weight: normal\">bar<b>[baz]</b>quz</span>qoz</b>",
    [["stylewithcss","true"],["bold",""]],
    "<b>foo<span style=\"font-weight:normal\">bar[baz]quz</span>qoz</b>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<b>foo<span style=\"font-weight: normal\">bar<b>[baz]</b>quz</span>qoz</b>",
    [["stylewithcss","false"],["bold",""]],
    "<b>foo<span style=\"font-weight:normal\">bar[baz]quz</span>qoz</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<b>foo<span style=\"font-weight: normal\">[bar]</span>baz</b>",
    [["stylewithcss","true"],["bold",""]],
    "<b>foo[bar]baz</b>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b>foo<span style=\"font-weight: normal\">[bar]</span>baz</b>",
    [["stylewithcss","false"],["bold",""]],
    "<b>foo[bar]baz</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<b>foo</b> <b>bar</b>}",
    [["stylewithcss","true"],["bold",""]],
    "{<span style=\"font-weight:bold\">foo bar}</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[true,false,"",false,true,""]}],
["{<b>foo</b> <b>bar</b>}",
    [["stylewithcss","false"],["bold",""]],
    "{<b>foo bar}</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[true,false,"",false,true,""]}],
["{<h3>foo</h3><b>bar</b>}",
    [["stylewithcss","true"],["bold",""]],
    "{<h3><span style=\"font-weight:normal\">foo</span></h3>bar}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foo</h3><b>bar</b>}",
    [["stylewithcss","false"],["bold",""]],
    "{<h3><span style=\"font-weight:normal\">foo</span></h3>bar}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<i><b>foo</b></i>[bar]<i><b>baz</b></i>",
    [["stylewithcss","true"],["bold",""]],
    "<b><i>foo</i>[bar]<i>baz</i></b>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<i><b>foo</b></i>[bar]<i><b>baz</b></i>",
    [["stylewithcss","false"],["bold",""]],
    "<b><i>foo</i>[bar]<i>baz</i></b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<i><b>foo</b></i>[bar]<b>baz</b>",
    [["stylewithcss","true"],["bold",""]],
    "<b><i>foo</i>[bar]baz</b>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<i><b>foo</b></i>[bar]<b>baz</b>",
    [["stylewithcss","false"],["bold",""]],
    "<b><i>foo</i>[bar]baz</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<i><b>baz</b></i>",
    [["stylewithcss","true"],["bold",""]],
    "<b>foo[bar]<i>baz</i></b>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<i><b>baz</b></i>",
    [["stylewithcss","false"],["bold",""]],
    "<b>foo[bar]<i>baz</i></b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<font color=blue face=monospace><b>foo</b></font>[bar]",
    [["bold",""]],
    "<b><font color=\"blue\" face=\"monospace\">foo</font>[bar]</b>",
    [true],
    {"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: normal\"><b>{bar}</b></span>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: normal\"><b>{bar}</b></span>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["[foo<span class=notbold>bar</span>baz]",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:bold\">[foo<span class=\"notbold\"><span style=\"font-weight:bold\">bar</span></span>baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["[foo<span class=notbold>bar</span>baz]",
    [["stylewithcss","false"],["bold",""]],
    "<b>[foo<span class=\"notbold\"><b>bar</b></span>baz]</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<b><span class=notbold>[foo]</span></b>",
    [["stylewithcss","true"],["bold",""]],
    "<span class=\"notbold\"><span style=\"font-weight:bold\">[foo]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b><span class=notbold>[foo]</span></b>",
    [["stylewithcss","false"],["bold",""]],
    "<span class=\"notbold\"><b>[foo]</b></span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<b><span class=notbold>foo[bar]baz</span></b>",
    [["stylewithcss","true"],["bold",""]],
    "<b><span class=\"notbold\">foo<span style=\"font-weight:bold\">[bar]</span>baz</span></b>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b><span class=notbold>foo[bar]baz</span></b>",
    [["stylewithcss","false"],["bold",""]],
    "<b><span class=\"notbold\">foo<b>[bar]</b>baz</span></b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<p style=\"font-weight: bold\">foo[bar]baz</p>",
    [["stylewithcss","true"],["bold",""]],
    "<p><span style=\"font-weight:bold\">foo</span>[bar]<span style=\"font-weight:bold\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<p style=\"font-weight: bold\">foo[bar]baz</p>",
    [["stylewithcss","false"],["bold",""]],
    "<p><b>foo</b>[bar]<b>baz</b></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["fo[o<b>b]ar</b>baz",
    [["bold",""]],
    "fo<b>[ob]ar</b>baz",
    [true],
    {"bold":[true,false,"",false,true,""]}],
["foo<b>ba[r</b>b]az",
    [["bold",""]],
    "foo<b>ba[rb]</b>az",
    [true],
    {"bold":[true,false,"",false,true,""]}],
["fo[o<b>bar</b>b]az",
    [["stylewithcss","true"],["bold",""]],
    "fo<span style=\"font-weight:bold\">[obarb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[true,false,"",false,true,""]}],
["fo[o<b>bar</b>b]az",
    [["stylewithcss","false"],["bold",""]],
    "fo<b>[obarb]</b>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[true,false,"",false,true,""]}],
["foo[<b>b]ar</b>baz",
    [["stylewithcss","true"],["bold",""]],
    "foo[b]<span style=\"font-weight:bold\">ar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>b]ar</b>baz",
    [["stylewithcss","false"],["bold",""]],
    "foo[b]<b>ar</b>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>ba[r</b>]baz",
    [["stylewithcss","true"],["bold",""]],
    "foo<span style=\"font-weight:bold\">ba</span>[r]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<b>ba[r</b>]baz",
    [["stylewithcss","false"],["bold",""]],
    "foo<b>ba</b>[r]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo{<b>bar</b>}baz",
    [["stylewithcss","true"],["bold",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo{<b>bar</b>}baz",
    [["stylewithcss","false"],["bold",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["fo[o<span style=font-weight:bold>b]ar</span>baz",
    [["bold",""]],
    "fo<span style=\"font-weight:bold\">[ob]ar</span>baz",
    [true],
    {"bold":[true,false,"",false,true,""]}],
["<span style=font-weight:800>fo[o</span><span style=font-weight:900>b]ar</span>",
    [["bold",""]],
    "<span style=\"font-weight:800\">fo</span>[ob]<span style=\"font-weight:900\">ar</span>",
    [true],
    {"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:700>fo[o</span><span style=font-weight:800>b]ar</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:700\">fo</span>[ob]<span style=\"font-weight:800\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:700>fo[o</span><span style=font-weight:800>b]ar</span>",
    [["stylewithcss","false"],["bold",""]],
    "<b>fo</b>[ob]<span style=\"font-weight:800\">ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:600>fo[o</span><span style=font-weight:700>b]ar</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:600\">fo</span>[ob]<span style=\"font-weight:700\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:600>fo[o</span><span style=font-weight:700>b]ar</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:600\">fo</span>[ob]<b>ar</b>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:500>fo[o</span><span style=font-weight:600>b]ar</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:500\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:600\"><span style=\"font-weight:bold\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[true,false,"",false,true,""]}],
["<span style=font-weight:500>fo[o</span><span style=font-weight:600>b]ar</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:500\">fo<b>[o</b></span><span style=\"font-weight:600\"><b>b]</b>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[true,false,"",false,true,""]}],
["<span style=font-weight:400>fo[o</span><span style=font-weight:500>b]ar</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:400\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:500\"><span style=\"font-weight:bold\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:400>fo[o</span><span style=font-weight:500>b]ar</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:400\">fo<b>[o</b></span><span style=\"font-weight:500\"><b>b]</b>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:300>fo[o</span><span style=font-weight:400>b]ar</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:300\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:400\"><span style=\"font-weight:bold\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:300>fo[o</span><span style=font-weight:400>b]ar</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:300\">fo<b>[o</b></span><span style=\"font-weight:400\"><b>b]</b>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:200>fo[o</span><span style=font-weight:300>b]ar</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:200\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:300\"><span style=\"font-weight:bold\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:200>fo[o</span><span style=font-weight:300>b]ar</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:200\">fo<b>[o</b></span><span style=\"font-weight:300\"><b>b]</b>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:100>fo[o</span><span style=font-weight:200>b]ar</span>",
    [["stylewithcss","true"],["bold",""]],
    "<span style=\"font-weight:100\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:200\"><span style=\"font-weight:bold\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:100>fo[o</span><span style=font-weight:200>b]ar</span>",
    [["stylewithcss","false"],["bold",""]],
    "<span style=\"font-weight:100\">fo<b>[o</b></span><span style=\"font-weight:200\"><b>b]</b>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],

// Don't delete non-editable node.
["abc<b>[d<span contenteditable=\"false\"><b>e</b></span>f]</b>ghi",
    [["stylewithcss","false"],["bold",""]],
    "abcd<span contenteditable=\"false\"><b>e</b></span>fghi",
    [true,true],
    {}],
// but delete editable node in non-editable node.
["abc<b>[d<span contenteditable=\"false\"><span contenteditable><b>e</b></span></span>f]</b>ghi",
    [["stylewithcss","false"],["bold",""]],
    "abcd<span contenteditable=\"false\"><span contenteditable=\"\">e</span></span>fghi",
    [true,true],
    {}],

// Check where the new style (<b>) will be applied.  Basically, it should be
// applied to minimized range as far as possible, but should not shrink the
// range into the nodes entirely selected.
["abc<i>[def]</i>ghi",
    [["stylewithcss","false"],["bold",""]],
    "abc<i><b>def</b></i>ghi",
    [true,true],
    {}],
["abc[<i>def</i>]ghi",
    [["stylewithcss","false"],["bold",""]],
    "abc<b><i>def</i></b>ghi",
    [true,true],
    {}],
["abc<i>{def}</i>ghi",
    [["stylewithcss","false"],["bold",""]],
    "abc<i><b>def</b></i>ghi",
    [true,true],
    {}],
["abc{<i>def</i>}ghi",
    [["stylewithcss","false"],["bold",""]],
    "abc<b><i>def</i></b>ghi",
    [true,true],
    {}],
["abc<i>[def</i>]ghi",
    [["stylewithcss","false"],["bold",""]],
    "abc<i><b>def</b></i>ghi",
    [true,true],
    {}],
["abc[<i>def]</i>ghi",
    [["stylewithcss","false"],["bold",""]],
    "abc<i><b>def</b></i>ghi",
    [true,true],
    {}],
]
