// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.measure.text-clusters-position.tentative
// Description:Test that TextMetrics::getTextClusters() returns clusters that are positioned according to the target align and baseline passed as options.
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

promise_test(async t => {
  var canvas = new OffscreenCanvas(500, 500);
  var ctx = canvas.getContext('2d');

  var f = new FontFace("CanvasTest", "url('/fonts/CanvasTest.ttf')");
  f.load();
  self.fonts.add(f);
  await self.fonts.ready;
  ctx.font = '40px CanvasTest';
  const text = 'E';

  // Origin for all the measurements is placed at the top left corner.
  ctx.textAlign = 'left';
  ctx.textBaseline = 'top';
  let tm = ctx.measureText(text);

  // X position.
  _assertSame(Math.abs(tm.getTextClusters({align: 'left'})[0].x), 0, "Math.abs(tm.getTextClusters({align: 'left'})[\""+(0)+"\"].x)", "0");
  _assertSame(tm.getTextClusters({align: 'center'})[0].x, 20, "tm.getTextClusters({align: 'center'})[\""+(0)+"\"].x", "20");
  _assertSame(tm.getTextClusters({align: 'right'})[0].x, 40, "tm.getTextClusters({align: 'right'})[\""+(0)+"\"].x", "40");

  // Y position.
  _assertSame(Math.abs(tm.getTextClusters({baseline: 'top'})[0].y), 0, "Math.abs(tm.getTextClusters({baseline: 'top'})[\""+(0)+"\"].y)", "0");
  _assertSame(tm.getTextClusters({baseline: 'middle'})[0].y, 20, "tm.getTextClusters({baseline: 'middle'})[\""+(0)+"\"].y", "20");
  _assertSame(tm.getTextClusters({baseline: 'bottom'})[0].y, 40, "tm.getTextClusters({baseline: 'bottom'})[\""+(0)+"\"].y", "40");
  _assertSame(tm.getTextClusters({baseline: 'alphabetic'})[0].y, 30, "tm.getTextClusters({baseline: 'alphabetic'})[\""+(0)+"\"].y", "30");
}, "Test that TextMetrics::getTextClusters() returns clusters that are positioned according to the target align and baseline passed as options.");
done();
