// META: script=/resources/testdriver.js?feature=bidi
// META: script=/resources/testdriver-vendor.js
// META: script=/common/gc.js
// META: script=/bluetooth/resources/bluetooth-test.js
// META: script=/bluetooth/resources/bluetooth-fake-devices.js
// META: timeout=long
// Generated by
// //bluetooth/bidi/generate.py
'use strict';
const test_desc =
    'Garbage Collection ran during a getPrimaryService call that ' +
    'succeeds. Should not crash.';
const expected = new DOMException(
    'GATT Server is disconnected. Cannot retrieve services. ' +
        '(Re)connect first with `device.gatt.connect`.',
    'NetworkError');
let promise;

bluetooth_bidi_test(
    () => getHealthThermometerDevice(
              {filters: [{services: ['health_thermometer']}]})
              .then(({device}) => {
                promise = assert_promise_rejects_with_message(
                    device.gatt.getPrimaryService('health_thermometer'),
                    expected);
                device.gatt.disconnect();
                return garbageCollect();
              })
              .then(() => promise),
    test_desc);
