// META: script=/resources/testdriver.js?feature=bidi
// META: script=/resources/testdriver-vendor.js
// META: script=/common/gc.js
// META: script=/bluetooth/resources/bluetooth-test.js
// META: script=/bluetooth/resources/bluetooth-fake-devices.js
// META: timeout=long
// Generated by
// //bluetooth/bidi/generate.py
'use strict';
const test_desc = 'Service is removed before getCharacteristic call. ' +
    'Reject with InvalidStateError.';
const expected =
    new DOMException('GATT Service no longer exists.', 'InvalidStateError');
let service, fake_service, fake_peripheral;

bluetooth_bidi_test(
    () => getHealthThermometerService()
              .then(_ => ({service, fake_service, fake_peripheral} = _))
              .then(() => fake_service.remove())
              .then(
                  () => assert_promise_rejects_with_message(
                      service.getCharacteristic('measurement_interval'),
                      expected, 'Service got removed.')),
    test_desc);
