// META: global=window,worker
// META: title=IDBCursor.direction
// META: script=resources/support.js

'use strict';

function cursor_direction(constant, dir) {
  let db;
  let t = async_test('IDBCursor.direction - ' + dir);
  let expected = dir ? dir : 'next';

  let open_rq = createdb(t);

  open_rq.onupgradeneeded = function(e) {
    db = e.target.result;
    t.add_cleanup(function() {
      db.close();
      indexedDB.deleteDatabase(db.name);
    });

    let objStore = db.createObjectStore('test');

    objStore.add('data', 'key');
  };

  open_rq.onsuccess = t.step_func(function(e) {
    let cursor_rq;
    let count = 0;
    let os = db.transaction('test', 'readonly').objectStore('test');
    if (dir)
      cursor_rq = os.openCursor(undefined, dir);
    else
      cursor_rq = os.openCursor();

    cursor_rq.onsuccess = t.step_func(function(e) {
      let cursor = e.target.result;

      assert_equals(cursor.direction, constant, 'direction constant');
      assert_equals(cursor.direction, expected, 'direction');
      assert_readonly(cursor, 'direction');

      count++;
      if (count >= 2)
        t.done();
    });

    let cursor_rq2 = db.transaction('test', 'readonly')
                         .objectStore('test')
                         .openCursor(undefined, constant);

    cursor_rq2.onsuccess = t.step_func(function(e) {
      let cursor = e.target.result;

      assert_equals(
          cursor.direction, constant, 'direction constant (second try)');
      assert_equals(cursor.direction, expected, 'direction (second try)');
      assert_readonly(cursor, 'direction');

      count++;
      if (count >= 2)
        t.done();
    });
  });
}

cursor_direction('next');
cursor_direction('next', 'next');
cursor_direction('prev', 'prev');
cursor_direction('nextunique', 'nextunique');
cursor_direction('prevunique', 'prevunique');
