# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Ръководство за Tor Browser
    .accesskey = Р
tor-browser-home-heading-stable = Изследвайте. Поверително
tor-browser-home-duck-duck-go-input =
    .placeholder = Търсете с DuckDuckGo
tor-browser-home-message-introduction = Готови сте да използвате най-поверителния браузър в света.
about-dialog-tor-project = { -brand-short-name } се разработва от <label data-l10n-name="project-link">{ -vendor-short-name }</label>, организация с нестопанска цел, работеща за предпазването на вашата поверителност и свобода онлайн.
about-dialog-help-out = Искате ли да помогнете? <label data-l10n-name="donate-link">Дарете</label> или <label data-l10n-name="community-link">се присъединете</label>!
about-dialog-questions-link = Въпроси?
about-dialog-grow-tor-network-link = Помогнете на мрежата на Tor да се разрасне!
about-dialog-browser-license-link = Лицензна информация
appmenuitem-new-tor-circuit =
    .label = Нова верига на Tor за този сайт
toolbar-new-tor-circuit =
    .label = Нова верига на Tor за този сайт
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-panel-node-browser = Този браузър
tor-circuit-panel-node-bridge = Мост
tor-circuit-panel-new-button = Нова верига на Tor за този сайт
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Непознат
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Свързан
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Свързано
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Помогнете на други да се свързват
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Разбрах
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Страница
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Научете повече
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Липсва състояние
# Tor Bridges Settings
tor-bridges-source-built-in = Вградени
# This dialog is shown when copying a suspected cryptocurrency address from a plain HTTP website.
crypto-safety-prompt-reload-button = Презареждане на раздела през нова верига
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Свързване
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Без връзка
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Свързване
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Вид на прокси
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Решете CAPTCHA за заявка на мост.
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Връзка
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Проверка
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Премахване
# Common button used in bridge dialogs.
bridge-dialog-button-accept = Добре
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Изпращане
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Настройки…
# This dialog is shown when copying a suspected cryptocurrency address from a plain HTTP website.
crypto-safety-prompt-dismiss-button = Отхвърляне на предупреждението
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = На линия
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Адрес
# Tor Bridges Settings.
tor-bridges-heading = Мостове
# Tor connection settings.
tor-connection-browser-learn-more-link = Научете повече
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Интернет:
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Има връзка
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Няма връзка
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Възможно е да е блокирана
# Tor Bridges Settings.
tor-bridges-learn-more-link = Научете повече
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = Решението не е правилно. Моля, опитайте отново.
# Tor advanced settings.
tor-advanced-settings-heading = Разширени
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Порт
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Потребителско име
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Парола
# Tor circuit panel.
# Text just before the list of circuit nodes.
tor-circuit-panel-node-list-introduction = Верига за Tor
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-captcha-input =
    .placeholder = Въведете знаците от изображението
tor-log-dialog-copy-button-copied =
    .label = Копирано!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = IP адрес или име на хост
tor-advanced-dialog-proxy-username-input =
    .placeholder = По желание
tor-advanced-dialog-proxy-password-input =
    .placeholder = По желание
tor-advanced-dialog-firewall-checkbox =
    .label = Този компютър се свързва през защитна стена, която позволява връзки само към определени портове
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Стойности, разделени със запетаи
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionize
    .title = Търсете със сайта на Онион
# Tor connection settings.
tor-connection-quickstart-checkbox =
    .label = Връзката да се установява автоматично
# Tor Bridges Settings.
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Редактиране на мостове
    .accesskey = Р
# Tor connection settings.
tor-connection-quickstart-heading = Бърз старт
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = Бързият старт свързва { -brand-short-name } към Tor Network автоматично при стартиране, въз основа на последно използваните настройки за връзката.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } пренасочва трафика през мрежата на Tor, поддържана от хиляди доброволци по света.
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Кара вашият трафик през Tor да изглежда като произволни данни. Може да не работи в силно цензурирани региони.
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Мрежа на Tor:
# Tor Bridges Settings.
tor-bridges-overview = Мостовете ви помагат да упражнявате сигурен достъп до мрежата на Tor от места, на които Tor е забранен. В зависимост от това къде се намирате, някои мостове може да работят по-добре от други.
# Tor Bridges Settings.
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Показване на QR код
    .accesskey = Q
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Пренасочва връзката ви през прокси сървъри на Snowflake, за да изглежда така, сякаш например провеждате видеоразговор.
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Връзката ви с Tor не се управлява от Tor Browser. Някои операционни системи (като например Tails) управляват връзката вместо вас, или пък е възможно да сте настроили персонализирана конфигурация. <a data-l10n-name="tor-check-link">Изпробвайте връзката си</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Tor Browser е актуализиран до { $version }. <a data-l10n-name="update-link">Вижте какво ново има</a>
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Начална страница на Tor Browser
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Ръководство за браузъра Tor
    .accesskey = Р
# Tor Browser home page.
tor-browser-home-heading-testing = Изпробвайте. Подробно
# Tor Bridges Settings.
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Използване на мостове
# Tor Bridges Settings.
tor-bridges-your-bridges = Вашите мостове
# Tor Browser home page.
tor-browser-home-message-donate = Използването на Tor е безплатно благодарение на дарения от хора като вас. <a data-l10n-name="donate-link">Дарете сега</a>
# Tor Bridges Settings.
tor-bridges-none-added = Няма добавени мостове
# Tor Browser home page.
tor-browser-home-message-news = Получавайте последните новини от Tor директно във вашата поща. <a data-l10n-name="news-link">Абонирайте се за новини от Tor</a>
# Tor Bridges Settings.
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Премахване на всички мостове
    .accesskey = П
# Tor Bridges Settings.
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Копиране на адреси на мостове
    .accesskey = К
# Tor Bridges Settings.
tor-bridges-source-user = Добавени от вас
# Tor Bridges Settings.
tor-bridges-source-requested = Поискани от Tor
# Tor Bridges Settings.
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Пропуск за мостове
# Tor Bridges Settings.
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Всички мостове
# Tor Browser home page.
tor-browser-home-message-testing = Това е нестабилна версия на Tor Browser за тестване на нови функции. <a data-l10n-name="learn-more-link">Научете повече</a>
# Tor Bridges Settings.
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Посетете <a data-l10n-name="url">{ $url }</a>
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Адреси на мостове
# Tor Bridges Settings.
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Замяна на мостове…
# Tor circuit panel.
# Represents the initial guard node used for a tor circuit.
# $region (String) - The region name for the guard node, already localized.
tor-circuit-panel-node-region-guard = { $region } (пазач)
# Built-in bridges dialog.
built-in-dialog-title =
    .title = Изберете вграден мост
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Покани за ваши доверени контакти
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Замяна на вашите мостове
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Използвам прокси сървър за свързване с интернет
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Вижте дневника на Tor.
# Tor Bridges Settings.
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Вашият пропуск за мостове е надграден!
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Свързване с BridgeDB. Моля, изчакайте.
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Използвайте мостове, предоставени от доверена организация или човек, когото познавате.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Премахване на всички мостове?
# Tor Bridges Settings.
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail или Riseup
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Настройки за връзка
# Tor advanced settings.
tor-advanced-settings-description = Конфигурирайте как се свързва { -brand-short-name } с интернет.
# Tor Bridges Settings.
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 моста от бота за мостове
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 моста от бота за мостове
# Tor Bridges Settings.
tor-bridges-add-addresses-description = Въведете адресите на мостове, които вече знаете
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Добавяне на мостове
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Поставете тук адресите на вашите мостове
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Неуспешно свързване със сървъра на пропуска за мостове.
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Следните мостове са споделени с вас.
# Tor circuit panel.
# Represents a number of unknown relays that complete a connection to an ".onion" site.
tor-circuit-panel-node-onion-relays = Прехвърляния към Онион сайт
# Tor circuit panel.
# Shown when the first node in the circuit is a bridge node.
tor-circuit-panel-new-button-description-bridge = Мостът може да не се промени
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Ако тези мостове са получени от torproject.org или са добавени ръчно, това действие не може да бъде отменено
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Built-in bridges dialog.
request-bridge-dialog-title =
    .title = Заявка за мост
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Копиране на дневника на Tor в клипборда
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Конфигурирайте как се свързва { -brand-short-name } с интернет.
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Разрешени портове
# Bridge QR code dialog.
bridge-qr-dialog-title =
    .title = Сканирайте QR кода
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } включва някои конкретни видове мостове, наричани „транспортни добавки“, които могат да прикрият факта, че използвате Tor.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Вижте дневника…
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Дневник на Tor
# This dialog is shown when copying a suspected cryptocurrency address from a plain HTTP website.
crypto-safety-prompt-title = Адресът за криптовалута е копиран от несигурен уебсайт
# This dialog is shown when copying a suspected cryptocurrency address from a plain HTTP website.
# $address (String) - The cryptocurrency address, possibly truncated.
# $host (String) - The website host the address was copied from.
crypto-safety-prompt-body = Копираният текст ({ $address }) изглежда е адрес за криптовалута. Тъй като връзката с { $host } не е защитена, адресът може да е бил модифициран и не бива да му се доверявате. Можете да опитате да установите сигурна връзка, като се свържете отново с нова верига.
# Tor Bridges Settings.
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Емоджи: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings.
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Последно обновяване:
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Създава впечатление, че сте свързани с уебсайт на Microsoft, вместо да използвате Tor. Може да работи в силно цензурирани региони, но обикновено е много бавен.
# Tor Bridges Settings.
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Мост на Tor:
# Tor Bridges Settings.
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } ден до отключване на:
       *[other] { $numDays } дни до отключване на:
    }
# Tor Bridges Settings.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] Имате още { $numInvites } покана
       *[other] Имате още { $numInvites } покани
    }
# Tor Bridges Settings.
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Тъй като много адреси на мостове не са публични, може да се наложи да поискате някои от тях от Tor Project.
# Tor Bridges Settings.
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Пишете на <a data-l10n-name="user">{ $telegramUserName }</a>
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Редактиране на вашите мостове
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Адреси на мост или покана
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Неправилно форматиран адрес на мост на ред { $line }.
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Поставете тук адресите на вашите мостове или покана за пропуск за мостове
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = Поканата не е приета. Опитайте с друга.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Свързване със сървъра на пропуска за мостове…
# New tor circuit.
# Shown in the File menu.
# Uses title case for English (US).
menu-new-tor-circuit =
    .label = Нова верига на Tor за този сайт
    .accesskey = В
# Tor circuit URL bar button.
# The tooltip also acts as the accessible name.
tor-circuit-urlbar-button =
    .tooltiptext = Верига на Tor
# Tor circuit panel.
# $host (String) - The host name shown in the URL bar, potentially shortened.
tor-circuit-panel-heading = Верига за { $host }
# Tor circuit panel.
# Represents a circuit node with an unknown regional location.
tor-circuit-panel-node-unknown-region = Неизвестен регион
# Tor circuit panel.
# Shown when the first node in the circuit is a guard node, rather than a bridge.
tor-circuit-panel-new-button-description-guard = Възелът-пазач може да не се промени
# Tor Bridges Settings.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Показване на поканите
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Следните мостове са въведени от вас.
# Tor Bridges Settings.
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Настройки на мост
# Tor circuit panel.
# Represents the bridge node used to connect to the Tor network.
# $bridge-type (String) - The name for the type of bridge used: meek, obfs4, snowflake, etc.
tor-circuit-panel-node-typed-bridge = Мост: { $bridge-type }
# Tor Bridges Settings.
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Нови мостове от бота за мостове
# Tor Bridges Settings.
tor-bridges-find-more-heading = Намиране на други мостове
# Tor Bridges Settings.
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Един от вашите мостове в Tor е бил премахнат.
# Tor Bridges Settings.
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Добавяне на мостове…
# Tor Bridges Settings.
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Вашите блокирани мостове са заменени
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Не може да бъде включена покана за пропуск за мостове.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Напред
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Премахване на мост
    .accesskey = П
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Неуспешно използване на поканата.
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Показване на QR код
    .accesskey = Q
# Tor Bridges Settings.
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = Мост { $type }:
# Tor Bridges Settings.
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Ако имате пропуск за мостове, ботът за мостове ще ви изпраща нови мостове, когато вашите бъдат блокирани. Ако мостовете ви не бъдат блокирани, ще отключите покани, с които можете да споделяте мостове с ваши доверени контакти.
# Tor Bridges Settings.
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Пратете имейл на { $address }
# Tor Bridges Settings.
tor-bridges-request-from-browser = Можете също така да получите мостове от бота за мостове, без да излизате от { -brand-short-name }.
# Tor Bridges Settings.
tor-bridges-request-button = Заявка за мостове…
# Tor circuit panel.
# Shown when the current address is a ".tor.onion" alias.
# $alias (String) - The alias onion address. This should be wrapped in '<a data-l10n-name="alias-link">' and '</a>', which will link to the corresponding address.
tor-circuit-panel-alias = Установена връзка към <a data-l10n-name="alias-link">{ $alias }</a>
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Текущ мост
    .aria-label = Текущ мост.
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Копиране на адреса на мост
    .accesskey = К
# Tor Bridges Settings.
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Всички ваши мостове в Tor са били премахнати.
# Tor Bridges Settings.
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Вашите мостове в Tor са променени.
# Tor Bridges Settings.
tor-bridges-share-description = Споделете мостовете си с доверени контакти.
# Tor Bridges Settings.
tor-bridges-copy-addresses-button = Копиране на адресите
# Tor Bridges Settings.
tor-bridges-qr-addresses-button =
    .title = Показване на QR код
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Още покани за ваши доверени контакти
# Tor Bridges Settings.
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Сега ви остава { $numInvites } покана за ваши доверени контакти
       *[other] Сега ви остават { $numInvites } покани за ваши доверени контакти
    }
# Tor Bridges Settings.
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Добавяне на мостове
# Tor Bridges Settings.
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Заменете мостовете си
# Tor Bridges Settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-bridges-select-built-in-description = Изберете някой от вградените мостове на { -brand-short-name }
# Tor Bridges Settings.
tor-bridges-select-built-in-button = Изберете вграден мост…
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Не може да включва повече от една покана.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Адресите на мостове не може да се смесват с покана.
downloads-tor-warning-dismiss-button = Разбрах
rulesets-warning-heading = Продължете с внимание
rulesets-update-rule-disabled = Изключено
rulesets-details-edit-button = Редакция
rulesets-details-update-button = Проверка за обновяване
rulesets-details-save-button = Записване
rulesets-details-cancel-button = Отказ
rulesets-details-scope = Обхват
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "HTTP(S)" refers to "HTTP or HTTPS".
rulesets-details-path-input-invalid = Префиксът на пътя не е валиден HTTP(S) URL
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Необходимо е удостоверяване
# Downloads warning.
# Shown in downloads panel, about:downloads and Library window.
downloads-tor-warning-title = Внимавайте при отваряне на изтеглени файлове
# Initial warning page in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
rulesets-warning-description = Добавянето или промяната на набори от правила може да позволи на нападатели да превземат четеца ви. Действайте само ако знаете какво правите.
# Initial warning page in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
rulesets-warning-continue-button = Приемам риска и продължавам
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
rulesets-side-panel-heading = Набори от правила
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
rulesets-side-panel-no-rules = Не са намерени набори от правила
# Ruleset update date in about:rulesets.
rulesets-update-never = Никога не е актуализирано или последната актуализация е била неуспешна
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "Regular expression" refers to the computing term for a special pattern used for matching: https://en.wikipedia.org/wiki/Regular_expression.
rulesets-details-scope-input-invalid = Неуспешен разбор на обхвата като регулярен израз
# Initial warning page in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
rulesets-warning-checkbox = Предупреждавайте ме, когато се опитам да упражня достъп до тези предпочитания
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
rulesets-details-enable-checkbox = Включване на този набор от правила
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk-input-invalid = Разборът на JWK не е успешен или ключът не е валиден
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "Path" refers to the URL domain this rule applies to.
rulesets-details-path = Префикс на път
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Проблем със зареждането на onion сайт
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Onion сайтът изисква удостоверяване
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-description = Достъпът до onion сайта изисква ключ, но такъв не е предоставен.
# Downloads warning.
# Shown in downloads panel, about:downloads and Library window.
# "Tails" is the brand name for the Tails operating system and should be localized appropriately, and will be a link to its website. The name should be wrapped in '<a data-l10n-name="tails-link">' and '</a>'.
downloads-tor-warning-description = Някои файлове могат да се свържат с интернет, когато се отворят без да използвате Tor. За да сте сигурни, отваряйте файловете, докато сте офлайн, или използвайте преносима операционна система като <a data-l10n-name="tails-link">Tails</a>.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Onion сайтът не е намерен
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-description = Най-вероятната причина за това е, че onion сайтът е офлайн. Свържете се с администратора на onion сайта.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-description = Onion сайтът е недостижим поради вътрешна грешка.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-description = Най-вероятната причина за това е, че onion сайтът е офлайн. Свържете се с администратора на onion сайта.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-description = Onion сайтът е зает или мрежата Tor е претоварена. Опитайте отново по-късно.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Времето за създаване на верига за onion сайт изтече
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Onion сайтът не може да бъде достигнат
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Връзката с onion сайта е прекъсната
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Неуспешно удостоверяване пред onion сайта
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Неуспешно свързване с onion сайта
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authetication-description = Предоставеният ключ е неправилен или е бил оттеглен. Свържете се с администратора на onion сайта.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-timed-out-description = Неуспешно свързване с onion сайта, вероятно поради лоша мрежова връзка.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Невалиден адрес на onion сайт
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-description = Предоставеният адрес на onion сайт е невалиден. Моля, проверете дали сте го въвели правилно.
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Когато запишете набор от правила в { -brand-short-name }, той ще се показва тук.
# Ruleset update date in about:rulesets.
# $date (Date) - The update date. The DATETIME function will format the $date according to the locale, using a "long" style. E.g. "January 1, 2000" for English (US), "١ يناير ٢٠٠٠" for Arabic, "2000년 1월 1일" in Korean, and "1 января 2000 г." in Russian.
rulesets-update-last = Последна актуализация: { DATETIME($date, dateStyle: "long") }
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Проверяване…
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk-input =
    .placeholder = Ключът, използван за подписване на този набор от правила във формат JWK (JSON Web Key)
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
rulesets-details-path-input =
    .placeholder = Префикс за URL, който съдържа файловете, необходими за набора от правила
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "Regular expression" refers to the computing term for a special pattern used for matching: https://en.wikipedia.org/wiki/Regular_expression.
rulesets-details-scope-input =
    .placeholder = Регулярен израз за обхвата на правилата
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Научете повече
onion-site-authentication-prompt-remember-checkbox =
    .label = Запомняне на ключа
onion-site-authentication-prompt-invalid-key = Въведете правилен ключ (52 знака base32 или 44 знака base64)
onion-site-authentication-prompt-setting-key-failed = Неуспешно настройване на Tor с вашия ключ
onion-site-authentication-preferences-learn-more = Научете повече
onion-site-saved-keys-dialog-table-header-key =
    .label = Ключ
onion-site-saved-keys-dialog-remove-button = Премахване
onion-site-saved-keys-dialog-remove-keys-error-message = Неуспешно премахване на ключ
onion-site-authentication-preferences-overview = Някои страници на onion изискват да се усостоверите самоличността си с помощта на ключ (подобно на парола), преди да получите достъп до тях.
onion-site-authentication-prompt-description = Страницата { $onionsite } изисква удостоверяване.
onion-site-authentication-prompt-key-input =
    .placeholder = Въведете тайния ключ за тази страница на onion
onion-site-authentication-prompt-ok-button =
    .label = Добре
    .accesskey = о
onion-site-authentication-prompt-cancel-button =
    .label = Отказ
    .accesskey = о
page-info-onion-site-encryption-plain = Връзката е шифроване (страница на onion)
onion-site-authentication-preferences-heading = Удостоверяване на страница на onion
onion-site-authentication-preferences-saved-keys-button = Запазени ключове…
onion-site-saved-keys-dialog-title =
    .title = Ключове за страници на onion
onion-site-saved-keys-dialog-intro = Следните ключове са налични на устройството.
onion-site-saved-keys-dialog-table-header-site =
    .label = Страница на onion
onion-site-authentication-urlbar-button =
    .tooltiptext = Панел за удостоверяване на страница на onion
page-info-onion-site-encryption-with-bits = Връзката е шифроване (страница на onion, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") } разряден ключ, { $encryption-version })
onion-site-saved-keys-dialog-remove-all-button = Премахване на всички
onion-site-saved-keys-dialog-fetch-keys-error-message = Неуспешно извличане на ключове от Tor
downloads-tor-warning-message-bar =
    .heading = Внимавайте при отваряне на изтеглени файлове
    .message = Някои файлове могат да се свържат с интернет, когато се отворят без да използвате Tor. За да сте сигурни, отваряйте файловете, докато сте извън мрежа, или използвайте преносима операционна система като Tails.
downloads-tor-warning-tails-link = Научете повече за Tails
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 ще получава само обновяване на сигурността за ограничен период от време. Обновете до macOS 10.15 или по-ново, за да получите най-новото издание на { -brand-short-name }.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 ще получава само обновяване на сигурността за ограничен период от време. Обновете до Windows 10 или по-нов, за да получите най-новото издание на { -brand-short-name }.
tor-connection-internet-status-unknown = Неизвестно състояние
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = Автоматично свъзрване
tor-connection-automatic-description = При стартиране се свързва с мрежата на Tor, използвайки текущите настройки за свързване.
tor-settings-failed-notification-title-bridges = Настройките за мост не могат да бъдат приложени
tor-settings-failed-notification-cause-bridges = Причината може да бъде неверен адрес на мост.
tor-settings-failed-notification-title-firewall = Настройките на защитната стена на Tor не са приложени
tor-settings-failed-notification-cause-proxy = Причината може да е неправилна информациа за него.
tor-settings-failed-notification-cause-firewall = Причината може да е неправилна информация за нея.
tor-settings-failed-notification-title-proxy = Настройките на проксито на Tor не са приложени
tor-settings-failed-notification-body-undo = Докато грешката не бъде отстранена, връзката с Tor използва предишните настройки. Можете да отмените последните промени, за да възстановите предишните работещи настройки, или да проверите дневника на Tor, за да откриете и отстраните проблема сами.
tor-settings-failed-notification-button-undo = Отменяне на промените
tor-settings-failed-notification-button-clear = Изчистване
tor-settings-failed-notification-button-fix-myself = Ще ги оправя
bridge-dialog-button-connect2 =
    .label = Свързване
bridge-dialog-button-accept2 =
    .label = Добре
bridge-dialog-button-submit2 =
    .label = Изпращане
tor-settings-failed-notification-body-default = Докато грешката не бъде отстранена, връзката с Tor използва предишните настройки. Можете да премахнеъе проблемните настройки или да възстановите подразбираните им стойности и да проверите дневника на Tor, за да откриете и отстраните проблема сами.
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = Свързва ви с мрежата на Tor чрез голям доставчик на облачна услуга. Може да работи в тежко цензурирани райони, но обикновено много бавно.
yec-donate-button = Дарете сега
yec-close-button =
    .title = Затваряне
yec2025-title = Освободете интернет
yec2025-body = Подкрепете инструментите, които късат оковите на цензурата и наблюдението. <b data-l10n-name="highlight">Дарете на проекта Tor днес.</b>
yec2025-matching = До 31-ви декември вашия дар ще бъде удвоен до 250 000 долара!
