tor-browser-home-heading-stable = Odkrywaj. Prywatnie.
tor-browser-home-heading-testing = Przetestuj. Dokładnie.
tor-browser-home-duck-duck-go-input =
    .placeholder = Wyszukaj z DuckDuckGo
tor-browser-home-message-introduction = Jesteś gotów do korzystania z najbardziej prywatnego sposobu przeglądania Internetu na świecie.
# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Podręcznik Tor Browser
    .accesskey = P
# Tor Browser home page.
tor-browser-home-message-donate = Tor jest darmowy dzięki darowiznom od osób takich jak Ty. <a data-l10n-name="donate-link">Przekaż darowiznę</a>
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Strona startowa Tor Browser
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Podręcznik Tor Browser
    .accesskey = P
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionuj
    .title = Wyszukaj za pomocą witryny onion
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Tor Browser zaktualizowano do wersji { $version }. <a data-l10n-name="update-link">Zobacz, co nowego</a>
# Tor Browser home page.
tor-browser-home-message-news = Otrzymuj najnowsze wiadomości z Tor prosto do swojej skrzynki odbiorczej. <a data-l10n-name="news-link">Zapisz się, aby otrzymywać wiadomości Tor</a>
# Tor Browser home page.
tor-browser-home-message-testing = To jest niestabilna wersja Tor Browser do testowania nowych funkcji. <a data-l10n-name="learn-more-link">Dowiedz się więcej</a>
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Twoje połączenie z siecią Tor nie jest zarządzane przez Tor Browser. Niektóre systemy operacyjne (takie jak Tails) poradzą sobie z tym za Ciebie, możesz też ręcznie skonfigurować niestandardową konfigurację. <a data-l10n-name="tor-check-link">Przetestuj swoje połączenie</a>
# Tor Bridges Settings
tor-bridges-your-bridges = Twoje mostki
# Tor Bridges Settings
tor-bridges-source-built-in = Wbudowane
# Tor Bridges Settings
tor-bridges-source-requested = Zażądane z sieci Tor
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Pokaż kod QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Skopiuj adresy mostków
    .accesskey = S
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Edytuj mostki
    .accesskey = E
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Usuń wszystkie mostki
    .accesskey = U
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Połączono
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = Mostek { $type }:
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Nieznane
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Połączono
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Brak stanu
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Opcje mostka
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Pokaż kod QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Skopiuj adres mostka
    .accesskey = S
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Przepustka mostkowa
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Wszystkie Twoje mostki Tor zostały usunięte.
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Twoje mostki Tor uległy zmianie.
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Pomóż innym się połączyć
# Tor Bridges Settings
tor-bridges-share-description = Udostępnij swoje mostki zaufanym kontaktom.
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Skopiuj adresy
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Pokaż kod QR
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Zaproszenia dla zaufanych kontaktów
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 mostki od bota mostka
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Więcej zaproszeń dla Twoich zaufanych kontaktów
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Pokaż zaproszenia
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Wymień swoje mostki
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Masz teraz { $numInvites } pozostałe zaproszenie dla zaufanych kontaktów
        [few] Masz teraz { $numInvites } pozostałe zaproszenia dla zaufanych kontaktów
        [many] Masz teraz { $numInvites } pozostałych zaproszeń dla zaufanych kontaktów
       *[other] Masz teraz { $numInvites } pozostałych zaproszeń dla zaufanych kontaktów
    }
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Rozumiem
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Dodaj mostki
# Tor Bridges Settings
tor-bridges-select-built-in-description = Wybierz jeden z wbudowanych mostków { -brand-short-name }
# Tor Bridges Settings
tor-bridges-select-built-in-button = Wybierz wbudowany mostek…
# Tor Bridges Settings
tor-bridges-add-addresses-description = Wpisz adresy mostków, które już znasz
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Dodaj nowe mostki…
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Wymień mostki…
# Tor Bridges Settings
tor-bridges-find-more-heading = Znajdź więcej mostków
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Ponieważ wiele adresów mostków nie jest publicznych, może będzie trzeba poprosić o nie Tor Project.
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Wiadomość do <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Web
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Odwiedź <a data-l10n-name="url">{ $url }</a>
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail lub Riseup
# Tor Bridges Settings
tor-bridges-request-from-browser = Możesz także zdobyć mostki od bota mostka bez opuszczania { -brand-short-name }.
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Edytuj swoje mostki
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Dodaj nowe mostki
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Wymień swoje mostki
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Skorzystaj z mostków dostarczonych przez zaufaną organizację lub osobę, którą znasz.
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Dowiedz się więcej
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Adresy mostków
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Adresy mostków lub zaproszenia
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Wklej tutaj adresy swoich mostków
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Nieprawidłowo sformatowany adres mostka w wierszu { $line }.
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Nie można dodać więcej niż jednego zaproszenia.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Nie można łączyć adresów mostków z zaproszeniem.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Nie można połączyć się z serwerem przepustki mostkowej.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Nie udało się wykorzystać zaproszenia.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Łączenie z serwerem przepustek mostkowych…
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Udostępniono Ci następujące mostki.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Następujące mostki zostały podane przez Ciebie
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Następny
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Użyj mostków
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Wszystkie mostki
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Mostek Tor:
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Usuń mostek
    .accesskey = U
# Tor Bridges Settings
tor-bridges-none-added = Nie dodano mostków
# Tor Bridges Settings
tor-bridges-source-user = Dodane przez Ciebie
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Ostatnia aktualizacja:
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Jeden z Twoich mostków Tor został usunięty.
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } dzień do odblokowania:
        [few] { $numDays } dni do odblokowania:
        [many] { $numDays } dni do odblokowania:
       *[other] { $numDays } dni do odblokowania:
    }
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] Pozostało { $numInvites } zaproszenie:
        [few] Pozostały { $numInvites } zaproszenia:
       *[other] Pozostało { $numInvites } zaproszeń:
    }
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = E-mail do { $address }
# Tor Bridges Settings
tor-bridges-request-button = Poproś o mostki…
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Nie można dołączyć zaproszenia na przepustkę mostkową.
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = Zaproszenie nie zostało przyjęte. Spróbuj innego.
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Dzięki przepustce mostkowej bot mostka wyśle Ci nowe mostki, gdy mostki zostaną zablokowane. Jeśli Twoje mostki nie zostaną zablokowane, odblokujesz zaproszenia umożliwiające udostępnianie mostków zaufanym kontaktom.
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Wklej tutaj adresy swoich mostków lub zaproszenie mostkowe
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Twoja przepustka mostkowa została ulepszona!
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Twoje zablokowane mostki zostały wymienione
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Nowe mostki od bota mostka
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 mostki od bota mostka
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Bieżący mostek
    .aria-label = Bieżący mostek.
# About Tor Browser dialog.
# '<label data-l10n-name="project-link">' and '</label>' should wrap the link text for the Tor Project, and will link to the Tor Project web page.
# -brand-short-name refers to 'Tor Browser', localized.
# -vendor-short-name refers to 'Tor Project', localized.
about-dialog-tor-project = { -brand-short-name } jest rozwijana przez <label data-l10n-name="project-link">{ -vendor-short-name }</label>, organizację non-profit działającą na rzecz ochrony prywatności i wolności w Internecie.
# About Tor Browser dialog.
# Link text for the Tor Project support page.
about-dialog-questions-link = Pytania?
# About Tor Browser dialog.
# Link text for the Tor Project page for Tor Network relay operators.
about-dialog-grow-tor-network-link = Pomóż sieci Tor się powiększyć!
# About Tor Browser dialog.
# '<label data-l10n-name="donate-link">' and '</label>' should wrap the link text for donating to Tor Project, and will link to the Tor Project donation page.
# '<label data-l10n-name="community-link">' and '</label>' should wrap the link text for getting involved with Tor Project, and will link to the Tor Project community page.
about-dialog-help-out = Chcieć pomóc? <label data-l10n-name="donate-link">Przekaż darowiznę</label> lub <label data-l10n-name="community-link">zaangażuj się</label>!
# About Tor Browser dialog.
# Link text for the Tor Browser license page (about:license).
about-dialog-browser-license-link = Informacje o licencjach
menu-new-tor-circuit =
    .label = Nowy obwód Tor dla tej witryny
    .accesskey = o
appmenuitem-new-tor-circuit =
    .label = Nowy obwód Tor dla tej witryny
toolbar-new-tor-circuit =
    .label = Nowy obwód Tor dla tej witryny
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Obwód Tor
tor-circuit-panel-heading = Obwód dla { $host }
tor-circuit-panel-alias = Połączono z <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Obwód Tor
tor-circuit-panel-node-browser = Ta przeglądarka
tor-circuit-panel-node-onion-relays = Przekaźniki witryny onion
tor-circuit-panel-node-typed-bridge = Mostek: { $bridge-type }
tor-circuit-panel-node-bridge = Mostek
tor-circuit-panel-node-region-guard = { $region } (strażnik)
tor-circuit-panel-node-unknown-region = Nieznany region
tor-circuit-panel-new-button = Nowy obwód Tor dla tej witryny
tor-circuit-panel-new-button-description-guard = Twój węzeł strażnika może się nie zmienić
tor-circuit-panel-new-button-description-bridge = Twój mostek może się nie zmienić
crypto-safety-prompt-title = Adres kryptowaluty skopiowany z niezabezpieczonej strony internetowej
crypto-safety-prompt-body = Skopiowany tekst ({ $address }) wydaje się adresem kryptowaluty. Ponieważ połączenie z { $host } nie jest bezpieczne, adres mógł zostać zmodyfikowany i nie należy mu ufać. Możesz spróbować nawiązać bezpieczne połączenie, łącząc się ponownie z nowym obwodem.
crypto-safety-prompt-reload-button = Załaduj ponownie kartę z nowym obwodem
crypto-safety-prompt-dismiss-button = Odrzuć ostrzeżenie
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Usuń
# Tor connection settings.
tor-connection-quickstart-checkbox =
    .label = Zawsze łącz się automatycznie
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Sprawia, że ruch sieci Tor wygląda jak losowe dane. Może to nie działać w silnie ocenzurowanych regionach.
# Tor Bridges Settings.
tor-bridges-learn-more-link = Dowiedz się więcej
# Bridge QR code dialog.
bridge-qr-dialog-title =
    .title = Skanuj kod QR
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } zawiera pewne specyficzne typy mostków znane jako „transporty wtykowe”, które mogą pomóc ukryć fakt, że używasz sieci Tor.
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Kieruje połączenie przez serwery proxy Snowflake, aby wyglądało to tak, że użytkownik na przykład prowadzi rozmowę wideo.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = Szybki start łączy { -brand-short-name } z siecią Tor automatycznie po uruchomieniu na podstawie ostatnio używanych ustawień połączenia.
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Połączenie
# Tor connection settings.
tor-connection-quickstart-heading = Szybki start
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet:
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = Online
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Offline
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Nie połączono
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Potencjalnie zablokowano
# Tor Bridges Settings.
tor-bridges-heading = Mostki
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Usunąć wszystkie mostki?
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Jeśli te mostki zostały otrzymane z torproject.org lub dodano je ręcznie, tej czynności nie można cofnąć
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Połącz
# Common button used in bridge dialogs.
bridge-dialog-button-accept = OK
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Potwierdź
# Built-in bridges dialog.
built-in-dialog-title =
    .title = Wybierz wbudowany mostek
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } kieruje Twój ruch przez sieć Tor, utrzymywaną przez tysiące wolontariuszy na całym świecie.
# Tor connection settings.
tor-connection-browser-learn-more-link = Dowiedz się więcej
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Przetestuj
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Sieć Tor:
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Połączono
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Połącz
# Tor Bridges Settings.
tor-bridges-overview = Mostki pomagają w bezpiecznym dostępie do sieci Tor w miejscach, w których ją zablokowano. W zależności od tego, gdzie jesteś, jeden mostek może działać lepiej niż inny.
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Sprawia, że wygląda to tak, jakby użytkownik był połączony z witryną Microsoftu, a nie korzystał z sieci Tor. Może to działać w silnie ocenzurowanych regionach, ale zazwyczaj działa bardzo wolno.
# Built-in bridges dialog.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
# Built-in bridges dialog.
# "meek-azure" is a technical name, and likely should not be translated.
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
# Tor advanced connection settings dialog.
# SOCKS5 is a technical name, and should likely not be translated.
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-address-input =
    .placeholder = Adres IP lub nazwa hosta
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-checkbox =
    .label = Ten komputer przechodzi przez zaporę sieciową, która zezwala tylko na połączenia z określonymi portami
# Built-in bridges dialog.
request-bridge-dialog-title =
    .title = Poproś o mostek
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Rozwiąż CAPTCHA, aby poprosić o mostek.
# Built-in bridges dialog.
request-bridge-dialog-captcha-input =
    .placeholder = Wprowadź znaki z obrazu
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = Rozwiązanie nie jest poprawne. Spróbuj ponownie.
# Tor advanced settings.
tor-advanced-settings-heading = Zaawansowane
# Tor advanced settings.
tor-advanced-settings-description = Skonfiguruj sposób, w jaki { -brand-short-name } łączy się z Internetem.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Zobacz dziennik Tor.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Skopiuj dziennik Tor do schowka
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Skonfiguruj sposób, w jaki { -brand-short-name } łączy się z Internetem.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Typ serwera proxy
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Adres
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Port
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Użytkownik
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input =
    .placeholder = Opcjonalnie
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Hasło
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input =
    .placeholder = Opcjonalnie
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Dozwolone porty
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Wartości oddzielone przecinkiem
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Nawiązywanie połączenia z BridgeDB. Proszę czekać.
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Ustawienia…
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Zobacz dziennik…
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Dziennik Tor
# Tor log dialog.
# Button text changes for a short time after activating the button.
tor-log-dialog-copy-button-copied =
    .label = Skopiowano!
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Ustawienia połączenia
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Używam serwera proxy do łączenia się z Internetem
# Tor advanced connection settings dialog.
# SOCKS4 is a technical name, and should likely not be translated.
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
# Tor advanced connection settings dialog.
# HTTP and HTTPS are technical names, and should likely not be translated.
# The "/" refers to "HTTP or HTTPS" and can be translated.
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
downloads-tor-warning-title = Ostrożnie przy otwieraniu pobranych plików
downloads-tor-warning-description = Niektóre pliki mogą łączyć się z Internetem, jeśli zostaną otwarte bez użycia sieci Tor. Dla bezpieczeństwa otwieraj pliki w trybie offline lub korzystaj z przenośnego systemu operacyjnego, takiego jak <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = Rozumiem
rulesets-warning-heading = Postępuj ostrożnie
rulesets-warning-description = Dodawanie lub modyfikowanie zestawów reguł może spowodować, że atakujący przejmą przeglądarkę. Kontynuuj tylko, jeśli wiesz, co robisz.
rulesets-warning-checkbox = Ostrzegaj mnie, kiedy próbuję uzyskać dostęp do tych preferencji
rulesets-warning-continue-button = Zaakceptuj ryzyko i kontynuuj
rulesets-side-panel-heading = Zestawy reguł
rulesets-side-panel-no-rules = Nie znaleziono żadnych zestawów reguł
rulesets-update-last = Ostatnia aktualizacja { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Nigdy nie zaktualizowano albo ostatnia aktualizacja nie powiodła się
rulesets-update-rule-disabled = Nieaktywny
rulesets-details-edit-button = Edytuj
rulesets-details-enable-checkbox = Włącz ten zestaw reguł
rulesets-details-update-button = Sprawdź aktualizacje
rulesets-details-save-button = Zapisz
rulesets-details-cancel-button = Anuluj
rulesets-details-jwk-input =
    .placeholder = Klucz używany do podpisania tego zestawu reguł w formacie JWK (JSON Web Key)
rulesets-details-jwk-input-invalid = JWK nie można analizować lub nie jest ważnym kluczem
rulesets-details-path = Prefiks ścieżki
rulesets-details-path-input =
    .placeholder = Prefiks URL, który zawiera pliki wymagane przez zestaw reguł
rulesets-details-path-input-invalid = Prefiks ścieżki nie jest prawidłowym adresem URL HTTP(S)
rulesets-details-scope = Zakres
rulesets-details-scope-input =
    .placeholder = Wyrażenie regularne dla zakresu reguł
rulesets-details-scope-input-invalid = Zakres nie mógł być analizowany jako wyrażenie regularne
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Gdy zapiszesz zestaw reguł w { -brand-short-name }, pojawi się on tutaj.
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
onion-neterror-not-found-description = Najbardziej prawdopodobną przyczyną jest to, że witryna onion jest offline. Skontaktuj się z administratorem witryny onion.
onion-neterror-unreachable-description = Witryna onion jest nieosiągalna z powodu błędu wewnętrznego.
onion-neterror-disconnected-description = Najbardziej prawdopodobną przyczyną jest to, że witryna onion jest offline. Skontaktuj się z administratorem witryny onion.
onion-neterror-connection-failed-description = Witryna onion jest zajęta lub sieć Tor jest przeciążona. Spróbuj ponownie później.
onion-neterror-missing-authentication-description = Dostęp do witryny onion wymaga klucza, ale żaden nie został dostarczony.
onion-neterror-incorrect-authetication-description = Podany klucz jest niepoprawny lub został odwołany. Skontaktuj się z administratorem witryny onion.
onion-neterror-invalid-address-description = Podany adres strony onion jest nieprawidłowy. Sprawdź, czy wpisałeś go poprawnie.
onion-neterror-timed-out-description = Nie udało się połączyć z witryną onion, prawdopodobnie z powodu słabego połączenia sieciowego.
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Nie można połączyć się z witryną onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Witryna onion wymaga uwierzytelnienia
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Uwierzytelnianie witryny onion nie powiodło się
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Nieprawidłowy adres witryny onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Limit czasu tworzenia obwodu witryny onion
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Testowanie…
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Problem z ładowaniem witryny onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Wymagane uwierzytelnienie
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Nie znaleziono witryny onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Nie można dotrzeć do witryny onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Witryna onion została rozłączona
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Dowiedz się więcej
onion-site-authentication-prompt-remember-checkbox =
    .label = Zapamiętaj ten klucz
onion-site-authentication-prompt-invalid-key = Wprowadź poprawny klucz (52 znaki base32 lub 44 znaki base64)
onion-site-authentication-prompt-setting-key-failed = Konfiguracja Tor przy użyciu twojego klucza nie powiodła się
onion-site-authentication-preferences-learn-more = Dowiedz się więcej
onion-site-saved-keys-dialog-table-header-key =
    .label = Klucz
onion-site-saved-keys-dialog-remove-button = Usuń
onion-site-saved-keys-dialog-remove-keys-error-message = Usunięcie klucza nie powiodło się
onion-site-authentication-urlbar-button =
    .tooltiptext = Otwórz panel uwierzytelniania witryny onion
onion-site-authentication-prompt-description = Witryna onion { $onionsite } prosi o uwierzytelnienie.
onion-site-authentication-prompt-key-input =
    .placeholder = Wprowadź swój klucz prywatny dla tej witryny onion
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
onion-site-authentication-preferences-saved-keys-button = Zapisane klucze…
onion-site-saved-keys-dialog-title =
    .title = Klucze witryny onion
onion-site-saved-keys-dialog-remove-all-button = Usuń wszystko
onion-site-saved-keys-dialog-intro = Następujące klucze witryny onion są przechowywane na tym komputerze.
onion-site-authentication-prompt-cancel-button =
    .label = Anuluj
    .accesskey = A
page-info-onion-site-encryption-plain = Połączenie szyfrowane (witryna onion)
onion-site-authentication-preferences-overview = Niektóre witryny typu onion wymagają podania klucza (rodzaju hasła), aby uzyskać do nich dostęp.
page-info-onion-site-encryption-with-bits = Połączenie szyfrowane (witryna onion, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") }-bitowe klucze, { $encryption-version })
onion-site-authentication-preferences-heading = Uwierzytelnianie witryny onion
onion-site-saved-keys-dialog-table-header-site =
    .label = Witryna onion
onion-site-saved-keys-dialog-fetch-keys-error-message = Nie można odebrać kluczy z Tor
downloads-tor-warning-message-bar =
    .heading = Ostrożnie przy otwieraniu pobranych plików
    .message = Niektóre pliki mogą łączyć się z Internetem, jeśli zostaną otwarte bez użycia sieci Tor. Dla bezpieczeństwa otwieraj pliki w trybie offline lub korzystaj z przenośnego systemu operacyjnego, takiego jak Tails.
downloads-tor-warning-tails-link = Dowiedz się więcej o Tails
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 będzie otrzymywać aktualizacje bezpieczeństwa tylko przez ograniczony czas. Uaktualnij do systemu Windows 10 lub nowszego, aby otrzymać najnowszą wersję { -brand-short-name }.
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 będzie otrzymywać aktualizacje bezpieczeństwa tylko przez ograniczony czas. Uaktualnij do systemu macOS 10.15 lub nowszego, aby otrzymać najnowszą wersję { -brand-short-name }.
tor-connection-internet-status-unknown = Stan nieznany
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-description = Automatycznie połącz się z siecią Tor przy uruchomieniu, korzystając z bieżących ustawień połączenia.
tor-connection-automatic-heading = Połącz automatycznie
tor-settings-failed-notification-body-undo = Do czasu rozwiązania problemu połączenie Tor będzie nadal korzystać z poprzednich ustawień. Możesz cofnąć ostatnie zmiany, aby przywrócić poprzednie działające ustawienia lub sprawdzić dziennik Tor, aby znaleźć i samodzielnie rozwiązać problem.
tor-settings-failed-notification-title-bridges = Nie można zastosować ustawień mostka Tor
tor-settings-failed-notification-cause-bridges = Może to być spowodowane nieprawidłowym adresem mostka.
tor-settings-failed-notification-title-proxy = Nie można zastosować ustawień serwera proxy Tor
tor-settings-failed-notification-cause-proxy = Może to być spowodowane nieprawidłowymi informacjami serwera proxy.
tor-settings-failed-notification-title-firewall = Nie można zastosować ustawień zapory sieciowej Tor
tor-settings-failed-notification-cause-firewall = Może to być spowodowane nieprawidłowymi informacjami zapory sieciowej.
tor-settings-failed-notification-body-default = Do czasu rozwiązania problemu połączenie Tor będzie nadal korzystać z ustawień domyślnych. Możesz wyczyścić problematyczne ustawienia, aby przywrócić je do domyślnych, lub sprawdzić dziennik Tor, aby znaleźć i rozwiązać problem samodzielnie.
tor-settings-failed-notification-button-undo = Cofnij zmiany
tor-settings-failed-notification-button-clear = Wyczyść
tor-settings-failed-notification-button-fix-myself = Naprawię samodzielnie
bridge-dialog-button-connect2 =
    .label = Połącz
bridge-dialog-button-accept2 =
    .label = OK
bridge-dialog-button-submit2 =
    .label = Potwierdź
tor-bridges-built-in-meek-name = meek
tor-bridges-built-in-meek-description = Łączy z siecią Tor za pośrednictwem dużego dostawcy chmury. Może działać w regionach z silną cenzurą, ale zazwyczaj jest bardzo powolny.
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
yec-donate-button = Wpłać teraz
yec-close-button =
    .title = Zamknij
yec2025-title = Uwolnij Internet
yec2025-body = Wesprzyj narzędzia, które przełamują łańcuchy cenzury i nadzoru. <b data-l10n-name="highlight">Przekaż darowiznę na rzecz Tor Project już dziś.</b>
yec2025-matching = Do 31 grudnia Twoja darowizna zostanie podwojona, do kwoty 250 000 $!
