# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Guide d’utilisation du Navigateur Tor
    .accesskey = M
tor-browser-home-heading-stable = Explorez, en toute confidentialité.
tor-browser-home-heading-testing = Tester. Rigoureusement.
tor-browser-home-duck-duck-go-input =
    .placeholder = Chercher avec DuckDuckGo
tor-browser-home-message-introduction = Vous êtes prêt pour l’expérience de navigation la plus confidentielle au monde.
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Manuel du navigateur Tor
    .accesskey = m
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionize
    .title = Recherche à l'aide du site en onion
# Tor Browser home page.
tor-browser-home-message-donate = Tor est gratuit grâce aux dons de personnes comme vous. <a data-l10n-name="donate-link">Faites un don maintenant</a>
# Tor Browser home page.
tor-browser-home-message-testing = Il s'agit d'une version instable du navigateur Tor pour tester de nouvelles fonctionnalités. <a data-l10n-name="learn-more-link">En savoir plus</a>
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Accueil du navigateur Tor
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Le navigateur Tor a été mis à jour vers { $version }. <a data-l10n-name="update-link">Voir ce qu'il y a de nouveau</a>
# Tor Browser home page.
tor-browser-home-message-news = Recevez les dernières nouvelles de Tor directement dans votre boîte de réception. <a data-l10n-name="news-link">Abonnez-vous aux nouvelles de Tor</a>
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Votre connexion à Tor n'est pas gérée par le navigateur Tor. Certains systèmes d'exploitation (comme Tails) gèrent cela à votre place, ou vous pouvez avoir mis en place une configuration personnalisée. <a data-l10n-name="tor-check-link">Tester votre connexion</a>
about-dialog-tor-project = { -brand-short-name } est développé par <label data-l10n-name="project-link">le { -vendor-short-name }</label>, un organisme sans but lucratif qui s’efforce de protéger votre vie privée, vos données personnels et votre liberté en ligne.
about-dialog-help-out = Voulez-vous aider ? <label data-l10n-name="donate-link">Faites un don</label> ou <label data-l10n-name="community-link">impliquez-vous</label> !
about-dialog-questions-link = Des questions ?
about-dialog-grow-tor-network-link = Aidez à la croissance du réseau Tor !
about-dialog-browser-license-link = Renseignements relatifs à la licence
menu-new-tor-circuit =
    .label = Nouveau circuit Tor pour ce site
    .accesskey = c
appmenuitem-new-tor-circuit =
    .label = Nouveau circuit Tor pour ce site
toolbar-new-tor-circuit =
    .label = Nouveau circuit Tor pour ce site
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Circuit Tor
tor-circuit-panel-heading = Circuit pour { $host }
tor-circuit-panel-alias = Connecté à <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Circuit Tor
tor-circuit-panel-node-browser = Ce navigateur
tor-circuit-panel-node-onion-relays = Relais de site onion
tor-circuit-panel-node-typed-bridge = Pont : { $bridge-type }
tor-circuit-panel-node-bridge = Pont
tor-circuit-panel-node-region-guard = { $region } (garde)
tor-circuit-panel-node-unknown-region = Région inconnue
tor-circuit-panel-new-button = Nouveau circuit Tor pour ce site
tor-circuit-panel-new-button-description-guard = Votre nœud de garde peut rester inchangé
tor-circuit-panel-new-button-description-bridge = Votre pont peut rester inchangé
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Aucun status
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Je l'ai
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = En apprendre davantage
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Adresses des ponts
# Tor Bridges Settings
tor-bridges-source-built-in = Inclus
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Connecté
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Inconnue
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Connecté(e)
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Aider les autres à se connecter
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail ou Riseup
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Web
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Montrer les invitations
# Tor Bridges Settings
tor-bridges-none-added = Aucun pont ajouté
# Tor Bridges Settings
tor-bridges-source-user = Ajouté par vous
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Utiliser des ponts
# Tor Bridges Settings
tor-bridges-your-bridges = Vos ponts
crypto-safety-prompt-title = L'adresse d'un wallet de cryptomonnaies copiée à partir d'un site non sécurisé
crypto-safety-prompt-body = Le texte copié ({ $address }) semble être l'adresse d'un wallet de cryptomonnaies. La connexion à { $host } n'étant pas sécurisée, l'adresse peut avoir changé et ne pas être digne de confiance. Vous pouvez essayer d'établir une connexion sécurisée en vous reconnectant avec un nouveau circuit.
crypto-safety-prompt-reload-button = Recharger l’onglet avec un nouveau circuit
crypto-safety-prompt-dismiss-button = Ignorer l’avertissement
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
tor-bridges-learn-more-link = En apprendre davantage
# Tor advanced settings.
tor-advanced-settings-heading = Avancé
# Tor Bridges Settings.
tor-bridges-heading = Ponts
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = En ligne
# Tor connection settings.
tor-connection-quickstart-heading = Démarrage rapide
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Hors ligne
# Common button used in bridge dialogs.
bridge-dialog-button-accept = D'accord
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Envoyer
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Type de mandataire
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Identifiant
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Si ces ponts ont été reçus de torproject.org ou ont été ajoutés manuellement, cette action ne peut être annulée
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Supprimer tous les ponts ?
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Connecté(e)
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Résolvez le captcha pour demander un pont.
# Tor connection settings.
tor-connection-browser-learn-more-link = En apprendre davantage
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Connexion
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet :
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Tester
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Non connecté
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Potentiellement bloqué
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Se connecter
# Tor Bridges Settings.
tor-bridges-overview = Les ponts vous aident à accéder au Réseau Tor en toute sécurité là où Tor est bloqué. Selon l’endroit où vous vous trouvez, un pont peut fonctionner mieux qu’un autre.
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Fait ressembler votre trafic Tor à des données aléatoires. Peut ne pas fonctionner dans les régions fortement censurées.
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Achemine votre connexion via des proxys Snowflake pour faire croire que vous passez un appel vidéo, par exemple.
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Donne l'impression que vous êtes connecté à un site web de Microsoft, au lieu d'utiliser Tor. Peut fonctionner dans des régions fortement censurées, mais est généralement très lent.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Supprimer
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Se connecter
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Connexion à BridgeDB. Veuillez patienter.
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = La solution est erronée. Veuillez réessayer.
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Adresse
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Port
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Mot de passe
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Paramètres…
tor-connection-quickstart-checkbox =
    .label = Toujours se connecter automatiquement
bridge-qr-dialog-title =
    .title = Scanner le QR code
built-in-dialog-title =
    .title = Sélectionnez un pont intégré
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Demander un pont
request-bridge-dialog-captcha-input =
    .placeholder = Saisissez les caractères de l’image
tor-log-dialog-copy-button-copied =
    .label = Copié !
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = adresse IP ou nom d’hôte
tor-advanced-dialog-proxy-username-input =
    .placeholder = Facultatif
tor-advanced-dialog-proxy-password-input =
    .placeholder = Facultatif
tor-advanced-dialog-firewall-checkbox =
    .label = Cet ordinateur passe par un pare-feu qui n’autorise que les connexions à certains ports
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Valeurs séparées par des virgules
downloads-tor-warning-title = Attention à l'ouverture des téléchargements
downloads-tor-warning-description = Certains fichiers peuvent se connecter à Internet lorsqu'ils sont ouverts sans utiliser Tor. Pour plus de sécurité, ouvrez les fichiers hors ligne ou utilisez un système d'exploitation liveboot comme <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = J'ai compris
rulesets-warning-heading = Procéder avec prudence
rulesets-warning-description = L’ajout ou la modification d’ensembles de règles peut permettre à des assaillants de pirater votre navigateur. Ne procédez que si vous savez ce que vous faites.
rulesets-warning-checkbox = Me prévenir si je tente d’accéder à ces préférences
rulesets-warning-continue-button = Accepter le risque et poursuivre
rulesets-side-panel-heading = Ensembles de règles
rulesets-side-panel-no-rules = Aucun ensemble de règles n’a été trouvé
rulesets-update-last = Dernière mise à jour le { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Jamais mis à jour ou échec de la dernière mise à jour
rulesets-update-rule-disabled = Désactivées
rulesets-details-edit-button = Modifier
rulesets-details-enable-checkbox = Activer cet ensemble de règles
rulesets-details-update-button = Vérifier la présence de mises à jour
rulesets-details-save-button = Enregistrer
rulesets-details-cancel-button = Annuler
rulesets-details-jwk-input =
    .placeholder = La clé utilisée pour signer cet ensemble de règles au format JWK (JSON Web Key)
rulesets-details-jwk-input-invalid = Impossible d’analyser la JWK ou est la clé n’est pas valide
rulesets-details-path = Préfixe du chemin
rulesets-details-path-input =
    .placeholder = Préfixe URL qui comprend les fichiers nécessaires à l’ensemble de règles
rulesets-details-path-input-invalid = Le préfixe du chemin n’est pas une URL HTTP(S) valide
rulesets-details-scope = Champ d’application
rulesets-details-scope-input =
    .placeholder = Expression rationnelle pour le champ d’action de ces règles
rulesets-details-scope-input-invalid = Le champ d’action n’a pas pu être analysé en tant qu’expression rationnelle
onion-neterror-not-found-description = La cause la plus probable est que le site onion est hors ligne. Contactez l’administrateur du site onion.
onion-neterror-unreachable-description = Le site onion est inaccessible en raison d’une erreur interne.
onion-neterror-disconnected-description = La cause la plus probable est que le site onion soit hors ligne. Contactez l’administrateur du site onion.
onion-neterror-connection-failed-description = Le site onion n'est pas disponible ou le réseau Tor est surchargé. Veuillez réessayer ultérieurement.
onion-neterror-missing-authentication-description = Le site onion exige une clé, mais aucune n’a été indiquée.
onion-neterror-incorrect-authetication-description = La clé indiquée est incorrecte ou a été révoquée. Contactez l’administrateur du site onion.
onion-neterror-invalid-address-description = L’adresse indiquée est invalide. Veuillez vous assurer de l’avoir saisie correctement.
onion-neterror-timed-out-description = Échec de connexion au site onion, possiblement en raison d’une mauvaise connexion réseau.
# Tor Bridges Settings.
tor-bridges-source-requested = Requis par Tor
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Test en cours…
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = Le démarrage rapide connecte automatiquement { -brand-short-name } au réseau Tor quand il est lancé, en fonction des derniers paramètres de connexion utilisés.
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Réseau Tor :
# Tor Bridges Settings.
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Editer les ponts
    .accesskey = E
# Tor Bridges Settings.
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Tous les ponts
# Tor Bridges Settings.
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Copier les adresses des ponts
    .accesskey = C
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } achemine votre trafic sur le réseau Tor, opéré par des milliers de volontaires à travers le monde.
# Tor Bridges Settings.
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Montrer le QR code
    .accesskey = Q
# Tor Bridges Settings.
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Retirer tous les ponts
    .accesskey = R
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Les ponts suivants étaient entrés par vous.
# Tor Bridges Settings.
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Passerelle Tor :
# Tor Bridges Settings.
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Options de passerelle
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Retirer la passerelle
    .accesskey = R
# Tor Bridges Settings.
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Vos ponts bloqués ont été remplacés
# Tor Bridges Settings.
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Nouveaux ponts du bot des ponts
# Tor Bridges Settings.
tor-bridges-select-built-in-button = Choisissez un pont intégré au système…
# Tor Bridges Settings.
tor-bridges-request-button = Demander des ponts…
# Tor Bridges Settings.
tor-bridges-request-from-browser = Vous pouvez aussi obtenir des ponts du bot des ponts sans quitter { -brand-short-name }.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Impossible de se connecter au serveur des pass pont.
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Invitations pour vos contacts de confiance
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Paramètres de connection
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Copier les journaux de Tor dans le presse-papier
# Tor Bridges Settings.
tor-bridges-qr-addresses-button =
    .title = Montrer le QR code
# Tor Bridges Settings.
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Remplacer les ponts…
# Tor Bridges Settings.
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Se rendre sur <a data-l10n-name="url">{ $url }</a>
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Journaux de tor
# Tor Bridges Settings.
tor-bridges-find-more-heading = Trouver plus de ponts
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Collez les adresses de vos ponts ici
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } inclut certains types de ponts spécifiques appelés "pluggeable transports", qui peuvent vous aider à cacher le fait que vous utilisiez Tor.
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Montrer le QR code
    .accesskey = Q
# Tor Bridges Settings.
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Envoyer un courriel à { $address }
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Editer vos ponts
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor advanced settings.
tor-advanced-settings-description = Configurez la façon dont { -brand-short-name } se connecte à internet.
# Tor Bridges Settings.
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji : { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings.
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Avec un pass pont, le bot des ponts vous enverra de nouveaux ponts chaque fois que les ponts que vous utilisez sont bloqués. Si vos ponts ne sont pas bloqués, vous déverouillez des invitations qui vous permettent de partager des ponts avec vos contacts de confiance.
# Tor Bridges Settings.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } invitation restante
       *[other] { $numInvites } invitations restantes
    }
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Plus d'invitations pour vos contacts de confiance
# Tor Bridges Settings.
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Votre pass pont a été mis à jour !
# Tor Bridges Settings.
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Vous avez maintenant { $numInvites } invitation restante pour vos contacts de confiance
       *[other] Vous avez maintenant { $numInvites } invitations restantes pour vos contacts de confiance
    }
# Tor Bridges Settings.
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Ajouter de nouveaux ponts…
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Impossible de mélanger des adresses de pont avec une invitation.
# Tor Bridges Settings.
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 ponts du bot des ponts
# Tor Bridges Settings.
tor-bridges-add-addresses-description = Entrez les adresses des ponts que vous connaissez
# Tor Bridges Settings.
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Etant donné que beaucoup d'adresses de ponts ne sont pas publiques, il est possible que vous deviez en demander au projet Tor.
# Tor Bridges Settings.
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Une de vos passerelles Tor a été retirée.
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = L'invitation n'a pas été acceptée. Essayez-en une différente.
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Utilisez des ponts fournis par une organisation de confiance ou quelqu'un que vous connaissez.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Suivant
# Tor Bridges Settings.
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Remplacer vos ponts
# Tor Bridges Settings.
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Ajouter des ponts
# Tor Bridges Settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-bridges-select-built-in-description = Choisir un pont intégré au système parmi ceux de { -brand-short-name }
# Tor Bridges Settings.
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Envoyer un message à <a data-l10n-name="user">{ $telegramUserName }</a>
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Ajouter de nouveaux ponts
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Remplacer vos ponts
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Impossible d'ajouter une invitation de pass pont.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Erreur lors de la validation de l'invitation.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Connection en cours au serveur des pass pont…
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Les ponts suivants étaient partagés avec vous.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = J'utilise un serveur mandataire pour me connecter à internet
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Ports autorisés
# Tor Bridges Settings.
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = bridge { $type }:
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Coier l'addresse de la passerelle
    .accesskey = C
# Tor Bridges Settings.
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Mise à jour récente :
# Tor Bridges Settings.
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Toutes vos passerelles Tor ont été retirées.
# Tor Bridges Settings.
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Vos passerelles Tor ont changé.
# Tor Bridges Settings.
tor-bridges-share-description = Partager vos passerelles avec vos contacts de confiance.
# Tor Bridges Settings.
tor-bridges-copy-addresses-button = Copier les adresses
# Tor Bridges Settings.
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } jour avant de débloquer :
       *[other] { $numDays } jours avant de débloquer :
    }
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 ponts du bot des ponts
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Adresses des ponts ou invitation
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Collez les adresses de vos ponts ou une invitation de pass pont ici
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Adresse de pont incorrecte à la ligne { $line }.
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Impossible d'inclure plus d'une invitation.
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Pont actuel
    .aria-label = Pont actuel.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Voir les journaux de Tor.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Voir les journaux…
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Configurer la manière dont { -brand-short-name } se connecte à internet.
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Identification requise
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Problème de chargement du site en onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Le site en onion n'a pas été trouvé
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Le site en onion n'est pas accessible
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Le site onion est déconnecté
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Impossible de se connecter au site onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Ce site onion exige une authentification
# Tor Bridges Settings.
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Accès pont
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Lorsque vous enregistrerez un jeu de règles dans { -brand-short-name }, il apparaîtra ici.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Échec de l'authentification sur ce site onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Adresse invalide du site onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Délai de création du circuit du site onion est dépassé
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = En apprendre davantage
onion-site-authentication-prompt-remember-checkbox =
    .label = Mémoriser cette clé
onion-site-authentication-prompt-invalid-key = Veuillez saisir une clé valide (52 caractères Base32 ou 44 caractères Base64)
onion-site-authentication-prompt-setting-key-failed = Impossible de configurer Tor avec votre clé
onion-site-authentication-preferences-learn-more = En apprendre davantage
onion-site-saved-keys-dialog-table-header-key =
    .label = Clé
onion-site-saved-keys-dialog-remove-button = Supprimer
onion-site-saved-keys-dialog-remove-keys-error-message = Impossible de supprimer la clé
downloads-tor-warning-message-bar =
    .heading = Attention à l'ouverture des téléchargements
    .message = Certains fichiers peuvent se connecter à Internet lorsqu'ils sont ouverts sans utiliser Tor. Pour plus de sécurité, ouvrez les fichiers hors ligne ou utilisez un système d'exploitation liveboot comme Tails.
downloads-tor-warning-tails-link = En apprendre davantage sur Tails
onion-site-authentication-prompt-description = Le site onion { $onionsite } vous demande de vous authentifier.
onion-site-authentication-urlbar-button =
    .tooltiptext = Ouvrir le panneau d'authentification du site onion
onion-site-saved-keys-dialog-remove-all-button = Retirer de cet onglet toutes les sources
tor-connection-internet-status-unknown = Statut inconnu
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = Se connecter automatiquement
tor-connection-automatic-description = Se connecter automatiquement au réseau Tor au lancement, en utilisant vos paramètres de connexion actuels.
onion-site-authentication-prompt-cancel-button =
    .label = Annuler
    .accesskey = A
page-info-onion-site-encryption-with-bits = Connexion chiffrée (Site onion, { $encryption-type }, clé de { NUMBER($encryption-strength, useGrouping: "false") } bits, { $encryption-version })
onion-site-authentication-prompt-ok-button =
    .label = Valider
    .accesskey = O
onion-site-authentication-prompt-key-input =
    .placeholder = Entrez votre clé privée pour ce site en onion
onion-site-saved-keys-dialog-title =
    .title = Clés du site en onion
onion-site-saved-keys-dialog-intro = Les clés du site en onion suivantes sont stockées sur votre ordinateur.
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 ne recevra les mises à jour de sécurité que pour une durée limitée. Veuillez mettre à jour vers macOS 10.15 ou plus pour recevoir la dernière vresion de { -brand-short-name }.
onion-site-saved-keys-dialog-table-header-site =
    .label = Site en onion
onion-site-saved-keys-dialog-fetch-keys-error-message = Impossible de récupérer les clés depuis Tor
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 ne recevra les mises à jour de sécurité que pour une durée limitée. Veuillez mettre à jour vers Windows 10 ou plus pour recevoir la dernière version de { -brand-short-name }.
onion-site-authentication-preferences-overview = Certains sites onion exigent que vous vous identifiiez avec une clé (une sorte de mot de passe) avant de pouvoir y accéder.
page-info-onion-site-encryption-plain = Connexion chiffrée (Site onion)
onion-site-authentication-preferences-heading = Authentification sur le site onion
onion-site-authentication-preferences-saved-keys-button = Clés sauvegardées…
bridge-dialog-button-connect2 =
    .label = Se connecter
bridge-dialog-button-accept2 =
    .label = D'accord
bridge-dialog-button-submit2 =
    .label = Envoyer
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
yec-donate-button = Faites un don maintenant
yec2025-matching = Jusqu'au 31 décembre, les dons au projet Tor seront jumelés à hauteur de 250 000 $ !
yec2025-title = Libérez l'Internet
yec-close-button =
    .title = Fermer
yec2025-body = Soutenez des outils qui brisent les chaînes de la censure et de la surveillance. <b data-l10n-name="highlight">Faites un don au Projet Tor aujourd'hui.</b>
