# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Manual del Navegador Tor
    .accesskey = M
tor-browser-home-heading-stable = Explora. En privado.
tor-browser-home-heading-testing = Prueba. Minuciosamente.
tor-browser-home-duck-duck-go-input =
    .placeholder = Buscar con DuckDuckGo
tor-browser-home-message-introduction = Ya puedes experimentar la navegación más privada del mundo.
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Manual del Navegador Tor
    .accesskey = M
# Tor Browser home page.
tor-browser-home-message-donate = Tor es de uso gratuito gracias a las donaciones de personas como tú. <a data-l10n-name="donate-link">Dona ahora</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = El Navegador Tor ha sido actualizado a { $version }. <a data-l10n-name="update-link">Ver las novedades</a>
# Tor Browser home page.
tor-browser-home-message-testing = Esta es una versión inestable de Navegador Tor para probar nuevas características. <a data-l10n-name="learn-more-link">Saber más</a>
# Tor Browser home page.
tor-browser-home-message-news = Recibe las últimas novedades de Tor en tu bandeja de entrada. <a data-l10n-name="news-link">Subscríbete a las noticias de Tor</a>
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Página de inicio del Navegador Tor
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Tu conexión a Tor no está siendo gestionada por Tor Browser. Algunos sistemas operativos (como Tails) lo gestionarán por ti, o podrías haber establecido una configuración personalizada. <a data-l10n-name="tor-check-link">Prueba tu conexión</a>
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Encebollar
    .title = Buscar usando el sitio onion
# Tor Bridges Settings
tor-bridges-none-added = Ningún puente añadido
# Tor Bridges Settings
tor-bridges-your-bridges = Tus puentes
# Tor Bridges Settings
tor-bridges-source-user = Añadido por ti
# Tor Bridges Settings
tor-bridges-source-built-in = Integrado
# Tor Bridges Settings
tor-bridges-source-requested = Solicitado a Tor
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Todos los puentes
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Mostrar código QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Copiar direcciones de puente
    .accesskey = C
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Editar puentes
    .accesskey = E
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Eliminar todos los puentes
    .accesskey = R
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Conectado
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = { $type } puente:
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Puente de Tor:
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoticono: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Desconocido
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Conectad@
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Sin estado
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Opciones del puente
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Se eliminó uno de tus puentes de Tor.
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Se eliminaron todos tus puentes de Tor.
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Utilizar puentes
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Pasarela
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Mostrar código QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Quitar puente
    .accesskey = R
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Actualización reciente:
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Copiar dirección del puente
    .accesskey = C
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Tus puentes Tor han cambiado.
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Ayudar a otros a conectarse
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Copiar direcciones
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Mostrar el código QR
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } día hasta que se desbloquee:
       *[other] { $numDays } días hasta que se desbloqueen:
    }
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Mostrar invitaciones
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = ¡Tu pase de puente ha sido mejorado!
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Tus puentes bloqueados han sido sustituidos
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Nuevos puentes para el bot
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Ahora tiene { $numInvites } invitaciones restantes para tus contactos de confianza
       *[other] Ahora tiene { $numInvites } invitaciones restantes para tus contactos de confianza
    }
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Entendido
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Añadir puentes
# Tor Bridges Settings
tor-bridges-select-built-in-description = Elija uno de los puentes incorporados de { -brand-short-name }
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Reemplazar los puentes…
# Tor Bridges Settings
tor-bridges-find-more-heading = Más puentes
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Como muchas direcciones de puentes no son públicas, puede que necesites solicitar algunas al Proyecto Tor.
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Página web
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Visita <a data-l10n-name="url">{ $url }</a>
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail o Riseup
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Correo electrónico { $address }
# Tor Bridges Settings
tor-bridges-request-from-browser = También puedes obtener puentes del bot de puentes sin salir de { -brand-short-name }.
# Tor Bridges Settings
tor-bridges-request-button = Solicitando los puentes…
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Edita tus puentes
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Añadir puentes nuevos
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Sustituir los puentes
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Más información
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Direcciones de los puentes
# Tor Bridges Settings
tor-bridges-share-description = Comparte tus puentes con contactos de confianza.
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Con el pase de puente, el bot de puentes te enviará nuevos puentes cuando tus puentes se bloqueen. Si tus puentes no se bloquean, desbloquearás invitaciones que te permiten compartir puentes con contactos de confianza.
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Invitaciones para tus contactos de confianza
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Más invitaciones para tus contactos de confianza
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } invitación restante
       *[other] { $numInvites } invitaciones restantes
    }
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Sustituir los puentes
# Tor Bridges Settings
tor-bridges-select-built-in-button = Selecciona un puente integrado…
# Tor Bridges Settings
tor-bridges-add-addresses-description = Introduce las direcciones de los puentes que ya conoces
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Añadir puentes nuevos…
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Mensaje <a data-l10n-name="user">{ $telegramUserName }</a>
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Utiliza puentes proporcionados por una organización de confianza o alguien que conozcas.
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Direcciones de puente o invitación
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Pegar aquí tus direcciones de puentes
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Pegue aquí sus direcciones de puente o una invitación de pase de puente
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Dirección de puente con formato incorrecto en la línea { $line }.
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = No puedes incluir más de una invitación.
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = No puede incluir una invitación a un pase para un puente.
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = La invitación no ha sido aceptada. Prueba con otra.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = No se pueden mezclar direcciones de puente con una invitación.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = No se puede conectar al servidor de intercambio de puentes.
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = Se añadió más de dos puentes por el bot
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = Se añadió más de dos puentes por el bot
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Invitación no canjeada.
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Los siguientes puentes fueron compartidos contigo.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Los siguientes puentes fueron introducidos por ti.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Siguiente
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Conectándose al servidor del puente…
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Puente actual
    .aria-label = Puente actual.
about-dialog-tor-project = { -brand-short-name } está desarrollado por <label data-l10n-name="project-link">el { -vendor-short-name }</label>, una organización sin ánimo de lucro que trabaja para defender tu privacidad y libertad en línea.
about-dialog-help-out = ¿Quieres ayudar? <label data-l10n-name="donate-link">Dona</label> o <label data-l10n-name="community-link">implícate</label>!
about-dialog-questions-link = ¿Preguntas?
about-dialog-grow-tor-network-link = ¡Ayuda a la red Tor a crecer!
about-dialog-browser-license-link = Información de licencia
menu-new-tor-circuit =
    .label = Nuevo circuito Tor para este sitio
    .accesskey = c
appmenuitem-new-tor-circuit =
    .label = Nuevo circuito Tor para este sitio
toolbar-new-tor-circuit =
    .label = Nuevo circuito Tor para este sitio
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Circuito Tor
tor-circuit-panel-heading = Circuito para { $host }
tor-circuit-panel-alias = Conectado a <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Circuito Tor
tor-circuit-panel-node-browser = Este navegador
tor-circuit-panel-node-onion-relays = Repetidor a sitio Onion
tor-circuit-panel-node-typed-bridge = Puente: { $bridge-type }
tor-circuit-panel-node-bridge = Puente
tor-circuit-panel-node-region-guard = { $region } (guard)
tor-circuit-panel-node-unknown-region = Región desconocida
tor-circuit-panel-new-button = Nuevo circuito Tor para este sitio
tor-circuit-panel-new-button-description-guard = Tu nodo guard no puede ser cambiado
tor-circuit-panel-new-button-description-bridge = Tu puente no puede ser cambiado
crypto-safety-prompt-title = Dirección de criptomoneda copiada de un sitio web inseguro
crypto-safety-prompt-body = El texto copiado ({ $address }) parece ser una dirección de criptomoneda. Dado que la conexión a { $host } no es segura, la dirección puede haber sido modificada y no se debe confiar en ella. Puedes intentar establecer una conexión segura reconectándote con un nuevo circuito.
crypto-safety-prompt-reload-button = Recargar pestaña con un nuevo circuito
crypto-safety-prompt-dismiss-button = Ignorar advertencia
# Tor connection settings.
tor-connection-quickstart-checkbox =
    .label = Conectar siempre automáticamente
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Enviar
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = ¿Eliminar todos los puentes?
# Tor connection settings.
tor-connection-quickstart-heading = Inicio rápido
# Built-in bridges dialog.
request-bridge-dialog-title =
    .title = Solicitar un puente
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet:
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Registro de Tor
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Ver el registro de Tor.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input =
    .placeholder = Opcional
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Valores separados por comas
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Conectar
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Red Tor:
# Tor advanced settings.
tor-advanced-settings-description = Configura cómo { -brand-short-name } se conecta a Internet.
# Tor connection settings.
tor-connection-browser-learn-more-link = Más información
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Ajustes de la conexión
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Probar
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = Conectado
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Desconectado
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Conectado
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = No conectado
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Posiblemente bloqueado
# Tor Bridges Settings.
tor-bridges-heading = Puentes
# Tor Bridges Settings.
tor-bridges-learn-more-link = Más información
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Hace que tu tráfico en Tor parezcan datos aleatorios. Puede no funcionar en regiones muy censuradas.
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Eliminar
# Bridge QR code dialog.
bridge-qr-dialog-title =
    .title = Escanear el código QR
# Common button used in bridge dialogs.
bridge-dialog-button-accept = Aceptar
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Contactar con BridgeDB. Espera por favor.
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Resuelve el CAPTCHA para solicitar un puente.
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = La solución no es correcta. Por favor, inténtalo de nuevo.
# Tor advanced settings.
tor-advanced-settings-heading = Avanzado
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Ajustes…
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Ver el registro…
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Tipo de proxy
# Tor advanced connection settings dialog.
# SOCKS4 is a technical name, and should likely not be translated.
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
# Tor advanced connection settings dialog.
# SOCKS5 is a technical name, and should likely not be translated.
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Dirección
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-address-input =
    .placeholder = dirección IP o nombre del host
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Nombre de usuario
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Contraseña
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Puertos permitidos
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Enruta tu conexión a través de proxies Snowflake para que parezca que estás realizando una videollamada, por ejemplo.
# Built-in bridges dialog.
built-in-dialog-title =
    .title = Seleccionar un puente incorporado
# Built-in bridges dialog.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
# Tor log dialog.
# Button text changes for a short time after activating the button.
tor-log-dialog-copy-button-copied =
    .label = ¡Copiado!
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input =
    .placeholder = Opcional
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Si estos puentes se recibieron de torproject.org o se añadieron manualmente, esta acción no se puede deshacer
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Puerto
# Tor advanced connection settings dialog.
# HTTP and HTTPS are technical names, and should likely not be translated.
# The "/" refers to "HTTP or HTTPS" and can be translated.
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-checkbox =
    .label = Este ordenador tiene un cortafuegos que solo permite conexiones a determinados puertos
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Conexión
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } enruta tu tráfico a través de la Red Tor, dirigida por miles de voluntarios alrededor del mundo.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = El inicio rápido conecta { -brand-short-name } a la Red Tor automáticamente cuando se inicia, según la última configuración de conexión utilizada.
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Conectar
# Tor Bridges Settings.
tor-bridges-overview = Los puentes te ayudan a acceder de forma segura a la Red Tor en lugares donde Tor está bloqueado. Dependiendo de dónde estés, un puente puede funcionar mejor que otro.
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Hace que parezca que estás conectado a una página web de Microsoft, en lugar de usar Tor. Puede funcionar en regiones muy censuradas, pero suele ser muy lento.
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } incluye algunos tipos específicos de puentes conocidos como "transportes conectables", que pueden ayudar a ocultar el hecho de que está usando Tor.
# Built-in bridges dialog.
# "meek-azure" is a technical name, and likely should not be translated.
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
# Built-in bridges dialog.
request-bridge-dialog-captcha-input =
    .placeholder = Introduce los caracteres de la imagen
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Copiar el registro de Tor al portapapeles
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Configura cómo { -brand-short-name } se conecta a Internet.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Utiliza un proxy para conectarme a Internet
downloads-tor-warning-title = Ten cuidado abriendo descargas
downloads-tor-warning-description = Algunos archivos intentarán conectarse al internet al ser abiertos fuera de Tor. Para estar seguro, ábrelos sin conexión o usa un sistema operativo portable como <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = Entendido
rulesets-warning-heading = Procede con precaución
rulesets-warning-description = Agregar o modificar conjuntos de reglas puede hacer que los atacantes secuestren tu navegador. Continúa sólo si sabes lo que estás haciendo.
rulesets-warning-checkbox = Avisarme cuando intente acceder a estas preferencias
rulesets-warning-continue-button = Aceptar el riesgo y continuar
rulesets-side-panel-heading = Conjuntos de reglas
rulesets-side-panel-no-rules = No se ha encontrado ningún conjunto de reglas
rulesets-update-last = Última actualización { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Nunca se ha actualizado o ha fallado la última actualización
rulesets-update-rule-disabled = Desactivado
rulesets-details-edit-button = Editar
rulesets-details-enable-checkbox = Habilitar este conjunto de reglas
rulesets-details-update-button = Buscar actualizaciones
rulesets-details-save-button = Guardar
rulesets-details-cancel-button = Cancelar
rulesets-details-jwk-input =
    .placeholder = La clave utilizada para firmar este conjunto de reglas en el formato JWK (JSON Web Key)
rulesets-details-jwk-input-invalid = El JWK no se pudo analizar o no es una clave válida
rulesets-details-path = Prefijo de Ruta
rulesets-details-path-input =
    .placeholder = Prefijo URL que contiene los archivos que necesita el conjunto de reglas
rulesets-details-path-input-invalid = El prefijo de la ruta no es una URL HTTP(S) válida
rulesets-details-scope = Ámbito
rulesets-details-scope-input =
    .placeholder = Expresión regular para el alcance de las reglas
rulesets-details-scope-input-invalid = El alcance no se pudo analizar como una expresión regular
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Cuando guardes un conjunto de reglas en { -brand-short-name }, aparecerá aquí.
onion-neterror-not-found-description = La causa más probable es que el sitio onion esté desconectado. Póngase en contacto con el administrador del sitio onion.
onion-neterror-unreachable-description = El sitio onion es inaccesible debido a un error interno.
onion-neterror-disconnected-description = La causa más probable es que el sitio onion esté desconectado. Póngase en contacto con el administrador del sitio onion.
onion-neterror-connection-failed-description = La página de onion está ocupada o la red Tor está sobrecargada. Inténtalo más tarde.
onion-neterror-missing-authentication-description = El acceso a la página web onion necesita una clave, pero no se ha proporcionado ninguna.
onion-neterror-incorrect-authetication-description = La clave proporcionada es incorrecta o ha sido revocada. Contacta con el administrador del sitio onion.
onion-neterror-invalid-address-description = La dirección de las páginas web onion proporcionada no es válida. Por favor, comprueba que la hayas introducido correctamente.
onion-neterror-timed-out-description = No se pudo conectar al sitio onion, posiblemente debido a una mala conexión de red.
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Autentificación requerida
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = No se puede acceder al sitio onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = El sitio onion está desconectado
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = El sitio onion requiere autentificación
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Probando…
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Problema al cargar el sitio onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Sitio onion no encontrado
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = No se puede conectar al sitio onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Falló en la autenticación de la página web de onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Dirección incorrecta de la página web de onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Se agotó el tiempo de espera de la cadena de sitios Onion
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Conocer más
onion-site-authentication-prompt-remember-checkbox =
    .label = Recuerda esta clave
onion-site-authentication-prompt-invalid-key = Introduce una clave válida (52 caracteres base32 o 44 caracteres base64)
onion-site-authentication-prompt-setting-key-failed = Imposible configurar Tor con tu clave
onion-site-authentication-preferences-learn-more = Más información
onion-site-saved-keys-dialog-table-header-key =
    .label = Clave
onion-site-saved-keys-dialog-remove-button = Eliminar
onion-site-saved-keys-dialog-remove-keys-error-message = No se puede quitar la clave
onion-site-authentication-prompt-ok-button =
    .label = De acuerdo
    .accesskey = O
page-info-onion-site-encryption-plain = Conexión encriptada (Página Onion)
onion-site-authentication-preferences-overview = Algunas páginas onion exigen que te identifiques con una clave (una especie de contraseña) antes de poder acceder a ellas.
onion-site-saved-keys-dialog-intro = Las siguientes claves de la página onion se almacenan en tu ordenador.
onion-site-saved-keys-dialog-table-header-site =
    .label = Página Onion
onion-site-saved-keys-dialog-fetch-keys-error-message = No se pueden recuperar claves de Tor
onion-site-authentication-urlbar-button =
    .tooltiptext = Abrir el panel de autenticación de la página onion
onion-site-authentication-prompt-cancel-button =
    .label = Cancelar
    .accesskey = C
onion-site-authentication-prompt-description = La página onion{ $onionsite } solicita que te identifiques.
onion-site-authentication-prompt-key-input =
    .placeholder = Introduce tu clave privada para esta página onion
page-info-onion-site-encryption-with-bits = Conexión encriptada (Página onion, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") } claves de bits, { $encryption-version })
onion-site-authentication-preferences-heading = Autenticación de páginas onion
onion-site-authentication-preferences-saved-keys-button = Claves guardadas…
onion-site-saved-keys-dialog-title =
    .title = Claves de la página onion
onion-site-saved-keys-dialog-remove-all-button = Eliminar todo
downloads-tor-warning-message-bar =
    .heading = Ten cuidado abriendo descargas
    .message = Algunos archivos intentarán conectarse al internet al ser abiertos fuera de Tor. Para estar seguro, ábrelos sin conexión o usa un sistema operativo portable como Tails.
downloads-tor-warning-tails-link = Aprende más acerca de Tails
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 solo recibirá actualizaciones de seguridad durante un tiempo limitado. Actualice a macOS 10.15 o posterior para recibir la última versión de { -brand-short-name }.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 solo recibirá actualizaciones de seguridad durante un tiempo limitado. Actualice a Windows 10 o posterior para recibir la última versión de { -brand-short-name }.
tor-connection-internet-status-unknown = Estado desconocido
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = Conectar automáticamente
tor-connection-automatic-description = Conectar automáticamente a la red Tor al inicio usando tu configuración de conexión actual.
bridge-dialog-button-connect2 =
    .label = Conectar
bridge-dialog-button-accept2 =
    .label = Aceptar
bridge-dialog-button-submit2 =
    .label = Enviar
tor-settings-failed-notification-button-undo = Deshacer cambios
tor-settings-failed-notification-button-clear = Limpiar
tor-settings-failed-notification-body-undo = Hasta que se arregle este problema, tu conexión a Tor continuará usando la configuración anterior. Puedes deshacer los últimos cambios para restaurar la configuración que funcionaba, o mirar el log de Tor para encontrar el problema.
tor-settings-failed-notification-button-fix-myself = Yo lo arreglo
tor-settings-failed-notification-cause-proxy = Podría ser porque la información de proxy es incorrecta.
tor-settings-failed-notification-title-bridges = No se pudo aplicar tu configuración de puentes de Tor
tor-settings-failed-notification-cause-bridges = Podría ser por una dirección incorrecta de puentes.
tor-settings-failed-notification-title-proxy = No se ha podido aplicar tu configuración de proxy de Tor
tor-settings-failed-notification-title-firewall = No se ha podido aplicar tu configuración de firewall para Tor
tor-settings-failed-notification-cause-firewall = Podría ser porque la información de firewall es incorrecta.
tor-settings-failed-notification-body-default = Hasta que este problema se arregle, tu conexión a Tor seguirá usando la configuración por defecto. Puedes borrar la configuración problemática para dejarlo como estaba, o mirar el log de Tor para encontrar y arreglar el error.
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = Te conecta a la red Tor a través de un gran proveedor en la nube. Puede funcionar en regiones muy censuradas, pero suele ser muy lento.
yec-donate-button = Dona ahora
yec-close-button =
    .title = Cerrar
yec2025-title = Libera el internet
yec2025-body = Apoya herramientas que rompen las cadenas de la censura y la vigilancia. <b data-l10n-name="highlight">Dona hoy al Proyecto Tor.</b>
yec2025-matching = ¡Hasta el 31 de diciembre, tu donación será igualada, hasta $250.000!
