tor-browser-home-heading-stable = Entdecken. Privat.
tor-browser-home-heading-testing = Testen. Gründlich.
tor-browser-home-duck-duck-go-input =
    .placeholder = Mit DuckDuckGo suchen
tor-browser-home-message-introduction = Du bist bereit für das privateste Browsing-Erlebnis der Welt.
# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Tor-Browser-Handbuch
    .accesskey = H
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Tor-Browser-Handbuch
    .accesskey = H
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Tor-Browser-Startseite
# Tor Browser home page.
tor-browser-home-message-donate = Tor kann dank der Spenden von Menschen wie dir kostenlos genutzt werden. <a data-l10n-name="donate-link">Jetzt spenden</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Der Tor-Browser wurde aktualisiert auf { $version }. <a data-l10n-name="update-link">Sieh, was Neues existiert</a>
# Tor Browser home page.
tor-browser-home-message-testing = Dies ist eine unsichere Version des Tor-Browsers, um neue Funktionen zu testen. <a data-l10n-name="learn-more-link">Mehr erfahren</a>
# Tor Browser home page.
tor-browser-home-message-news = Erhalte die neuesten Nachrichten von Tor direkt in deinen Posteingang. <a data-l10n-name="news-link">Melde dich für Tor-Nachrichten an</a>
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionisieren
    .title = Suche über die Onion-Site
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Deine Verbindung mit Tor wird nicht vom Tor-Browser verwaltet. Einige Betriebssysteme (wie Tails) verwalten dies für dich oder du könntest eine eigene Konfiguration eingerichtet haben. <a data-l10n-name="tor-check-link">Teste deine Verbindung</a>
about-dialog-tor-project = { -brand-short-name } wird entwickelt von <label data-l10n-name="project-link">das { -vendor-short-name }</label>, eine gemeinnützige Organisation, um deine Privatsphäre und Freiheit im Internet zu verteidigen.
about-dialog-help-out = Willst du helfen? <label data-l10n-name="donate-link">Spende</label> oder <label data-l10n-name="community-link">mach mit</label>!
about-dialog-questions-link = Fragen?
about-dialog-grow-tor-network-link = Hilf dem Tor-Netzwerk zu wachsen!
about-dialog-browser-license-link = Lizenzinformationen
menu-new-tor-circuit =
    .label = Neuer Tor-Kanal für diese Seite
    .accesskey = K
appmenuitem-new-tor-circuit =
    .label = Neuer Tor-Kanal für diese Seite
toolbar-new-tor-circuit =
    .label = Neuer Tor-Kanal für diese Seite
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Tor-Kanal
tor-circuit-panel-heading = Kanal für { $host }
tor-circuit-panel-alias = Verbunden mit <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Tor-Kanal
tor-circuit-panel-node-browser = Dieser Browser
tor-circuit-panel-node-onion-relays = Onion-Site-Relays
tor-circuit-panel-node-typed-bridge = Brücke: { $bridge-type }
tor-circuit-panel-node-bridge = Brücke
tor-circuit-panel-node-region-guard = { $region } (Wächter)
tor-circuit-panel-node-unknown-region = Unbekannte Region
tor-circuit-panel-new-button = Neuer Tor-Kanal für diese Seite
tor-circuit-panel-new-button-description-guard = Dein Wächterknoten darf sich nicht ändern
tor-circuit-panel-new-button-description-bridge = Deine Brücke darf sich nicht ändern
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Verbunden
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Unbekannt
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Verbunden
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
tor-bridges-source-built-in = Mitgeliefert
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Anderen helfen, sich zu vernetzen
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Verstanden
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail oder Riseup
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Mehr erfahren
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Brücken-Adressen
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Kein Status
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Einladungen zeigen
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Web
crypto-safety-prompt-title = Kryptowährungsadresse wurde von einer unsicheren Webseite kopiert
crypto-safety-prompt-body = Der kopierte Text ({ $address }) scheint eine Kryptowährungsadresse zu sein. Da die Verbindung zu { $host } nicht sicher ist, kann die Adresse geändert worden sein und sollte nicht als vertrauenswürdig eingestuft werden. Du kannst versuchen, eine sichere Verbindung herzustellen, indem du die Verbindung mit einem neuen Kanal wieder aufbaust.
crypto-safety-prompt-reload-button = Tab mit einem neuen Kanal neu laden
crypto-safety-prompt-dismiss-button = Warnung ignorieren
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
tor-bridges-learn-more-link = Mehr erfahren
# Tor advanced settings.
tor-advanced-settings-heading = Erweitert
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Lässt es so aussehen, als ob du mit einer Microsoft-Website verbunden wärst, anstatt Tor zu benutzen. Kann in stark zensierten Regionen funktionieren, ist jedoch in der Regel sehr langsam.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Benutzername
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Verbindung
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet:
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Verbunden
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Verbinden
# Common button used in bridge dialogs.
bridge-dialog-button-accept = OK
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Absenden
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Kontaktiere BridgeDB. Bitte warten.
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Adresse
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Potenziell blockiert
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Nicht verbunden
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Wenn diese Brücken von torproject.org stammen oder manuell hinzugefügt wurden, kann diese Aktion nicht rückgängig gemacht werden
# Tor connection settings.
tor-connection-browser-learn-more-link = Mehr erfahren
# Tor connection settings.
tor-connection-quickstart-heading = Schnellstart
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Test
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = Online
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Offline
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Verbinden
# Tor Bridges Settings.
tor-bridges-heading = Brücken
# Tor Bridges Settings.
tor-bridges-overview = Brücken helfen dir beim Zugriff auf das Tor-Netzwerk an Orten, an denen Tor blockiert ist. Je nachdem, wo du dich befindest, kann eine Brücke besser funktionieren als eine andere.
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Sorgt dafür, dass dein Datenverkehr über Tor aussieht wie zufällige Daten. Dies funktioniert möglicherweise nicht in stark zensierten Regionen.
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Leitet deine Verbindung über Snowflake-Proxys, damit es beispielsweise so aussieht, als würdest du einen Videoanruf starten.
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Alle Brücken entfernen?
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Entfernen
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Löse das CAPTCHA, um eine Brücke anzufordern.
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = Die Lösung ist nicht korrekt. Bitte versuche es erneut.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Proxy-Typ
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Port
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Passwort
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Einstellungen…
tor-connection-quickstart-checkbox =
    .label = Immer automatisch verbinden
bridge-qr-dialog-title =
    .title = Den QR-Code scannen
built-in-dialog-title =
    .title = Bereitgestellte Brücke auswählen
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Brücke anfordern
request-bridge-dialog-captcha-input =
    .placeholder = Gib die Zeichen aus dem Bild ein
tor-log-dialog-copy-button-copied =
    .label = Kopiert!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = IP-Adresse oder Rechnername
tor-advanced-dialog-proxy-username-input =
    .placeholder = Optional
tor-advanced-dialog-firewall-checkbox =
    .label = Die Verbindung dieses Rechners geht durch eine Firewall, die nur bestimmte Anschlüsse zulässt
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Komma-getrennte Werte
downloads-tor-warning-title = Vorsicht beim Öffnen von heruntergeladenen Dateien
downloads-tor-warning-description = Einige Dateien können sich mit dem Internet verbinden, wenn sie ohne Tor geöffnet werden. Um sicherzugehen, öffne die Dateien offline oder verwende ein portables Betriebssystem wie <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = Verstanden
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Tor-Netzwerk:
rulesets-warning-heading = Vorsichtig fortfahren
rulesets-warning-description = Das Hinzufügen neuer Quellen könnte es Angreifern erlauben, den Browser zu übernehmen. Fahre nur fort, wenn du weißt, was du tust.
rulesets-warning-checkbox = Warne mich, wenn ich versuche, auf diese Einstellungen zuzugreifen
rulesets-warning-continue-button = Akzeptiere das Risiko und fahre fort
rulesets-side-panel-heading = Regelsätze
rulesets-side-panel-no-rules = Keine Regelsätze gefunden
rulesets-update-last = Zuletzt aktualisiert { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Nie aktualisiert oder letzte Aktualisierung fehlgeschlagen
rulesets-update-rule-disabled = Deaktiviert
rulesets-details-edit-button = Ändern
rulesets-details-enable-checkbox = Diesen Regelsatz aktivieren
rulesets-details-update-button = Auf Aktualisierungen prüfen
rulesets-details-save-button = Speichern
rulesets-details-cancel-button = Abbrechen
rulesets-details-jwk-input =
    .placeholder = Der zum Signieren dieses Regelsatzes verwendete Schlüssel im JWK-Format (JSON Web Key)
rulesets-details-jwk-input-invalid = Der JWK konnte nicht geparst werden, oder es ist kein gültiger Schlüssel
rulesets-details-path = Pfad-Präfix
rulesets-details-path-input =
    .placeholder = URL-Präfix, das die für den Regelsatz benötigten Dateien enthält
rulesets-details-path-input-invalid = Der Pfadpräfix ist keine gültige HTTP(S)-URL
rulesets-details-scope = Umfang
rulesets-details-scope-input =
    .placeholder = Regulärer Ausdruck für den Anwendungsbereich der Regeln
rulesets-details-scope-input-invalid = Der Bereich konnte nicht als regulärer Ausdruck geparst werden
# Tor Bridges Settings.
tor-bridges-select-built-in-button = Eine eingebaute Brücke auswählen…
onion-neterror-not-found-description = Die wahrscheinlichste Ursache ist, dass die Onion-Seite offline ist. Wende dich an den Administrator der Onion-Seite.
onion-neterror-unreachable-description = Die Onion-Site ist aufgrund eines internen Fehlers nicht erreichbar.
onion-neterror-disconnected-description = Die wahrscheinlichste Ursache ist, dass die Onion-Seite offline ist. Wende dich an den Administrator der Onion-Seite.
onion-neterror-connection-failed-description = Die Onion-Seite ist beschäftigt oder das Tor-Netzwerk ist überlastet. Versuche es später noch einmal.
onion-neterror-missing-authentication-description = Für den Zugang zur Onion-Seite ist ein Schlüssel erforderlich, doch es wurde kein Schlüssel zur Verfügung gestellt.
onion-neterror-incorrect-authetication-description = Der angegebene Schlüssel ist falsch oder wurde widerrufen. Wende dich an den Administrator der Onion-Seite.
onion-neterror-invalid-address-description = Die angegebene Adresse der Onion-Seite ist ungültig. Bitte überprüfe, ob du sie korrekt eingegeben hast.
onion-neterror-timed-out-description = Verbindung zur Onion-Seite ist fehlgeschlagen, möglicherweise aufgrund einer schlechten Netzwerkverbindung.
# Tor Bridges Settings.
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Brücken hinzufügen
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Erlaubte Ports
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Testen…
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Authentifikation erforderlich
# Tor Bridges Settings.
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Brücken-Optionen
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Deine Brücken bearbeiten
# Tor Bridges Settings.
tor-bridges-none-added = Keine Brücken hinzugefügt
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 Brücken vom Brückenbot
# Tor Bridges Settings.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } Einladung übrig
       *[other] { $numInvites } Einladungen übrig
    }
# Tor Bridges Settings.
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Deine blockierten Brücken sind ersetzt worden
# Tor Bridges Settings.
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Besuche <a data-l10n-name="url">{ $url }</a>
# Tor Bridges Settings.
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Du hast jetzt { $numInvites } verbleibende Einladung für deine vertrauenswürdigen Kontakte
       *[other] Du hast jetzt { $numInvites } verbleibende Einladungen für deine vertrauenswürdigen Kontakte
    }
# Tor Bridges Settings.
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Ersetze deine Brücken
# Tor Bridges Settings.
tor-bridges-add-addresses-description = Gib die dir bereits bekannten Brückenadressen ein
# Tor Bridges Settings.
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } Tag bis zur Freigabe:
       *[other] { $numDays } Tage bis zur Freigabe:
    }
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Deine Brücken ersetzen
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Füge hier deine Brückenadressen oder eine Brücken-Pass-Einladung ein
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Falsch formatierte Brückenadresse in Zeile { $line }.
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Die folgenden Brücken wurden mit dir geteilt.
# Tor Bridges Settings.
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Brücken benutzen
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Kann nicht mehr als eine Einladung enthalten.
# Tor Bridges Settings.
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Alle Brücken entfernen
    .accesskey = R
# Tor Bridges Settings.
tor-bridges-source-user = Von dir hinzugefügt
# Tor Bridges Settings.
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = { $type } Brücke:
# Tor Bridges Settings.
tor-bridges-share-description = Teile deine Brücken mit vertrauenswürdigen Kontakten.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Die Einladung konnte nicht angenommen werden.
# Tor Bridges Settings.
tor-bridges-source-requested = Von Tor angefordert
# Tor Bridges Settings.
tor-bridges-your-bridges = Deine Brücken
# Tor Bridges Settings.
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Eine deiner Tor-Brücken ist entfernt worden.
# Tor Bridges Settings.
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Einladungen für deine vertrauenswürdigen Kontakte
# Tor Bridges Settings.
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Brücken-Pass
# Tor Bridges Settings.
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Alle Brücken
# Tor Bridges Settings.
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Brücken bearbeiten
    .accesskey = E
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = QR-Code anzeigen
    .accesskey = Q
# Tor Bridges Settings.
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Alle deine Tor-Brücken sind entfernt worden.
# Tor Bridges Settings.
tor-bridges-find-more-heading = Weitere Brücken suchen
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } leitet deinen Datenverkehr über das Tor-Netzwerk, das von Tausenden von Freiwilligen auf der ganzen Welt betrieben wird.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = Schnellstart verbindet { -brand-short-name } beim Start automatisch mit dem Tor-Netzwerk, basierend auf den zuletzt verwendeten Verbindungseinstellungen.
# Tor Bridges Settings.
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Brückenadressen kopieren
    .accesskey = C
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Brückenadresse kopieren
    .accesskey = C
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Verbinde mit Brücken-Pass-Server…
# Tor Bridges Settings.
tor-bridges-qr-addresses-button =
    .title = QR-Code anzeigen
# Tor Bridges Settings.
tor-bridges-copy-addresses-button = Adressen kopieren
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Mehr Einladungen für deine vertrauenswürdigen Kontakte
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Brücke entfernen
    .accesskey = R
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Die folgenden Brücken wurden von dir eingegeben.
# Tor Bridges Settings.
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Tor-Brücke:
# Tor Bridges Settings.
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Brücken ersetzen…
# Tor Bridges Settings.
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = QR-Code anzeigen
    .accesskey = Q
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Neue Brücken hinzufügen
# Tor Bridges Settings.
tor-bridges-request-from-browser = Du kannst auch Brücken vom Brückenbot abrufen, ohne { -brand-short-name } zu verlassen.
# Tor Bridges Settings.
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 Brücken vom Brückenbot
# Tor Bridges Settings.
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Schreibe <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings.
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = E-Mail an { $address }
# Tor Bridges Settings.
tor-bridges-request-button = Brücken anfordern…
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Brückenadressen oder Einladung
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Füge hier deine Brückenadressen ein
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = Einladung wurde nicht angenommen. Versuche eine andere.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Keine Verbindung mit dem Brücken-Pass-Server möglich.
# Tor Bridges Settings.
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Letztes Update:
# Tor Bridges Settings.
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Deine Tor-Brücken haben sich geändert.
# Tor Bridges Settings.
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Mit einem Brücken Pass schickt dir der Brückenbot neue Brücken, wenn deine Brücken blockiert werden. Wenn deine Brücken nicht blockiert werden, schaltest du Einladungen frei, mit denen du Brücken mit vertrauenswürdigen Kontakten teilen kannst.
# Tor Bridges Settings.
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Dein Brücken-Pass wurde aufgewertet!
# Tor Bridges Settings.
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Neue Brücken vom Brückenbot
# Tor Bridges Settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-bridges-select-built-in-description = Wähle eine der eingebauten Brücken von { -brand-short-name } aus
# Tor Bridges Settings.
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Neue Brücken hinzufügen…
# Tor Bridges Settings.
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Da viele Brückenadressen nicht öffentlich sind, musst du vielleicht einige vom Tor-Projekt anfordern.
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Verwende Brücken, die von einer vertrauenswürdigen Organisation oder einer dir bekannten Person zur Verfügung gestellt werden.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Brückenadressen können nicht mit einer Einladung gemischt werden.
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Keine Einladung zu einem Brücken-Pass möglich.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Weiter
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } enthält einige spezielle Arten von Brücken, die als „austauschbare Übertragungsarten“ bekannt sind, was helfen kann, die Tatsache zu verbergen, dass du Tor benutzt.
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Aktuelle Brücke
    .aria-label = Aktuelle Brücke.
# Tor advanced settings.
tor-advanced-settings-description = Konfiguriere, wie { -brand-short-name } sich mit dem Internet verbindet.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Schau dir das Tor-Protokoll an.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Tor-Protokoll in die Zwischenablage kopieren
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Protokoll ansehen…
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Tor-Protokoll
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Verbindungseinstellungen
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Konfiguriere, wie { -brand-short-name } sich mit dem Internet verbindet.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Ich benutze einen Proxy, um mich mit dem Internet zu verbinden
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Problem beim Laden der Onion-Site
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Onion-Site hat die Verbindung getrennt
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Verbindung mit der Onion-Site nicht möglich
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Onion-Site erfordert Authentifizierung
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Ungültige Adresse der Onion-Site
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Die Erstellung des Onion-Site-Kanals wurde abgebrochen
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Wenn du einen Regelsatz in { -brand-short-name } speicherst, wird er hier angezeigt.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Onion-Site-Authentifizierung fehlgeschlagen
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Onion-Site nicht gefunden
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Onion-Seite kann nicht erreicht werden
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input =
    .placeholder = Optional
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Mehr erfahren
onion-site-authentication-prompt-remember-checkbox =
    .label = Diesen Schlüssel merken
onion-site-authentication-prompt-invalid-key = Bitte gib einen gültigen Schlüssel (52 Base32-Zeichen oder 44 Base64-Zeichen) ein
onion-site-authentication-prompt-setting-key-failed = Das Konfigurieren von Tor mit deinem Schlüssel ist nicht möglich
onion-site-authentication-preferences-learn-more = Mehr erfahren
onion-site-saved-keys-dialog-table-header-key =
    .label = Schlüssel
onion-site-saved-keys-dialog-remove-button = Entfernen
onion-site-saved-keys-dialog-remove-keys-error-message = Schlüssel entfernen nicht möglich
onion-site-authentication-urlbar-button =
    .tooltiptext = Öffne das Onion-Site-Authentifizierungs-Panel
onion-site-authentication-prompt-description = Die Onion-Site { $onionsite } fordert dich auf, dich zu authentifizieren.
onion-site-authentication-prompt-key-input =
    .placeholder = Gib deinen privaten Schlüssel für diese Onion-Site ein
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
onion-site-authentication-prompt-cancel-button =
    .label = Abbrechen
    .accesskey = C
page-info-onion-site-encryption-with-bits = Verbindung verschlüsselt (Onion-Seite, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") }-Bit-Schlüssel, { $encryption-version })
page-info-onion-site-encryption-plain = Verbindung verschlüsselt (Onion-Dienst)
onion-site-authentication-preferences-heading = Onion-Site-Authentifizierung
onion-site-authentication-preferences-overview = Einige Onion-Dienste verlangen, dass du dich mit einem Schlüssel (einer Art Passwort) identifizierst, bevor du auf sie zugreifen kannst.
onion-site-authentication-preferences-saved-keys-button = Gespeicherte Schlüssel …
onion-site-saved-keys-dialog-title =
    .title = Onion-Site-Schlüssel
onion-site-saved-keys-dialog-intro = Die folgenden Onion-Site-Schlüssel sind auf deinem Computer gespeichert.
onion-site-saved-keys-dialog-table-header-site =
    .label = Onion-Seite
onion-site-saved-keys-dialog-remove-all-button = Alle entfernen
onion-site-saved-keys-dialog-fetch-keys-error-message = Abrufen der Schlüssel von Tor nicht möglich
downloads-tor-warning-message-bar =
    .heading = Vorsicht beim Öffnen von heruntergeladenen Dateien
    .message = Einige Dateien können sich mit dem Internet verbinden, wenn sie ohne Tor geöffnet werden. Um sicher zu gehen, öffne die Dateien offline oder verwende ein portables Betriebssystem wie Tails.
downloads-tor-warning-tails-link = Mehr üeber Tails erfahren
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 wird nur für eine begrenzte Zeit Sicherheitsaktualisierungen erhalten. Bitte aktualisiere auf macOS 10.15 oder höher, um die neueste Version von { -brand-short-name } zu erhalten.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 wird nur für eine begrenzte Zeit Sicherheitsaktualisierungen erhalten. Bitte aktualisiere auf Windows 10 oder höher, um die neueste Version von { -brand-short-name } zu erhalten.
tor-connection-internet-status-unknown = Unbekannter Status
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-description = Beim Start automatisch mit deinen aktuellen Verbindungseinstellungen zum Tor-Netzwerk verbinden.
tor-connection-automatic-heading = Automatisch verbinden
bridge-dialog-button-connect2 =
    .label = Verbinden
bridge-dialog-button-accept2 =
    .label = OK
bridge-dialog-button-submit2 =
    .label = Absenden
tor-settings-failed-notification-cause-firewall = Dies könnte auf ungültige Firewall-Informationen zurückzuführen sein.
tor-settings-failed-notification-cause-bridges = Dies könnte auf eine ungültige Brücken-Adresse zurückzuführen sein.
tor-settings-failed-notification-title-bridges = Deine Tor-Brücke-Einstellungen konnten nicht übernommen werden
tor-settings-failed-notification-title-proxy = Deine Tor-Proxy-Einstellungen konnten nicht übernommen werden
tor-settings-failed-notification-cause-proxy = Dies könnte auf ungültige Proxy-Informationen zurückzuführen sein.
tor-settings-failed-notification-title-firewall = Deine Tor-Firewall-Einstellungen konnten nicht übernommen werden
tor-settings-failed-notification-body-undo = Solange das Problem nicht behoben ist, wird deine Tor-Verbindung weiterhin die vorherigen Einstellungen verwenden. Du kannst entweder die letzten Änderungen rückgängig machen, um die vorherigen Einstellungen wiederherzustellen, oder das Tor-Protokoll überprüfen, um das Problem selbst zu finden und zu beheben.
tor-settings-failed-notification-button-fix-myself = Selbst reparieren
tor-settings-failed-notification-body-default = Bis das Problem behoben ist, wird deine Tor-Verbindung weiterhin die Standardeinstellungen verwenden. Du kannst entweder die problematischen Einstellungen löschen, um sie auf die Standardeinstellungen zurückzusetzen, oder das Tor-Protokoll überprüfen, um das Problem selbst zu finden und zu beheben.
tor-settings-failed-notification-button-undo = Änderungen verwerfen
tor-settings-failed-notification-button-clear = Löschen
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = Verbindet dich mit dem Tor-Netzwerk über einen großen Cloud-Anbieter. Kann in stark zensierten Regionen funktionieren, ist aber üblicherweise sehr langsam.
yec-donate-button = Jetzt spenden
yec-close-button =
    .title = Schliessen
yec2025-title = Befreit das Internet
yec2025-body = Unterstützt Tools, welche die Ketten der Zensur und Überwachung sprengen. <b data-l10n-name="highlight">Spendet noch heute für das Tor-Projekt.</b>
yec2025-matching = Bis zum 31. Dezember wird die Spende bis zu einer Höhe von 250.000 Dollar verdoppelt!
