# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Manual del Navegador Tor
    .accesskey = M
tor-browser-home-heading-stable = Exploreu. Privadament.
tor-browser-home-duck-duck-go-input =
    .placeholder = Cerca amb DuckDuckGo
tor-browser-home-message-introduction = Esteu preparat per a l'experiència de navegació més privada del món.
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Inici del Navegador Tor
# Tor Browser home page.
tor-browser-home-message-donate = Tor és d'ús gratuït gràcies a les donacions de persones com tu. <a data-l10n-name="donate-link">Feu una donació</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = El Navegador Tor s'ha actualitzat a { $version }. <a data-l10n-name="update-link">Vegeu les novetats</a>
# Tor Browser home page.
tor-browser-home-message-testing = Aquesta és una versió inestable del Navegador Tor per provar noves funcions. <a data-l10n-name="learn-more-link">Més informació</a>
# Tor Browser home page.
tor-browser-home-heading-testing = Proveu. Minuciosament.
# Tor Browser home page.
tor-browser-home-message-news = Rebeu les últimes notícies de Tor directament a la vostra safata d'entrada. <a data-l10n-name="news-link">Registreu-vos a les notícies de Tor</a>
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Manual del Navegador Tor
    .accesskey = M
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionitza
    .title = Cerca amb el lloc onion
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = El Navegador Tor no gestiona la vostra connexió amb Tor. Alguns sistemes operatius (com Tails) ho gestionaran per vosaltres, o podríeu haver configurat unes preferències personalitzades. <a data-l10n-name="tor-check-link">Proveu la vostra connexió</a>
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Utilitza ponts
# Tor Bridges Settings
tor-bridges-none-added = No s'han afegit ponts
# Tor Bridges Settings
tor-bridges-your-bridges = Els vostres ponts
# Tor Bridges Settings
tor-bridges-source-user = Afegits per vós
# Tor Bridges Settings
tor-bridges-source-built-in = Integrat
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = S'han eliminat tots els vostres ponts de Tor.
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Elimina tots els ponts
    .accesskey = R
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Sense estat
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Opcions del pont
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Mostra el codi QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Copia l'adreça del pont
    .accesskey = C
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = S'ha eliminat un dels vostres ponts de Tor.
# Tor Bridges Settings
tor-bridges-source-requested = Sol·licitat per Tor
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Tots els ponts
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Mostra el codi QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Copia les adreces de pont
    .accesskey = C
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Edita els ponts
    .accesskey = E
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = Pont { $type }:
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Pont de Tor:
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Elimina el pont
    .accesskey = R
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Actualització recent:
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoticona: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Connectat
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Desconegut
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Connectat
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Amb un permís de pont, el bot de pont us enviarà ponts nous quan els vostres ponts es bloquegin. Si els vostres ponts no es bloquegen, desbloquejareu invitacions que us permetran compartir ponts amb contactes de confiança.
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } dia fins que es desbloquegi:
       *[other] { $numDays } dies fins que es desbloquegi:
    }
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } invitació restant
       *[other] { $numInvites } invitacions restants
    }
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Ara teniu { $numInvites } invitació restant per als vostres contactes de confiança
       *[other] Ara teniu { $numInvites } invitacions restants per als vostres contactes de confiança
    }
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Entesos
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Substitueix ponts…
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Com que moltes adreces de pont no són públiques, és possible que n'hagueu de sol·licitar al Projecte Tor.
# Tor Bridges Settings
tor-bridges-find-more-heading = Troba més ponts
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Correu electrònic { $address }
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Utilitzeu els ponts proporcionats per una organització de confiança o algú que conegueu.
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Adreces de pont o invitacions
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Enganxeu les vostres adreces de ponts o una invitació de permís pont aquí
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = No s'ha pogut connectar al servidor de permisos de pont.
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Permís de pont
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Els vostres ponts de Tor han canviat.
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Ajudeu els altres a connectar-se
# Tor Bridges Settings
tor-bridges-share-description = Compartiu els vostres ponts amb contactes de confiança.
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Copia les adreces
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Mostra el codi QR
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 ponts del bot dels ponts
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Invitacions per als vostres contactes de confiança
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Més invitacions per als vostres contactes de confiança
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Mostra les invitacions
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = El vostre permís de pont s'ha millorat!
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Els vostres ponts bloquejats s'han substituït
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Nous ponts del bot dels ponts
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 ponts del bot dels ponts
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Afegeix ponts
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Substitueix els ponts
# Tor Bridges Settings
tor-bridges-select-built-in-description = Trieu entre un dels ponts integrats de { -brand-short-name }
# Tor Bridges Settings
tor-bridges-select-built-in-button = Seleccioneu un pont predefinit…
# Tor Bridges Settings
tor-bridges-add-addresses-description = Introduïu adreces pont que ja coneixeu
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Afegeix ponts nous…
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Envia un missatge a <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Visiteu <a data-l10n-name="url">{ $url }</a>
# Tor Bridges Settings
tor-bridges-request-from-browser = També podeu obtenir ponts des del bot de ponts sense sortir de { -brand-short-name }.
# Tor Bridges Settings
tor-bridges-request-button = Sol·licita ponts…
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Editeu els vostres ponts
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Afegiu nous ponts
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Substituïu els vostres ponts
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Enganxeu les vostres adreces de ponts aquí
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Adreça de pont amb un format incorrecte a la línia { $line }.
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = No es pot incloure més d'una invitació.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = No es poden barrejar adreces de pont amb una invitació.
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = No es pot incloure una invitació de permís de pont.
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = No s'ha acceptat la invitació. Proveu-ne una de diferent.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = No s'ha pogut bescanviar la invitació.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = S'està connectant al servidor de permisos de pont…
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Els ponts següents s'han compartit amb vós.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Els ponts següents els heu introduït vós.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Següent
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Apreneu-ne més
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Web
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail o Riseup
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Adreces de pont
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Pont actual
    .aria-label = Pont actual.
about-dialog-tor-project = { -brand-short-name } és desenvolupat per <label data-l10n-name="project-link">El { -vendor-short-name }</label>, un treball sense ànim de lucre per defensar la privacitat i llibertat virtual.
about-dialog-help-out = Vols ajudar? <label data-l10n-name="donate-link">Fes una donació</label> o <label data-l10n-name="community-link">Forma'n part</label>!
about-dialog-questions-link = Preguntes?
about-dialog-grow-tor-network-link = Ajuda la xarxa Tor a créixer!
about-dialog-browser-license-link = Informació de la llicència
menu-new-tor-circuit =
    .label = Nou circuit Tor per a aquest lloc
    .accesskey = c
appmenuitem-new-tor-circuit =
    .label = Nou circuit de Tor per a aquest lloc
toolbar-new-tor-circuit =
    .label = Nou circuit de Tor per a aquest lloc
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Circuit de Tor
tor-circuit-panel-heading = Circuit per a { $host }
tor-circuit-panel-alias = S'ha connectat a <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Circuit de Tor
tor-circuit-panel-node-browser = Aquest navegador
tor-circuit-panel-node-onion-relays = Repetidors per a llocs Onion
tor-circuit-panel-node-typed-bridge = Pont: { $bridge-type }
tor-circuit-panel-node-bridge = Pont
tor-circuit-panel-node-region-guard = { $region } (guarda)
tor-circuit-panel-node-unknown-region = Regió desconeguda
tor-circuit-panel-new-button = Nou circuit de Tor per a aquest lloc
tor-circuit-panel-new-button-description-guard = El vostre node de guarda pot no canviar
tor-circuit-panel-new-button-description-bridge = És possible que el vostre pont no canviï
crypto-safety-prompt-title = Adreça de criptomoneda copiada d'un lloc web insegur
crypto-safety-prompt-body = El text copiat ({ $address }) sembla ser una adreça de criptomoneda. Com que la connexió a { $host } no és segura, és possible que l'adreça s'hagi modificat i hauríeu de confiar en ella. Podeu provar d'establir una connexió segura tornant a connectar-vos amb un circuit nou.
crypto-safety-prompt-reload-button = Recarrega la pestanya amb un circuit nou
crypto-safety-prompt-dismiss-button = Ignora l'avís
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Voleu eliminar tots els ponts?
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Built-in bridges dialog.
request-bridge-dialog-top-wait = S'està contactant amb el BridgeDB. Espereu.
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Fora de línia
# Tor connection settings.
tor-connection-browser-learn-more-link = Més informació
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Test
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Connexió
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Connecta't
# Tor Bridges Settings.
tor-bridges-learn-more-link = Més informació
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Suprimeix
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Connecta't
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Solucioneu el CAPTCHA per sol·licitar un pont.
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Adreça
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Desconnectat
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Fa que el vostre trànsit Tor sembli dades aleatòries. Pot ser que no funcioni en regions molt censurades.
# Tor connection settings.
tor-connection-quickstart-heading = Inici ràpid
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet:
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = En línia
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Connectat
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Potencialment bloquejat
# Tor Bridges Settings.
tor-bridges-heading = Ponts
# Tor Bridges Settings.
tor-bridges-overview = Els ponts us ajuden a accedir a la xarxa Tor en llocs on Tor està bloquejat. Depenent d'on sigueu, un pont pot funcionar millor que un altre.
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Encamina la vostra connexió a través dels servidors intermediaris de Snowflake perquè sembli que esteu fent una videotrucada, per exemple.
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Fa que sembli que esteu connectat a un lloc web de Microsoft, en lloc d'utilitzar Tor. Pot funcionar en regions molt censurades, però normalment és molt lent.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Si aquests ponts s'han rebut de torproject.org o s'han afegit manualment, aquesta acció no es pot desfer
# Common button used in bridge dialogs.
bridge-dialog-button-accept = D'acord
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Envia
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = La solució no és correcta. Torneu a provar-ho.
# Tor advanced settings.
tor-advanced-settings-heading = Avançat
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Tipus de servidor intermediari
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Port
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Nom d'usuari
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Contrasenya
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Paràmetres…
tor-connection-quickstart-checkbox =
    .label = Activa sempre la connexió automàtica
bridge-qr-dialog-title =
    .title = Escaneja el codi QR
built-in-dialog-title =
    .title = Seleccioneu un pont predefinit
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Sol·licita un pont
request-bridge-dialog-captcha-input =
    .placeholder = Introduïu els caràcters de la imatge
tor-log-dialog-copy-button-copied =
    .label = S'ha copiat!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = Adreça IP o nom del host
tor-advanced-dialog-proxy-username-input =
    .placeholder = Opcional
tor-advanced-dialog-proxy-password-input =
    .placeholder = Opcional
tor-advanced-dialog-firewall-checkbox =
    .label = Aquest ordinador va a través d'un tallafoc que només permet connexions a certs ports
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Valors separats per comes
downloads-tor-warning-title = Aneu amb compte amb l'obertura de baixades
downloads-tor-warning-description = Alguns fitxers poden connectar-se a Internet quan s'obren sense utilitzar Tor. Per estar segur, obriu els fitxers sense connexió o utilitzeu un sistema operatiu portàtil com <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = D'acord
rulesets-warning-heading = Procediu amb precaució
rulesets-warning-description = Afegir o modificar conjunts de regles pot provocar que els atacants segrestin el vostre navegador. Procediu només si sabeu el que esteu fent.
rulesets-warning-checkbox = Avisa'm quan intenti accedir a aquestes preferències
rulesets-warning-continue-button = Accepta el risc i continua
rulesets-side-panel-heading = Conjunts de regles
rulesets-side-panel-no-rules = No s'ha trobat cap conjunt de regles
rulesets-update-last = Darrera actualització: { DATETIME($date, dateStyle: "long") }
rulesets-update-never = No s'ha actualitzat mai, o la darrera actualització ha fallat
rulesets-update-rule-disabled = Desactivat
rulesets-details-edit-button = Editar
rulesets-details-enable-checkbox = Activa aquest conjunt de regles
rulesets-details-update-button = Comprova si hi ha actualitzacions
rulesets-details-save-button = Desa
rulesets-details-cancel-button = Cancel·la
rulesets-details-jwk-input =
    .placeholder = La clau utilitzada per signar aquest conjunt de regles en el format JWK (clau web JSON)
rulesets-details-jwk-input-invalid = No s'ha pogut analitzar la JWK o no és una clau vàlida
rulesets-details-path = Prefix de camí
rulesets-details-path-input =
    .placeholder = Prefix d'URL que conté els fitxers necessaris pel conjunt de regles
rulesets-details-path-input-invalid = El prefix del camí no és un URL HTTP(S) vàlid
rulesets-details-scope = Abast
rulesets-details-scope-input =
    .placeholder = Expressió regular de l'abast de les normes
rulesets-details-scope-input-invalid = L'abast no s'ha pogut analitzar com a expressió regular
onion-neterror-not-found-description = La causa més probable és que el lloc onion es troba fora de línia. Contacteu amb l'administrador del lloc onion.
onion-neterror-unreachable-description = No es pot accedir al lloc onion a causa d'un error intern.
onion-neterror-disconnected-description = La causa més probable és que el lloc onion es trobi fora de línia. Contacteu amb l'administrador del lloc onion.
onion-neterror-connection-failed-description = El lloc onion està ocupat o la xarxa Tor està sobrecarregada. Proveu-ho de nou més tard.
onion-neterror-missing-authentication-description = L'accés al lloc onion requereix una clau però no se n'ha proporcionat cap.
onion-neterror-incorrect-authetication-description = La clau proporcionada no és correcta o s'ha revocat. Contacteu amb l'administrador del lloc onion.
onion-neterror-invalid-address-description = L'adreça del servei onion proporcionada no és vàlida. Comproveu que l'heu introduïda correctament.
onion-neterror-timed-out-description = Ha fallat la connexió amb el lloc onion, possiblement a causa d'una mala connexió a la xarxa.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Es requereix autenticació
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = No es pot accedir al lloc onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = S'ha esgotat el temps de creació del circuit del lloc onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Adreça del lloc onion no vàlida
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = S'ha produït un problema en carregar el lloc onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = No s'ha trobat el lloc onion
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Quan deseu un conjunt de regles al { -brand-short-name }, apareixerà aquí.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = El lloc onion s'ha desconnectat
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = No s'ha pogut connectar al lloc onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = El lloc onion requereix autenticació
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = L'autenticació del lloc onion ha fallat
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Veure el registre de Tor.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Copia el registre de Tor al porta-retalls
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Xarxa Tor:
# Tor advanced settings.
tor-advanced-settings-description = Configura com el { -brand-short-name } es connecta a Internet.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Veure el registre…
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Configura com el { -brand-short-name } es connecta a Internet.
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Paràmetres de la connexió
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = El { -brand-short-name } dirigeix el trànsit a través de la xarxa Tor, gestionada per milers de voluntaris arreu del món.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = L'inici ràpid connecta el { -brand-short-name } a la xarxa Tor automàticament quan s'inicia, en funció de la darrera configuració de connexió utilitzada.
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } inclou alguns tipus específics de ponts coneguts com a "transports integrables", que poden ajudar a ocultar el fet que utilitzeu Tor.
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Registre de Tor
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Utilitzo un servidor intermediari per connectar-me a Internet
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Ports permesos
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = S'està provant…
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Més informació
onion-site-authentication-prompt-remember-checkbox =
    .label = Recorda aquesta clau
onion-site-authentication-prompt-invalid-key = Introduïu una clau vàlida (52 caràcters en base 32, o 44 caràcters en base 64)
onion-site-authentication-prompt-setting-key-failed = No s'ha pogut configurar Tor amb la vostra clau
onion-site-authentication-preferences-learn-more = Més informació
onion-site-saved-keys-dialog-table-header-key =
    .label = Clau
onion-site-saved-keys-dialog-remove-button = Suprimeix la subscripció
onion-site-saved-keys-dialog-remove-keys-error-message = No s'ha pogut suprimir la clau
downloads-tor-warning-message-bar =
    .heading = Aneu amb compte amb l'obertura de baixades
    .message = Alguns fitxers poden connectar-se a Internet quan s'obren sense utilitzar Tor. Per estar segur, obriu els fitxers sense connexió o utilitzeu un sistema operatiu portàtil com Tails.
downloads-tor-warning-tails-link = Més informació quant a Tails
onion-site-authentication-prompt-key-input =
    .placeholder = Introduïu la vostra clau privada per a aquest lloc onion
page-info-onion-site-encryption-with-bits = Connexió xifrada (lloc Onion, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") } claus de bits, { $encryption-version })
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = El { -brand-short-name } 13.5 només rebrà actualitzacions de seguretat durant un temps limitat. Actualitzeu a macOS 10.15 o posterior per rebre la darrera versió del { -brand-short-name }.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = El { -brand-short-name } 13.5 només rebrà actualitzacions de seguretat durant un temps limitat. Actualitzeu al Windows 10 o posterior per rebre la darrera versió del { -brand-short-name }.
onion-site-authentication-urlbar-button =
    .tooltiptext = Obre el panell d'autenticació del lloc onion
onion-site-authentication-prompt-description = El lloc onion { $onionsite } us demana que us autentiqueu.
onion-site-authentication-prompt-ok-button =
    .label = D'acord
    .accesskey = D
onion-site-authentication-prompt-cancel-button =
    .label = Cancel·la
    .accesskey = C
onion-site-authentication-preferences-heading = Autenticació del lloc onion
onion-site-authentication-preferences-overview = Alguns llocs onion requereixen que us identifiqueu amb una clau (una mena de contrasenya) abans de poder accedir-hi.
onion-site-authentication-preferences-saved-keys-button = Claus desades…
onion-site-saved-keys-dialog-title =
    .title = Claus del lloc onion
onion-site-saved-keys-dialog-intro = Les claus de lloc onion següents s'emmagatzemen al vostre ordinador.
onion-site-saved-keys-dialog-table-header-site =
    .label = Lloc onion
onion-site-saved-keys-dialog-remove-all-button = Elimina-les totes
onion-site-saved-keys-dialog-fetch-keys-error-message = No s'han pogut recuperar les claus de Tor
page-info-onion-site-encryption-plain = Connexió xifrada (Onion Service)
tor-connection-internet-status-unknown = Estat desconegut
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
bridge-dialog-button-connect2 =
    .label = Connecta't
bridge-dialog-button-accept2 =
    .label = D'acord
bridge-dialog-button-submit2 =
    .label = Envia
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-connection-automatic-heading = Connecta automàticament
