/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.oss.licenses.plugin;

import com.google.android.gms.oss.licenses.plugin.ArtifactInfo;
import com.google.android.gms.oss.licenses.plugin.DependencyUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.XmlSlurper;
import java.beans.Transient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.LoggerFactory;

public abstract class LicensesTask
extends DefaultTask
implements GroovyObject {
    private static final String UTF_8 = "UTF-8";
    private static final byte[] LINE_SEPARATOR;
    private static final int GRANULAR_BASE_VERSION = 14;
    private static final String GOOGLE_PLAY_SERVICES_GROUP = "com.google.android.gms";
    private static final String LICENSE_ARTIFACT_SUFFIX = "-license";
    private static final String FIREBASE_GROUP = "com.google.firebase";
    private static final String FAIL_READING_LICENSES_ERROR = "Failed to read license text.";
    private static final Object logger;
    protected int start;
    protected Set<String> googleServiceLicenses;
    protected Map<String, String> licensesMap;
    protected Map<String, String> licenseOffsets;
    protected static final String ABSENT_DEPENDENCY_KEY = "Debug License Info";
    protected static final String ABSENT_DEPENDENCY_TEXT = "Licenses are only provided in build variants (e.g. release) where the Android Gradle Plugin generates an app dependency list.";
    @OutputDirectory
    private File rawResourceDir;
    @OutputFile
    private File licenses;
    @OutputFile
    private File licensesMetadata;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public LicensesTask() {
        MetaClass metaClass;
        Map map;
        Map map2;
        int n;
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        this.start = n = 0;
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.googleServiceLicenses = (Set)ScriptBytecodeAdapter.castToType((Object)list, Set.class);
        this.licensesMap = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.licenseOffsets = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @InputFile
    public abstract RegularFileProperty getDependenciesJson();

    @TaskAction
    public void action() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[0].callCurrent((GroovyObject)this);
        } else {
            this.initOutputDir();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[1].callCurrent((GroovyObject)this);
        } else {
            this.initLicenseFile();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[2].callCurrent((GroovyObject)this);
        } else {
            this.initLicensesMetadata();
        }
        File dependenciesJsonFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), File.class);
        Object artifactInfoSet = callSiteArray[6].callStatic(LicensesTask.class, (Object)dependenciesJsonFile);
        if (ScriptBytecodeAdapter.isCase((Object)callSiteArray[7].callGetProperty(DependencyUtil.class), (Object)artifactInfoSet)) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[8].call(artifactInfoSet), (Object)1)) {
                throw (Throwable)callSiteArray[9].callConstructor(IllegalStateException.class, (Object)"artifactInfoSet that contains EMPTY_ARTIFACT should not contain other artifacts.");
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[10].callCurrent((GroovyObject)this);
            } else {
                this.addDebugLicense();
            }
        } else {
            Object artifactInfo = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(artifactInfoSet), Iterator.class);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    artifactInfo = iterator.next();
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callStatic(LicensesTask.class, callSiteArray[13].callGetProperty(artifactInfo)))) {
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call(callSiteArray[15].callGetProperty(artifactInfo), (Object)LICENSE_ARTIFACT_SUFFIX))) {
                            callSiteArray[16].callCurrent((GroovyObject)this, artifactInfo);
                        }
                        if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callStatic(LicensesTask.class, callSiteArray[18].callGetProperty(artifactInfo))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call(callSiteArray[20].callGetProperty(artifactInfo), (Object)LICENSE_ARTIFACT_SUFFIX)))) continue;
                        callSiteArray[21].callCurrent((GroovyObject)this, artifactInfo);
                        continue;
                    }
                    callSiteArray[22].callCurrent((GroovyObject)this, artifactInfo);
                }
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[23].callCurrent((GroovyObject)this);
        } else {
            this.writeMetadata();
        }
    }

    private static List<ArtifactInfo> loadDependenciesJson(File jsonFile) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object allDependencies = callSiteArray[24].call(callSiteArray[25].callConstructor(JsonSlurper.class), (Object)jsonFile);
        Object artifactInfoSet = callSiteArray[26].callConstructor(HashSet.class);
        Object entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(allDependencies), Iterator.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                entry = iterator.next();
                ArtifactInfo artifactInfo = (ArtifactInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callStatic(LicensesTask.class, entry), ArtifactInfo.class);
                callSiteArray[29].call(artifactInfoSet, (Object)artifactInfo);
            }
        }
        public final class _loadDependenciesJson_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _loadDependenciesJson_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _loadDependenciesJson_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _loadDependenciesJson_closure1.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _loadDependenciesJson_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadDependenciesJson_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "toString";
                return new CallSiteArray(_loadDependenciesJson_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _loadDependenciesJson_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(artifactInfoSet), callSiteArray[33].call(Comparator.class, (Object)new _loadDependenciesJson_closure1(LicensesTask.class, LicensesTask.class))), callSiteArray[34].call(Collectors.class)), List.class);
    }

    private void addDebugLicense() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        callSiteArray[35].callCurrent((GroovyObject)this, (Object)ABSENT_DEPENDENCY_KEY, callSiteArray[36].call((Object)ABSENT_DEPENDENCY_TEXT, (Object)UTF_8));
    }

    protected void initOutputDir() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].call((Object)this.rawResourceDir))) {
            callSiteArray[38].call((Object)this.rawResourceDir);
        }
    }

    protected void initLicenseFile() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)this.licenses, null)) {
            callSiteArray[39].call(logger, (Object)"License file is undefined");
        }
        public final class _initLicenseFile_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _initLicenseFile_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _initLicenseFile_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object w) {
                CallSite[] callSiteArray = _initLicenseFile_closure2.$getCallSiteArray();
                return callSiteArray[0].call(w, (Object)"");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _initLicenseFile_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "leftShift";
                return new CallSiteArray(_initLicenseFile_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _initLicenseFile_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[40].call(callSiteArray[41].call((Object)this.licenses), (Object)new _initLicenseFile_closure2((Object)this, (Object)this));
    }

    protected void initLicensesMetadata() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        public final class _initLicensesMetadata_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _initLicensesMetadata_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _initLicensesMetadata_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object w) {
                CallSite[] callSiteArray = _initLicensesMetadata_closure3.$getCallSiteArray();
                return callSiteArray[0].call(w, (Object)"");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _initLicensesMetadata_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "leftShift";
                return new CallSiteArray(_initLicensesMetadata_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _initLicensesMetadata_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[42].call(callSiteArray[43].call((Object)this.licensesMetadata), (Object)new _initLicensesMetadata_closure3((Object)this, (Object)this));
    }

    protected static boolean isGoogleServices(String group) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].call((Object)GOOGLE_PLAY_SERVICES_GROUP, (Object)group)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call((Object)FIREBASE_GROUP, (Object)group));
    }

    protected static boolean isGranularVersion(String version) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object[] versions = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call((Object)version, (Object)"\\."), String[].class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[47].callGetProperty((Object)versions), (Object)0) && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[48].call(Integer.class, callSiteArray[49].call((Object)versions, (Object)0)), (Object)GRANULAR_BASE_VERSION);
        }
        return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[50].callGetProperty((Object)versions), (Object)0) && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[51].call(Integer.class, BytecodeInterface8.objectArrayGet((Object[])versions, (int)0)), (Object)GRANULAR_BASE_VERSION);
    }

    protected void addGooglePlayServiceLicenses(ArtifactInfo artifactInfo) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        File artifactFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].call(DependencyUtil.class, callSiteArray[53].callCurrent((GroovyObject)this), (Object)artifactInfo), File.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)artifactFile, null)) {
            callSiteArray[54].call(logger, (Object)new GStringImpl(new Object[]{artifactInfo}, new String[]{"Unable to find Google Play Services Artifact for ", ""}));
            return;
        }
        callSiteArray[55].callCurrent((GroovyObject)this, (Object)artifactFile);
    }

    protected void addGooglePlayServiceLicenses(File artifactFile) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        ZipFile licensesZip = (ZipFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callConstructor(ZipFile.class, (Object)artifactFile), ZipFile.class);
        ZipEntry jsonFile = (ZipEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].call((Object)licensesZip, (Object)"third_party_licenses.json"), ZipEntry.class);
        ZipEntry txtFile = (ZipEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call((Object)licensesZip, (Object)"third_party_licenses.txt"), ZipEntry.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)jsonFile) || !DefaultTypeTransformation.booleanUnbox((Object)txtFile) : !DefaultTypeTransformation.booleanUnbox((Object)jsonFile) || !DefaultTypeTransformation.booleanUnbox((Object)txtFile)) {
            return;
        }
        Reference jsonSlurper = new Reference((Object)((JsonSlurper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callConstructor(JsonSlurper.class), JsonSlurper.class)));
        public final class _addGooglePlayServiceLicenses_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference jsonSlurper;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addGooglePlayServiceLicenses_closure4(Object _outerInstance, Object _thisObject, Reference jsonSlurper) {
                Reference reference;
                CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.jsonSlurper = reference = jsonSlurper;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                return callSiteArray[0].call((Object)((JsonSlurper)ScriptBytecodeAdapter.castToType((Object)this.jsonSlurper.get(), JsonSlurper.class)), it);
            }

            @Generated
            public JsonSlurper getJsonSlurper() {
                CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                return (JsonSlurper)ScriptBytecodeAdapter.castToType((Object)this.jsonSlurper.get(), JsonSlurper.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addGooglePlayServiceLicenses_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "parse";
                return new CallSiteArray(_addGooglePlayServiceLicenses_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addGooglePlayServiceLicenses_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object licensesObj = callSiteArray[60].call(callSiteArray[61].call((Object)licensesZip, (Object)jsonFile), (Object)new _addGooglePlayServiceLicenses_closure4((Object)this, (Object)this, jsonSlurper));
        if (ScriptBytecodeAdapter.compareEqual((Object)licensesObj, null)) {
            return;
        }
        Object entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].call(licensesObj), Iterator.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                entry = iterator.next();
                Reference key = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[63].callGetProperty(entry)));
                Reference startValue = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callGetProperty(callSiteArray[65].callGetProperty(entry)), Integer.class)));
                Reference lengthValue = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callGetProperty(callSiteArray[67].callGetProperty(entry)), Integer.class)));
                if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].call(this.googleServiceLicenses, (Object)((String)key.get()))))) continue;
                public final class _addGooglePlayServiceLicenses_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference startValue;
                    private /* synthetic */ Reference lengthValue;
                    private /* synthetic */ Reference key;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _addGooglePlayServiceLicenses_closure5(Object _outerInstance, Object _thisObject, Reference startValue, Reference lengthValue, Reference key) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.startValue = reference3 = startValue;
                        this.lengthValue = reference2 = lengthValue;
                        this.key = reference = key;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure5.$getCallSiteArray();
                        byte[] content = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callCurrent((GroovyObject)this, it, (Object)((Integer)ScriptBytecodeAdapter.castToType((Object)this.startValue.get(), Integer.class)), (Object)((Integer)ScriptBytecodeAdapter.castToType((Object)this.lengthValue.get(), Integer.class))), byte[].class);
                        callSiteArray[1].call(callSiteArray[2].callGetProperty((Object)this), (Object)ShortTypeHandling.castToString((Object)this.key.get()));
                        return callSiteArray[3].callCurrent((GroovyObject)this, (Object)ShortTypeHandling.castToString((Object)this.key.get()), (Object)content);
                    }

                    @Generated
                    public Integer getStartValue() {
                        CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure5.$getCallSiteArray();
                        return (Integer)ScriptBytecodeAdapter.castToType((Object)this.startValue.get(), Integer.class);
                    }

                    @Generated
                    public Integer getLengthValue() {
                        CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure5.$getCallSiteArray();
                        return (Integer)ScriptBytecodeAdapter.castToType((Object)this.lengthValue.get(), Integer.class);
                    }

                    @Generated
                    public String getKey() {
                        CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure5.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.key.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _addGooglePlayServiceLicenses_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getBytesFromInputStream";
                        stringArray[1] = "add";
                        stringArray[2] = "googleServiceLicenses";
                        stringArray[3] = "appendDependency";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _addGooglePlayServiceLicenses_closure5.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_addGooglePlayServiceLicenses_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _addGooglePlayServiceLicenses_closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[69].call(callSiteArray[70].call((Object)licensesZip, (Object)txtFile), (Object)new _addGooglePlayServiceLicenses_closure5((Object)this, (Object)this, startValue, lengthValue, key));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static byte[] getBytesFromInputStream(InputStream stream, long offset, int length) {
        var4_3 = LicensesTask.$getCallSiteArray();
        buffer = new byte[1024];
        textArray = (ByteArrayOutputStream)ScriptBytecodeAdapter.castToType((Object)var4_3[71].callConstructor(ByteArrayOutputStream.class), ByteArrayOutputStream.class);
        var4_3[72].call((Object)stream, (Object)offset);
        bytesRemaining = 0;
        bytesRemaining = !BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || LicensesTask.__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? DefaultTypeTransformation.intUnbox((Object)(length > 0 != false ? Integer.valueOf(length) : var4_3[73].callGetProperty(Integer.class))) : DefaultTypeTransformation.intUnbox((Object)(length > 0 != false ? Integer.valueOf(length) : var4_3[74].callGetProperty(Integer.class)));
        bytes = 0;
        while (true) {
            if (!(bytesRemaining > 0)) ** GOTO lbl-1000
            v0 = var4_3[75].call((Object)stream, (Object)buffer, (Object)0, var4_3[76].call(Math.class, (Object)bytesRemaining, var4_3[77].callGetProperty((Object)buffer)));
            bytes = DefaultTypeTransformation.intUnbox((Object)v0);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)v0, (Object)-1)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) break;
            var4_3[78].call((Object)textArray, (Object)buffer, (Object)0, (Object)bytes);
            bytesRemaining = DefaultTypeTransformation.intUnbox((Object)var4_3[79].call((Object)bytesRemaining, (Object)bytes));
        }
        var4_3[80].call((Object)stream);
        var9_8 = (byte[])ScriptBytecodeAdapter.castToType((Object)var4_3[81].call((Object)textArray), byte[].class);
        try {
            return var9_8;
        }
        catch (Exception e) {
            throw (Throwable)var4_3[82].callConstructor(RuntimeException.class, (Object)LicensesTask.FAIL_READING_LICENSES_ERROR, (Object)e);
        }
    }

    protected void addLicensesFromPom(ArtifactInfo artifactInfo) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object pomFile = callSiteArray[83].call(DependencyUtil.class, callSiteArray[84].callCurrent((GroovyObject)this), (Object)artifactInfo);
        callSiteArray[85].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((File)ScriptBytecodeAdapter.castToType((Object)pomFile, File.class)), File.class), callSiteArray[86].callGroovyObjectGetProperty((Object)artifactInfo), callSiteArray[87].callGroovyObjectGetProperty((Object)artifactInfo));
    }

    protected void addLicensesFromPom(File pomFile, String group, String name) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)pomFile, null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].call((Object)pomFile))) {
                callSiteArray[89].call(logger, (Object)new GStringImpl(new Object[]{pomFile, group, name}, new String[]{"POM file ", " for ", ":", " does not exist."}));
                return;
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)pomFile, null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].call((Object)pomFile))) {
            callSiteArray[91].call(logger, (Object)new GStringImpl(new Object[]{pomFile, group, name}, new String[]{"POM file ", " for ", ":", " does not exist."}));
            return;
        }
        Object rootNode = callSiteArray[92].call(callSiteArray[93].callConstructor(XmlSlurper.class), (Object)pomFile);
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[94].call(callSiteArray[95].callGetProperty(rootNode)), (Object)0)) {
            return;
        }
        Reference libraryName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[96].callGetProperty(rootNode)));
        Reference licenseKey = new Reference((Object)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{group, name}, new String[]{"", ":", ""})));
        if (ScriptBytecodeAdapter.compareEqual((Object)((String)libraryName.get()), null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[97].call((Object)((String)libraryName.get())))) {
            libraryName.set((Object)((String)licenseKey.get()));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[98].call(callSiteArray[99].callGetProperty(callSiteArray[100].callGetProperty(rootNode))), (Object)1)) {
            public final class _addLicensesFromPom_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference licenseKey;
                private /* synthetic */ Reference libraryName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addLicensesFromPom_closure6(Object _outerInstance, Object _thisObject, Reference licenseKey, Reference libraryName) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _addLicensesFromPom_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.licenseKey = reference2 = licenseKey;
                    this.libraryName = reference = libraryName;
                }

                public Object doCall(Object license) {
                    CallSite[] callSiteArray = _addLicensesFromPom_closure6.$getCallSiteArray();
                    String licenseName = ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(license));
                    String licenseUrl = ShortTypeHandling.castToString((Object)callSiteArray[1].callGetProperty(license));
                    return callSiteArray[2].callCurrent((GroovyObject)this, callSiteArray[3].callConstructor(Dependency.class, (Object)new GStringImpl(new Object[]{ShortTypeHandling.castToString((Object)this.licenseKey.get()), licenseName}, new String[]{"", " ", ""}), (Object)ShortTypeHandling.castToString((Object)this.libraryName.get())), callSiteArray[4].call((Object)licenseUrl, ScriptBytecodeAdapter.getField(_addLicensesFromPom_closure6.class, LicensesTask.class, (String)"UTF_8")));
                }

                @Generated
                public String getLicenseKey() {
                    CallSite[] callSiteArray = _addLicensesFromPom_closure6.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.licenseKey.get());
                }

                @Generated
                public String getLibraryName() {
                    CallSite[] callSiteArray = _addLicensesFromPom_closure6.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.libraryName.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addLicensesFromPom_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "url";
                    stringArray[2] = "appendDependency";
                    stringArray[3] = "<$constructor$>";
                    stringArray[4] = "getBytes";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _addLicensesFromPom_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addLicensesFromPom_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addLicensesFromPom_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[101].call(callSiteArray[102].callGetProperty(callSiteArray[103].callGetProperty(rootNode)), (Object)new _addLicensesFromPom_closure6((Object)this, (Object)this, licenseKey, libraryName));
        } else {
            String nodeUrl = ShortTypeHandling.castToString((Object)callSiteArray[104].callGetProperty(callSiteArray[105].callGetProperty(callSiteArray[106].callGetProperty(rootNode))));
            callSiteArray[107].callCurrent((GroovyObject)this, callSiteArray[108].callConstructor(Dependency.class, (Object)((String)licenseKey.get()), (Object)((String)libraryName.get())), callSiteArray[109].call((Object)nodeUrl, (Object)UTF_8));
        }
    }

    protected void appendDependency(String key, byte ... license) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        callSiteArray[110].callCurrent((GroovyObject)this, callSiteArray[111].callConstructor(Dependency.class, (Object)key, (Object)key), (Object)license);
    }

    protected void appendDependency(Dependency dependency, byte ... license) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        String licenseText = ShortTypeHandling.castToString((Object)callSiteArray[112].callConstructor(String.class, (Object)license, (Object)UTF_8));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[113].call(this.licensesMap, callSiteArray[114].callGroovyObjectGetProperty((Object)dependency)))) {
            return;
        }
        String offsets = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[115].call(this.licenseOffsets, (Object)licenseText))) {
            offsets = ShortTypeHandling.castToString((Object)callSiteArray[116].call(this.licenseOffsets, (Object)licenseText));
        } else {
            offsets = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.start, callSiteArray[117].callGetProperty((Object)license)}, new String[]{"", ":", ""}));
            callSiteArray[118].call(this.licenseOffsets, (Object)licenseText, (Object)offsets);
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[119].callCurrent((GroovyObject)this, (Object)license);
            } else {
                this.appendLicenseContent(license);
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[120].callCurrent((GroovyObject)this, (Object)LINE_SEPARATOR);
            } else {
                this.appendLicenseContent(LINE_SEPARATOR);
            }
        }
        callSiteArray[121].call(this.licensesMap, callSiteArray[122].callGroovyObjectGetProperty((Object)dependency), callSiteArray[123].call((Object)dependency, (Object)offsets));
    }

    protected void appendLicenseContent(byte ... content) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        callSiteArray[124].call((Object)this.licenses, (Object)content);
        this.start = DefaultTypeTransformation.intUnbox((Object)callSiteArray[125].call((Object)this.start, callSiteArray[126].callGetProperty((Object)content)));
    }

    protected void writeMetadata() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[127].call(this.licensesMap), Iterator.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                entry = iterator.next();
                callSiteArray[128].call((Object)this.licensesMetadata, callSiteArray[129].callGetProperty(entry), (Object)UTF_8);
                callSiteArray[130].call((Object)this.licensesMetadata, (Object)LINE_SEPARATOR);
            }
        }
    }

    public static ArtifactInfo artifactInfoFromEntry(Object entry) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        return (ArtifactInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[131].callConstructor(ArtifactInfo.class, callSiteArray[132].callGetProperty(entry), callSiteArray[133].callGetProperty(entry), callSiteArray[134].callGetProperty(entry)), ArtifactInfo.class);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[135].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[136].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[137].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LicensesTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object;
        Object object2 = LicensesTask.$getCallSiteArray()[138].call(LicensesTask.$getCallSiteArray()[139].call(System.class, (Object)"line.separator"), (Object)UTF_8);
        LINE_SEPARATOR = (byte[])ScriptBytecodeAdapter.castToType((Object)object2, byte[].class);
        logger = object = LicensesTask.$getCallSiteArray()[140].call(LoggerFactory.class, LicensesTask.class);
    }

    @Generated
    public File getRawResourceDir() {
        return this.rawResourceDir;
    }

    @Generated
    public void setRawResourceDir(File file) {
        this.rawResourceDir = file;
    }

    @Generated
    public File getLicenses() {
        return this.licenses;
    }

    @Generated
    public void setLicenses(File file) {
        this.licenses = file;
    }

    @Generated
    public File getLicensesMetadata() {
        return this.licensesMetadata;
    }

    @Generated
    public void setLicensesMetadata(File file) {
        this.licensesMetadata = file;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "initOutputDir";
        stringArray[1] = "initLicenseFile";
        stringArray[2] = "initLicensesMetadata";
        stringArray[3] = "get";
        stringArray[4] = "asFile";
        stringArray[5] = "dependenciesJson";
        stringArray[6] = "loadDependenciesJson";
        stringArray[7] = "ABSENT_ARTIFACT";
        stringArray[8] = "size";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "addDebugLicense";
        stringArray[11] = "iterator";
        stringArray[12] = "isGoogleServices";
        stringArray[13] = "group";
        stringArray[14] = "endsWith";
        stringArray[15] = "name";
        stringArray[16] = "addLicensesFromPom";
        stringArray[17] = "isGranularVersion";
        stringArray[18] = "version";
        stringArray[19] = "endsWith";
        stringArray[20] = "name";
        stringArray[21] = "addGooglePlayServiceLicenses";
        stringArray[22] = "addLicensesFromPom";
        stringArray[23] = "writeMetadata";
        stringArray[24] = "parse";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "iterator";
        stringArray[28] = "artifactInfoFromEntry";
        stringArray[29] = "add";
        stringArray[30] = "collect";
        stringArray[31] = "sorted";
        stringArray[32] = "stream";
        stringArray[33] = "comparing";
        stringArray[34] = "toUnmodifiableList";
        stringArray[35] = "appendDependency";
        stringArray[36] = "getBytes";
        stringArray[37] = "exists";
        stringArray[38] = "mkdirs";
        stringArray[39] = "error";
        stringArray[40] = "withWriter";
        stringArray[41] = "newWriter";
        stringArray[42] = "withWriter";
        stringArray[43] = "newWriter";
        stringArray[44] = "equalsIgnoreCase";
        stringArray[45] = "equalsIgnoreCase";
        stringArray[46] = "split";
        stringArray[47] = "length";
        stringArray[48] = "valueOf";
        stringArray[49] = "getAt";
        stringArray[50] = "length";
        stringArray[51] = "valueOf";
        stringArray[52] = "getLibraryFile";
        stringArray[53] = "getProject";
        stringArray[54] = "warn";
        stringArray[55] = "addGooglePlayServiceLicenses";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "getEntry";
        stringArray[58] = "getEntry";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "withCloseable";
        stringArray[61] = "getInputStream";
        stringArray[62] = "iterator";
        stringArray[63] = "key";
        stringArray[64] = "start";
        stringArray[65] = "value";
        stringArray[66] = "length";
        stringArray[67] = "value";
        stringArray[68] = "contains";
        stringArray[69] = "withCloseable";
        stringArray[70] = "getInputStream";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "skip";
        stringArray[73] = "MAX_VALUE";
        stringArray[74] = "MAX_VALUE";
        stringArray[75] = "read";
        stringArray[76] = "min";
        stringArray[77] = "length";
        stringArray[78] = "write";
        stringArray[79] = "minus";
        stringArray[80] = "close";
        stringArray[81] = "toByteArray";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "resolvePomFileArtifact";
        stringArray[84] = "getProject";
        stringArray[85] = "addLicensesFromPom";
        stringArray[86] = "group";
        stringArray[87] = "name";
        stringArray[88] = "exists";
        stringArray[89] = "error";
        stringArray[90] = "exists";
        stringArray[91] = "error";
        stringArray[92] = "parse";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "size";
        stringArray[95] = "licenses";
        stringArray[96] = "name";
        stringArray[97] = "isBlank";
        stringArray[98] = "size";
        stringArray[99] = "license";
        stringArray[100] = "licenses";
        stringArray[101] = "each";
        stringArray[102] = "license";
        stringArray[103] = "licenses";
        stringArray[104] = "url";
        stringArray[105] = "license";
        stringArray[106] = "licenses";
        stringArray[107] = "appendDependency";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "getBytes";
        stringArray[110] = "appendDependency";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "<$constructor$>";
        stringArray[113] = "containsKey";
        stringArray[114] = "key";
        stringArray[115] = "containsKey";
        stringArray[116] = "get";
        stringArray[117] = "length";
        stringArray[118] = "put";
        stringArray[119] = "appendLicenseContent";
        stringArray[120] = "appendLicenseContent";
        stringArray[121] = "put";
        stringArray[122] = "key";
        stringArray[123] = "buildLicensesMetadata";
        stringArray[124] = "append";
        stringArray[125] = "plus";
        stringArray[126] = "length";
        stringArray[127] = "iterator";
        stringArray[128] = "append";
        stringArray[129] = "value";
        stringArray[130] = "append";
        stringArray[131] = "<$constructor$>";
        stringArray[132] = "group";
        stringArray[133] = "name";
        stringArray[134] = "version";
        stringArray[135] = "length";
        stringArray[136] = "getAt";
        stringArray[137] = "length";
        stringArray[138] = "getBytes";
        stringArray[139] = "getProperty";
        stringArray[140] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[141];
        LicensesTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LicensesTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LicensesTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    protected static class Dependency
    implements GroovyObject {
        private String key;
        private String name;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public Dependency(String key, String name) {
            String string;
            String string2;
            MetaClass metaClass;
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.key = string2 = key;
            this.name = string = name;
        }

        public String buildLicensesMetadata(String offset) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{offset, this.name}, new String[]{"", " ", ""}));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[1].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[4].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Dependency.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public void setKey(String string) {
            this.key = string;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "length";
            stringArray[1] = "getAt";
            stringArray[2] = "length";
            stringArray[3] = "length";
            stringArray[4] = "getAt";
            stringArray[5] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[6];
            Dependency.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(Dependency.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Dependency.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

