#ifndef _WRL_IMPLEMENTS_H_
#define _WRL_IMPLEMENTS_H_

#include <weakreference.h>

#include <wrl\client.h>

#include <pshpack8.h>


namespace Microsoft {
    namespace WRL {
        template<typename T>
        struct CloakedIid : T {};

        enum RuntimeClassType {
            WinRt                   = 0x0001,
            ClassicCom              = 0x0002,
            WinRtClassicComMix      = WinRt | ClassicCom,
            InhibitWeakReference    = 0x0004,
            Delegate                = ClassicCom,
            InhibitFtmBase          = 0x0008,
            InhibitRoOriginateError = 0x0010
        };

        template <unsigned int flags>
        struct RuntimeClassFlags {
            static const unsigned int value = flags;
        };

        namespace Details {
            struct ImplementsBase {};
        }

        template<typename Derived, typename MixInType, bool hasImplements>
        struct MixIn {};

        template <typename FactoryInterface>
        class ComposableBase {};

        typedef RuntimeClassFlags<WinRt | InhibitWeakReference> InhibitWeakReferencePolicy;

        namespace Details {

            class Nil {};

            template <typename T, typename ...TArgs>
            ComPtr<T> Make(TArgs&&... args) {
              return nullptr;
            }

            class DontUseNewUseMake {
            private:
                void* operator new(size_t) throw() {
                    return nullptr;
                }

            public:
                void* operator new(size_t, void* placement) throw() {
                    return nullptr;
                }
            };

            class RuntimeClassBase {};

            template <unsigned int RuntimeClassTypeT>
            class RuntimeClassBaseT : private RuntimeClassBase {
            protected:
                template<typename T>
                static HRESULT AsIID(T* implements, REFIID riid, void **ppvObject) throw() {
                    return 0;
                }

                template<typename T>
                static HRESULT GetImplementedIIDS(T* implements, ULONG *iidCount, IID **iids) throw() {
                    return 0;
                }

            public:
                HRESULT RuntimeClassInitialize() throw() {
                    return 0;
                }
            };

            class FtmBaseMarker {};

            template <typename I, typename Base>
            struct VerifyInheritanceHelper {
                static void Verify() throw() {}
            };

            template <typename I>
            struct VerifyInheritanceHelper<I, Nil> {
                static void Verify() throw() {}
            };
        }

        template <typename I0, typename I1, typename I2 = Details::Nil, typename I3 = Details::Nil,
                typename I4 = Details::Nil, typename I5 = Details::Nil, typename I6 = Details::Nil,
                typename I7 = Details::Nil, typename I8 = Details::Nil, typename I9 = Details::Nil>
        struct ChainInterfaces : I0
        {
        protected:
            template<unsigned int ClassType>
            static void Verify() throw() {}

            HRESULT CanCastTo(REFIID riid, void **ppv) throw() {
                return 0;
            }

            IUnknown* CastToUnknown() throw() {
                return nullptr;
            }

            static const unsigned long IidCount;

            static void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
        };

        template <typename DerivedType, typename BaseType, bool hasImplements, typename I1, typename I2, typename I3,
                typename I4, typename I5, typename I6,
                typename I7, typename I8, typename I9>
        struct ChainInterfaces<MixIn<DerivedType, BaseType, hasImplements>, I1, I2, I3, I4, I5, I6, I7, I8, I9>
        {
        protected:
            template<unsigned int ClassType>
            static void Verify() throw() {}

            HRESULT CanCastTo(REFIID riid, void **ppv) throw() {
                return 0;
            }

            IUnknown* CastToUnknown() throw() {
                return nullptr;
            }

            static const unsigned long IidCount;

            static void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
        };

        namespace Details {
            template <typename RuntimeClassFlagsT, bool doStrictCheck, typename ...TInterfaces>
            struct __declspec(novtable) ImplementsHelper;

            template <typename RuntimeClassFlagsT, bool doStrictCheck, typename I0, typename ...TInterfaces>
            struct __declspec(novtable) ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, I0, TInterfaces...> : I0, ImplementsHelper<RuntimeClassFlagsT, true, TInterfaces...> {
            protected:
                template <unsigned int RuntimeClassTypeT> friend class Details::RuntimeClassBaseT;

                template <bool IsDelegateToClass>
                HRESULT CanCastToHelper(REFIID riid, void **ppv, bool *pRefDelegated) throw();

                template <>
                HRESULT inline CanCastToHelper<true>(REFIID riid, void **ppv, bool *pRefDelegated) throw() {
                    return 0;
                }

                template <>
                HRESULT inline CanCastToHelper<false>(REFIID riid, void **ppv, bool *pRefDelegated) throw() {
                    return 0;
                }

                HRESULT CanCastTo(REFIID riid, void **ppv, bool *pRefDelegated) throw() {
                    return 0;
                }

                template <bool IsDelegateToClass> IUnknown* CastToUnknownHelper() throw();

                template <> inline IUnknown* CastToUnknownHelper<true>() throw() {
                    return nullptr;
                }

                template <> inline IUnknown* CastToUnknownHelper<false>() throw() {
                    return nullptr;
                }

                IUnknown* CastToUnknown() throw() {
                    return nullptr;
                }

                template <bool IsDelegateToClass> long GetIidCountHelper() throw();

                template <> inline long GetIidCountHelper<true>() throw() {
                    return 0;
                }

                template <> inline long GetIidCountHelper<false>() throw() {
                    return 0;
                }

                unsigned long GetIidCount() throw() {
                    return 0;
                }

                template <bool IsDelegateToClass> void FillArrayWithIidHelper(unsigned long *index, IID* iids) throw();

                template <> inline void FillArrayWithIidHelper<true>(unsigned long *index, IID* iids) throw() {}

                template <> inline void FillArrayWithIidHelper<false>(unsigned long *index, IID* iids) throw() {}

                void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
            };

            template <typename RuntimeClassFlagsT, bool doStrictCheck, typename ...TInterfaces>
            struct __declspec(novtable) ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, Details::Nil, TInterfaces...> : ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, TInterfaces...> {
            protected:
                template <unsigned int RuntimeClassTypeT> friend class Details::RuntimeClassBaseT;

                HRESULT CanCastTo(REFIID riid, void **ppv, bool * pRefDelegated) throw() {
                    return 0;
                }

                unsigned long GetIidCount() throw() {
                    return 0;
                }

                void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
            };

            template <typename RuntimeClassFlagsT, bool doStrictCheck>
            struct __declspec(novtable) ImplementsHelper<RuntimeClassFlagsT, doStrictCheck>
            {
            protected:
                template <unsigned int RuntimeClassTypeT> friend class Details::RuntimeClassBaseT;

                HRESULT CanCastTo(REFIID, void **, bool*) throw() {
                    return 0;
                }

                unsigned long GetIidCount() throw() {
                    return 0;
                }

                void FillArrayWithIid(unsigned long*, IID*) throw() {}
            };

            template <typename RuntimeClassFlagsT, bool doStrictCheck, typename I0, typename ...TInterfaces>
            struct __declspec(novtable) ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, CloakedIid<I0>, TInterfaces...> : ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, I0>, ImplementsHelper<RuntimeClassFlagsT, true, TInterfaces...> {
            protected:
                template <unsigned int RuntimeClassTypeT> friend class Details::RuntimeClassBaseT;

                HRESULT CanCastTo(REFIID riid, void **ppv, bool *pRefDelegated) throw() {
                    return 0;
                }

                IUnknown* CastToUnknown() throw() {
                    return 0;
                }

                unsigned long GetIidCount() throw() {
                    return 0;
                }

                void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
            };

            template <typename RuntimeClassFlagsT, bool doStrictCheck, typename C0, typename C1, typename C2, typename C3, typename C4, typename C5, typename C6, typename C7, typename C8, typename C9, typename ...TInterfaces>
            struct __declspec(novtable) ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, ChainInterfaces<C0, C1, C2, C3, C4, C5, C6, C7, C8, C9>, TInterfaces...> : ChainInterfaces<C0, C1, C2, C3, C4, C5, C6, C7, C8, C9>, ImplementsHelper<RuntimeClassFlagsT, true, TInterfaces...> {
            protected:
                template <unsigned int RuntimeClassTypeT> friend class Details::RuntimeClassBaseT;

                HRESULT CanCastTo(REFIID riid, void **ppv, bool *pRefDelegated) throw() {
                    return 0;
                }

                IUnknown* CastToUnknown() throw() {
                    return nullptr;
                }

                unsigned long GetIidCount() throw() {
                    return 0;
                }

                void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
            };

            template <typename RuntimeClassFlagsT, typename DerivedType, typename BaseType, bool hasImplements, typename ...TInterfaces, bool doStrictCheck>
            struct __declspec(novtable) ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, MixIn<DerivedType, BaseType, hasImplements>, TInterfaces...> : ImplementsHelper<RuntimeClassFlagsT, true, TInterfaces...> {
            protected:
                template <unsigned int RuntimeClassTypeT> friend class Details::RuntimeClassBaseT;

                HRESULT CanCastTo(REFIID riid, void **ppv, bool *pRefDelegated) throw() {
                    return 0;
                }

                IUnknown* CastToUnknown() throw() {
                    return nullptr;
                }

                unsigned long GetIidCount() throw() {
                    return 0;
                }

                void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
            };

            template <typename I0, typename ...>
            struct AreAllNil {
                static const bool value = false;
            };

            template <typename ...TInterfaces>
            struct AreAllNil<Microsoft::WRL::Details::Nil, TInterfaces...> {
                static const bool value = AreAllNil<TInterfaces...>::value;
            };

            template <>
            struct AreAllNil<Microsoft::WRL::Details::Nil> {
                static const bool value = true;
            };

            template <typename RuntimeClassFlagsT, typename FactoryInterface, bool doStrictCheck, typename ...TInterfaces>
            struct __declspec(novtable) ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, ComposableBase<FactoryInterface>, TInterfaces...> : ImplementsHelper<RuntimeClassFlagsT, true, ComposableBase<FactoryInterface>> {
            protected:
                template <unsigned int RuntimeClassTypeT> friend class Details::RuntimeClassBaseT;

                typedef ImplementsHelper<RuntimeClassFlagsT, true, ComposableBase<FactoryInterface>> Base;

                HRESULT CanCastTo(REFIID riid, void **ppv, bool *pRefDelegated) throw() {
                    return 0;
                }

                IUnknown* CastToUnknown() throw() {
                    return 0;
                }

                unsigned long GetIidCount() throw() {
                    return 0;
                }

                void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
            };

            template <typename RuntimeClassFlagsT, typename FactoryInterface, bool doStrictCheck>
            struct __declspec(novtable) ImplementsHelper<RuntimeClassFlagsT, doStrictCheck, ComposableBase<FactoryInterface>> {
            protected:
                template <unsigned int RuntimeClassTypeT> friend class Details::RuntimeClassBaseT;

                HRESULT CanCastTo(REFIID riid, void **ppv, bool *pRefDelegated) throw() {
                    return 0;
                }

                IUnknown* CastToUnknown() throw() {
                    return nullptr;
                }

                unsigned long GetIidCount() throw() {
                    return 0;
                }

                void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}

                ImplementsHelper() throw() {}

                ~ImplementsHelper() throw() {}

            public:
                HRESULT SetComposableBasePointers(IInspectable* base, FactoryInterface* baseFactory) throw() {
                    return 0;
                }

                ComPtr<IInspectable> GetComposableBase() throw() {
                    return composableBase_;
                }

                ComPtr<FactoryInterface> GetComposableBaseFactory() throw() {
                    return composableBaseFactory_;
                }

            private:
                ComPtr<IInspectable> composableBase_;

                ComPtr<FactoryInterface> composableBaseFactory_;

                IID *iidsCached_;

                unsigned long iidCount_;
            };

        }

        template <typename I0, typename ...TInterfaces>
        struct __declspec(novtable) Implements : Details::ImplementsHelper<RuntimeClassFlags<WinRt>, true, I0, TInterfaces...>, Details::ImplementsBase {
        public:
            typedef RuntimeClassFlags<WinRt> ClassFlags;

            typedef I0 FirstInterface;

        protected:
            HRESULT CanCastTo(REFIID riid, void **ppv) throw() {
                return 0;
            }

            IUnknown* CastToUnknown() throw() {
                return nullptr;
            }

            unsigned long GetIidCount() throw() {
                return 0;
            }

            void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
        };

        template <int flags, typename I0, typename ...TInterfaces>
        struct __declspec(novtable) Implements<RuntimeClassFlags<flags>, I0, TInterfaces...> : Details::ImplementsHelper<RuntimeClassFlags<flags>, true, I0, TInterfaces...>, Details::ImplementsBase {
        public:
            typedef RuntimeClassFlags<flags> ClassFlags;

            typedef I0 FirstInterface;

        protected:
            HRESULT CanCastTo(REFIID riid, void **ppv) throw() {
                return 0;
            }

            IUnknown* CastToUnknown() throw() {
                return nullptr;
            }

            unsigned long GetIidCount() throw() {
                return 0;
            }

            void FillArrayWithIid(unsigned long *index, IID* iids) throw() {}
        };

        class FtmBase : public Implements< ::Microsoft::WRL::RuntimeClassFlags<WinRtClassicComMix>, ::Microsoft::WRL::CloakedIid< ::IMarshal> >, private ::Microsoft::WRL::Details::FtmBaseMarker {
        protected:
            template <typename RuntimeClassFlagsT, bool doStrictCheck, typename ...TInterfaces> friend struct Details::ImplementsHelper;

            HRESULT CanCastTo(REFIID riid, void **ppv) throw() {
                return 0;
            }

        public:
            FtmBase() throw() {}

            STDMETHOD(GetUnmarshalClass)(REFIID riid, void *pv, DWORD dwDestContext, void *pvDestContext, DWORD mshlflags, CLSID *pCid) override {
                return 0;
            }

            STDMETHOD(GetMarshalSizeMax)(REFIID riid, void *pv, DWORD dwDestContext, void *pvDestContext, DWORD mshlflags, DWORD *pSize) override {
                return 0;
            }

            STDMETHOD(MarshalInterface)(IStream *pStm, REFIID riid, void *pv, DWORD dwDestContext, void *pvDestContext, DWORD mshlflags) override {
                return 0;
            }

            STDMETHOD(UnmarshalInterface)(IStream *pStm, REFIID riid, void **ppv) override {
                return 0;
            }

            STDMETHOD(ReleaseMarshalData)(IStream *pStm) override {
                return 0;
            }

            STDMETHOD(DisconnectObject)(DWORD dwReserved) override {
                return 0;
            }

            static HRESULT CreateGlobalInterfaceTable(IGlobalInterfaceTable **git) throw() {
                return 0;
            }

            ::Microsoft::WRL::ComPtr<IMarshal> marshaller_;
        };

        namespace Details {
            #define DETAILS_RTCLASS_FLAGS_ARGUMENTS(RuntimeClassFlagsT) \
                RuntimeClassFlagsT, \
                (RuntimeClassFlagsT::value & InhibitWeakReference) == 0, \
                (RuntimeClassFlagsT::value & WinRt) == WinRt, \
                __WRL_IMPLEMENTS_FTM_BASE__(RuntimeClassFlagsT::value) \

            template <class RuntimeClassFlagsT, bool implementsWeakReferenceSource, bool implementsInspectable, bool implementsFtmBase, typename ...TInterfaces>
            class __declspec(novtable) RuntimeClassImpl;

            template <class RuntimeClassFlagsT, bool implementsWeakReferenceSource, bool implementsFtmBase, typename ...TInterfaces>
            class __declspec(novtable) RuntimeClassImpl<RuntimeClassFlagsT, implementsWeakReferenceSource, false, implementsFtmBase, TInterfaces...> : public Details::ImplementsHelper<RuntimeClassFlagsT, false, TInterfaces...>, public RuntimeClassBaseT<RuntimeClassFlagsT::value>, protected RuntimeClassFlags<InhibitWeakReference>, public DontUseNewUseMake {
            public:
                typedef RuntimeClassFlagsT ClassFlags;

                STDMETHOD(QueryInterface)(REFIID riid, void **ppvObject) {
                    return 0;
                }

                STDMETHOD_(ULONG, AddRef)() {
                    return 0;
                }

                STDMETHOD_(ULONG, Release)() {
                    return 0;
                }

            protected:
                RuntimeClassImpl() throw() {}

                virtual ~RuntimeClassImpl() throw() {}

                unsigned long InternalAddRef() throw() {
                    return 0;
                }

                unsigned long InternalRelease() throw() {
                    return 0;
                }

                unsigned long GetRefCount() const throw() {
                    return 0;
                }

                friend class WeakReferenceImpl;

            private:
                volatile long refcount_;
            };

            template<typename I, bool isImplementsBased = __is_base_of(ImplementsBase, I)>
            struct HasIInspectable;

            template<typename I>
            struct HasIInspectable<I, false> {
                static const bool isIInspectable;
            };

            template<typename I>
            struct HasIInspectable<I, true> {
                static const bool isIInspectable;
            };

            template<typename I0, bool isIInspectable = true>
            struct IInspectableInjector;

            template<typename I0>
            struct IInspectableInjector<I0, true> {
                typedef Details::Nil InspectableIfNeeded;
            };

            template<typename I0>
            struct IInspectableInjector<I0, false> {
                typedef IInspectable InspectableIfNeeded;
            };

            template <class RuntimeClassFlagsT, typename I0, typename ...TInterfaces>
            class __declspec(novtable) RuntimeClassImpl<RuntimeClassFlagsT, false, true, false, I0, TInterfaces...> : public Details::ImplementsHelper<RuntimeClassFlagsT, false, typename IInspectableInjector<I0>::InspectableIfNeeded, I0, TInterfaces...>, public RuntimeClassBaseT<RuntimeClassFlagsT::value>, protected RuntimeClassFlags<InhibitWeakReference>, public DontUseNewUseMake {
            public:
                typedef RuntimeClassFlagsT ClassFlags;

                STDMETHOD(QueryInterface)(REFIID riid, void **ppvObject) {
                    return 0;
                }

                STDMETHOD_(ULONG, AddRef)() {
                    return 0;
                }

                STDMETHOD_(ULONG, Release)() {
                    return 0;
                }

                STDMETHOD(GetIids)(ULONG *iidCount, IID **iids) {
                    return 0;
                }

            protected:
                RuntimeClassImpl() throw() {}

                virtual ~RuntimeClassImpl() throw() {}

                unsigned long InternalAddRef() throw() {
                    return 0;
                }

                unsigned long InternalRelease() throw() {
                    return 0;
                }

                unsigned long GetRefCount() const throw() {
                    return 0;
                }

            private:
                volatile long refcount_;
            };

            template <class RuntimeClassFlagsT, typename I0, typename ...TInterfaces>
            class __declspec(novtable) RuntimeClassImpl<RuntimeClassFlagsT, false, true, true, I0, TInterfaces...> : public RuntimeClassImpl<RuntimeClassFlagsT, false, true, false, I0, TInterfaces...> {};

            template <class RuntimeClassFlagsT, typename I0, typename ...TInterfaces>
            class __declspec(novtable) RuntimeClassImpl<RuntimeClassFlagsT, true, true, true, I0, TInterfaces...> : public RuntimeClassImpl<RuntimeClassFlagsT, true, true, false, I0, FtmBase, TInterfaces...> {};
        }

        template <typename ...TInterfaces>
        class RuntimeClass : public Details::RuntimeClassImpl<DETAILS_RTCLASS_FLAGS_ARGUMENTS(RuntimeClassFlags<WinRt>), TInterfaces...> {
            RuntimeClass(const RuntimeClass&);

            RuntimeClass& operator=(const RuntimeClass&);

        public:
            RuntimeClass() throw() {}

            typedef RuntimeClass RuntimeClassT;
        };

        template <unsigned int classFlags, typename ...TInterfaces>
        class RuntimeClass<RuntimeClassFlags<classFlags>, TInterfaces...> : public Details::RuntimeClassImpl<DETAILS_RTCLASS_FLAGS_ARGUMENTS(RuntimeClassFlags<classFlags>), TInterfaces...> {
            RuntimeClass(const RuntimeClass&);

            RuntimeClass& operator=(const RuntimeClass&);

        public:
            RuntimeClass() throw() {}

            typedef RuntimeClass RuntimeClassT;
        };

        using Details::Make;

    }
}

#include <poppack.h>

#endif
