#ifndef _WRL_EVENT_H_
#define _WRL_EVENT_H_

// #include <wrl/def.h>
#include <wrl/internal.h>
#include <wrl/client.h>
#include <wrl/implements.h>
#include <wrl/wrappers/corewrappers.h>
#include <eventtoken.h>
// #include <roerrorapi.h>

#include <pshpack8.h>

namespace Microsoft {
    namespace WRL {
        enum DelegateCheckMode {
            NoCheck = 1
        };

        template<DelegateCheckMode delegateCheckMode> struct DelegateTraits;

        template<> struct DelegateTraits<NoCheck> {
            static HRESULT CheckReturn(HRESULT hr) {
                return 0;
            }
        };

        extern __declspec(selectany) const DelegateCheckMode DefaultDelegateCheckMode = NoCheck;

        enum InvokeMode {
            StopOnFirstError = 1,
            FireAll = 2,
        };

        template<InvokeMode invokeModeValue> struct InvokeModeOptions {
            static const InvokeMode invokeMode = invokeModeValue;
        };

        template<InvokeMode invokeMode> struct InvokeTraits;

        template<typename TDelegateInterface, typename EventSourceOptions>
        class EventSource;

        namespace Details {
            template<typename TDelegateInterface>
            void* GetDelegateBucketAssist(TDelegateInterface *pDelegate) {
                return nullptr;
            }

            template<typename TMemberFunction> struct ArgTraits {
                static const int args = -1;
            };

            template<typename TDelegateInterface>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(void)> {
                static const int args = 0;
            };

            template<typename TDelegateInterface, typename TArg1>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1)> {
                static const int args = 1;
                typedef TArg1 Arg1Type;
            };

            template<typename TDelegateInterface, typename TArg1, typename TArg2>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1, TArg2)>
            {
                static const int args = 2;
                typedef TArg1 Arg1Type;
                typedef TArg2 Arg2Type;
            };

            template<typename TDelegateInterface, typename TArg1, typename TArg2, typename TArg3>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1, TArg2, TArg3)>
            {
                static const int args = 3;
                typedef TArg1 Arg1Type;
                typedef TArg2 Arg2Type;
                typedef TArg3 Arg3Type;
            };

            template<typename TDelegateInterface, typename TArg1, typename TArg2, typename TArg3, typename TArg4>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1, TArg2, TArg3, TArg4)>
            {
                static const int args = 4;
                typedef TArg1 Arg1Type;
                typedef TArg2 Arg2Type;
                typedef TArg3 Arg3Type;
                typedef TArg4 Arg4Type;
            };

            template<typename TDelegateInterface, typename TArg1, typename TArg2, typename TArg3, typename TArg4, typename TArg5>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1, TArg2, TArg3, TArg4, TArg5)>
            {
                static const int args = 5;
                typedef TArg1 Arg1Type;
                typedef TArg2 Arg2Type;
                typedef TArg3 Arg3Type;
                typedef TArg4 Arg4Type;
                typedef TArg5 Arg5Type;
            };

            template<typename TDelegateInterface, typename TArg1, typename TArg2, typename TArg3, typename TArg4, typename TArg5, typename TArg6>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1, TArg2, TArg3, TArg4, TArg5, TArg6)>
            {
                static const int args = 6;
                typedef TArg1 Arg1Type;
                typedef TArg2 Arg2Type;
                typedef TArg3 Arg3Type;
                typedef TArg4 Arg4Type;
                typedef TArg5 Arg5Type;
                typedef TArg6 Arg6Type;
            };

            template<typename TDelegateInterface, typename TArg1, typename TArg2, typename TArg3, typename TArg4, typename TArg5, typename TArg6, typename TArg7>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1, TArg2, TArg3, TArg4, TArg5, TArg6, TArg7)>
            {
                static const int args = 7;
                typedef TArg1 Arg1Type;
                typedef TArg2 Arg2Type;
                typedef TArg3 Arg3Type;
                typedef TArg4 Arg4Type;
                typedef TArg5 Arg5Type;
                typedef TArg6 Arg6Type;
                typedef TArg7 Arg7Type;
            };

            template<typename TDelegateInterface, typename TArg1, typename TArg2, typename TArg3, typename TArg4, typename TArg5, typename TArg6, typename TArg7, typename TArg8>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1, TArg2, TArg3, TArg4, TArg5, TArg6, TArg7, TArg8)>
            {
                static const int args = 8;
                typedef TArg1 Arg1Type;
                typedef TArg2 Arg2Type;
                typedef TArg3 Arg3Type;
                typedef TArg4 Arg4Type;
                typedef TArg5 Arg5Type;
                typedef TArg6 Arg6Type;
                typedef TArg7 Arg7Type;
                typedef TArg8 Arg8Type;
            };

            template<typename TDelegateInterface, typename TArg1, typename TArg2, typename TArg3, typename TArg4, typename TArg5, typename TArg6, typename TArg7, typename TArg8, typename TArg9>
            struct ArgTraits<HRESULT(STDMETHODCALLTYPE TDelegateInterface::*)(TArg1, TArg2, TArg3, TArg4, TArg5, TArg6, TArg7, TArg8, TArg9)>
            {
                static const int args = 9;
                typedef TArg1 Arg1Type;
                typedef TArg2 Arg2Type;
                typedef TArg3 Arg3Type;
                typedef TArg4 Arg4Type;
                typedef TArg5 Arg5Type;
                typedef TArg6 Arg6Type;
                typedef TArg7 Arg7Type;
                typedef TArg8 Arg8Type;
                typedef TArg9 Arg9Type;
            };

            template<typename TDelegateInterface, bool isImplements = __is_base_of(ImplementsBase, TDelegateInterface)>
            struct ArgTraitsHelper;

            template<typename TDelegateInterface>
            struct ArgTraitsHelper<TDelegateInterface, false>
            {
                typedef decltype(&TDelegateInterface::Invoke) methodType;
                typedef ArgTraits<methodType> Traits;
                static const int args = Traits::args;
                typedef TDelegateInterface Interface;
            };

            template<typename TDelegateInterface>
            struct ArgTraitsHelper<TDelegateInterface, true> {};

            template<typename TDelegateInterface> class DelegateArgTraits {};

            template<typename TDelegateInterface, typename ...TArgs>
            class DelegateArgTraits<HRESULT (STDMETHODCALLTYPE TDelegateInterface::*)(TArgs...)>
            {
                template<typename TCallback, DelegateCheckMode checkMode>
                struct DelegateInvokeHelper WrlSealed : public ::Microsoft::WRL::RuntimeClass<RuntimeClassFlags<Delegate>, TDelegateInterface>, RemoveReference<TCallback>::Type {
                    DelegateInvokeHelper(TCallback&& callback) noexcept {}

                    HRESULT STDMETHODCALLTYPE Invoke(TArgs... args) noexcept override {
                        return 0;
                    }
                };

            public:
                template<typename TImplements, DelegateCheckMode checkMode = DefaultDelegateCheckMode, typename TLambda>
                static ComPtr<TImplements> Callback(TLambda&& callback) noexcept {
                    ComPtr<TImplements> empty;
                    return empty;
                }
            };

            template<typename TDelegateInterface, bool isImplements = __is_base_of(ImplementsBase, TDelegateInterface)>
            struct DelegateArgTraitsHelper;

            template<typename TDelegateInterface>
            struct DelegateArgTraitsHelper<TDelegateInterface, false> {
                typedef TDelegateInterface Interface;
                typedef DelegateArgTraits<decltype(&TDelegateInterface::Invoke)> Traits;
            };

            template<typename TDelegateInterface>
            struct DelegateArgTraitsHelper<TDelegateInterface, true> {};

            template<typename TDelegateInterface>
            HRESULT CreateAgileHelper(TDelegateInterface* delegateInterface, TDelegateInterface** wrapper) {
                return 0;
            }
        }

        template<typename TDelegateInterface, typename TLambda>
        ComPtr<typename Details::DelegateArgTraitsHelper<TDelegateInterface>::Interface> Callback(TLambda&& callback) noexcept {
            return 0;
        }

        template<typename TDelegateInterface, typename TFunc>
        ComPtr<typename Details::DelegateArgTraitsHelper<TDelegateInterface>::Interface> Callback(TFunc* callback) noexcept {
            return 0;
        };

        template<typename TDelegateInterface, typename TCallbackObject, typename... TArgs>
        ComPtr<typename Details::DelegateArgTraitsHelper<TDelegateInterface>::Interface> Callback(TCallbackObject *object, HRESULT(TCallbackObject::* method)(TArgs...)) noexcept {
            return 0;
        }

        template<typename TDelegateInterface>
        HRESULT WeakReferenceCallback(IWeakReferenceSource* innerCallback, TDelegateInterface** callback) {
            return 0;
        }

        template<typename TDelegateInterface>
        HRESULT WeakReferenceCallback(TDelegateInterface* innerCallback, TDelegateInterface** callback) {
            return 0;
        }

        template<typename T, typename TDelegateInterface, typename ...TArgs>
        HRESULT WeakReferenceCallback(T* targetObject, HRESULT (T::*targetMethod)(TArgs... args), TDelegateInterface** callback) {
            return 0;
        }

        template<typename T, typename TDelegateInterface, typename ...TArgs>
        HRESULT WeakReferenceCallback(T* targetObject, HRESULT(T::*targetMethod)(TArgs... args), ::Microsoft::WRL::Details::ComPtrRef< ::Microsoft::WRL::ComPtr<TDelegateInterface>> callback) {
            return 0;
        }

        namespace Details {

            class EventTargetArray WrlSealed : public ::Microsoft::WRL::RuntimeClass< ::Microsoft::WRL::RuntimeClassFlags<ClassicCom>, IUnknown > {
            public:
                EventTargetArray() noexcept {}

                HRESULT RuntimeClassInitialize(size_t items) noexcept {
                    return 0;
                }

                ~EventTargetArray() noexcept
                {
                    delete[] begin_;
                    delete[] bucketAssists_;
                }

                ComPtr<IUnknown>* Begin() noexcept {
                    return nullptr;
                }

                ComPtr<IUnknown>* End() noexcept {
                    return nullptr;
                }

                void AddTail(IUnknown* element) noexcept {
                }

                void AddTail(IUnknown* element, void *bucketAssist) noexcept {
                }

                size_t Length() noexcept {
                    return 0;
                }

                void **Begin_BucketAssists() {
                    return nullptr;
                }

                void **End_BucketAssists() {
                    return nullptr;
                }

            private:
                ComPtr<IUnknown>* begin_;

                ComPtr<IUnknown>* end_;

                void **bucketAssists_;
            };
        }

        template<>
        struct InvokeTraits<FireAll>
        {
            template<typename TInvokeMethod, typename TDelegateInterface>
            static HRESULT InvokeDelegates(TInvokeMethod invokeOne, Details::EventTargetArray *targetArray, EventSource<TDelegateInterface, InvokeModeOptions<FireAll>>* pEvent) {
                return 0;
            }
        };

        template<>
        struct InvokeTraits<StopOnFirstError>
        {
            template<typename TInvokeMethod, typename TDelegateInterface>
            static HRESULT InvokeDelegates(TInvokeMethod invokeOne, Details::EventTargetArray *targetArray, EventSource<TDelegateInterface, InvokeModeOptions<StopOnFirstError>>* pEvent) {
                return 0;
            }
        };

        template<typename TDelegateInterface, typename TEventSourceOptions>
        class EventSource {
        public:
            EventSource() noexcept {}

            HRESULT Add(TDelegateInterface* delegateInterface, EventRegistrationToken* token) noexcept {
                return 0;
            }

            HRESULT Remove(EventRegistrationToken token) noexcept {
                return 0;
            }

        protected:

            HRESULT Add(TDelegateInterface* delegateInterface, void *bucketAssist, EventRegistrationToken* token) noexcept {
                return 0;
            }

        private:

            HRESULT AddInternal(TDelegateInterface* delegateInterface, void *bucketAssist, EventRegistrationToken* token) noexcept {
                return 0;
            }

            template <typename TInvokeMethod>
            HRESULT DoInvoke(TInvokeMethod invokeOne) noexcept {
                return 0;
            }

        public:
            template<typename ...TArgs>
            HRESULT InvokeAll(TArgs... args) noexcept {
                return 0;
            }

            size_t GetSize() const noexcept {
                return 0;
            }

        protected:
            ComPtr<Details::EventTargetArray> targets_;

            mutable Wrappers::SRWLock targetsPointerLock_;

            Wrappers::SRWLock addRemoveLock_;
        };
    }
}

#include <poppack.h>

#endif
