'\"
'\" Copyright (c) 1996-2003, Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "transform" n 2.1.4  "Trf transformer commands"
.BS
.SH NAME
transform \- Tcl level transformations
.SH SYNOPSIS
package require \fBTcl  ?8.2?\fR
.sp
package require \fBTrf  ?2.1.4?\fR
.sp
\fBtransform\fR ?\fIoptions...\fR? ?\fIdata\fR?
.sp
\fBcallback\fR \fIoperation\fR \fIdata\fR
.sp
.BE
.SH DESCRIPTION
The command \fBtransform\fR reflects the API for a stack channel
transformation into the tcl level, thus enabling the writing of
transformations in tcl.
.PP
.TP
\fBtransform\fR ?\fIoptions...\fR? ?\fIdata\fR?
.RS
.TP
\fB-mode\fR \fBread\fR|\fBwrite\fR
This option is accepted by the command if and only if it is used in
\fIimmediate\fR mode.  See section
\fBIMMEDIATE versus ATTACHED\fR for an explanation of the term.
.sp
The argument value specifies whether to run the read or the write part
of the transformation specified via option \fB-command\fR on the
immediate data.
.sp
Beyond the argument values listed above all unique abbreviations are
recognized too.
.TP
\fB-command\fR \fIcmd\fR
This option has to be present and is always understood. Its argument
is a command prefix. This command prefix will be called by internally
whenever some operation of the transformation has to be executed. An
empty \fIcmd\fR is not allowed.
.sp
The exact nature of the various possible calls and their expected
results is described later, in section \fBCALLBACK API\fR.
.TP
\fB-attach\fR \fIchannel\fR
The presence/absence of this option determines the main operation mode
of the transformation.
.sp
If present the transformation will be stacked onto the \fIchannel\fR
whose handle was given to the option and run in \fIattached\fR
mode. More about this in section \fBIMMEDIATE versus ATTACHED\fR.
.sp
If the option is absent the transformation is used in \fIimmediate\fR
mode and the options listed below are recognized. More about this in
section \fBIMMEDIATE versus ATTACHED\fR.
.TP
\fB-in\fR \fIchannel\fR
This options is legal if and only if the transformation is used in
\fIimmediate\fR mode. It provides the handle of the channel the data
to transform has to be read from.
.sp
If the transformation is in \fIimmediate\fR mode and this option is
absent the data to transform is expected as the last argument to the
transformation.
.TP
\fB-out\fR \fIchannel\fR
This options is legal if and only if the transformation is used in
\fIimmediate\fR mode. It provides the handle of the channel the
generated transformation result is written to.
.sp
If the transformation is in \fIimmediate\fR mode and this option is
absent the generated data is returned as the result of the command
itself.
.RE
.PP
.SH "IMMEDIATE VERSUS ATTACHED"
The transformation distinguishes between two main ways of using
it. These are the \fIimmediate\fR and \fIattached\fR operation
modes.
.PP
For the \fIattached\fR mode the option \fB-attach\fR is used to
associate the transformation with an existing channel. During the
execution of the command no transformation is performed, instead the
channel is changed in such a way, that from then on all data written
to or read from it passes through the transformation and is modified
by it according to the definition above.
This attachment can be revoked by executing the command \fBunstack\fR
for the chosen channel. This is the only way to do this at the Tcl
level.
.PP
In the second mode, which can be detected by the absence of option
\fB-attach\fR, the transformation immediately takes data from
either its commandline or a channel, transforms it, and returns the
result either as result of the command, or writes it into a channel.
The mode is named after the immediate nature of its execution.
.PP
Where the data is taken from, and delivered to, is governed by the
presence and absence of the options \fB-in\fR and \fB-out\fR.
It should be noted that this ability to immediately read from and/or
write to a channel is an historic artifact which was introduced at the
beginning of Trf's life when Tcl version 7.6 was current as this and
earlier versions have trouble to deal with \\0 characters embedded into
either input or output.
.SH "CALLBACK API"
Here we describe the API of the callback command implementing the
actual transformation.
.PP
.TP
\fBcallback\fR \fIoperation\fR \fIdata\fR
The callback is always called with two arguments, first an operation
code followed by data. The latter will be empty for some operations.
.sp
The known operations are listed below, together with an explanation of
the arguments, what is expected of them, and how their results are
handled.
.RS
.TP
\fBcreate/write\fR
When called \fIdata\fR is empty. The result of the call is ignored.
.sp
This is the first operation executed for the write side of the
transformation. It has to initialize the internals of this part of the
transformation and ready it for future calls.
.TP
\fBdelete/write\fR
When called \fIdata\fR is empty. The result of the call is ignored.
.sp
This is the last operation executed for the write side of the
transformation. It has to shutdown the internals of this part of the
transformation and release any resources which were acquired over the
lifetime of the transformation.
.TP
\fBwrite\fR
The operation is called whenever data is written to the channel.
.sp
At the time of the call the argument \fIdata\fR will contain the bytes
to transform. The result of the call is taken as the result of the
transformation and handed to the next stage down in the stack of
transformation associated with the channel.
.sp
This operation has to transform the contents of \fIdata\fR, using
whatever data was left over from the last call of the operation. The
transformation is allowed to buffer incomplete data.
.TP
\fBflush/write\fR
When called \fIdata\fR is empty. The operation has to transform any
incomplete data it has buffered internally on the write side. The
result of the call is taken as the result of the transformation and
handed to the next stage down in the stack of transformation
associated with the channel.
.TP
\fBclear/write\fR
When called \fIdata\fR is empty. The result of the call is ignored.
.sp
The write side of the transformation has to clear its internal
buffers. This operation is called when the user seeks on the channel,
thus invalidating any incomplete transformation.
.TP
\fBcreate/read\fR
When called \fIdata\fR is empty. The result of the call is ignored.
.sp
This is the first operation executed for the read side of the
transformation. It has to initialize the internals of this part of the
transformation and ready it for future calls.
.TP
\fBdelete/read\fR
When called \fIdata\fR is empty. The result of the call is ignored.
.sp
This is the last operation executed for the write side of the
transformation. It has to shutdown the internals of this part of the
transformation and release any resources which were acquired over the
lifetime of the transformation.
.TP
\fBread\fR
The operation is called whenever data is read from the channel.
.sp
At the time of the call the argument \fIdata\fR will contain the bytes
to transform. The result of the call is taken as the result of the
transformation and posted to the next stage up in the stack of
transformation associated with the channel.
.sp
This operation has to transform the contents of \fIdata\fR, using
whatever data was left over from the last call of the operation. The
transformation is allowed to buffer incomplete data.
.TP
\fBflush/read\fR
When called \fIdata\fR is empty. The operation has to transform any
incomplete data it has buffered internally on the read side. The
result of the call is taken as the result of the transformation and
posted to the next stage up in the stack of transformation associated
with the channel.
.TP
\fBclear/read\fR
When called \fIdata\fR is empty. The result of the call is ignored.
.sp
The read side of the transformation has to clear its internal
buffers. This operation is called when the user seeks on the channel,
thus invalidating any incomplete transformation.
.TP
\fBquery/maxRead\fR
When called \fIdata\fR is empty. The result of the call is interpreted
as integer number. This operation is used by the generic layer to
determine if the transformation establishes a limit on the number of
bytes it (the generic layer) is allowed read from the transformations
lower in the stack. A negative result unsets any limit.
.sp
This has to be used if a transformation employs some kind of
end-of-data marker. We cannot allow the generic layer to overshoot
this marker because any data read after it cannot be stuffed back into
the core buffers, causing the I/O system to loose data if the
transformation is unstacked after it recognized the end of its
data. This is a limitation of the I/O system in the tcl core.
.sp
Returning a positive value will cause the I/O system to slow down, but
also ensures that no data is lost.
.sp
Two examples for such transformations are the data decompressors for
\fBzip\fR and \fBbz2\fR. They use the C-level equivalent of this
operation to prevent the overshooting.
.RE
.PP
.SH "SEE ALSO"
trf-intro
.SH KEYWORDS
general transform
.SH COPYRIGHT
.nf
Copyright (c) 1996-2003, Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi