'\"
'\" Copyright (c) 2005-2006, Aaron Faupell <afaupell@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "tiff" n 0.2.1 tiff "TIFF image manipulation"
.BS
.SH NAME
tiff \- TIFF reading, writing, and querying and manipulation of meta data
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBtiff  ?0.2.1?\fR
.sp
\fB::tiff::isTIFF\fR \fIfile\fR
.sp
\fB::tiff::byteOrder\fR \fIfile\fR
.sp
\fB::tiff::numImages\fR \fIfile\fR
.sp
\fB::tiff::dimensions\fR \fIfile\fR ?image?
.sp
\fB::tiff::imageInfo\fR \fIfile\fR ?image?
.sp
\fB::tiff::entries\fR \fIfile\fR ?image?
.sp
\fB::tiff::getEntry\fR \fIfile\fR \fIentry\fR ?image?
.sp
\fB::tiff::addEntry\fR \fIfile\fR \fIentry\fR ?image?
.sp
\fB::tiff::deleteEntry\fR \fIfile\fR \fIentry\fR ?image?
.sp
\fB::tiff::getImage\fR \fIfile\fR ?image?
.sp
\fB::tiff::writeImage\fR \fIimage\fR \fIfile\fR ?entry?
.sp
\fB::tiff::nametotag\fR \fInames\fR
.sp
\fB::tiff::tagtoname\fR \fItags\fR
.sp
\fB::tiff::debug\fR \fIfile\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides commands to query, modify, read, and write TIFF images.
TIFF stands for \fITagged Image File Format\fR and is a standard
for lossless storage of photographical images and associated metadata.
It is specified at \fIhttp://partners.adobe.com/public/developer/tiff/index.html\fR.
.PP
Multiple images may be stored in a single TIFF file. The ?image? options to the functions
in this package are for accessing images other than the first. Data in a TIFF image is
stored as a series of tags having a numerical value, which are represented in either a 4 digit
hexadecimal format or a string name. For a reference on defined tags and their meanings see
\fIhttp://www.awaresystems.be/imaging/tiff/tifftags.html\fR
.SH COMMANDS
.TP
\fB::tiff::isTIFF\fR \fIfile\fR
Returns a boolean value indicating if \fIfile\fR is a
TIFF image.
.TP
\fB::tiff::byteOrder\fR \fIfile\fR
Returns either \fBbig\fR or \fBlittle\fR.
Throws an error if \fIfile\fR is not a TIFF image.
.TP
\fB::tiff::numImages\fR \fIfile\fR
Returns the number of images in \fIfile\fR.
Throws an error if \fIfile\fR is not a TIFF image.
.TP
\fB::tiff::dimensions\fR \fIfile\fR ?image?
Returns the dimensions of image number ?image? in \fIfile\fR as a list of the
horizontal and vertical pixel count.
Throws an error if \fIfile\fR is not a TIFF image.
.TP
\fB::tiff::imageInfo\fR \fIfile\fR ?image?
Returns a dictionary with keys \fBImageWidth\fR, \fBImageLength\fR,
\fBBitsPerSample\fR, \fBCompression\fR, \fBPhotometricInterpretation\fR,
\fBImageDescription\fR, \fBOrientation\fR, \fBXResolution\fR,
\fBYResolution\fR, \fBResolutionUnit\fR, \fBDateTime\fR, \fBArtist\fR,
and \fBHostComputer\fR. The values are the associated properties of
the TIFF ?image? in \fIfile\fR. Values may be empty if the associated tag is not
present in the file.
.nf

    puts [::tiff::imageInfo photo.tif]

    ImageWidth 686 ImageLength 1024 BitsPerSample {8 8 8} Compression 1
    PhotometricInterpretation 2 ImageDescription {} Orientation 1
    XResolution 170.667 YResolution 170.667 ResolutionUnit 2 DateTime {2005:12:28 19:44:45}
    Artist {} HostComputer {}

.fi
There is nothing special about these tags, this is simply a convience procedure which calls
\fBgetEntry\fR with common entries.
Throws an error if \fIfile\fR is not a TIFF image.
.TP
\fB::tiff::entries\fR \fIfile\fR ?image?
Returns a list of all entries in the given \fIfile\fR and ?image?
in hexadecimal format.
Throws an error if \fIfile\fR is not a TIFF image.
.TP
\fB::tiff::getEntry\fR \fIfile\fR \fIentry\fR ?image?
Returns the value of \fIentry\fR from image ?image? in the TIFF \fIfile\fR.
\fIentry\fR may be a list of multiple entries. If an entry does not exist, an
empty string is returned
.nf

    set data [::tiff::getEntry photo.tif {0131 0132}]
    puts "file was written at [lindex $data 0] with software [lindex $data 1]"

.fi
Throws an error if \fIfile\fR is not a TIFF image.
.TP
\fB::tiff::addEntry\fR \fIfile\fR \fIentry\fR ?image?
Adds the specified entries to the image named by ?image? (default 0), or optionally \fBall\fR.
\fIentry\fR must be a list where each element is a list of tag, type, and value. If a tag already
exists, it is overwritten.
.nf

    ::tiff::addEntry photo.tif {{010e 2 "an example photo"} {013b 2 "Aaron F"}}

.fi
The data types are defined as follows
.RS
.TP
\fB1\fR
BYTE (8 bit unsigned integer)
.TP
\fB2\fR
ASCII
.TP
\fB3\fR
SHORT (16 bit unsigned integer)
.TP
\fB4\fR
LONG (32 bit unsigned integer)
.TP
\fB5\fR
RATIONAL
.TP
\fB6\fR
SBYTE (8 bit signed byte)
.TP
\fB7\fR
UNDEFINED (uninterpreted binary data)
.TP
\fB8\fR
SSHORT (signed 16 bit integer)
.TP
\fB9\fR
SLONG (signed 32 bit integer)
.TP
\fB10\fR
SRATIONAL
.TP
\fB11\fR
FLOAT (32 bit floating point number)
.TP
\fB12\fR
DOUBLE (64 bit floating point number)
.RE
Throws an error if \fIfile\fR is not a TIFF image.
.TP
\fB::tiff::deleteEntry\fR \fIfile\fR \fIentry\fR ?image?
Deletes the specified entries from the image named by ?image? (default 0), or optionally \fBall\fR.
Throws an error if \fIfile\fR is not a TIFF image.
.TP
\fB::tiff::getImage\fR \fIfile\fR ?image?
Returns the name of a Tk image containing the image at index ?image? from \fIfile\fR
Throws an error if \fIfile\fR is not a TIFF image, or if image is an unsupported format.
Supported formats are uncompressed 24 bit RGB and uncompressed 8 bit palette.
.TP
\fB::tiff::writeImage\fR \fIimage\fR \fIfile\fR ?entry?
Writes the contents of the Tk image \fIimage\fR to a tiff file \fIfile\fR. Files are
written in the 24 bit uncompressed format, with big endian byte order. Additional entries
to be added to the image may be specified, in the same format as \fBtiff::addEntry\fR
.TP
\fB::tiff::nametotag\fR \fInames\fR
Returns a list with \fInames\fR translated from string to 4 digit format. 4 digit names
in the input are passed through unchanged. Strings without a defined tag name will throw
an error.
.TP
\fB::tiff::tagtoname\fR \fItags\fR
Returns a list with \fItags\fR translated from 4 digit to string format. If a tag does
not have a defined name it is passed through unchanged.
.TP
\fB::tiff::debug\fR \fIfile\fR
Prints everything we know about the given file in a nice format.
.PP
.SH VARIABLES
The mapping of 4 digit tag names to string names uses the array ::tiff::tiff_tags. The reverse
mapping uses the array ::tiff::tiff_sgat.
.SH LIMITATIONS
.IP [1]
Cannot write exif ifd
.IP [2]
Reading limited to uncompressed 8 bit rgb and 8 bit palletized images
.IP [3]
Writing limited to uncompressed 8 bit rgb
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fItiff\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
image, tif, tiff
.SH CATEGORY
File formats
.SH COPYRIGHT
.nf
Copyright (c) 2005-2006, Aaron Faupell <afaupell@users.sourceforge.net>

.fi