'\"
'\" Copyright (c) 2004-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "tie" n 1.1 tie "Tcl Data Structures"
.BS
.SH NAME
tie \- Array persistence
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBtie  ?1.1?\fR
.sp
\fB::tie::tie\fR \fIarrayvarname\fR \fIoptions\fR... \fIdstype\fR \fIdsname\fR...
.sp
\fB::tie::untie\fR \fIarrayvarname\fR ?\fItoken\fR?
.sp
\fB::tie::info\fR \fBties\fR \fIarrayvarname\fR
.sp
\fB::tie::info\fR \fBtypes\fR
.sp
\fB::tie::info\fR \fBtype\fR \fIdstype\fR
.sp
\fB::tie::register\fR \fIdsclasscmd\fR \fBas\fR \fIdstype\fR
.sp
\fBdsclasscmd\fR \fIobjname\fR ?\fIdsname\fR...?
.sp
\fBds\fR \fBdestroy\fR
.sp
\fBds\fR \fBnames\fR
.sp
\fBds\fR \fBsize\fR
.sp
\fBds\fR \fBget\fR
.sp
\fBds\fR \fBset\fR \fIdict\fR
.sp
\fBds\fR \fBunset\fR ?\fIpattern\fR?
.sp
\fBds\fR \fBsetv\fR \fIindex\fR \fIvalue\fR
.sp
\fBds\fR \fBunsetv\fR \fIindex\fR
.sp
\fBds\fR \fBgetv\fR \fIindex\fR
.sp
.BE
.SH DESCRIPTION
The \fBtie\fR package provides a framework for the creation of
persistent Tcl array variables. It should be noted that the provided
mechanism is generic enough to also allow its usage for the
distribution of the contents of Tcl arrays over multiple threads and
processes, i.e. communication.
.PP
This, persistence and communication, is accomplished by \fItying\fR)
a Tcl array variable to a \fIdata source\fR. Examples of data
sources are other Tcl arrays and files.
.PP
It should be noted that a single Tcl array variable can be tied to
more than one \fIdata source\fR. It is this feature which allows
the framework to be used for communication as well. Just tie several
Tcl arrays in many client processes to a Tcl array in a server and all
changes to any of them will be distributed to all. Less centralized
variants of this are of course possible as well.
.SH "USING TIES"
.SS "TIE API"
This section describes the basic API used to establish and remove ties
between Tcl array variables and data sources. This interface is the
only one a casual user has to be concerned about. The following
sections about the various internal interfaces can be safely skipped.
.TP
\fB::tie::tie\fR \fIarrayvarname\fR \fIoptions\fR... \fIdstype\fR \fIdsname\fR...
This command establishes a tie between the Tcl array whose name is
provided by the argument \fIarrayvarname\fR and the
\fIdata source\fR identified by the \fIdstype\fR and its series of
\fIdsname\fR arguments. All changes made to the Tcl array after this
command returns will be saved to the \fIdata source\fR for
safekeeping (or distribution).
.sp
The result of the command is always a token which identifies the new
tie. This token can be used later to destroy this specific tie.
.RS
.TP
varname \fIarrayvarname\fR (in)
The name of the Tcl array variable to connect the new tie to.
.TP
name|command \fIdstype\fR (in)
This argument specifies the type of the \fIdata source\fR we wish
to access.
The \fIdstype\fR can be one of \fBlog\fR, \fBarray\fR,
\fBremotearray\fR, \fBfile\fR, \fBgrowfile\fR, or
\fBdsource\fR; in addition, the programmer can register additional
data source types.
Each \fIdstype\fR is followed by one or more arguments that identify
the \fIdata source\fR to which the array is to be tied.
.TP
string \fIdsname\fR (in)
The series of \fIdsname\fR arguments coming after the \fIdstype\fR
identifies the \fIdata source\fR we wish to connect to, and has to
be appropriate for the chosen type.
.RE
.sp
The command understands a number of additional options which guide the
process of setting up the connection between Tcl array and
\fIdata source\fR.
.sp
.RS
.TP
\fB-open\fR
The Tcl array for the new tie is \fIloaded\fR from the
\fIdata source\fR, and the previously existing contents of the Tcl
array are erased. Care is taken to \fInot\fR erase the previous
contents should the creation of the tie fail.
.sp
This option and the option \fB-save\fR exclude each other. If
neither this nor option \fB-save\fR are specified then this option
is assumed as default.
.TP
\fB-save\fR
The Tcl array for the new tie is \fIsaved\fR to the
\fIdata source\fR, and the previously existing contents of the
\fIdata source\fR are erased.
.sp
This option and the option \fB-open\fR exclude each other. If
neither this nor option \fB-open\fR are specified then option
\fB-open\fR is assumed as default.
.TP
\fB-merge\fR
Using this option prevents the erasure of any previously existing
content and merges the data instead. It can be specified in
conjunction with either \fB-open\fR or \fB-save\fR. They
determine how data existing in both Tcl array and
\fIdata source\fR, i.e duplicates, are dealt with.
.sp
When used with \fB-open\fR data in the \fIdata source\fR has
precedence.
In other words, for duplicates the data in the \fIdata source\fR is
loaded into the Tcl array.
.sp
When used with \fB-save\fR data in the Tcl array has precedence. In
other words, for duplicates the data in the Tcl array is saved into
the \fIdata source\fR.
.RE
.sp
.TP
\fB::tie::untie\fR \fIarrayvarname\fR ?\fItoken\fR?
This command dissolves one or more ties associated with the Tcl array
named by \fIarrayvarname\fR. If no \fItoken\fR is specified then all
ties to that Tcl array are dissolved. Otherwise only the tie the token
stands for is removed, if it is actually connected to the
array. Trying to remove a specific tie not belonging to the provided
array will cause an error.
.sp
It should be noted that while severing a tie will destroy management
information internal to the package the \fIdata source\fR which was
handled by the tie will not be touched, only closed.
.sp
After the command returns none of changes made to the array will be
saved to the \fIdata source\fR anymore.
.sp
The result of the command is an empty string.
.RS
.TP
varname \fIarrayname\fR (in)
The name of a Tcl array variable which may have ties.
.TP
handle \fItoken\fR (in)
A handle representing a specific tie. This argument is optional.
.RE
.sp
.TP
\fB::tie::info\fR \fBties\fR \fIarrayvarname\fR
This command returns a list of ties associated with the Tcl array
variable named by \fIarrayvarname\fR. The result list will be empty if
the variable has no ties associated with it.
.TP
\fB::tie::info\fR \fBtypes\fR
This command returns a dictionary of registered types, and the class
commands they are associated with.
.TP
\fB::tie::info\fR \fBtype\fR \fIdstype\fR
This command returns the fully resolved class command for a type
name. This means that the command will follow a chain of type
definitions ot its end.
.PP
.SS "STANDARD DATA SOURCE TYPES"
This package provides the six following types as examples and standard
data sources.
.TP
\fBlog\fR
This \fIdata source\fR does not maintain any actual data, nor
persistence. It does not accept any identifying arguments. All changes
are simply logged to \fBstdout\fR.
.TP
\fBarray\fR
This \fIdata source\fR uses a regular Tcl array as the origin of
the persistent data. It accepts a single identifying argument, the
name of this Tcl array. All changes are mirrored to that array.
.TP
\fBremotearray\fR
This \fIdata source\fR is similar to \fBarray\fR. The difference
is that the Tcl array to which we are mirroring is not directly
accessible, but through a \fBsend\fR-like command.
.sp
It accepts three identifying arguments, the name of the other Tcl
array, the command prefix for the \fBsend\fR-like accessor command,
and an identifier for the remote entity hosting the array, in this
order. All changes are mirrored to that array, via the command
prefix. All commands will be executed in the context of the global
namespace.
.sp
\fBsend\fR-like means that the command prefix has to have \fBsend\fR
syntax and semantics. I.e. it is a channel over which we can send
arbitrary commands to some other entity.
The remote array \fIdata source\fR however uses only the commands
\fBset\fR, \fBunset\fR, \fBarray exists\fR, \fBarray names\fR, \fBarray set\fR, and
\fBarray get\fR to retrieve and set values in the remote array.
.sp
The command prefix and the entity id are separate to allow the data
source to use options like \fB-async\fR when assembling the actual
commands.
.sp
Examples of command prefixes, listed with the id of the remote entity,
without options. In reality only the part before the id is the command
prefix:
.RS
.TP
\fBsend\fR \fItkname\fR
The Tcl array is in a remote interpreter and is accessed via Tk's X
communication.
.TP
\fBcomm::comm send\fR \fIhostportid\fR
The Tcl array is in a remote interpreter and is accessed through a
socket.
.TP
\fBthread::send\fR \fIthreadid\fR
The Tcl array is in a remote interpreter in a different thread of this
process.
.RE
.sp
.TP
\fBfile\fR
This \fIdata source\fR uses a single file as origin of the
persistent data. It accepts a single identifying argument, the path to
this file. The file has to be both readable and writable. It may not
exist, the \fIdata source\fR will create it in that case. This (and
only this) situation will require that the directory for the file
exists and is writable as well.
.sp
All changes are saved in the file, as proper Tcl commands, one command
per operation. In other words, the file will always contain a proper
Tcl script.
.sp
If the file exists when the tie using it is set up, then it will be
compacted, i.e. superfluous operations are removed, if the operations
log stored in it contains either at least one operation clearing the
whole array, or at least 1.5 times more operations than entries in the
loaded array.
.TP
\fBgrowfile\fR
This \fIdata source\fR is like \fBfile\fR in terms of the storage
medium for the array data, and how it is configured. In constrast to
the former it however assumes and ensures that the tied array will
never shrink. I.e. the creation of new array entries, and the
modification of existing entries is allowed, but the deletion of
entries is not, and causes the data source to throw errors.
.sp
This restriction allows us to simplify both file format and access to
the file radically. For one, the file is read only once and the
internal cache cannot be invalidated. Second, writing data is reduced
to a simple append, and no compaction step is necessary. The format of
the contents is the string representation of a dictionary which can be
incrementally extended forever at the end.
.TP
\fBdsource\fR
This \fIdata source\fR uses an explicitly specified
\fIdata source object\fR as the source for the persistent
data. It accepts a single identifying argument, the command prefix,
i.e. object command.
.sp
To use this type it is necessary to know how the framework manages
ties and what \fBdata source objects\fR are.
.sp
All changes are delegated to the specified object.
.PP
.SH "CREATING NEW DATA SOURCES"
This section is of no interest to the casual user of ties. Only
developers wishing to create new data sources have to know the
information provided herein.
.SS "DATA SOURCE OBJECTS"
All ties are represented internally by an in-memory object which
mediates between the tie framework and the specific
\fIdata source\fR, like an array, file, etc.
This is the \fIdata source object\fR.
.PP
Its class, the \fBdata source class\fR is \fInot\fR generic,
but specific to the type of the \fIdata source\fR. Writing a new
\fIdata source\fR requires us to write such a class, and then
registering it with the framework as a new type.
.PP
The following subsections describe the various APIs a
\fBdata source class\fR and the objects it generates will have
to follow to be compatible with the tie framework.
.PP
Data source objects are normally automatically created and destroyed
by the framework when a tie is created, or removed. This management
can be explicitly bypassed through the usage of the "dsource" type.
The \fIdata source\fR for this type is a
\fIdata source object\fR itself, and this object is outside of the
scope of the tie framework and not managed by it.
In other words, this type allows the creation of ties which talk to
pre-existing \fIdata source object\fRs, and these objects will
survive the removal of the ties using them as well.
.SS "REGISTERING A NEW DATA SOURCE CLASS"
After a \fBdata source class\fR has been written it is necessary
to register it as a new type with the framework.
.TP
\fB::tie::register\fR \fIdsclasscmd\fR \fBas\fR \fIdstype\fR
Using this command causes the tie framework to remember the class
command \fIdsclasscmd\fR of a \fBdata source class\fR under the
type name \fIdstype\fR.
.sp
After the call the argument \fIdstype\fR of the basic user command
\fB::tie::tie\fR will accept \fIdstype\fR as a type name and translate
it internally to the appropriate class command for the creation of
\fBdata source objects\fR for the new \fIdata source\fR.
.PP
.SS "DATA SOURCE CLASS"
Each data source class is represented by a single command, also called
the \fIclass command\fR, or \fIobject creation command\fR. Its
syntax is
.TP
\fBdsclasscmd\fR \fIobjname\fR ?\fIdsname\fR...?
The first argument of the class command is the name of the
\fIdata source object\fR to create.
The framework itself will always supply the string \fB%AUTO%\fR, to
signal that the class command has to generate not only the object, but
the object name as well.
.sp
This is followed by a series of arguments identifying the data source
the new object is for. These are the same \fIdsname\fR arguments which
are given to the basic user command \fB::tie::tie\fR. Their actual
meaning is dependent on the \fIdata source class\fR.
.sp
The result of the class command has to be the fully-qualified name of
the new \fIdata source object\fR, i.e. the name of the
\fIobject command\fR.
The interface this command has to follow is described in the section
\fBDATA SOURCE OBJECT API\fR
.PP
.PP
.SS "DATA SOURCE OBJECT API"
Please read the section \fBDATA SOURCE CLASS\fR first, to know
how to generate new \fIobject commands\fR.
.PP
Each \fIobject command\fR for a \fIdata source\fR object has to
provide at least the methods listed below for proper inter-operation
with the tie framework. Note that the names of most of the methods
match the subcommands of the builtin \fBarray\fR command.
.PP
.TP
\fBds\fR \fBdestroy\fR
This method is called when the object \fBds\fR is destroyed. It now
has to release all its internal resources associated with the external
data source.
.TP
\fBds\fR \fBnames\fR
This command has to return a list containing the names of all keys
found in the \fIdata source\fR the object talks to. This is
equivalent to \fBarray names\fR.
.TP
\fBds\fR \fBsize\fR
This command has to return an integer number specifying the number of
keys found in the \fIdata source\fR the object talks to. This is
equivalent to \fBarray size\fR.
.TP
\fBds\fR \fBget\fR
This command has to return a dictionary containing the data found in
the \fIdata source\fR the object talks to. This is equivalent to
\fBarray get\fR.
.TP
\fBds\fR \fBset\fR \fIdict\fR
This command takes a dictionary and adds its contents to the data
source the object talks to. This is equivalent to \fBarray set\fR.
.TP
\fBds\fR \fBunset\fR ?\fIpattern\fR?
This command takes a pattern and removes all elements whose keys
matching it from the \fIdata source\fR. If no pattern is specified
it defaults to \fB*\fR, causing the removal of all elements. This
is nearly equivalent to \fBarray unset\fR.
.TP
\fBds\fR \fBsetv\fR \fIindex\fR \fIvalue\fR
This command has to save the \fIvalue\fR in the \fIdata source\fR
the object talks to, under the key \fIindex\fR.
.sp
The result of the command is ignored. If an error is thrown then this
error will show up as error of the set operation which caused the
method call.
.TP
\fBds\fR \fBunsetv\fR \fIindex\fR
This command has to remove the value under the key \fIindex\fR from
the \fIdata source\fR the object talks to.
.sp
The result of the command is ignored. If an error is thrown then this
error will show up as error of the unset operation which caused the
method call.
.TP
\fBds\fR \fBgetv\fR \fIindex\fR
This command has to return the value for the key \fIindex\fR in the
\fIdata source\fR the object talks to.
.PP
And here a small table comparing the \fIdata source\fR methods to
the regular Tcl commands for accessing an array.
.PP
.nf

        Regular Tcl             Data source
        -----------             -----------
        array names a           ds names
        array size  a           ds size
        array get   a           ds get
        array set   a dict      ds set   dict
        array unset a pattern   ds unset ?pattern?
        -----------             -----------
        set a($idx) $val        ds setv   idx val
        unset a($idx)           ds unsetv idx
        $a($idx)                ds getv   idx
        -----------             -----------

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fItie\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
array, database, file, metakit, persistence, tie, untie
.SH CATEGORY
Programming tools
.SH COPYRIGHT
.nf
Copyright (c) 2004-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi