'\"
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pt::param" n 1 pt "Parser Tools"
.BS
.SH NAME
pt::param \- PackRat Machine Specification
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR. This document is the
entrypoint to the whole system the current package is a part of.
.PP
Welcome to the PackRat Machine (short: \fIPARAM\fR), a virtual
machine geared towards the support of recursive descent parsers,
especially packrat parsers. Towards this end it has features like the
caching and reuse of partial results, the caching of the encountered
input, and the ability to backtrack in both input and AST creation.
.PP
This document specifies the machine in terms of its architectural
state and instruction set.
.SH "ARCHITECTURAL STATE"
Any PARAM implementation has to manage at least the following state:
.TP
\fIInput\fR (IN)
This is the channel the characters to process are read from.
.sp
This part of the machine's state is used and modified by the
instructions defined in the section \fBInput Handling\fR.
.TP
\fICurrent Character\fR (CC)
The character from the \fIinput\fR currently tested against its
possible alternatives.
.sp
This part of the machine's state is used and modified by the
instructions defined in the section \fBCharacter Processing\fR.
.TP
\fICurrent Location\fR (CL)
The location of the \fIcurrent character\fR in the \fIinput\fR, as
offset relative to the beginning of the input. Character offsets are
counted from \fB0\fR.
.sp
This part of the machine's state is used and modified by the
instructions defined in the sections \fBCharacter Processing\fR,
\fBLocation Handling\fR, and \fBNonterminal Execution\fR.
.TP
\fILocation Stack\fR (LS)
A stack of locations in the \fIinput\fR, saved for possible
backtracking.
.sp
This part of the machine's state is used and modified by the
instructions defined in the sections \fBCharacter Processing\fR,
\fBLocation Handling\fR, and \fBNonterminal Execution\fR.
.TP
\fIStatus\fR (ST)
The status of the last attempt of testing the \fIinput\fR, indicating
either success or failure.
.sp
This part of the machine's state is used and modified by the
instructions defined in the sections \fBStatus Control\fR,
\fBCharacter Processing\fR, and \fBNonterminal Execution\fR.
.TP
\fISemantic Value\fR (SV)
The current semantic value, either empty, or a node for AST
constructed from the input.
.sp
This part of the machine's state is used and modified by the
instructions defined in the sections \fBValue Construction\fR, and
\fBAST Construction\fR.
.TP
\fIAST Reduction Stack\fR (ARS)
The stack of partial ASTs constructed during the processing of
nonterminal symbols.
.sp
This part of the machine's state is used and modified by the
instructions defined in the sections \fBValue Construction\fR, and
\fBAST Construction\fR.
.TP
\fIAST Stack\fR (AS)
The stack of reduction stacks, saved for possible backtracking.
.sp
This part of the machine's state is used and modified by the
instructions defined in the sections \fBValue Construction\fR, and
\fBAST Construction\fR.
.TP
\fIError Status\fR (ER)
The machine's current knowledge of errors. This is either empty, or
set to a pair of location in the input and the set of messages for
that location.
.sp
\fINote\fR that this part of the machine's state can be set even if
the last test of the \fIcurrent character\fR was successful. For
example, the *-operator (matching a sub-expression zero or more times)
in a PEG is always successful, even if it encounters a problem further
in the input and has to backtrack. Such problems must not be forgotten
when continuing the parsing.
.sp
This part of the machine's state is used and modified by the
instructions defined in the sections \fBError Handling\fR,
\fBCharacter Processing\fR, and \fBNonterminal Execution\fR.
.TP
\fIError Stack\fR (ES)
The stack of error stati, saved for backtracking. This enables the
machine to merge current and older error stati when performing
backtracking in choices after an failed match.
.sp
This part of the machine's state is used and modified by the
instructions defined in the sections \fBError Handling\fR,
\fBCharacter Processing\fR, and \fBNonterminal Execution\fR.
.TP
\fINonterminal Cache\fR (NC)
A cache of machine states keyed by pairs name of nonterminal symbol
and location in the input. Each pair (N, L) is associated with a
4-tuple holding the values to use for CL, ST, SV, and ER after the
nonterminal N was parsed starting from the location L.
It is a performance aid for backtracking parsers, allowing them to
avoid an expensive reparsing of complex nonterminal symbols if they
have been encountered before at a given location.
.sp
The key location is where machine started the attempt to match the
named nonterminal symbol, and the location in the saved 4-tuple is
where machine ended up after the attempt completed, independent of the
success of the attempt.
.sp
This part of the machine's state is used and modified by the
instructions defined in the section \fBNonterminal Execution\fR.
.TP
\fITerminal Cache\fR (TC)
A cache of characters read from IN, with their location in IN as pair
of line and column, keyed by the location in IN, this time as
character offset from the beginning of IN.
It is a performance aid for backtracking parsers, allowing them to
avoid a possibly expensive rereading of characters from IN, or even
enabling backtracking at, i.e. in the case of IN not randomly
seekable.
.sp
This part of the machine's state is used and modified by the
instructions defined in the section \fBInput Handling\fR.
.PP
.SH "INSTRUCTION SET"
With the machine's architectural state specified it is now possible to
specify the instruction set operating on that state and to be
implemented by any realization of the PARAM. The 37 instructions are
grouped roughly by the state they influence and/or query during their
execution.
.SS "INPUT HANDLING"
The instructions in this section mainly access IN, pulling the
characters to process into the machine.
.TP
\fBinput_next\fR \fImsg\fR
This method reads the next character, i.e. the character after CL,
from IN. If successful this character becomes CC, CL is advanced by
one, ES is cleared, and the operation is recorded as a success in ST.
.sp
The operation may read the character from IN if the next character
is not yet known to TC. If successful the new character is stored in
TC, with its location (line, column), and the operation otherwise
behaves as specified above. Future reads from the same location,
possible due to backtracking, will then be satisfied from TC instead
of IN.
.sp
If, on the other hand, the end of IN was reached, the operation is
recorded as failed in ST, CL is left unchanged, and the pair of CL and
\fImsg\fR becomes the new ES.
.PP
.SS "CHARACTER PROCESSING"
The instructions in this section mainly access CC, testing it against
character classes, ranges, and individual characters.
.TP
\fBtest_alnum\fR
This instruction implements the special PE operator "alnum", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_alpha\fR
This instruction implements the special PE operator "alpha", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_ascii\fR
This instruction implements the special PE operator "ascii", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_char\fR \fIchar\fR
This instruction implements the character matching operator, i.e. it
checks if CC is \fIchar\fR.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_ddigit\fR
This instruction implements the special PE operator "ddigit", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_digit\fR
This instruction implements the special PE operator "digit", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_graph\fR
This instruction implements the special PE operator "graph", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_lower\fR
This instruction implements the special PE operator "lower", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_print\fR
This instruction implements the special PE operator "print", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_punct\fR
This instruction implements the special PE operator "punct", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_range\fR \fIchars\fR \fIchare\fR
This instruction implements the range matching operator, i.e. it
checks if CC falls into the interval of characters spanned up by the
two characters from \fIchars\fR to \fIchare\fR, both inclusive.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_space\fR
This instruction implements the special PE operator "space", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_upper\fR
This instruction implements the special PE operator "upper", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_wordchar\fR
This instruction implements the special PE operator "wordchar", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.TP
\fBtest_xdigit\fR
This instruction implements the special PE operator "xdigit", which
checks if CC falls into the character class of the same name, or not.
.sp
Success and failure of the test are both recorded directly in ST.
Success further clears ES, wheras failure sets the pair of CL and
expected input (encoded as a leaf parsing expression) as the new ES
and then rewinds CL by one character, preparing the machine for
another parse attempt by a possible alternative.
.PP
.SS "ERROR HANDLING"
The instructions in this section mainly access ER and ES.
.TP
\fBerror_clear\fR
This instruction clears ER.
.TP
\fBerror_push\fR
This instruction makes a copy of ER and pushes it on ES.
.TP
\fBerror_pop_merge\fR
This instruction takes the topmost entry of ES and merges the error
status it contains with ES, making the result the new ES.
.sp
The merge is governed by four rules, with the merge result
.RS
.IP [1]
Empty if both states are empty.
.IP [2]
The non-empty state if only one of the two states is non-empty.
.IP [3]
The state with the larger location, if the two states specify
different locations.
.IP [4]
The pair of the location shared by the two states, and the set-union
of their messages for states at the same location.
.RE
.TP
\fBerror_nonterminal\fR \fIsymbol\fR
This is a guarded instruction. It does nothing if either ES is empty,
or if the location in ES is not just past the last location saved in
LS. Otherwise it sets the pair of that location and the nonterminal
\fIsymbol\fR as the new ES.
.sp
\fINote\fR: In the above "just past" means "that location plus one",
or also "the location of the next character after that location".
.PP
.SS "STATUS CONTROL"
The instructions in this section directly manipulate ST.
.TP
\fBstatus_ok\fR
This instruction sets ST to \fBtrue\fR, recording a success.
.TP
\fBstatus_fail\fR
This instruction sets ST to \fBfalse\fR, recording a failure.
.TP
\fBstatus_negate\fR
This instruction negates ST, turning a failure into a success and vice
versa.
.PP
.SS "LOCATION HANDLING"
The instructions in this section access CL and LS.
.TP
\fBloc_push\fR
This instruction makes a copy of CL and pushes it on LS.
.TP
\fBloc_pop_discard\fR
This instructions pops the last saved location from LS.
.TP
\fBloc_pop_rewind\fR
This instruction pops the last saved location from LS and restores it
as CL.
.PP
.SS "NONTERMINAL EXECUTION"
The instructions in this section access and manipulate NC.
.TP
\fBsymbol_restore\fR \fIsymbol\fR
This instruction checks if NC contains data for the nonterminal
\fIsymbol\fR at CL, or not. The result of the instruction is a boolean
flag, with \fBTrue\fR indicating that data was found in the
cache. In that case the instruction has further updated the
architectural state of the machine with the cached information, namely
CL, ST, ER, and SV.
.sp
The method with which the instruction's result is transformed into
control flow is left undefined and the responsibility of the
implementation.
.TP
\fBsymbol_save\fR \fIsymbol\fR
This instructions saves the current settings of CL, ST, ER, and SV in
NC, using the pair of nonterminal \fIsymbol\fR and the last location
saved in LS as key.
.PP
.SS "VALUE CONSTRUCTION"
The instructions in this section manipulate SV.
.TP
\fBvalue_clear\fR
This instruction clears SV.
.TP
\fBvalue_leaf\fR \fIsymbol\fR
This instruction constructs an AST node for \fIsymbol\fR covering the
range of IN from one character after the last location saved on LS to
CL and stores it in SV. ...
.TP
\fBvalue_reduce\fR \fIsymbol\fR
This instruction generally behaves like \fBvalue_nonterminal_leaf\fR,
except that it takes all AST nodes on ARS, if any, and makes them the
children of the new node, with the last node saved on ARS becoming the
right-most / last child. Note that ARS is not modfied by this
operation.
.PP
.SS "AST CONSTRUCTION"
The instructions in this section manipulate ARS and AS.
.TP
\fBast_value_push\fR
This instruction makes a copy of SV and pushes it on ARS.
.TP
\fBast_push\fR
This instruction pushes the current state of ARS on AS and then clears
ARS.
.TP
\fBast_pop_rewind\fR
This instruction pops the last entry saved on AS and restores it as
the new state of ARS.
.TP
\fBast_pop_discard\fR
This instruction pops the last entry saved on AS.
.PP
.SS "CONTROL FLOW"
Normally this section would contain the specifications of the control
flow instructions of the PARAM, i.e. (un)conditional jumps and the
like. However, this part of the PARAM is intentionally left
unspecified. This allows the implementations to freely choose how to
implement control flow.
.PP
The implementation of this machine in Parser Tools, i.e the package
\fBpt::rde\fR, is not only coded in Tcl, but also relies on Tcl
commands to provide it with control flow (instructions).
.SH "INTERACTION OF THE INSTRUCTIONS WITH THE ARCHITECTURAL STATE"
.nf

Instruction		Inputs				Outputs
======================= =======================		====================
ast_pop_discard		AS			->	AS
ast_pop_rewind		AS			->	AS, ARS
ast_push		ARS, AS			->	AS
ast_value_push		SV, ARS			->	ARS
======================= =======================		====================
error_clear		-			->	ER
error_nonterminal sym	ER, LS			->	ER
error_pop_merge   	ES, ER			->	ER
error_push		ES, ER			->	ES
======================= =======================		====================
input_next msg		IN			->	TC, CL, CC, ST, ER
======================= =======================		====================
loc_pop_discard		LS			->	LS
loc_pop_rewind		LS			->	LS, CL
loc_push		CL, LS			->	LS
======================= =======================		====================
status_fail		-			->	ST
status_negate		ST			->	ST
status_ok		-			->	ST
======================= =======================		====================
symbol_restore sym	NC			->	CL, ST, ER, SV
symbol_save    sym	CL, ST, ER, SV LS	->	NC
======================= =======================		====================
test_alnum  		CC			->	ST, ER
test_alpha		CC			->	ST, ER
test_ascii		CC			->	ST, ER
test_char char		CC			->	ST, ER
test_ddigit		CC			->	ST, ER
test_digit		CC			->	ST, ER
test_graph		CC			->	ST, ER
test_lower		CC			->	ST, ER
test_print		CC			->	ST, ER
test_punct		CC			->	ST, ER
test_range chars chare	CC			->	ST, ER
test_space		CC			->	ST, ER
test_upper		CC			->	ST, ER
test_wordchar		CC			->	ST, ER
test_xdigit		CC			->	ST, ER
======================= =======================		====================
value_clear		-			->	SV
value_leaf symbol	LS, CL			->	SV
value_reduce symbol	ARS, LS, CL		->	SV
======================= =======================		====================

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpt\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer, virtual machine
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi