'\"
'\" Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "page_pluginmgr" n 1.0 page "Parser generator tools"
.BS
.SH NAME
page_pluginmgr \- page plugin manager
.SH SYNOPSIS
package require \fBpage::pluginmgr  ?0.2?\fR
.sp
package require \fBfileutil \fR
.sp
\fB::page::pluginmgr::reportvia\fR \fIcmd\fR
.sp
\fB::page::pluginmgr::report\fR \fIlevel\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fB::page::pluginmgr::log\fR \fIcmd\fR
.sp
\fB::page::pluginmgr::configuration\fR \fIname\fR
.sp
\fB::page::pluginmgr::reader\fR \fIname\fR
.sp
\fB::page::pluginmgr::rconfigure\fR \fIdict\fR
.sp
\fB::page::pluginmgr::rtimeable\fR
.sp
\fB::page::pluginmgr::rtime\fR
.sp
\fB::page::pluginmgr::rgettime\fR
.sp
\fB::page::pluginmgr::rhelp\fR
.sp
\fB::page::pluginmgr::rlabel\fR
.sp
\fB::page::pluginmgr::read\fR \fIread\fR \fIeof\fR ?\fIcomplete\fR?
.sp
\fIread\fR \fInum\fR
.sp
\fIeof\fR
.sp
\fIdone\fR
.sp
\fB::page::pluginmgr::writer\fR \fIname\fR
.sp
\fB::page::pluginmgr::wconfigure\fR \fIdict\fR
.sp
\fB::page::pluginmgr::wtimeable\fR
.sp
\fB::page::pluginmgr::wtime\fR
.sp
\fB::page::pluginmgr::wgettime\fR
.sp
\fB::page::pluginmgr::whelp\fR
.sp
\fB::page::pluginmgr::wlabel\fR
.sp
\fB::page::pluginmgr::write\fR \fIchan\fR \fIdata\fR
.sp
\fB::page::pluginmgr::transform\fR \fIname\fR
.sp
\fB::page::pluginmgr::tconfigure\fR \fIid\fR \fIdict\fR
.sp
\fB::page::pluginmgr::ttimeable\fR \fIid\fR
.sp
\fB::page::pluginmgr::ttime\fR \fIid\fR
.sp
\fB::page::pluginmgr::tgettime\fR \fIid\fR
.sp
\fB::page::pluginmgr::thelp\fR \fIid\fR
.sp
\fB::page::pluginmgr::tlabel\fR \fIid\fR
.sp
\fB::page::pluginmgr::transform_do\fR \fIid\fR \fIdata\fR
.sp
\fBpage_cdefinition\fR
.sp
\fBpage_rfeature\fR \fIname\fR
.sp
\fBpage_rtime\fR
.sp
\fBpage_rgettime\fR
.sp
\fBpage_rlabel\fR
.sp
\fBpage_rhelp\fR
.sp
\fBpage_roptions\fR
.sp
\fBpage_rconfigure\fR \fIoption\fR \fIvalue\fR
.sp
\fBpage_rrun\fR
.sp
\fBpage_read\fR \fInum\fR
.sp
\fBpage_read_done\fR
.sp
\fBpage_eof\fR
.sp
\fBpage_info\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_warning\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_error\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_log_info\fR \fItext\fR
.sp
\fBpage_log_warning\fR \fItext\fR
.sp
\fBpage_log_error\fR \fItext\fR
.sp
\fBpage_wfeature\fR
.sp
\fBpage_wtime\fR
.sp
\fBpage_wgettime\fR
.sp
\fBpage_wlabel\fR
.sp
\fBpage_whelp\fR
.sp
\fBpage_woptions\fR
.sp
\fBpage_wconfigure\fR \fIoption\fR \fIvalue\fR
.sp
\fBpage_wrun\fR \fIchan\fR \fIdata\fR
.sp
\fBpage_info\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_warning\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_error\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_log_info\fR \fItext\fR
.sp
\fBpage_log_warning\fR \fItext\fR
.sp
\fBpage_log_error\fR \fItext\fR
.sp
\fBpage_tfeature\fR
.sp
\fBpage_ttime\fR
.sp
\fBpage_tgettime\fR
.sp
\fBpage_tlabel\fR
.sp
\fBpage_thelp\fR
.sp
\fBpage_toptions\fR
.sp
\fBpage_tconfigure\fR \fIoption\fR \fIvalue\fR
.sp
\fBpage_trun\fR \fIchan\fR \fIdata\fR
.sp
\fBpage_info\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_warning\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_error\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fBpage_log_info\fR \fItext\fR
.sp
\fBpage_log_warning\fR \fItext\fR
.sp
\fBpage_log_error\fR \fItext\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides the plugin manager central to the \fBpage\fR
application. It manages the various reader, writer, configuration, and
transformation plugins which actually process the text (read,
transform, and write).
.PP
All plugins are loaded into slave interpreters specially prepared for
them. While implemented using packages they need this special
environment and are not usable in a plain interpreter, like
tclsh. Because of that they are only described in general terms in
section \fBPREDEFINED PLUGINS\fR, and not documented as regular
packages. It is expected that they follow the APIs specified in the
sections
.IP [1]
\fBCONFIG PLUGIN API\fR
.IP [2]
\fBREADER PLUGIN API\fR
.IP [3]
\fBWRITER PLUGIN API\fR
.IP [4]
\fBTRANSFORM PLUGIN API\fR
.PP
as per their type.
.SH API
.TP
\fB::page::pluginmgr::reportvia\fR \fIcmd\fR
This command defines the callback command used by
\fB::page::pluginmgr::report\fR (see below) to report input errors and
warnings. The default is to write such reports to the standard error
channel.
.TP
\fB::page::pluginmgr::report\fR \fIlevel\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
This command is used to report input errors and warnings. By default
such reports are written to the standard error. This can be changed by
setting a user-specific callback command with
\fB::page::pluginmgr::reportvia\fR (see above).
.sp
The arguments \fIlevel\fR and \fItext\fR specify both the importance
of the message, and the message itself. For the former see the package
\fBlogger\fR for the allowed values.
.sp
The optional argument \fIfrom\fR and \fIto\fR can be used by the
caller to indicate the location (or range) in the input where the
reported problem occured. Each is a list containing two elements, the
line and the column in the input, in this order.
.TP
\fB::page::pluginmgr::log\fR \fIcmd\fR
This command defines a log callback command to be used by loaded
plugins for the reporting of internal errors, warnings, and general
information. Specifying the empty string as callback disables logging.
.sp
Note: The \fIcmd\fR has to be created by the \fBlogger\fR package,
or follow the same API as such.
.sp
The command returns the empty string as its result.
.TP
\fB::page::pluginmgr::configuration\fR \fIname\fR
This command loads the named configuration plugin, retrieves the
options encoded in it, and then immediately unloads it again.
.sp
If the \fIname\fR is the path to a file, then this files will be tried
to be loaded as a plugin first, and, if that fails, opened and its
contents read as a list of options and their arguments, separated by
spaces, tabs and newlines, possibly quotes with single and double
quotes.
.sp
See section \fBCONFIG PLUGIN API\fR for the API expected of
configuration plugins.
.sp
The result of the command is the list of options retrieved.
.TP
\fB::page::pluginmgr::reader\fR \fIname\fR
This command loads the named reader plugin and initializes it. The
result of the command is a list of options the plugin understands.
.sp
Only a single reader plugin can be loaded. Loading another reader
plugin causes the previously loaded reader plugin to be de-initialized
and unloaded.
.sp
See section \fBREADER PLUGIN API\fR for the API expected of
reader plugins.
.TP
\fB::page::pluginmgr::rconfigure\fR \fIdict\fR
This commands configures the loaded reader plugin. The options and
their values are provided as a Tcl dictionary. The result of the
command is the empty string.
.TP
\fB::page::pluginmgr::rtimeable\fR
This commands checks if the loaded reader plugin is able to collect
timing statistics. The result of the command is a boolean flag. The
result is \fBtrue\fR if the plugin can be timed, and \fBfalse\fR
otherwise.
.TP
\fB::page::pluginmgr::rtime\fR
This command activates the collection of timing statistics in the
loaded reader plugin.
.TP
\fB::page::pluginmgr::rgettime\fR
This command retrieves the collected timing statistics of the loaded
reader plugin after it was executed.
.TP
\fB::page::pluginmgr::rhelp\fR
This command retrieves the help string of the loaded reader
plugin. This is expected to be in \fIdoctools\fR format.
.TP
\fB::page::pluginmgr::rlabel\fR
This command retrieves the human-readable name of the loaded reader
plugin.
.TP
\fB::page::pluginmgr::read\fR \fIread\fR \fIeof\fR ?\fIcomplete\fR?
This command invokes the loaded reader plugin to process the input,
and returns the results of the plugin as its own result. The input is
accessible through the callback commands \fIread\fR, and \fIeof\fR. The
optional \fIdone\fR can be used to intrecept when the plugin has
completed its processing. All arguments are command prefixes.
.sp
The plugin will invoke the various callbacks in the following
situations:
.RS
.TP
\fIread\fR \fInum\fR
is invoked whenever input to process is needed, with the number of
characters/bytes it asks for. The result is expected to be the input
the plugin is in need of.
.TP
\fIeof\fR
is invoked by the plugin to check if the input has reached the of the
stream. The result is expected to be a boolean flag, \fBtrue\fR when
the input has hit EOF, and \fBfalse\fR otherwise.
.TP
\fIdone\fR
is invoked when the plugin has completed the processing of the input.
.RE
.TP
\fB::page::pluginmgr::writer\fR \fIname\fR
This command loads the named writer plugin and initializes it. The
result of the command is a list of options the plugin understands.
.sp
Only a single reader plugin can be loaded. Loading another reader
plugin causes the previously loaded reader plugin to be de-initialized
and unloaded.
.sp
See section \fBWRITER PLUGIN API\fR for the API expected of
writer plugins.
.TP
\fB::page::pluginmgr::wconfigure\fR \fIdict\fR
This commands configures the loaded writer plugin. The options and
their values are provided as a Tcl dictionary. The result of the
command is the empty string.
.TP
\fB::page::pluginmgr::wtimeable\fR
This commands checks if the loaded writer plugin is able to measure
execution times. The result of the command is a boolean flag. The
result is \fBtrue\fR if the plugin can be timed, and \fBfalse\fR
otherwise.
.TP
\fB::page::pluginmgr::wtime\fR
This command activates the collection of timing statistics in the
loaded writer plugin.
.TP
\fB::page::pluginmgr::wgettime\fR
This command retrieves the collected timing statistics of the loaded
writer plugin after it was executed.
.TP
\fB::page::pluginmgr::whelp\fR
This command retrieves the help string of the loaded writer
plugin. This is expected to be in \fIdoctools\fR format.
.TP
\fB::page::pluginmgr::wlabel\fR
This command retrieves the human-readable name of the loaded writer
plugin.
.TP
\fB::page::pluginmgr::write\fR \fIchan\fR \fIdata\fR
The loaded writer plugin is invoked to generate the output. It is
given the \fIdata\fR to generate the outpout from, and the Tcl handle
\fIchan\fR of the channel to write the generated output to. The
command returns th empty string as its result.
.TP
\fB::page::pluginmgr::transform\fR \fIname\fR
This command loads the named transformation plugin and initializes
it. The result of the command is a 2-element list containing the
plugin id and a list of options the plugin understands, in this order.
.sp
Multiple transformations plugins can be loaded and are identified by
handles.
.sp
See section \fBTRANSFORM PLUGIN API\fR for the API expected of
transformation plugins.
.TP
\fB::page::pluginmgr::tconfigure\fR \fIid\fR \fIdict\fR
This commands configures the identified transformation plugin. The
options and their values are provided as a Tcl dictionary. The result
of the command is the empty string.
.TP
\fB::page::pluginmgr::ttimeable\fR \fIid\fR
This commands checks if the identified transformation plugin is able
to collect timing statistics. The result of the command is a boolean
flag. The result is \fBtrue\fR if the plugin can be timed, and
\fBfalse\fR otherwise.
.TP
\fB::page::pluginmgr::ttime\fR \fIid\fR
This command activates the collection of timing statistics in the
identified transformation plugin.
.TP
\fB::page::pluginmgr::tgettime\fR \fIid\fR
This command retrieves the collected timing statistics of the
identified transformation plugin after it was executed.
.TP
\fB::page::pluginmgr::thelp\fR \fIid\fR
This command retrieves the help string of the identified
transformation plugin. This is expected to be in \fIdoctools\fR
format.
.TP
\fB::page::pluginmgr::tlabel\fR \fIid\fR
This command retrieves the human-readable name of the identified
transformation plugin.
.TP
\fB::page::pluginmgr::transform_do\fR \fIid\fR \fIdata\fR
The identified transformation plugin is invoked to process the
specified \fIdata\fR. The result of the plugin is returned as the
result of the command.
.PP
.SH "CONFIG PLUGIN API"
Configuration plugins are expected to provide a single command,
described below.
.PP
.TP
\fBpage_cdefinition\fR
This command of a configuration plugin is called by the plugin manager
to execute it. Its result has to be a list of options and values to
process.
.PP
.PP
Configuration plugins do not expect the environment to provide any
special commands.
.PP
It is expected that a configuration plugin \fBFOO\fR is implemented
by the package \fBpage::config::\fBFOO\fR\fR.
.PP
Configuration plugins are loaded, executed, and unloaded in one step,
they are not kept in memory. The command for doing this is
\fB::page::pluginmgr::configuration\fR.
.SH "READER PLUGIN API"
Reader plugins are expected to provide the following commands,
described below.
.PP
.TP
\fBpage_rfeature\fR \fIname\fR
This command takes a feature \fIname\fR and returns a boolean flag
indicating whether the feature is supported by the plugin, or not.
The result has to be \fBtrue\fR if the feature is supported, and
\fBfalse\fR otherwise.
.sp
See section \fBFEATURES\fR for the possible features the plugin
manager will ask for.
.TP
\fBpage_rtime\fR
This command is invoked to activate the collection of timing
statistics.
.TP
\fBpage_rgettime\fR
This command is invoked to retrieve the collected timing statistics.
.TP
\fBpage_rlabel\fR
This command is invoked to retrieve a human-readable label for the
plugin.
.TP
\fBpage_rhelp\fR
This command is invoked to retrieve a help text for plugin. The text
is expected to be in \fIdoctools\fR format.
.TP
\fBpage_roptions\fR
This command is invoked to retrieve the options understood by the
plugin.
.TP
\fBpage_rconfigure\fR \fIoption\fR \fIvalue\fR
This command is invoked to reconfigure the plugin, specifically the
given \fIoption\fR is set to the new \fIvalue\fR.
.TP
\fBpage_rrun\fR
This command is invoked to process the input stream per the current
plugin configuration.  The result of the command is the result of the
processing.
.PP
.PP
Reader plugins expect the environment to provide the following special
commands.
.TP
\fBpage_read\fR \fInum\fR
This command is invoked to read \fInum\fR characters/bytes from the
input. Its result has to be read characters/bytes.
.TP
\fBpage_read_done\fR
This command is invoked to signal that the plugin has completed the
processing of the input.
.TP
\fBpage_eof\fR
This command is invoked to check if the input stream has reached its
end. Its result has to be a boolean flag, \fBtrue\fR when the input
has reached the end, \fBfalse\fR otherwise.
.TP
\fBpage_info\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report some information to the user. May indicate a
location or range in the input. Each piece of location data, if
provided, is a 2-element list containing line and column numbers.
.TP
\fBpage_warning\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report a warning to the user. May indicate a location or
range in the input. Each piece of location data, if provided, is a
2-element list containing line and column numbers.
.TP
\fBpage_error\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report an error to the user. May indicate a location or
range in the input. Each piece of location data, if provided, is a
2-element list containing line and column numbers.
.TP
\fBpage_log_info\fR \fItext\fR
Invoked to report some internal information.
.TP
\fBpage_log_warning\fR \fItext\fR
Invoked to report an internal warning.
.TP
\fBpage_log_error\fR \fItext\fR
Invoked to report an internal error.
.PP
.PP
It is expected that a reader plugin \fBFOO\fR is implemented
by the package \fBpage::reader::\fBFOO\fR\fR.
.PP
Reader plugins are loaded by the command
\fB::page::pluginmgr::reader\fR. At most one reader plugin can be kept
in memory.
.SH "WRITER PLUGIN API"
Writer plugins are expected to provide the following commands,
described below.
.PP
.TP
\fBpage_wfeature\fR
This command takes a feature \fIname\fR and returns a boolean flag
indicating whether the feature is supported by the plugin, or not.
The result has to be \fBtrue\fR if the feature is supported, and
\fBfalse\fR otherwise.
.sp
See section \fBFEATURES\fR for the possible features the plugin
manager will ask for.
.TP
\fBpage_wtime\fR
This command is invoked to activate the collection of timing
statistics.
.TP
\fBpage_wgettime\fR
This command is invoked to retrieve the collected timing statistics.
.TP
\fBpage_wlabel\fR
This command is invoked to retrieve a human-readable label for the
plugin.
.TP
\fBpage_whelp\fR
This command is invoked to retrieve a help text for plugin. The text
is expected to be in \fIdoctools\fR format.
.TP
\fBpage_woptions\fR
This command is invoked to retrieve the options understood by the
plugin.
.TP
\fBpage_wconfigure\fR \fIoption\fR \fIvalue\fR
This command is invoked to reconfigure the plugin, specifically the
given \fIoption\fR is set to the new \fIvalue\fR.
.TP
\fBpage_wrun\fR \fIchan\fR \fIdata\fR
This command is invoked to process the specified \fIdata\fR and write
it to the output stream \fIchan\fR. The latter is a Tcl channel handle
opened for writing. The result of the command is the empty string.
.PP
.PP
Writer plugins expect the environment to provide the following special
commands.
.TP
\fBpage_info\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report some information to the user. May indicate a
location or range in the input. Each piece of location data, if
provided, is a 2-element list containing line and column numbers.
.TP
\fBpage_warning\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report a warning to the user. May indicate a location or
range in the input. Each piece of location data, if provided, is a
2-element list containing line and column numbers.
.TP
\fBpage_error\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report an error to the user. May indicate a location or
range in the input. Each piece of location data, if provided, is a
2-element list containing line and column numbers.
.TP
\fBpage_log_info\fR \fItext\fR
Invoked to report some internal information.
.TP
\fBpage_log_warning\fR \fItext\fR
Invoked to report an internal warning.
.TP
\fBpage_log_error\fR \fItext\fR
Invoked to report an internal error.
.PP
.PP
It is expected that a writer plugin \fBFOO\fR is implemented
by the package \fBpage::writer::\fBFOO\fR\fR.
.PP
Writer plugins are loaded by the command
\fB::page::pluginmgr::writer\fR. At most one writer plugin can be kept
in memory.
.SH "TRANSFORM PLUGIN API" page::transform::*
Transformation plugins are expected to provide the following commands,
described below.
.PP
.TP
\fBpage_tfeature\fR
This command takes a feature \fIname\fR and returns a boolean flag
indicating whether the feature is supported by the plugin, or not.
The result has to be \fBtrue\fR if the feature is supported, and
\fBfalse\fR otherwise.
.sp
See section \fBFEATURES\fR for the possible features the plugin
manager will ask for.
.TP
\fBpage_ttime\fR
This command is invoked to activate the collection of timing
statistics.
.TP
\fBpage_tgettime\fR
This command is invoked to retrieve the collected timing statistics.
.TP
\fBpage_tlabel\fR
This command is invoked to retrieve a human-readable label for the
plugin.
.TP
\fBpage_thelp\fR
This command is invoked to retrieve a help text for plugin. The text
is expected to be in \fIdoctools\fR format.
.TP
\fBpage_toptions\fR
This command is invoked to retrieve the options understood by the
plugin.
.TP
\fBpage_tconfigure\fR \fIoption\fR \fIvalue\fR
This command is invoked to reconfigure the plugin, specifically the
given \fIoption\fR is set to the new \fIvalue\fR.
.TP
\fBpage_trun\fR \fIchan\fR \fIdata\fR
This command is invoked to process the specified \fIdata\fR and write
it to the output stream \fIchan\fR. The latter is a Tcl channel handle
opened for writing. The result of the command is the empty string.
.PP
.PP
Transformation plugins expect the environment to provide the following
special commands.
.TP
\fBpage_info\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report some information to the user. May indicate a
location or range in the input. Each piece of location data, if
provided, is a 2-element list containing line and column numbers.
.TP
\fBpage_warning\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report a warning to the user. May indicate a location or
range in the input. Each piece of location data, if provided, is a
2-element list containing line and column numbers.
.TP
\fBpage_error\fR \fItext\fR ?\fIfrom\fR ?\fIto\fR??
Invoked to report an error to the user. May indicate a location or
range in the input. Each piece of location data, if provided, is a
2-element list containing line and column numbers.
.TP
\fBpage_log_info\fR \fItext\fR
Invoked to report some internal information.
.TP
\fBpage_log_warning\fR \fItext\fR
Invoked to report an internal warning.
.TP
\fBpage_log_error\fR \fItext\fR
Invoked to report an internal error.
.PP
.PP
It is expected that a transformation plugin \fBFOO\fR is implemented
by the package \fBpage::transform::\fBFOO\fR\fR.
.PP
Transformation plugins are loaded by the command
\fB::page::pluginmgr::transform\fR. More than one transformation
plugin can be kept in memory.
.SH "PREDEFINED PLUGINS"
The following predefined plugins are known, i.e. provided by the page
module.
.TP
Configuration
.RS
.TP
peg
Returns a set of options to configure the \fBpage\fR application
for the processing of a PEG grammar and the generation of ME code. See
the packages \fBgrammar_peg\fR, \fBgrammar_me\fR and relations
for more details.
.RE
.TP
Reader
.RS
.TP
hb
Expects a so-called \fIhalf-baked PEG container\fR as input and
returns the equivalent abstract syntax tree. See the writer plugin
\fIhb\fR for the plugin generating this type of input.
.TP
lemon
Expects a grammar specification as understood by Richar Hipp's LEMON
parser generator and returns an abstract syntax tree for it.
.TP
peg
Expects a grammar specification in the form of a parsing expression
grammar (PEG) and returns an abstract syntax tree for it.
.TP
ser
Expect the serialized form of a parsing expression grammar as
generated by the package \fBgrammar::peg\fR as input, converts it
into an equivalent abstract syntax tree and returns that.
.TP
treeser
Expects the serialized form of a tree as generated by the package
\fBstruct::tree\fR as input and returns it, after validation.
.RE
.TP
Writer
.RS
.TP
hb
Expects an abstract syntax tree for a parsing expression grammar as
input and writes it out in the form of a so-called
\fIhalf-baked PEG container\fR.
.TP
identity
Takes any input and writes it as is.
.TP
mecpu
Expects symbolic assembler code for the MatchEngine CPU (See the
package \fBgrammar::me::cpu\fR and relatives) and writes it out as
Tcl code for a parser.
.TP
me
Expects an abstract syntax tree for a parsing expression grammar as
input and writes it out as Tcl code for the MatchEngine (See the
package \fBgrammar::me\fR and relatives) which parses input in
that grammar.
.TP
null
Takes any input and writes nothing. The logical equivalent of
/dev/null.
.TP
peg
Expects an abstract syntax tree for a parsing expression grammar as
input and writes it out in the form of a canonical PEG which can be
read by the reader plugin \fIpeg\fR.
.TP
ser
Expects an abstract syntax tree for a parsing expression grammar as
input and writes it out as a serialized PEG container which can be
read by the reader plugin \fIser\fR.
.TP
tpc
Expects an abstract syntax tree for a parsing expression grammar as
input and writes it out as Tcl code initializing a PEG container as
provided by the package \fBgrammar::peg\fR.
.TP
tree
Takes any serialized tree (per package \fBstruct::tree\fR) as
input and writes it out in a generic indented format.
.RE
.TP
Transformation
.RS
.TP
mecpu
Takes an abstract syntax tree for a parsing expression grammer as
input, generates symbolic assembler code for the MatchEngine CPU, and
returns that as its result (See the package \fBgrammar::me::cpu\fR
and relatives).
.TP
reachable
Takes an abstract syntax tree for a parsing expression grammer as
input, performs a reachability analysis, and returns the modified and
annotated tree.
.TP
realizable
Takes an abstract syntax tree for a parsing expression grammer as
input, performs an analysis of realizability, and returns the modified
and annotated tree.
.RE
.PP
.SH FEATURES
The plugin manager currently checks the plugins for only one feature,
\fBtimeable\fR. A plugin supporting this feature is assumed to be
able to collect timing statistics on request.
.SH "BUGS, IDEAS, FEEDBACK"
This document, will undoubtedly contain bugs and other problems.
Please report such in the category \fIpage\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have.
.SH KEYWORDS
page, parser generator, text processing
.SH CATEGORY
Page Parser Generator
.SH COPYRIGHT
.nf
Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi