'\"
'\" Copyright (c) 2007-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "nameserv::server" n 0.3.2 nns "Name service facility"
.BS
.SH NAME
nameserv::server \- Name service facility, Server
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBnameserv::server  ?0.3.2?\fR
.sp
package require \fBcomm \fR
.sp
package require \fBinterp \fR
.sp
package require \fBlogger \fR
.sp
\fB::nameserv::server::start\fR
.sp
\fB::nameserv::server::stop\fR
.sp
\fB::nameserv::server::active?\fR
.sp
\fB::nameserv::server::cget\fR \fB-option\fR
.sp
\fB::nameserv::server::configure\fR
.sp
\fB::nameserv::server::configure\fR \fB-option\fR
.sp
\fB::nameserv::server::configure\fR \fB-option\fR \fIvalue\fR...
.sp
.BE
.SH DESCRIPTION
Please read \fIName service facility, introduction\fR first.
.PP
This package provides an implementation of the serviver side of the
name service facility queried by the client provided by the package
\fBnameserv\fR. All information required by the server will be
held in memory. There is no persistent state.
.PP
This service is built in top of and for the package \fBcomm\fR.
It has nothing to do with the Internet's Domain Name System. If the
reader is looking for a package dealing with that please see Tcllib's
packages \fBdns\fR and \fBresolv\fR.
.PP
This server supports the \fICore\fR protocol feature, and since
version 0.3 the \fISearch/Continuous\fR feature as well.
.SH API
The package exports five commands, as specified below:
.TP
\fB::nameserv::server::start\fR
This command starts the server and causes it to listen on the
configured port. From now on clients are able to connect and make
requests. The result of the command is the empty string.
.sp
Note that any incoming requests will only be handled if the
application the server is part of does enter an event loop after this
command has been run.
.TP
\fB::nameserv::server::stop\fR
Invoking this command stops the server and releases all information it
had. Existing connections are shut down, and no new connections will
be accepted any longer. The result of the command is the empty string.
.TP
\fB::nameserv::server::active?\fR
This command returns a boolean value indicating the state of the
server. The result will be \fBtrue\fR if the server is active,
i.e. has been started, and \fBfalse\fR otherwise.
.TP
\fB::nameserv::server::cget\fR \fB-option\fR
This command returns the currently configured value for the specified
\fB-option\fR. The list of supported options and their meaning can
be found in section \fBOPTIONS\fR.
.TP
\fB::nameserv::server::configure\fR
In this form the command returns a dictionary of all supported
options, and their current values. The list of supported options and
their meaning can be found in section \fBOPTIONS\fR.
.TP
\fB::nameserv::server::configure\fR \fB-option\fR
In this form the command is an alias for
"\fB::nameserv::server::cget\fR \fB-option\fR]".
The list of supported options and their meaning can be found in
section \fBOPTIONS\fR.
.TP
\fB::nameserv::server::configure\fR \fB-option\fR \fIvalue\fR...
In this form the command is used to configure one or more of the
supported options. At least one option has to be specified, and each
option is followed by its new value.
The list of supported options and their meaning can be found in
section \fBOPTIONS\fR.
.sp
This form can be used only if the server is not active, i.e. has not
been started yet, or has been stopped. While the server is active it
cannot be reconfigured.
.PP
.SH OPTIONS
The options supported by the server are for the specification of the
TCP port to listen on, and whether to accept non-local connections or
not.
They are:
.TP
\fB-localonly\fR \fIbool\fR
This option specifies whether to accept only local connections
(-localonly 1) or remote connections as well (-localonly 0). The
default is to accept only local connections.
.TP
\fB-port\fR \fInumber\fR
This option specifies the port the name service will listen on after
it has been started. It has to be a positive integer number (> 0) not
greater than 65536 (unsigned short). The initial default is the number
returned by the command \fB::nameserv::server::common::port\fR, as
provided by the package \fB::nameserv::server::common\fR.
.PP
.SH HISTORY
.TP
0.3
Extended the server with the ability to perform asynchronous and
continuous searches.
.TP
0.2
Changed name of -local switch to -localonly.
.TP
0.1
Initial implementation of the server.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fInameserv\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
nameserv::client(n), nameserv::common(n)
.SH KEYWORDS
name service, server
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2007-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi