'\"
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "doctools2toc_introduction" n 2.0 doctools2toc "Documentation tools"
.BS
.SH NAME
doctools2toc_introduction \- DocTools - Tables of Contents
.SH DESCRIPTION
\fIdoctoc\fR (short for \fIdocumentation tables of contents\fR)
stands for a set of related, yet different, entities which are working
together for the easy creation and transformation of tables and
contents for documentation.
.PP
These are
.IP [1]
A tcl based language for the semantic markup of a table of contents.
Markup is represented by Tcl commands.
Beginners should start with the
\fIdoctoc language introduction\fR.
The formal specification is split over two documents, one dealing with
the \fIdoctoc language syntax\fR, the other a
\fIdoctoc language command reference\fR.
.IP [2]
A set of packages for the programmatic manipulation of tables of
contents in memory, and their conversion between various formats,
reading and writing. The aforementioned markup language is one of the
formats which can be both read from and written to.
.IP [3]
The system for the conversion of tables of contents is based on a
plugin mechanism, for this we have two APIs describing the interface
between the packages above and the import/export plugins.
.PP
.PP
Which of the more detailed documents are relevant to the reader of
this introduction depends on their role in the documentation process.
.PP
.IP [1]
A \fIwriter\fR of documentation has to understand the markup language
itself. A beginner to doctoc should read the more informally written
\fIdoctoc language introduction\fR first. Having digested this
the formal \fIdoctoc language syntax\fR specification should
become understandable. A writer experienced with doctoc may only
need the \fIdoctoc language command reference\fR from time to
time to refresh her memory.
.sp
While a document is written the \fBdtp\fR application can be used
to validate it, and after completion it also performs the conversion
into the chosen system of visual markup, be it *roff, HTML, plain
text, wiki, etc. The simpler \fBdtplite\fR application makes
internal use of doctoc when handling directories of documentation,
automatically generating a proper table of contents for them.
.IP [2]
A \fIprocessor\fR of documentation written in the \fIdoctoc\fR
markup language has to know which tools are available for use.
.sp
The main tool is the aforementioned \fBdtp\fR application provided
by Tcllib. The simpler \fBdtplite\fR does not expose doctoc to the
user. At the bottom level, common to both applications, however we
find the three packages providing the basic facilities to handle
tables of contents, i.e. import from textual formats, programmatic
manipulation in memory, and export to textual formats. These are
.RS
.TP
\fBdoctoools::toc\fR
Programmatic manipulation of tables of contents in memory.
.TP
\fBdoctoools::toc::import\fR
Import of tables of contents from various textual formats. The set of
supported formats is extensible through plugin packages.
.TP
\fBdoctoools::toc::export\fR
Export of tables of contents to various textual formats. The set of
supported formats is extensible through plugin packages.
.RE
See also section \fBPackage Overview\fR for an overview of the
dependencies between these and other, supporting packages.
.IP [3]
At last, but not least, \fIplugin writers\fR have to understand the
interaction between the import and export packages and their plugins.
These APIs are described in the documentation for the two relevant
packages, i.e.
.RS
.IP \(bu
\fBdoctoools::toc::import\fR
.IP \(bu
\fBdoctoools::toc::export\fR
.RE
.PP
.SH "RELATED FORMATS"
The doctoc format does not stand alone, it has two companion formats.
These are called \fIdocidx\fR and \fIdoctools\fR, and they are
intended for the markup of \fIkeyword indices\fR, and of general
documentation, respectively.
They are described in their own sets of documents, starting at
the \fIDocTools - Keyword Indices\fR and
the \fIDocTools - General\fR, respectively.
.SH "PACKAGE OVERVIEW"
.nf

                                    ~~~~~~~~~~~ doctools::toc ~~~~~~~~~~~
                                   ~~                   |               ~~
                doctools::toc::export ~~~~~~~~~~~~~~~~~ | ~~~~~~~~~~~~~ doctools::toc::import
                        |                               |                       |
        +---------------+-------------------------+     |    +------------------+---------------+-----------------------+---------------+
        |               |                         |     |    |                  |               |                       |               |
doctools::config        =                         |     |    |                  =       doctools::include       doctools::config doctools::paths
                        |                         |     |    |                  |
                doctools::toc::export::<*>        |     |    |          doctools::toc::import::<*>
                        doctoc                    |     |    |                  doctoc, json
                        json                      |     |    |                  |           \\\\
                        html                      |     |    |          doctools::toc::parse \\\\
                        nroff                     |     |    |                  |             \\\\
                        wiki                      |     |    |  +---------------+              json
                        text                      |     |    |  |               |
                                                doctools::toc::structure        |
                                                                                |
                                                                        +-------+---------------+
                                                                        |                       |
          doctools::html  doctools::html::cssdefaults           doctools::tcl::parse    doctools::msgcat
                |                                                                               |
          doctools::text  doctools::nroff::man_macros                                           =
                                                                                                |
                                                                                        doctools::msgcat::toc::<*>
                                                                                                c, en, de, fr
                                                                                                (fr == en for now)
        ~~      Interoperable objects, without actual package dependencies
        --      Package dependency, higher requires lower package
        =       Dynamic dependency through plugin system
        <*>     Multiple packages following the given form of naming.


.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIdoctools\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
doctools2doc_introduction, doctools2idx_introduction
.SH KEYWORDS
contents, conversion, formatting, markup, parsing, plugin, semantic markup, table of contents
.SH CATEGORY
Documentation tools
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi