'\"
'\" Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "doctoc_lang_intro" n 1.0 doctools "Documentation tools"
.BS
.SH NAME
doctoc_lang_intro \- doctoc language introduction
.SH DESCRIPTION
.PP
This document is an informal introduction to version 1.1 of the doctoc
markup language based on a multitude of examples. After reading this a
writer should be ready to understand the two parts of the formal
specification, i.e. the \fIdoctoc language syntax\fR specification
and the \fIdoctoc language command reference\fR.
.SS FUNDAMENTALS
While the \fIdoctoc markup language\fR is quite similar to the
\fIdoctools markup language\fR, in the broadest terms possible,
there is one key difference. A table of contents consists essentially
only of markup commands, with no plain text interspersed between them,
except for whitespace.
.PP
Each markup command is a Tcl command surrounded by a matching pair of
\fB[\fR and \fB]\fR. Inside of these delimiters the usual
rules for a Tcl command apply with regard to word quotation, nested
commands, continuation lines, etc. I.e.
.PP
.nf

    ... [division_start {Appendix 1}] ...

.fi
.nf

  ... [item thefile \\\\
          label {file description}] ...

.fi
.SS "BASIC STRUCTURE"
The most simple document which can be written in doctoc is
.nf

    [toc_begin GROUPTITLE TITLE]
    [toc_end]

.fi
This also shows us that all doctoc documents consist of only one
part where we will list \fIitems\fR and \fIdivisions\fR.
.PP
The user is free to mix these as she sees fit. This is a change from
version 1 of the language, which did not allow this mixing, but only
the use of either a series of items or a series of divisions.
.PP
We will discuss the commands for each of these two possibilities in
the next sections.
.SS ITEMS
Use the command \fBitem\fR to put an \fIitem\fR into a table of
contents. This is essentially a reference to a section, subsection,
etc. in the document, or set of documents, the table of contents is
for. The command takes three arguments, a symbolic name for the file
the item is for and two text to label the item and describe the
referenced section.
.PP
Symbolic names are used to preserve the convertibility of this format
to any output format. The actual name of any file will be inserted by
the chosen formatting engine when converting the input, based on a
mapping from symbolic to actual names given to the engine.
.PP
Here a made up example for a table of contents of this document:
.nf

[toc_begin Doctoc {Language Introduction}]
[\fBitem 1 DESCRIPTION\fR]
[\fBitem 1.1 {Basic structure}\fR]
[\fBitem 1.2 Items\fR]
[\fBitem 1.3 Divisions\fR]
[\fBitem 2 {FURTHER READING}\fR]
[toc_end]

.fi
.SS DIVISIONS
One thing of notice in the last example in the previous section is
that the referenced sections actually had a nested structure,
something which was expressed in the item labels, by using a common
prefix for all the sections nested under section 1.
.PP
This kind of structure can be made more explicit in the doctoc
language by using divisions. Instead of using a series of plain items
we use a series of divisions for the major references, and then place
the nested items inside of these.
.PP
Of course, instead of the nested items we can again use divisions and
thus nest arbitrarily deep.
.PP
A division is marked by two commands instead of one, one to start it,
the other to close the last opened division. They are:
.TP
\fBdivision_start\fR
This command opens a new division. It takes one or two arguments, the
title of the division, and the symbolic name of the file it refers
to. The latter is optional.
If the symbolic filename is present then the section title should link
to the referenced document, if links are supported by the output
format.
.TP
\fBdivision_end\fR
This command closes the last opened and not yet closed division.
.PP
.PP
Using this we can recast the last example like this
.nf

[toc_begin Doctoc {Language Introduction}]
[\fBdivision_start DESCRIPTION\fR]
[item 1 {Basic structure}]
[item 2 Items]
[item 3 Divisions]
[\fBdivision_end\fR]
[\fBdivision_start {FURTHER READING}\fR]
[\fBdivision_end\fR]
[toc_end]

.fi
.PP
Or, to demonstrate deeper nesting
.nf

[toc_begin Doctoc {Language Introduction}]
[\fBdivision_start DESCRIPTION\fR]
[\fBdivision_start {Basic structure}\fR]
[item 1 Do]
[item 2 Re]
[\fBdivision_end\fR]
[\fBdivision_start Items\fR]
[item a Fi]
[item b Fo]
[item c Fa]
[\fBdivision_end\fR]
[\fBdivision_start Divisions\fR]
[item 1 Sub]
[item 1 Zero]
[\fBdivision_end\fR]
[\fBdivision_end\fR]
[\fBdivision_start {FURTHER READING}\fR]
[\fBdivision_end\fR]
[toc_end]

.fi
And do not forget, it is possible to freely mix items and divisions,
and to have empty divisions.
.nf

[toc_begin Doctoc {Language Introduction}]
[item 1 Do]
[\fBdivision_start DESCRIPTION\fR]
[\fBdivision_start {Basic structure}\fR]
[item 2 Re]
[\fBdivision_end\fR]
[item a Fi]
[\fBdivision_start Items\fR]
[item b Fo]
[item c Fa]
[\fBdivision_end\fR]
[\fBdivision_start Divisions\fR]
[\fBdivision_end\fR]
[\fBdivision_end\fR]
[\fBdivision_start {FURTHER READING}\fR]
[\fBdivision_end\fR]
[toc_end]

.fi
.SS "ADVANCED STRUCTURE"
In all previous examples we fudged a bit regarding the markup actually
allowed to be used before the \fBtoc_begin\fR command opening the
document.
.PP
Instead of only whitespace the two templating commands \fBinclude\fR
and \fBvset\fR are also allowed, to enable the writer to either set
and/or import configuration settings relevant to the table of
contents. I.e. it is possible to write
.nf

[\fBinclude FILE\fR]
[\fBvset VAR VALUE\fR]
[toc_begin GROUPTITLE TITLE]
...
[toc_end]

.fi
Even more important, these two commands are allowed anywhere where a
markup command is allowed, without regard for any other
structure.
.nf

[toc_begin GROUPTITLE TITLE]
[\fBinclude FILE\fR]
[\fBvset VAR VALUE\fR]
...
[toc_end]

.fi
The only restriction \fBinclude\fR has to obey is that the contents of
the included file must be valid at the place of the inclusion. I.e. a
file included before \fBtoc_begin\fR may contain only the templating
commands \fBvset\fR and \fBinclude\fR, a file included in a division
may contain only items or divisions commands, etc.
.SS ESCAPES
Beyond the 6 commands shown so far we have two more available.
However their function is not the marking up of toc structure, but the
insertion of characters, namely \fB[\fR and \fB]\fR.
These commands, \fBlb\fR and \fBrb\fR respectively, are required
because our use of [ and ] to bracket markup commands makes it
impossible to directly use [ and ] within the text.
.PP
Our example of their use are the sources of the last sentence in the
previous paragraph, with some highlighting added.
.nf

  ...
  These commands, [cmd lb] and [cmd lb] respectively, are required
  because our use of [\fBlb\fR] and [\fBrb\fR] to bracket markup commands makes it
  impossible to directly use [\fBlb\fR] and [\fBrb\fR] within the text.
  ...

.fi
.SH "FURTHER READING"
Now that this document has been digested the reader, assumed to be a
\fIwriter\fR of documentation should be fortified enough to be able
to understand the formal \fIdoctoc language syntax\fR
specification as well. From here on out the
\fIdoctoc language command reference\fR will also serve as the
detailed specification and cheat sheet for all available commands and
their syntax.
.PP
To be able to validate a document while writing it, it is also
recommended to familiarize oneself with Tclapps' ultra-configurable
\fBdtp\fR.
.PP
On the other hand, doctoc is perfectly suited for the automatic
generation from doctools documents, and this is the route Tcllib's
easy and simple \fBdtplite\fR goes, creating a table of contents
for a set of documents behind the scenes, without the writer having to
do so on their own.
.SH "BUGS, IDEAS, FEEDBACK"
This document, will undoubtedly contain bugs and other problems.
Please report such in the category \fIdoctools\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have.
.SH "SEE ALSO"
doctoc_intro, doctoc_lang_cmdref, doctoc_lang_syntax
.SH KEYWORDS
doctoc commands, doctoc language, doctoc markup, doctoc syntax, markup, semantic markup
.SH CATEGORY
Documentation tools
.SH COPYRIGHT
.nf
Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi