'\"
'\" Copyright (c) 2007-2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "docidx_lang_intro" n 1.0 doctools "Documentation tools"
.BS
.SH NAME
docidx_lang_intro \- docidx language introduction
.SH DESCRIPTION
.PP
This document is an informal introduction to version 1 of the docidx
markup language based on a multitude of examples. After reading this a
writer should be ready to understand the two parts of the formal
specification, i.e. the \fIdocidx language syntax\fR specification
and the \fIdocidx language command reference\fR.
.SS FUNDAMENTALS
While the \fIdocidx markup language\fR is quite similar to the
\fIdoctools markup language\fR, in the broadest terms possible,
there is one key difference. An index consists essentially only of
markup commands, with no plain text interspersed between them, except
for whitespace.
.PP
Each markup command is a Tcl command surrounded by a matching pair of
\fB[\fR and \fB]\fR. Inside of these delimiters the usual
rules for a Tcl command apply with regard to word quotation, nested
commands, continuation lines, etc. I.e.
.PP
.nf

    ... [key {markup language}] ...

.fi
.nf

  ... [manpage thefile \\\\
          {file description}] ...

.fi
.SS "BASIC STRUCTURE"
The most simple document which can be written in docidx is
.nf

    [index_begin GROUPTITLE TITLE]
    [index_end]

.fi
.PP
Not very useful, but valid. This also shows us that all docidx
documents consist of only one part where we will list all keys and
their references.
.PP
A more useful index will contain at least keywords, or short 'keys',
i.e. the phrases which were indexed. So:
.nf

[index_begin GROUPTITLE TITLE]
[\fBkey markup\fR]
[\fBkey {semantic markup}]\fR]
[\fBkey {docidx markup}\fR]
[\fBkey {docidx language}\fR]
[\fBkey {docidx commands}\fR]
[index_end]

.fi
.PP
In the above example the command \fBkey\fR is used to declare the
keyword phrases we wish to be part of the index.
.PP
However a truly useful index does not only list the keyword phrases,
but will also contain references to documents associated with the
keywords. Here is a made-up index for all the manpages in the module
\fIbase64\fR:
.nf

[index_begin tcllib/base64 {De- & Encoding}]
[key base64]
[\fBmanpage base64\fR]
[key encoding]
[\fBmanpage base64\fR]
[\fBmanpage uuencode\fR]
[\fBmanpage yencode\fR]
[key uuencode]
[\fBmanpage uuencode\fR]
[key yEnc]
[\fBmanpage yencode\fR]
[key ydecode]
[\fBmanpage yencode\fR]
[key yencode]
[\fBmanpage yencode\fR]
[index_end]

.fi
.PP
In the above example the command \fBmanpage\fR is used to insert
references to documents, using symbolic file names, with each command
belonging to the last \fBkey\fR command coming before it.
.PP
The other command to insert references is \fBurl\fR. In contrast to
\fBmanpage\fR it uses explicit (possibly format-specific) urls to
describe the location of the referenced document. As such this command
is intended for the creation of references to external documents which
could not be handled in any other way.
.SS "ADVANCED STRUCTURE"
In all previous examples we fudged a bit regarding the markup actually
allowed to be used before the \fBindex_begin\fR command opening the
document.
.PP
Instead of only whitespace the two templating commands \fBinclude\fR
and \fBvset\fR are also allowed, to enable the writer to either set
and/or import configuration settings relevant to the table of
contents. I.e. it is possible to write
.nf

[\fBinclude FILE\fR]
[\fBvset VAR VALUE\fR]
[index_begin GROUPTITLE TITLE]
...
[index_end]

.fi
Even more important, these two commands are allowed anywhere where a
markup command is allowed, without regard for any other
structure.
.nf

[index_begin GROUPTITLE TITLE]
[\fBinclude FILE\fR]
[\fBvset VAR VALUE\fR]
...
[index_end]

.fi
The only restriction \fBinclude\fR has to obey is that the contents of
the included file must be valid at the place of the inclusion. I.e. a
file included before \fBindex_begin\fR may contain only the templating
commands \fBvset\fR and \fBinclude\fR, a file included after a key
may contain only manape or url references, and other keys, etc.
.SS ESCAPES
Beyond the 6 commands shown so far we have two more available.
However their function is not the marking up of index structure, but
the insertion of characters, namely \fB[\fR and \fB]\fR.
These commands, \fBlb\fR and \fBrb\fR respectively, are required
because our use of [ and ] to bracket markup commands makes it
impossible to directly use [ and ] within the text.
.PP
Our example of their use are the sources of the last sentence in the
previous paragraph, with some highlighting added.
.nf

  ...
  These commands, [cmd lb] and [cmd lb] respectively, are required
  because our use of [\fBlb\fR] and [\fBrb\fR] to bracket markup commands makes it
  impossible to directly use [\fBlb\fR] and [\fBrb\fR] within the text.
  ...

.fi
.SH "FURTHER READING"
Now that this document has been digested the reader, assumed to be a
\fIwriter\fR of documentation should be fortified enough to be able
to understand the formal \fIdocidx language syntax\fR
specification as well. From here on out the
\fIdocidx language command reference\fR will also serve as the
detailed specification and cheat sheet for all available commands and
their syntax.
.PP
To be able to validate a document while writing it, it is also
recommended to familiarize oneself with Tclapps' ultra-configurable
\fBdtp\fR.
.PP
On the other hand, docidx is perfectly suited for the automatic
generation from doctools documents, and this is the route Tcllib's
easy and simple \fBdtplite\fR goes, creating an index for a set of
documents behind the scenes, without the writer having to do so on
their own.
.SH "BUGS, IDEAS, FEEDBACK"
This document, will undoubtedly contain bugs and other problems.
Please report such in the category \fIdoctools\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have.
.SH "SEE ALSO"
docidx_intro, docidx_lang_cmdref, docidx_lang_syntax
.SH KEYWORDS
docidx commands, docidx language, docidx markup, docidx syntax, markup, semantic markup
.SH CATEGORY
Documentation tools
.SH COPYRIGHT
.nf
Copyright (c) 2007-2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi