'\"
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "struct::disjointset" n 1.0 struct "Tcl Data Structures"
.BS
.SH NAME
struct::disjointset \- Disjoint set data structure
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBstruct::disjointset  ?1.0?\fR
.sp
\fB::struct::disjointset\fR \fIdisjointsetName\fR
.sp
\fIdisjointsetName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIdisjointsetName\fR \fBadd-partition\fR \fIelements\fR
.sp
\fIdisjointsetName\fR \fBpartitions\fR
.sp
\fIdisjointsetName\fR \fBnum-partitions\fR
.sp
\fIdisjointsetName\fR \fBequal\fR \fIa\fR \fIb\fR
.sp
\fIdisjointsetName\fR \fBmerge\fR \fIa\fR \fIb\fR
.sp
\fIdisjointsetName\fR \fBfind\fR \fIe\fR
.sp
\fIdisjointsetName\fR \fBdestroy\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides \fIdisjoint sets\fR. An alternative name for
this kind of structure is \fImerge-find\fR.
.PP
Normally when dealing with sets and their elements the question is "Is
this element E contained in this set S?", with both E and S known.
.PP
Here the question is "Which of several sets contains the element
E?". I.e. while the element is known, the set is not, and we wish to
find it quickly. It is not quite the inverse of the original question,
but close.
Another operation which is often wanted is that of quickly merging two
sets into one, with the result still fast for finding elements. Hence
the alternative term \fImerge-find\fR for this.
.PP
Why now is this named a \fIdisjoint-set\fR ?
Because another way of describing the whole situation is that we have
.IP \(bu
a finite \fIset\fR S, containing
.IP \(bu
a number of \fIelements\fR E, split into
.IP \(bu
a set of \fIpartitions\fR P. The latter term
applies, because the intersection of each pair P, P' of
partitions is empty, with the union of all partitions
covering the whole set.
.IP \(bu
An alternative name for the \fIpartitions\fR would be
\fIequvalence classes\fR, and all elements in the same
class are considered as equal.
.PP
Here is a pictorial representation of the concepts listed above:
.nf

	+-----------------+ The outer lines are the boundaries of the set S.
	|           /     | The inner regions delineated by the skewed lines
	|  *       /   *  | are the partitions P. The *'s denote the elements
	|      *  / \\     | E in the set, each in a single partition, their
	|*       /   \\    | equivalence class.
	|       /  *  \\   |
	|      / *   /    |
	| *   /\\  * /     |
	|    /  \\  /      |
	|   /    \\/  *    |
	|  / *    \\       |
	| /     *  \\      |
	+-----------------+

.fi
.PP
For more information see \fIhttp://en.wikipedia.org/wiki/Disjoint_set_data_structure\fR.
.SH API
The package exports a single command, \fB::struct::disjointset\fR. All
functionality provided here can be reached through a subcommand of
this command.
.PP
.TP
\fB::struct::disjointset\fR \fIdisjointsetName\fR
Creates a new disjoint set object with an associated global Tcl
command whose name is \fIdisjointsetName\fR. This command may be used
to invoke various operations on the disjointset. It has the following
general form:
.RS
.TP
\fIdisjointsetName\fR \fIoption\fR ?\fIarg arg ...\fR?
The \fBoption\fR and the \fIarg\fRs determine the exact behavior of
the command. The following commands are possible for disjointset
objects:
.RE
.TP
\fIdisjointsetName\fR \fBadd-partition\fR \fIelements\fR
Creates a new partition in specified disjoint set, and fills it with
the values found in the set of \fIelements\fR. The command maintains
the integrity of the disjoint set, i.e. it verifies that none of the
\fIelements\fR are already part of the disjoint set and throws an
error otherwise.
.sp
The result of the command is the empty string.
.TP
\fIdisjointsetName\fR \fBpartitions\fR
Returns the set of partitions the named disjoint set currently
consists of.
.TP
\fIdisjointsetName\fR \fBnum-partitions\fR
Returns the number of partitions the named disjoint set currently
consists of.
.TP
\fIdisjointsetName\fR \fBequal\fR \fIa\fR \fIb\fR
Determines if the two elements \fIa\fR and \fIb\fR of the disjoint set
belong to the same partition. The result of the method is a boolean
value, \fBTrue\fR if the two elements are contained in the same
partition, and \fBFalse\fR otherwise.
.sp
An error will be thrown if either \fIa\fR or \fIb\fR are not elements
of the disjoint set.
.TP
\fIdisjointsetName\fR \fBmerge\fR \fIa\fR \fIb\fR
Determines the partitions the elements \fIa\fR and \fIb\fR are
contained in and merges them into a single partition.  If the two
elements were already contained in the same partition nothing will
change.
.sp
The result of the method is the empty string.
.TP
\fIdisjointsetName\fR \fBfind\fR \fIe\fR
Returns the partition of the disjoint set which contains the element
\fIe\fR.
.TP
\fIdisjointsetName\fR \fBdestroy\fR
Destroys the disjoint set object and all associated memory.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIstruct :: disjointset\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
disjoint set, equivalence class, find, merge find, partition, partitioned set, union
.SH CATEGORY
Data structures