#if (defined(USE_UIKIT_PUBLIC_HEADERS) && USE_UIKIT_PUBLIC_HEADERS) || !__has_include(<UIKitCore/UIGraphicsRendererSubclass.h>)
//
//  UIGraphicsRendererSubclass.h
//  UIKit
//
//  Copyright (c) 2016-2018 Apple Inc. All rights reserved.
//

#import <UIKit/UIGraphicsRenderer.h>

NS_HEADER_AUDIT_BEGIN(nullability, sendability)

typedef void (^UIGraphicsDrawingActions)(__kindof UIGraphicsRendererContext *rendererContext) API_AVAILABLE(ios(10.0)) API_UNAVAILABLE(watchos);

/*
 To create a subclass of UIGraphicsRenderer, you must include this header in your implementation and override at least the following methods:
    + (Class)rendererContextClass
    + (nullable CGContextRef)contextWithFormat:(UIGraphicsRendererFormat *)format
 */
@interface UIGraphicsRenderer (UIGraphicsRendererProtected)
// The Class of your UIGraphicsRendererContext subclass
+ (Class)rendererContextClass API_AVAILABLE(ios(10.0));

// Override this to create a context with a custom format
+ (nullable CGContextRef)contextWithFormat:(UIGraphicsRendererFormat *)format CF_RETURNS_RETAINED API_AVAILABLE(ios(10.0));

// Override this to provide a CGContext created by a renderer with a custom initial configuration
+ (void)prepareCGContext:(CGContextRef)context withRendererContext:(UIGraphicsRendererContext *)rendererContext API_AVAILABLE(ios(10.0));

// Invokes the drawingActions with a context generated by +contextWithFormat:, captured in an instance of +rendererContextClass, after preparation by +prepareCGContext:withRendererContext:
// This method is not intended to be overridden.
- (BOOL)runDrawingActions:(NS_NOESCAPE UIGraphicsDrawingActions)drawingActions completionActions:(nullable NS_NOESCAPE UIGraphicsDrawingActions)completionActions error:(NSError **)error API_AVAILABLE(ios(10.0));
@end

NS_HEADER_AUDIT_END(nullability, sendability)

#else
#import <UIKitCore/UIGraphicsRendererSubclass.h>
#endif
