/*
 * Copyright (c) 2000-2023 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */

/*
 * This file is automatically generated
 * DO NOT EDIT!
 */

/*
 * Reserved Keys
 *
 *   kSCResvLink                                        "__LINK__"                     CFString
 *   kSCResvInactive                                    "__INACTIVE__"
 *
 * Generic Keys
 *
 *   kSCPropInterfaceName                               "InterfaceName"                CFString
 *   kSCPropMACAddress                                  "MACAddress"                   CFString
 *   kSCPropUserDefinedName                             "UserDefinedName"              CFString
 *   kSCPropVersion                                     "Version"                      CFString
 *
 * Preference Keys
 *
 *   kSCPrefCurrentSet                                  "CurrentSet"                   CFString
 *   kSCPrefNetworkServices                             "NetworkServices"              CFDictionary
 *   kSCPrefSets                                        "Sets"                         CFDictionary
 *   kSCPrefSystem                                      "System"                       CFDictionary
 *
 * Component Keys
 *
 *   kSCCompNetwork                                     "Network"
 *   kSCCompService                                     "Service"
 *   kSCCompGlobal                                      "Global"
 *   kSCCompHostNames                                   "HostNames"
 *   kSCCompInterface                                   "Interface"
 *   kSCCompSystem                                      "System"
 *   kSCCompUsers                                       "Users"
 *
 *   --- Regex pattern which matches any component ---
 *   kSCCompAnyRegex                                    "[^/]+"
 *
 * Network Entity Keys
 *
 *   kSCEntNetAirPort                                   "AirPort"                      CFDictionary
 *   kSCEntNetDHCP                                      "DHCP"                         CFDictionary
 *   kSCEntNetDNS                                       "DNS"                          CFDictionary
 *   kSCEntNetEthernet                                  "Ethernet"                     CFDictionary
 *   kSCEntNetFireWire                                  "FireWire"                     CFDictionary
 *   kSCEntNetInterface                                 "Interface"                    CFDictionary
 *   kSCEntNetIPSec                                     "IPSec"                        CFDictionary
 *   kSCEntNetIPv4                                      "IPv4"                         CFDictionary
 *   kSCEntNetIPv6                                      "IPv6"                         CFDictionary
 *   kSCEntNetL2TP                                      "L2TP"                         CFDictionary
 *   kSCEntNetLink                                      "Link"                         CFDictionary
 *   kSCEntNetModem                                     "Modem"                        CFDictionary
 *   kSCEntNetPPP                                       "PPP"                          CFDictionary
 *   kSCEntNetPPPoE                                     "PPPoE"                        CFDictionary
 *   kSCEntNetPPPSerial                                 "PPPSerial"                    CFDictionary
 *   kSCEntNetPPTP                                      "PPTP"                         CFDictionary
 *   kSCEntNetProxies                                   "Proxies"                      CFDictionary
 *   kSCEntNetSMB                                       "SMB"                          CFDictionary
 *   kSCEntNet6to4                                      "6to4"                         CFDictionary
 *
 * kSCCompNetwork Properties
 *
 *   kSCPropNetOverridePrimary                          "OverridePrimary"              CFNumber (0 or 1)
 *   kSCPropNetServiceOrder                             "ServiceOrder"                 CFArray[CFString]
 *   kSCPropNetPPPOverridePrimary                       "PPPOverridePrimary"           CFNumber (0 or 1)
 *
 * kSCCompNetworkInterface Properties
 *
 *   kSCPropNetInterfaces                               "Interfaces"                   CFArray[CFString]
 *
 * kSCCompNetworkHostNames Properties
 *
 *   kSCPropNetLocalHostName                            "LocalHostName"                CFString
 *
 * kSCEntNetDNS Entity Keys
 *
 *   kSCPropNetDNSDomainName                            "DomainName"                   CFString
 *   kSCPropNetDNSOptions                               "Options"                      CFString
 *   kSCPropNetDNSSearchDomains                         "SearchDomains"                CFArray[CFString]
 *   kSCPropNetDNSSearchOrder                           "SearchOrder"                  CFNumber
 *   kSCPropNetDNSServerAddresses                       "ServerAddresses"              CFArray[CFString]
 *   kSCPropNetDNSServerPort                            "ServerPort"                   CFNumber
 *   kSCPropNetDNSServerTimeout                         "ServerTimeout"                CFNumber
 *   kSCPropNetDNSSortList                              "SortList"                     CFArray[CFString]
 *   kSCPropNetDNSSupplementalMatchDomains              "SupplementalMatchDomains"     CFArray[CFString]
 *   kSCPropNetDNSSupplementalMatchOrders               "SupplementalMatchOrders"      CFArray[CFNumber]
 *
 * kSCEntNetEthernet (Hardware) Entity Keys
 *
 *   kSCPropNetEthernetMediaSubType                     "MediaSubType"                 CFString
 *   kSCPropNetEthernetMediaOptions                     "MediaOptions"                 CFArray[CFString]
 *   kSCPropNetEthernetMTU                              "MTU"                          CFNumber
 *
 * kSCEntNetFireWire (Hardware) Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *
 * kSCEntNetInterface Entity Keys
 *
 *   kSCPropNetInterfaceDeviceName                      "DeviceName"                   CFString
 *   kSCPropNetInterfaceHardware                        "Hardware"                     CFString
 *   kSCPropNetInterfaceType                            "Type"                         CFString
 *   kSCPropNetInterfaceSubType                         "SubType"                      CFString
 *
 *   --- kSCPropNetInterfaceType values ---
 *   kSCValNetInterfaceTypeEthernet                     "Ethernet"
 *   kSCValNetInterfaceTypeFireWire                     "FireWire"
 *   kSCValNetInterfaceTypePPP                          "PPP"
 *   kSCValNetInterfaceType6to4                         "6to4"
 *   kSCValNetInterfaceTypeIPSec                        "IPSec"
 *
 *   --- kSCPropNetServiceSubType values (for PPP) ---
 *   kSCValNetInterfaceSubTypePPPoE                     "PPPoE"
 *   kSCValNetInterfaceSubTypePPPSerial                 "PPPSerial"
 *   kSCValNetInterfaceSubTypePPTP                      "PPTP"
 *   kSCValNetInterfaceSubTypeL2TP                      "L2TP"
 *
 * kSCEntNetIPSec Entity Keys
 *
 *   kSCPropNetIPSecAuthenticationMethod                "AuthenticationMethod"         CFString
 *   kSCPropNetIPSecLocalCertificate                    "LocalCertificate"             CFData
 *   kSCPropNetIPSecLocalIdentifier                     "LocalIdentifier"              CFString
 *   kSCPropNetIPSecLocalIdentifierType                 "LocalIdentifierType"          CFString
 *   kSCPropNetIPSecSharedSecret                        "SharedSecret"                 CFString
 *   kSCPropNetIPSecSharedSecretEncryption              "SharedSecretEncryption"       CFString
 *   kSCPropNetIPSecConnectTime                         "ConnectTime"                  CFNumber
 *   kSCPropNetIPSecRemoteAddress                       "RemoteAddress"                CFString
 *   kSCPropNetIPSecStatus                              "Status"                       CFNumber
 *   kSCPropNetIPSecXAuthEnabled                        "XAuthEnabled"                 CFNumber (0 or 1)
 *   kSCPropNetIPSecXAuthName                           "XAuthName"                    CFString
 *   kSCPropNetIPSecXAuthPassword                       "XAuthPassword"                CFString
 *   kSCPropNetIPSecXAuthPasswordEncryption             "XAuthPasswordEncryption"      CFString
 *
 *   --- kSCPropNetIPSecAuthenticationMethod values ---
 *   kSCValNetIPSecAuthenticationMethodSharedSecret     "SharedSecret"
 *   kSCValNetIPSecAuthenticationMethodCertificate      "Certificate"
 *   kSCValNetIPSecAuthenticationMethodHybrid           "Hybrid"
 *
 *   --- kSCPropNetIPSecLocalIdentifierType values ---
 *   kSCValNetIPSecLocalIdentifierTypeKeyID             "KeyID"
 *
 *   --- kSCPropNetIPSecSharedSecretEncryption values ---
 *   kSCValNetIPSecSharedSecretEncryptionKeychain       "Keychain"
 *
 *   --- kSCPropNetIPSecXAuthPasswordEncryption values ---
 *   kSCValNetIPSecXAuthPasswordEncryptionKeychain      "Keychain"
 *   kSCValNetIPSecXAuthPasswordEncryptionPrompt        "Prompt"
 *
 * kSCEntNetIPv4 Entity Keys
 *
 *   kSCPropNetIPv4Addresses                            "Addresses"                    CFArray[CFString]
 *   kSCPropNetIPv4ConfigMethod                         "ConfigMethod"                 CFString
 *   kSCPropNetIPv4DHCPClientID                         "DHCPClientID"                 CFString
 *   kSCPropNetIPv4Router                               "Router"                       CFString
 *   kSCPropNetIPv4SubnetMasks                          "SubnetMasks"                  CFArray[CFString]
 *   kSCPropNetIPv4DestAddresses                        "DestAddresses"                CFArray[CFString]
 *   kSCPropNetIPv4BroadcastAddresses                   "BroadcastAddresses"           CFArray[CFString]
 *
 *   --- kSCPropNetIPv4ConfigMethod values ---
 *   kSCValNetIPv4ConfigMethodAutomatic                 "Automatic"
 *   kSCValNetIPv4ConfigMethodBOOTP                     "BOOTP"
 *   kSCValNetIPv4ConfigMethodDHCP                      "DHCP"
 *   kSCValNetIPv4ConfigMethodINFORM                    "INFORM"
 *   kSCValNetIPv4ConfigMethodLinkLocal                 "LinkLocal"
 *   kSCValNetIPv4ConfigMethodManual                    "Manual"
 *   kSCValNetIPv4ConfigMethodPPP                       "PPP"
 *
 * kSCEntNetIPv6 Entity Keys
 *
 *   kSCPropNetIPv6Addresses                            "Addresses"                    CFArray[CFString]
 *   kSCPropNetIPv6ConfigMethod                         "ConfigMethod"                 CFString
 *   kSCPropNetIPv6DestAddresses                        "DestAddresses"                CFArray[CFString]
 *   kSCPropNetIPv6Flags                                "Flags"                        CFArray[CFNumber]
 *   kSCPropNetIPv6PrefixLength                         "PrefixLength"                 CFArray[CFNumber]
 *   kSCPropNetIPv6Router                               "Router"                       CFString
 *
 *   --- kSCPropNetIPv6ConfigMethod values ---
 *   kSCValNetIPv6ConfigMethodAutomatic                 "Automatic"
 *   kSCValNetIPv6ConfigMethodLinkLocal                 "LinkLocal"
 *   kSCValNetIPv6ConfigMethodManual                    "Manual"
 *   kSCValNetIPv6ConfigMethodRouterAdvertisement       "RouterAdvertisement"
 *   kSCValNetIPv6ConfigMethod6to4                      "6to4"
 *
 * kSCEntNet6to4 Entity Keys
 *
 *   kSCPropNet6to4Relay                                "Relay"                        CFString
 *
 * kSCEntNetLink Entity Keys
 *
 *   kSCPropNetLinkActive                               "Active"                       CFBoolean
 *   kSCPropNetLinkDetaching                            "Detaching"                    CFBoolean
 *
 * kSCEntNetModem (Hardware) Entity Keys
 *
 *   kSCPropNetModemAccessPointName                     "AccessPointName"              CFString
 *   kSCPropNetModemConnectionPersonality               "ConnectionPersonality"        CFString
 *   kSCPropNetModemConnectionScript                    "ConnectionScript"             CFString
 *   kSCPropNetModemConnectSpeed                        "ConnectSpeed"                 CFNumber
 *   kSCPropNetModemDataCompression                     "DataCompression"              CFNumber (0 or 1)
 *   kSCPropNetModemDeviceContextID                     "DeviceContextID"              CFString
 *   kSCPropNetModemDeviceModel                         "DeviceModel"                  CFString
 *   kSCPropNetModemDeviceVendor                        "DeviceVendor"                 CFString
 *   kSCPropNetModemDialMode                            "DialMode"                     CFString
 *   kSCPropNetModemErrorCorrection                     "ErrorCorrection"              CFNumber (0 or 1)
 *   kSCPropNetModemHoldCallWaitingAudibleAlert         "HoldCallWaitingAudibleAlert"  CFNumber (0 or 1)
 *   kSCPropNetModemHoldDisconnectOnAnswer              "HoldDisconnectOnAnswer"       CFNumber (0 or 1)
 *   kSCPropNetModemHoldEnabled                         "HoldEnabled"                  CFNumber (0 or 1)
 *   kSCPropNetModemHoldReminder                        "HoldReminder"                 CFNumber (0 or 1)
 *   kSCPropNetModemHoldReminderTime                    "HoldReminderTime"             CFNumber
 *   kSCPropNetModemNote                                "Note"                         CFString
 *   kSCPropNetModemPulseDial                           "PulseDial"                    CFNumber (0 or 1)
 *   kSCPropNetModemSpeaker                             "Speaker"                      CFNumber (0 or 1)
 *   kSCPropNetModemSpeed                               "Speed"                        CFNumber
 *
 *   --- kSCPropNetModemDialMode values ---
 *   kSCValNetModemDialModeIgnoreDialTone               "IgnoreDialTone"
 *   kSCValNetModemDialModeManual                       "Manual"
 *   kSCValNetModemDialModeWaitForDialTone              "WaitForDialTone"
 *
 * kSCEntNetPPP Entity Keys
 *
 *   kSCPropNetPPPACSPEnabled                           "ACSPEnabled"                  CFNumber (0 or 1)
 *   kSCPropNetPPPConnectTime                           "ConnectTime"                  CFNumber
 *   kSCPropNetPPPDeviceLastCause                       "DeviceLastCause"              CFNumber
 *   kSCPropNetPPPDialOnDemand                          "DialOnDemand"                 CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnFastUserSwitch            "DisconnectOnFastUserSwitch"   CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnIdle                      "DisconnectOnIdle"             CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnIdleTimer                 "DisconnectOnIdleTimer"        CFNumber
 *   kSCPropNetPPPDisconnectOnLogout                    "DisconnectOnLogout"           CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnSleep                     "DisconnectOnSleep"            CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectTime                        "DisconnectTime"               CFNumber
 *   kSCPropNetPPPIdleReminder                          "IdleReminder"                 CFNumber (0 or 1)
 *   kSCPropNetPPPIdleReminderTimer                     "IdleReminderTimer"            CFNumber
 *   kSCPropNetPPPLastCause                             "LastCause"                    CFNumber
 *   kSCPropNetPPPLogfile                               "Logfile"                      CFString
 *   kSCPropNetPPPRetryConnectTime                      "RetryConnectTime"             CFNumber
 *   kSCPropNetPPPSessionTimer                          "SessionTimer"                 CFNumber
 *   kSCPropNetPPPStatus                                "Status"                       CFNumber
 *   kSCPropNetPPPUseSessionTimer                       "UseSessionTimer"              CFNumber (0 or 1)
 *   kSCPropNetPPPVerboseLogging                        "VerboseLogging"               CFNumber (0 or 1)
 *
 *   --- Auth: ---
 *   kSCPropNetPPPAuthName                              "AuthName"                     CFString
 *   kSCPropNetPPPAuthPassword                          "AuthPassword"                 CFString
 *   kSCPropNetPPPAuthPasswordEncryption                "AuthPasswordEncryption"       CFString
 *   kSCPropNetPPPAuthPrompt                            "AuthPrompt"                   CFString
 *   kSCPropNetPPPAuthProtocol                          "AuthProtocol"                 CFArray[CFString]
 *
 *   --- kSCPropNetPPPAuthPasswordEncryption values ---
 *   kSCValNetPPPAuthPasswordEncryptionKeychain         "Keychain"
 *   kSCValNetPPPAuthPasswordEncryptionToken            "Token"
 *
 *   --- kSCPropNetPPPAuthPrompt values ---
 *   kSCValNetPPPAuthPromptBefore                       "Before"                       CFString
 *   kSCValNetPPPAuthPromptAfter                        "After"                        CFString
 *
 *   --- kSCPropNetPPPAuthProtocol values ---
 *   kSCValNetPPPAuthProtocolCHAP                       "CHAP"                         CFString
 *   kSCValNetPPPAuthProtocolEAP                        "EAP"                          CFString
 *   kSCValNetPPPAuthProtocolMSCHAP1                    "MSCHAP1"                      CFString
 *   kSCValNetPPPAuthProtocolMSCHAP2                    "MSCHAP2"                      CFString
 *   kSCValNetPPPAuthProtocolPAP                        "PAP"                          CFString
 *
 *   --- Comm: ---
 *   kSCPropNetPPPCommAlternateRemoteAddress            "CommAlternateRemoteAddress"   CFString
 *   kSCPropNetPPPCommConnectDelay                      "CommConnectDelay"             CFNumber
 *   kSCPropNetPPPCommDisplayTerminalWindow             "CommDisplayTerminalWindow"    CFNumber (0 or 1)
 *   kSCPropNetPPPCommRedialCount                       "CommRedialCount"              CFNumber
 *   kSCPropNetPPPCommRedialEnabled                     "CommRedialEnabled"            CFNumber (0 or 1)
 *   kSCPropNetPPPCommRedialInterval                    "CommRedialInterval"           CFNumber
 *   kSCPropNetPPPCommRemoteAddress                     "CommRemoteAddress"            CFString
 *   kSCPropNetPPPCommTerminalScript                    "CommTerminalScript"           CFString
 *   kSCPropNetPPPCommUseTerminalScript                 "CommUseTerminalScript"        CFNumber (0 or 1)
 *
 *   --- CCP: ---
 *   kSCPropNetPPPCCPEnabled                            "CCPEnabled"                   CFNumber (0 or 1)
 *   kSCPropNetPPPCCPMPPE40Enabled                      "CCPMPPE40Enabled"             CFNumber (0 or 1)
 *   kSCPropNetPPPCCPMPPE128Enabled                     "CCPMPPE128Enabled"            CFNumber (0 or 1)
 *
 *   --- IPCP: ---
 *   kSCPropNetPPPIPCPCompressionVJ                     "IPCPCompressionVJ"            CFNumber (0 or 1)
 *   kSCPropNetPPPIPCPUsePeerDNS                        "IPCPUsePeerDNS"               CFNumber (0 or 1)
 *
 *   --- LCP: ---
 *   kSCPropNetPPPLCPEchoEnabled                        "LCPEchoEnabled"               CFNumber (0 or 1)
 *   kSCPropNetPPPLCPEchoFailure                        "LCPEchoFailure"               CFNumber
 *   kSCPropNetPPPLCPEchoInterval                       "LCPEchoInterval"              CFNumber
 *   kSCPropNetPPPLCPCompressionACField                 "LCPCompressionACField"        CFNumber (0 or 1)
 *   kSCPropNetPPPLCPCompressionPField                  "LCPCompressionPField"         CFNumber (0 or 1)
 *   kSCPropNetPPPLCPMRU                                "LCPMRU"                       CFNumber
 *   kSCPropNetPPPLCPMTU                                "LCPMTU"                       CFNumber
 *   kSCPropNetPPPLCPReceiveACCM                        "LCPReceiveACCM"               CFNumber
 *   kSCPropNetPPPLCPTransmitACCM                       "LCPTransmitACCM"              CFNumber
 *
 * kSCEntNetPPPoE Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *
 * kSCEntNetPPPSerial Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *
 * kSCEntNetL2TP Entity Keys
 *
 *   kSCPropNetL2TPIPSecSharedSecret                    "IPSecSharedSecret"            CFString
 *   kSCPropNetL2TPIPSecSharedSecretEncryption          "IPSecSharedSecretEncryption"  CFString
 *   kSCPropNetL2TPTransport                            "Transport"                    CFString
 *
 *   --- kSCPropNetL2TPIPSecSharedSecretEncryption values ---
 *   kSCValNetL2TPIPSecSharedSecretEncryptionKeychain   "Keychain"
 *
 *   --- kSCPropNetL2TPTransport values ---
 *   kSCValNetL2TPTransportIP                           "IP"
 *   kSCValNetL2TPTransportIPSec                        "IPSec"
 *
 * kSCEntNetProxies Entity Keys
 *
 *   kSCPropNetProxiesExceptionsList                    "ExceptionsList"               CFArray[CFString]
 *   kSCPropNetProxiesExcludeSimpleHostnames            "ExcludeSimpleHostnames"       CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPEnable                         "FTPEnable"                    CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPPassive                        "FTPPassive"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPPort                           "FTPPort"                      CFNumber
 *   kSCPropNetProxiesFTPProxy                          "FTPProxy"                     CFString
 *   kSCPropNetProxiesFTPUser                           "FTPUser"                      CFString
 *   kSCPropNetProxiesGopherEnable                      "GopherEnable"                 CFNumber (0 or 1)
 *   kSCPropNetProxiesGopherPort                        "GopherPort"                   CFNumber
 *   kSCPropNetProxiesGopherProxy                       "GopherProxy"                  CFString
 *   kSCPropNetProxiesGopherUser                        "GopherUser"                   CFString
 *   kSCPropNetProxiesHTTPEnable                        "HTTPEnable"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesHTTPPort                          "HTTPPort"                     CFNumber
 *   kSCPropNetProxiesHTTPProxy                         "HTTPProxy"                    CFString
 *   kSCPropNetProxiesHTTPUser                          "HTTPUser"                     CFString
 *   kSCPropNetProxiesHTTPSEnable                       "HTTPSEnable"                  CFNumber (0 or 1)
 *   kSCPropNetProxiesHTTPSPort                         "HTTPSPort"                    CFNumber
 *   kSCPropNetProxiesHTTPSProxy                        "HTTPSProxy"                   CFString
 *   kSCPropNetProxiesHTTPSUser                         "HTTPSUser"                    CFString
 *   kSCPropNetProxiesRTSPEnable                        "RTSPEnable"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesRTSPPort                          "RTSPPort"                     CFNumber
 *   kSCPropNetProxiesRTSPProxy                         "RTSPProxy"                    CFString
 *   kSCPropNetProxiesRTSPUser                          "RTSPUser"                     CFString
 *   kSCPropNetProxiesSOCKSEnable                       "SOCKSEnable"                  CFNumber (0 or 1)
 *   kSCPropNetProxiesSOCKSPort                         "SOCKSPort"                    CFNumber
 *   kSCPropNetProxiesSOCKSProxy                        "SOCKSProxy"                   CFString
 *   kSCPropNetProxiesSOCKSUser                         "SOCKSUser"                    CFString
 *   kSCPropNetProxiesProxyAutoConfigEnable             "ProxyAutoConfigEnable"        CFNumber (0 or 1)
 *   kSCPropNetProxiesProxyAutoConfigJavaScript         "ProxyAutoConfigJavaScript"    CFString
 *   kSCPropNetProxiesProxyAutoConfigURLString          "ProxyAutoConfigURLString"     CFString
 *   kSCPropNetProxiesProxyAutoDiscoveryEnable          "ProxyAutoDiscoveryEnable"     CFNumber (0 or 1)
 *
 * kSCEntNetSMB Entity Keys
 *
 *   kSCPropNetSMBNetBIOSName                           "NetBIOSName"                  CFString
 *   kSCPropNetSMBNetBIOSNodeType                       "NetBIOSNodeType"              CFString
 *   kSCPropNetSMBNetBIOSScope                          "NetBIOSScope"                 CFString
 *   kSCPropNetSMBWINSAddresses                         "WINSAddresses"                CFArray[CFString]
 *   kSCPropNetSMBWorkgroup                             "Workgroup"                    CFString
 *
 *   --- kSCPropNetSMBNetBIOSNodeType values ---
 *   kSCValNetSMBNetBIOSNodeTypeBroadcast               "Broadcast"
 *   kSCValNetSMBNetBIOSNodeTypePeer                    "Peer"
 *   kSCValNetSMBNetBIOSNodeTypeMixed                   "Mixed"
 *   kSCValNetSMBNetBIOSNodeTypeHybrid                  "Hybrid"
 *
 * kSCCompUsers Entity Keys
 *
 *   kSCEntUsersConsoleUser                             "ConsoleUser"
 *
 * kSCCompSystem Properties
 *
 *   kSCPropSystemComputerName                          "ComputerName"                 CFString
 *   kSCPropSystemComputerNameEncoding                  "ComputerNameEncoding"         CFNumber
 *
 * SCDynamicStore "domain" prefixes
 *
 *   kSCDynamicStoreDomainFile                          "File:"
 *   kSCDynamicStoreDomainPlugin                        "Plugin:"
 *   kSCDynamicStoreDomainSetup                         "Setup:"
 *   kSCDynamicStoreDomainState                         "State:"
 *   kSCDynamicStoreDomainPrefs                         "Prefs:"
 *
 * Preference ("location") Keys
 *
 *   kSCDynamicStorePropSetupCurrentSet                 "CurrentSet"                   CFString
 *   kSCDynamicStorePropSetupLastUpdated                "LastUpdated"
 *
 * Common/shared Keys
 *
 *   kSCDynamicStorePropNetInterfaces                   "Interfaces"                   CFArray[CFString]
 *   kSCDynamicStorePropNetPrimaryInterface             "PrimaryInterface"             CFString
 *   kSCDynamicStorePropNetPrimaryService               "PrimaryService"               CFString
 *   kSCDynamicStorePropNetServiceIDs                   "ServiceIDs"                   CFArray[CFString]
 */


#ifndef	_SCSCHEMADEFINITIONS_H
#define	_SCSCHEMADEFINITIONS_H

#include <os/availability.h>
#include <TargetConditionals.h>
#include <CoreFoundation/CFString.h>

/*!
 *	@header SCSchemaDefinitions
 */


CF_ASSUME_NONNULL_BEGIN

/*!
  @const kSCResvLink
  @discussion Value is a CFString
 */
extern const CFStringRef kSCResvLink                                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCResvLink kSCResvLink

/*!
  @const kSCResvInactive
 */
extern const CFStringRef kSCResvInactive                                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCResvInactive kSCResvInactive

/*!
  @const kSCPropInterfaceName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropInterfaceName                               API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropInterfaceName kSCPropInterfaceName

/*!
  @const kSCPropMACAddress
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropMACAddress                                  API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropMACAddress kSCPropMACAddress

/*!
  @const kSCPropUserDefinedName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropUserDefinedName                             API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropUserDefinedName kSCPropUserDefinedName

/*!
  @const kSCPropVersion
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropVersion                                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropVersion kSCPropVersion

/*!
  @group Preference Keys
 */

/*!
  @const kSCPrefCurrentSet
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPrefCurrentSet                                  API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPrefCurrentSet kSCPrefCurrentSet

/*!
  @const kSCPrefNetworkServices
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCPrefNetworkServices                             API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPrefNetworkServices kSCPrefNetworkServices

/*!
  @const kSCPrefSets
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCPrefSets                                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPrefSets kSCPrefSets

/*!
  @const kSCPrefSystem
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCPrefSystem                                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPrefSystem kSCPrefSystem

/*!
  @group Component Keys
 */

/*!
  @const kSCCompNetwork
 */
extern const CFStringRef kSCCompNetwork                                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCCompNetwork kSCCompNetwork

/*!
  @const kSCCompService
 */
extern const CFStringRef kSCCompService                                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCCompService kSCCompService

/*!
  @const kSCCompGlobal
 */
extern const CFStringRef kSCCompGlobal                                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCCompGlobal kSCCompGlobal

/*!
  @const kSCCompHostNames
 */
extern const CFStringRef kSCCompHostNames                                   API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCCompHostNames kSCCompHostNames

/*!
  @const kSCCompInterface
 */
extern const CFStringRef kSCCompInterface                                   API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCCompInterface kSCCompInterface

/*!
  @const kSCCompSystem
 */
extern const CFStringRef kSCCompSystem                                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCCompSystem kSCCompSystem

/*!
  @const kSCCompUsers
 */
extern const CFStringRef kSCCompUsers                                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCCompUsers kSCCompUsers

/*!
  @const kSCCompAnyRegex
 */
extern const CFStringRef kSCCompAnyRegex                                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCCompAnyRegex kSCCompAnyRegex

/*!
  @group Network Entity Keys
 */

/*!
  @const kSCEntNetAirPort
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetAirPort                                   API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetAirPort kSCEntNetAirPort

/*!
  @const kSCEntNetDHCP
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetDHCP                                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetDHCP kSCEntNetDHCP

/*!
  @const kSCEntNetDNS
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetDNS                                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetDNS kSCEntNetDNS

/*!
  @const kSCEntNetEthernet
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetEthernet                                  API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetEthernet kSCEntNetEthernet

/*!
  @const kSCEntNetFireWire
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetFireWire                                  API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetFireWire kSCEntNetFireWire

/*!
  @const kSCEntNetInterface
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetInterface                                 API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetInterface kSCEntNetInterface

/*!
  @const kSCEntNetIPSec
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetIPSec                                     API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetIPSec kSCEntNetIPSec

/*!
  @const kSCEntNetIPv4
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetIPv4                                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetIPv4 kSCEntNetIPv4

/*!
  @const kSCEntNetIPv6
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetIPv6                                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetIPv6 kSCEntNetIPv6

/*!
  @const kSCEntNetL2TP
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetL2TP                                      API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetL2TP kSCEntNetL2TP

/*!
  @const kSCEntNetLink
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetLink                                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetLink kSCEntNetLink

/*!
  @const kSCEntNetModem
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetModem                                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetModem kSCEntNetModem

/*!
  @const kSCEntNetPPP
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetPPP                                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetPPP kSCEntNetPPP

/*!
  @const kSCEntNetPPPoE
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetPPPoE                                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetPPPoE kSCEntNetPPPoE

/*!
  @const kSCEntNetPPPSerial
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetPPPSerial                                 API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetPPPSerial kSCEntNetPPPSerial

/*!
  @const kSCEntNetPPTP
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetPPTP                                      API_DEPRECATED("No longer supported", macos(10.3,10.12)) API_UNAVAILABLE(ios);
#define kSCEntNetPPTP kSCEntNetPPTP

/*!
  @const kSCEntNetProxies
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetProxies                                   API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetProxies kSCEntNetProxies

/*!
  @const kSCEntNetSMB
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetSMB                                       API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNetSMB kSCEntNetSMB

/*!
  @const kSCEntNet6to4
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNet6to4                                      API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntNet6to4 kSCEntNet6to4

/*!
  @group kSCCompNetwork Properties
 */

/*!
  @const kSCPropNetOverridePrimary
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetOverridePrimary                          API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetOverridePrimary kSCPropNetOverridePrimary

/*!
  @const kSCPropNetServiceOrder
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetServiceOrder                             API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetServiceOrder kSCPropNetServiceOrder

/*!
  @const kSCPropNetPPPOverridePrimary
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPOverridePrimary                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPOverridePrimary kSCPropNetPPPOverridePrimary

/*!
  @group kSCCompNetworkInterface Properties
 */

/*!
  @const kSCPropNetInterfaces
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetInterfaces                               API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetInterfaces kSCPropNetInterfaces

/*!
  @group kSCCompNetworkHostNames Properties
 */

/*!
  @const kSCPropNetLocalHostName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetLocalHostName                            API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetLocalHostName kSCPropNetLocalHostName

/*!
  @group kSCEntNetAirPort (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetAirPortAllowNetCreation
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetAirPortAllowNetCreation                  API_DEPRECATED("No longer supported", macos(10.2,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetAirPortAllowNetCreation kSCPropNetAirPortAllowNetCreation

/*!
  @const kSCPropNetAirPortAuthPassword
  @discussion Value is a CFData
 */
extern const CFStringRef kSCPropNetAirPortAuthPassword                      API_DEPRECATED("No longer supported", macos(10.1,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetAirPortAuthPassword kSCPropNetAirPortAuthPassword

/*!
  @const kSCPropNetAirPortAuthPasswordEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetAirPortAuthPasswordEncryption            API_DEPRECATED("No longer supported", macos(10.1,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetAirPortAuthPasswordEncryption kSCPropNetAirPortAuthPasswordEncryption

/*!
  @const kSCPropNetAirPortJoinMode
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetAirPortJoinMode                          API_DEPRECATED("No longer supported", macos(10.2,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetAirPortJoinMode kSCPropNetAirPortJoinMode

/*!
  @const kSCPropNetAirPortPowerEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetAirPortPowerEnabled                      API_DEPRECATED("No longer supported", macos(10.1,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetAirPortPowerEnabled kSCPropNetAirPortPowerEnabled

/*!
  @const kSCPropNetAirPortPreferredNetwork
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetAirPortPreferredNetwork                  API_DEPRECATED("No longer supported", macos(10.1,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetAirPortPreferredNetwork kSCPropNetAirPortPreferredNetwork

/*!
  @const kSCPropNetAirPortSavePasswords
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetAirPortSavePasswords                     API_DEPRECATED("No longer supported", macos(10.2,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetAirPortSavePasswords kSCPropNetAirPortSavePasswords

/*!
  @const kSCValNetAirPortJoinModeAutomatic
 */
extern const CFStringRef kSCValNetAirPortJoinModeAutomatic                  API_DEPRECATED("No longer supported", macos(10.3,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetAirPortJoinModeAutomatic kSCValNetAirPortJoinModeAutomatic

/*!
  @const kSCValNetAirPortJoinModePreferred
 */
extern const CFStringRef kSCValNetAirPortJoinModePreferred                  API_DEPRECATED("No longer supported", macos(10.2,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetAirPortJoinModePreferred kSCValNetAirPortJoinModePreferred

/*!
  @const kSCValNetAirPortJoinModeRanked
 */
extern const CFStringRef kSCValNetAirPortJoinModeRanked                     API_DEPRECATED("No longer supported", macos(10.4,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetAirPortJoinModeRanked kSCValNetAirPortJoinModeRanked

/*!
  @const kSCValNetAirPortJoinModeRecent
 */
extern const CFStringRef kSCValNetAirPortJoinModeRecent                     API_DEPRECATED("No longer supported", macos(10.2,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetAirPortJoinModeRecent kSCValNetAirPortJoinModeRecent

/*!
  @const kSCValNetAirPortJoinModeStrongest
 */
extern const CFStringRef kSCValNetAirPortJoinModeStrongest                  API_DEPRECATED("No longer supported", macos(10.2,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetAirPortJoinModeStrongest kSCValNetAirPortJoinModeStrongest

/*!
  @const kSCValNetAirPortAuthPasswordEncryptionKeychain
 */
extern const CFStringRef kSCValNetAirPortAuthPasswordEncryptionKeychain     API_DEPRECATED("No longer supported", macos(10.3,10.9)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetAirPortAuthPasswordEncryptionKeychain kSCValNetAirPortAuthPasswordEncryptionKeychain

/*!
  @group kSCEntNetDNS Entity Keys
 */

/*!
  @const kSCPropNetDNSDomainName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetDNSDomainName                            API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSDomainName kSCPropNetDNSDomainName

/*!
  @const kSCPropNetDNSOptions
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetDNSOptions                               API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSOptions kSCPropNetDNSOptions

/*!
  @const kSCPropNetDNSSearchDomains
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetDNSSearchDomains                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSSearchDomains kSCPropNetDNSSearchDomains

/*!
  @const kSCPropNetDNSSearchOrder
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetDNSSearchOrder                           API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSSearchOrder kSCPropNetDNSSearchOrder

/*!
  @const kSCPropNetDNSServerAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetDNSServerAddresses                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSServerAddresses kSCPropNetDNSServerAddresses

/*!
  @const kSCPropNetDNSServerPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetDNSServerPort                            API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSServerPort kSCPropNetDNSServerPort

/*!
  @const kSCPropNetDNSServerTimeout
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetDNSServerTimeout                         API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSServerTimeout kSCPropNetDNSServerTimeout

/*!
  @const kSCPropNetDNSSortList
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetDNSSortList                              API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSSortList kSCPropNetDNSSortList

/*!
  @const kSCPropNetDNSSupplementalMatchDomains
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetDNSSupplementalMatchDomains              API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSSupplementalMatchDomains kSCPropNetDNSSupplementalMatchDomains

/*!
  @const kSCPropNetDNSSupplementalMatchOrders
  @discussion Value is a CFArray[CFNumber]
 */
extern const CFStringRef kSCPropNetDNSSupplementalMatchOrders               API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetDNSSupplementalMatchOrders kSCPropNetDNSSupplementalMatchOrders

/*!
  @group kSCEntNetEthernet (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetEthernetMediaSubType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetEthernetMediaSubType                     API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetEthernetMediaSubType kSCPropNetEthernetMediaSubType

/*!
  @const kSCPropNetEthernetMediaOptions
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetEthernetMediaOptions                     API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetEthernetMediaOptions kSCPropNetEthernetMediaOptions

/*!
  @const kSCPropNetEthernetMTU
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetEthernetMTU                              API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetEthernetMTU kSCPropNetEthernetMTU

/*!
  @group kSCEntNetFireWire (Hardware) Entity Keys
 */

/*!
  @group kSCEntNetInterface Entity Keys
 */

/*!
  @const kSCPropNetInterfaceDeviceName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetInterfaceDeviceName                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetInterfaceDeviceName kSCPropNetInterfaceDeviceName

/*!
  @const kSCPropNetInterfaceHardware
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetInterfaceHardware                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetInterfaceHardware kSCPropNetInterfaceHardware

/*!
  @const kSCPropNetInterfaceType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetInterfaceType                            API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetInterfaceType kSCPropNetInterfaceType

/*!
  @const kSCPropNetInterfaceSubType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetInterfaceSubType                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetInterfaceSubType kSCPropNetInterfaceSubType

/*!
  @const kSCPropNetInterfaceSupportsModemOnHold
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetInterfaceSupportsModemOnHold             API_DEPRECATED("No longer supported", macos(10.2,10.13)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetInterfaceSupportsModemOnHold kSCPropNetInterfaceSupportsModemOnHold

/*!
  @const kSCValNetInterfaceTypeEthernet
 */
extern const CFStringRef kSCValNetInterfaceTypeEthernet                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetInterfaceTypeEthernet kSCValNetInterfaceTypeEthernet

/*!
  @const kSCValNetInterfaceTypeFireWire
 */
extern const CFStringRef kSCValNetInterfaceTypeFireWire                     API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetInterfaceTypeFireWire kSCValNetInterfaceTypeFireWire

/*!
  @const kSCValNetInterfaceTypePPP
 */
extern const CFStringRef kSCValNetInterfaceTypePPP                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetInterfaceTypePPP kSCValNetInterfaceTypePPP

/*!
  @const kSCValNetInterfaceType6to4
 */
extern const CFStringRef kSCValNetInterfaceType6to4                         API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetInterfaceType6to4 kSCValNetInterfaceType6to4

/*!
  @const kSCValNetInterfaceTypeIPSec
 */
extern const CFStringRef kSCValNetInterfaceTypeIPSec                        API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetInterfaceTypeIPSec kSCValNetInterfaceTypeIPSec

/*!
  @const kSCValNetInterfaceSubTypePPPoE
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPPoE                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetInterfaceSubTypePPPoE kSCValNetInterfaceSubTypePPPoE

/*!
  @const kSCValNetInterfaceSubTypePPPSerial
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPPSerial                 API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetInterfaceSubTypePPPSerial kSCValNetInterfaceSubTypePPPSerial

/*!
  @const kSCValNetInterfaceSubTypePPTP
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPTP                      API_DEPRECATED("No longer supported", macos(10.2,10.12)) API_UNAVAILABLE(ios);
#define kSCValNetInterfaceSubTypePPTP kSCValNetInterfaceSubTypePPTP

/*!
  @const kSCValNetInterfaceSubTypeL2TP
 */
extern const CFStringRef kSCValNetInterfaceSubTypeL2TP                      API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetInterfaceSubTypeL2TP kSCValNetInterfaceSubTypeL2TP

/*!
  @group kSCEntNetIPSec Entity Keys
 */

/*!
  @const kSCPropNetIPSecAuthenticationMethod
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecAuthenticationMethod                API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecAuthenticationMethod kSCPropNetIPSecAuthenticationMethod

/*!
  @const kSCPropNetIPSecLocalCertificate
  @discussion Value is a CFData
 */
extern const CFStringRef kSCPropNetIPSecLocalCertificate                    API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecLocalCertificate kSCPropNetIPSecLocalCertificate

/*!
  @const kSCPropNetIPSecLocalIdentifier
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecLocalIdentifier                     API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecLocalIdentifier kSCPropNetIPSecLocalIdentifier

/*!
  @const kSCPropNetIPSecLocalIdentifierType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecLocalIdentifierType                 API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecLocalIdentifierType kSCPropNetIPSecLocalIdentifierType

/*!
  @const kSCPropNetIPSecSharedSecret
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecSharedSecret                        API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecSharedSecret kSCPropNetIPSecSharedSecret

/*!
  @const kSCPropNetIPSecSharedSecretEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecSharedSecretEncryption              API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecSharedSecretEncryption kSCPropNetIPSecSharedSecretEncryption

/*!
  @const kSCPropNetIPSecConnectTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetIPSecConnectTime                         API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecConnectTime kSCPropNetIPSecConnectTime

/*!
  @const kSCPropNetIPSecRemoteAddress
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecRemoteAddress                       API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecRemoteAddress kSCPropNetIPSecRemoteAddress

/*!
  @const kSCPropNetIPSecStatus
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetIPSecStatus                              API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecStatus kSCPropNetIPSecStatus

/*!
  @const kSCPropNetIPSecXAuthEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetIPSecXAuthEnabled                        API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecXAuthEnabled kSCPropNetIPSecXAuthEnabled

/*!
  @const kSCPropNetIPSecXAuthName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecXAuthName                           API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecXAuthName kSCPropNetIPSecXAuthName

/*!
  @const kSCPropNetIPSecXAuthPassword
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecXAuthPassword                       API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecXAuthPassword kSCPropNetIPSecXAuthPassword

/*!
  @const kSCPropNetIPSecXAuthPasswordEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecXAuthPasswordEncryption             API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPSecXAuthPasswordEncryption kSCPropNetIPSecXAuthPasswordEncryption

/*!
  @const kSCValNetIPSecAuthenticationMethodSharedSecret
 */
extern const CFStringRef kSCValNetIPSecAuthenticationMethodSharedSecret     API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPSecAuthenticationMethodSharedSecret kSCValNetIPSecAuthenticationMethodSharedSecret

/*!
  @const kSCValNetIPSecAuthenticationMethodCertificate
 */
extern const CFStringRef kSCValNetIPSecAuthenticationMethodCertificate      API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPSecAuthenticationMethodCertificate kSCValNetIPSecAuthenticationMethodCertificate

/*!
  @const kSCValNetIPSecAuthenticationMethodHybrid
 */
extern const CFStringRef kSCValNetIPSecAuthenticationMethodHybrid           API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPSecAuthenticationMethodHybrid kSCValNetIPSecAuthenticationMethodHybrid

/*!
  @const kSCValNetIPSecLocalIdentifierTypeKeyID
 */
extern const CFStringRef kSCValNetIPSecLocalIdentifierTypeKeyID             API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPSecLocalIdentifierTypeKeyID kSCValNetIPSecLocalIdentifierTypeKeyID

/*!
  @const kSCValNetIPSecSharedSecretEncryptionKeychain
 */
extern const CFStringRef kSCValNetIPSecSharedSecretEncryptionKeychain       API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPSecSharedSecretEncryptionKeychain kSCValNetIPSecSharedSecretEncryptionKeychain

/*!
  @const kSCValNetIPSecXAuthPasswordEncryptionKeychain
 */
extern const CFStringRef kSCValNetIPSecXAuthPasswordEncryptionKeychain      API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPSecXAuthPasswordEncryptionKeychain kSCValNetIPSecXAuthPasswordEncryptionKeychain

/*!
  @const kSCValNetIPSecXAuthPasswordEncryptionPrompt
 */
extern const CFStringRef kSCValNetIPSecXAuthPasswordEncryptionPrompt        API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPSecXAuthPasswordEncryptionPrompt kSCValNetIPSecXAuthPasswordEncryptionPrompt

/*!
  @group kSCEntNetIPv4 Entity Keys
 */

/*!
  @const kSCPropNetIPv4Addresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv4Addresses                            API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv4Addresses kSCPropNetIPv4Addresses

/*!
  @const kSCPropNetIPv4ConfigMethod
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv4ConfigMethod                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv4ConfigMethod kSCPropNetIPv4ConfigMethod

/*!
  @const kSCPropNetIPv4DHCPClientID
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv4DHCPClientID                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv4DHCPClientID kSCPropNetIPv4DHCPClientID

/*!
  @const kSCPropNetIPv4Router
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv4Router                               API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv4Router kSCPropNetIPv4Router

/*!
  @const kSCPropNetIPv4SubnetMasks
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv4SubnetMasks                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv4SubnetMasks kSCPropNetIPv4SubnetMasks

/*!
  @const kSCPropNetIPv4DestAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv4DestAddresses                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv4DestAddresses kSCPropNetIPv4DestAddresses

/*!
  @const kSCPropNetIPv4BroadcastAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv4BroadcastAddresses                   API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv4BroadcastAddresses kSCPropNetIPv4BroadcastAddresses

/*!
  @const kSCValNetIPv4ConfigMethodAutomatic
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodAutomatic                 API_AVAILABLE(macos(10.6)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv4ConfigMethodAutomatic kSCValNetIPv4ConfigMethodAutomatic

/*!
  @const kSCValNetIPv4ConfigMethodBOOTP
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodBOOTP                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv4ConfigMethodBOOTP kSCValNetIPv4ConfigMethodBOOTP

/*!
  @const kSCValNetIPv4ConfigMethodDHCP
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodDHCP                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv4ConfigMethodDHCP kSCValNetIPv4ConfigMethodDHCP

/*!
  @const kSCValNetIPv4ConfigMethodINFORM
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodINFORM                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv4ConfigMethodINFORM kSCValNetIPv4ConfigMethodINFORM

/*!
  @const kSCValNetIPv4ConfigMethodLinkLocal
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodLinkLocal                 API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv4ConfigMethodLinkLocal kSCValNetIPv4ConfigMethodLinkLocal

/*!
  @const kSCValNetIPv4ConfigMethodManual
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodManual                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv4ConfigMethodManual kSCValNetIPv4ConfigMethodManual

/*!
  @const kSCValNetIPv4ConfigMethodPPP
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodPPP                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv4ConfigMethodPPP kSCValNetIPv4ConfigMethodPPP

/*!
  @group kSCEntNetIPv6 Entity Keys
 */

/*!
  @const kSCPropNetIPv6Addresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv6Addresses                            API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv6Addresses kSCPropNetIPv6Addresses

/*!
  @const kSCPropNetIPv6ConfigMethod
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv6ConfigMethod                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv6ConfigMethod kSCPropNetIPv6ConfigMethod

/*!
  @const kSCPropNetIPv6DestAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv6DestAddresses                        API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv6DestAddresses kSCPropNetIPv6DestAddresses

/*!
  @const kSCPropNetIPv6Flags
  @discussion Value is a CFArray[CFNumber]
 */
extern const CFStringRef kSCPropNetIPv6Flags                                API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv6Flags kSCPropNetIPv6Flags

/*!
  @const kSCPropNetIPv6PrefixLength
  @discussion Value is a CFArray[CFNumber]
 */
extern const CFStringRef kSCPropNetIPv6PrefixLength                         API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv6PrefixLength kSCPropNetIPv6PrefixLength

/*!
  @const kSCPropNetIPv6Router
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv6Router                               API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetIPv6Router kSCPropNetIPv6Router

/*!
  @const kSCValNetIPv6ConfigMethodAutomatic
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodAutomatic                 API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv6ConfigMethodAutomatic kSCValNetIPv6ConfigMethodAutomatic

/*!
  @const kSCValNetIPv6ConfigMethodLinkLocal
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodLinkLocal                 API_AVAILABLE(macos(10.7)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv6ConfigMethodLinkLocal kSCValNetIPv6ConfigMethodLinkLocal

/*!
  @const kSCValNetIPv6ConfigMethodManual
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodManual                    API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv6ConfigMethodManual kSCValNetIPv6ConfigMethodManual

/*!
  @const kSCValNetIPv6ConfigMethodRouterAdvertisement
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodRouterAdvertisement       API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv6ConfigMethodRouterAdvertisement kSCValNetIPv6ConfigMethodRouterAdvertisement

/*!
  @const kSCValNetIPv6ConfigMethod6to4
 */
extern const CFStringRef kSCValNetIPv6ConfigMethod6to4                      API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetIPv6ConfigMethod6to4 kSCValNetIPv6ConfigMethod6to4

/*!
  @group kSCEntNet6to4 Entity Keys
 */

/*!
  @const kSCPropNet6to4Relay
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNet6to4Relay                                API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNet6to4Relay kSCPropNet6to4Relay

/*!
  @group kSCEntNetLink Entity Keys
 */

/*!
  @const kSCPropNetLinkActive
  @discussion Value is a CFBoolean
 */
extern const CFStringRef kSCPropNetLinkActive                               API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetLinkActive kSCPropNetLinkActive

/*!
  @const kSCPropNetLinkDetaching
  @discussion Value is a CFBoolean
 */
extern const CFStringRef kSCPropNetLinkDetaching                            API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetLinkDetaching kSCPropNetLinkDetaching

/*!
  @group kSCEntNetModem (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetModemAccessPointName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemAccessPointName                     API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemAccessPointName kSCPropNetModemAccessPointName

/*!
  @const kSCPropNetModemConnectionPersonality
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemConnectionPersonality               API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemConnectionPersonality kSCPropNetModemConnectionPersonality

/*!
  @const kSCPropNetModemConnectionScript
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemConnectionScript                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemConnectionScript kSCPropNetModemConnectionScript

/*!
  @const kSCPropNetModemConnectSpeed
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetModemConnectSpeed                        API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemConnectSpeed kSCPropNetModemConnectSpeed

/*!
  @const kSCPropNetModemDataCompression
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemDataCompression                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemDataCompression kSCPropNetModemDataCompression

/*!
  @const kSCPropNetModemDeviceContextID
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemDeviceContextID                     API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemDeviceContextID kSCPropNetModemDeviceContextID

/*!
  @const kSCPropNetModemDeviceModel
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemDeviceModel                         API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemDeviceModel kSCPropNetModemDeviceModel

/*!
  @const kSCPropNetModemDeviceVendor
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemDeviceVendor                        API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemDeviceVendor kSCPropNetModemDeviceVendor

/*!
  @const kSCPropNetModemDialMode
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemDialMode                            API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemDialMode kSCPropNetModemDialMode

/*!
  @const kSCPropNetModemErrorCorrection
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemErrorCorrection                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemErrorCorrection kSCPropNetModemErrorCorrection

/*!
  @const kSCPropNetModemHoldCallWaitingAudibleAlert
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemHoldCallWaitingAudibleAlert         API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemHoldCallWaitingAudibleAlert kSCPropNetModemHoldCallWaitingAudibleAlert

/*!
  @const kSCPropNetModemHoldDisconnectOnAnswer
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemHoldDisconnectOnAnswer              API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemHoldDisconnectOnAnswer kSCPropNetModemHoldDisconnectOnAnswer

/*!
  @const kSCPropNetModemHoldEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemHoldEnabled                         API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemHoldEnabled kSCPropNetModemHoldEnabled

/*!
  @const kSCPropNetModemHoldReminder
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemHoldReminder                        API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemHoldReminder kSCPropNetModemHoldReminder

/*!
  @const kSCPropNetModemHoldReminderTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetModemHoldReminderTime                    API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemHoldReminderTime kSCPropNetModemHoldReminderTime

/*!
  @const kSCPropNetModemNote
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemNote                                API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemNote kSCPropNetModemNote

/*!
  @const kSCPropNetModemPulseDial
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemPulseDial                           API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemPulseDial kSCPropNetModemPulseDial

/*!
  @const kSCPropNetModemSpeaker
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemSpeaker                             API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemSpeaker kSCPropNetModemSpeaker

/*!
  @const kSCPropNetModemSpeed
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetModemSpeed                               API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetModemSpeed kSCPropNetModemSpeed

/*!
  @const kSCValNetModemDialModeIgnoreDialTone
 */
extern const CFStringRef kSCValNetModemDialModeIgnoreDialTone               API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetModemDialModeIgnoreDialTone kSCValNetModemDialModeIgnoreDialTone

/*!
  @const kSCValNetModemDialModeManual
 */
extern const CFStringRef kSCValNetModemDialModeManual                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetModemDialModeManual kSCValNetModemDialModeManual

/*!
  @const kSCValNetModemDialModeWaitForDialTone
 */
extern const CFStringRef kSCValNetModemDialModeWaitForDialTone              API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetModemDialModeWaitForDialTone kSCValNetModemDialModeWaitForDialTone

/*!
  @group kSCEntNetPPP Entity Keys
 */

/*!
  @const kSCPropNetPPPACSPEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPACSPEnabled                           API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPACSPEnabled kSCPropNetPPPACSPEnabled

/*!
  @const kSCPropNetPPPConnectTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPConnectTime                           API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPConnectTime kSCPropNetPPPConnectTime

/*!
  @const kSCPropNetPPPDeviceLastCause
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPDeviceLastCause                       API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPDeviceLastCause kSCPropNetPPPDeviceLastCause

/*!
  @const kSCPropNetPPPDialOnDemand
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDialOnDemand                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPDialOnDemand kSCPropNetPPPDialOnDemand

/*!
  @const kSCPropNetPPPDisconnectOnFastUserSwitch
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnFastUserSwitch            API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPDisconnectOnFastUserSwitch kSCPropNetPPPDisconnectOnFastUserSwitch

/*!
  @const kSCPropNetPPPDisconnectOnIdle
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnIdle                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPDisconnectOnIdle kSCPropNetPPPDisconnectOnIdle

/*!
  @const kSCPropNetPPPDisconnectOnIdleTimer
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnIdleTimer                 API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPDisconnectOnIdleTimer kSCPropNetPPPDisconnectOnIdleTimer

/*!
  @const kSCPropNetPPPDisconnectOnLogout
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnLogout                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPDisconnectOnLogout kSCPropNetPPPDisconnectOnLogout

/*!
  @const kSCPropNetPPPDisconnectOnSleep
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnSleep                     API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPDisconnectOnSleep kSCPropNetPPPDisconnectOnSleep

/*!
  @const kSCPropNetPPPDisconnectTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPDisconnectTime                        API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPDisconnectTime kSCPropNetPPPDisconnectTime

/*!
  @const kSCPropNetPPPIdleReminder
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPIdleReminder                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPIdleReminder kSCPropNetPPPIdleReminder

/*!
  @const kSCPropNetPPPIdleReminderTimer
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPIdleReminderTimer                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPIdleReminderTimer kSCPropNetPPPIdleReminderTimer

/*!
  @const kSCPropNetPPPLastCause
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLastCause                             API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLastCause kSCPropNetPPPLastCause

/*!
  @const kSCPropNetPPPLogfile
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPLogfile                               API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLogfile kSCPropNetPPPLogfile

/*!
  @const kSCPropNetPPPPlugins
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetPPPPlugins                               API_DEPRECATED("No longer supported", macos(10.2,10.15)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPPlugins kSCPropNetPPPPlugins

/*!
  @const kSCPropNetPPPRetryConnectTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPRetryConnectTime                      API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPRetryConnectTime kSCPropNetPPPRetryConnectTime

/*!
  @const kSCPropNetPPPSessionTimer
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPSessionTimer                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPSessionTimer kSCPropNetPPPSessionTimer

/*!
  @const kSCPropNetPPPStatus
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPStatus                                API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPStatus kSCPropNetPPPStatus

/*!
  @const kSCPropNetPPPUseSessionTimer
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPUseSessionTimer                       API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPUseSessionTimer kSCPropNetPPPUseSessionTimer

/*!
  @const kSCPropNetPPPVerboseLogging
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPVerboseLogging                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPVerboseLogging kSCPropNetPPPVerboseLogging

/*!
  @const kSCPropNetPPPAuthEAPPlugins
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetPPPAuthEAPPlugins                        API_DEPRECATED("No longer supported", macos(10.3,10.15)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPAuthEAPPlugins kSCPropNetPPPAuthEAPPlugins

/*!
  @const kSCPropNetPPPAuthName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPAuthName                              API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPAuthName kSCPropNetPPPAuthName

/*!
  @const kSCPropNetPPPAuthPassword
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPAuthPassword                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPAuthPassword kSCPropNetPPPAuthPassword

/*!
  @const kSCPropNetPPPAuthPasswordEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPAuthPasswordEncryption                API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPAuthPasswordEncryption kSCPropNetPPPAuthPasswordEncryption

/*!
  @const kSCPropNetPPPAuthPrompt
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPAuthPrompt                            API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPAuthPrompt kSCPropNetPPPAuthPrompt

/*!
  @const kSCPropNetPPPAuthProtocol
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetPPPAuthProtocol                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPAuthProtocol kSCPropNetPPPAuthProtocol

/*!
  @const kSCValNetPPPAuthPasswordEncryptionKeychain
 */
extern const CFStringRef kSCValNetPPPAuthPasswordEncryptionKeychain         API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthPasswordEncryptionKeychain kSCValNetPPPAuthPasswordEncryptionKeychain

/*!
  @const kSCValNetPPPAuthPasswordEncryptionToken
 */
extern const CFStringRef kSCValNetPPPAuthPasswordEncryptionToken            API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthPasswordEncryptionToken kSCValNetPPPAuthPasswordEncryptionToken

/*!
  @const kSCValNetPPPAuthPromptBefore
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthPromptBefore                       API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthPromptBefore kSCValNetPPPAuthPromptBefore

/*!
  @const kSCValNetPPPAuthPromptAfter
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthPromptAfter                        API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthPromptAfter kSCValNetPPPAuthPromptAfter

/*!
  @const kSCValNetPPPAuthProtocolCHAP
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolCHAP                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthProtocolCHAP kSCValNetPPPAuthProtocolCHAP

/*!
  @const kSCValNetPPPAuthProtocolEAP
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolEAP                        API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthProtocolEAP kSCValNetPPPAuthProtocolEAP

/*!
  @const kSCValNetPPPAuthProtocolMSCHAP1
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolMSCHAP1                    API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthProtocolMSCHAP1 kSCValNetPPPAuthProtocolMSCHAP1

/*!
  @const kSCValNetPPPAuthProtocolMSCHAP2
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolMSCHAP2                    API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthProtocolMSCHAP2 kSCValNetPPPAuthProtocolMSCHAP2

/*!
  @const kSCValNetPPPAuthProtocolPAP
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolPAP                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetPPPAuthProtocolPAP kSCValNetPPPAuthProtocolPAP

/*!
  @const kSCPropNetPPPCommAlternateRemoteAddress
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPCommAlternateRemoteAddress            API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommAlternateRemoteAddress kSCPropNetPPPCommAlternateRemoteAddress

/*!
  @const kSCPropNetPPPCommConnectDelay
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPCommConnectDelay                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommConnectDelay kSCPropNetPPPCommConnectDelay

/*!
  @const kSCPropNetPPPCommDisplayTerminalWindow
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCommDisplayTerminalWindow             API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommDisplayTerminalWindow kSCPropNetPPPCommDisplayTerminalWindow

/*!
  @const kSCPropNetPPPCommRedialCount
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPCommRedialCount                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommRedialCount kSCPropNetPPPCommRedialCount

/*!
  @const kSCPropNetPPPCommRedialEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCommRedialEnabled                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommRedialEnabled kSCPropNetPPPCommRedialEnabled

/*!
  @const kSCPropNetPPPCommRedialInterval
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPCommRedialInterval                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommRedialInterval kSCPropNetPPPCommRedialInterval

/*!
  @const kSCPropNetPPPCommRemoteAddress
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPCommRemoteAddress                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommRemoteAddress kSCPropNetPPPCommRemoteAddress

/*!
  @const kSCPropNetPPPCommTerminalScript
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPCommTerminalScript                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommTerminalScript kSCPropNetPPPCommTerminalScript

/*!
  @const kSCPropNetPPPCommUseTerminalScript
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCommUseTerminalScript                 API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCommUseTerminalScript kSCPropNetPPPCommUseTerminalScript

/*!
  @const kSCPropNetPPPCCPEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCCPEnabled                            API_AVAILABLE(macos(10.2)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCCPEnabled kSCPropNetPPPCCPEnabled

/*!
  @const kSCPropNetPPPCCPMPPE40Enabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCCPMPPE40Enabled                      API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCCPMPPE40Enabled kSCPropNetPPPCCPMPPE40Enabled

/*!
  @const kSCPropNetPPPCCPMPPE128Enabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCCPMPPE128Enabled                     API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPCCPMPPE128Enabled kSCPropNetPPPCCPMPPE128Enabled

/*!
  @const kSCPropNetPPPIPCPCompressionVJ
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPIPCPCompressionVJ                     API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPIPCPCompressionVJ kSCPropNetPPPIPCPCompressionVJ

/*!
  @const kSCPropNetPPPIPCPUsePeerDNS
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPIPCPUsePeerDNS                        API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPIPCPUsePeerDNS kSCPropNetPPPIPCPUsePeerDNS

/*!
  @const kSCPropNetPPPLCPEchoEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPLCPEchoEnabled                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPEchoEnabled kSCPropNetPPPLCPEchoEnabled

/*!
  @const kSCPropNetPPPLCPEchoFailure
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPEchoFailure                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPEchoFailure kSCPropNetPPPLCPEchoFailure

/*!
  @const kSCPropNetPPPLCPEchoInterval
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPEchoInterval                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPEchoInterval kSCPropNetPPPLCPEchoInterval

/*!
  @const kSCPropNetPPPLCPCompressionACField
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPLCPCompressionACField                 API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPCompressionACField kSCPropNetPPPLCPCompressionACField

/*!
  @const kSCPropNetPPPLCPCompressionPField
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPLCPCompressionPField                  API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPCompressionPField kSCPropNetPPPLCPCompressionPField

/*!
  @const kSCPropNetPPPLCPMRU
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPMRU                                API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPMRU kSCPropNetPPPLCPMRU

/*!
  @const kSCPropNetPPPLCPMTU
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPMTU                                API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPMTU kSCPropNetPPPLCPMTU

/*!
  @const kSCPropNetPPPLCPReceiveACCM
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPReceiveACCM                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPReceiveACCM kSCPropNetPPPLCPReceiveACCM

/*!
  @const kSCPropNetPPPLCPTransmitACCM
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPTransmitACCM                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetPPPLCPTransmitACCM kSCPropNetPPPLCPTransmitACCM

/*!
  @group kSCEntNetPPPoE Entity Keys
 */

/*!
  @group kSCEntNetPPPSerial Entity Keys
 */

/*!
  @group kSCEntNetL2TP Entity Keys
 */

/*!
  @const kSCPropNetL2TPIPSecSharedSecret
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetL2TPIPSecSharedSecret                    API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetL2TPIPSecSharedSecret kSCPropNetL2TPIPSecSharedSecret

/*!
  @const kSCPropNetL2TPIPSecSharedSecretEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetL2TPIPSecSharedSecretEncryption          API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetL2TPIPSecSharedSecretEncryption kSCPropNetL2TPIPSecSharedSecretEncryption

/*!
  @const kSCPropNetL2TPTransport
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetL2TPTransport                            API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetL2TPTransport kSCPropNetL2TPTransport

/*!
  @const kSCValNetL2TPIPSecSharedSecretEncryptionKeychain
 */
extern const CFStringRef kSCValNetL2TPIPSecSharedSecretEncryptionKeychain   API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetL2TPIPSecSharedSecretEncryptionKeychain kSCValNetL2TPIPSecSharedSecretEncryptionKeychain

/*!
  @const kSCValNetL2TPTransportIP
 */
extern const CFStringRef kSCValNetL2TPTransportIP                           API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetL2TPTransportIP kSCValNetL2TPTransportIP

/*!
  @const kSCValNetL2TPTransportIPSec
 */
extern const CFStringRef kSCValNetL2TPTransportIPSec                        API_AVAILABLE(macos(10.3)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetL2TPTransportIPSec kSCValNetL2TPTransportIPSec

/*!
  @group kSCEntNetProxies Entity Keys
 */

/*!
  @const kSCPropNetProxiesExceptionsList
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetProxiesExceptionsList                    API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesExceptionsList kSCPropNetProxiesExceptionsList

/*!
  @const kSCPropNetProxiesExcludeSimpleHostnames
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesExcludeSimpleHostnames            API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesExcludeSimpleHostnames kSCPropNetProxiesExcludeSimpleHostnames

/*!
  @const kSCPropNetProxiesFTPEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesFTPEnable                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesFTPEnable kSCPropNetProxiesFTPEnable

/*!
  @const kSCPropNetProxiesFTPPassive
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesFTPPassive                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesFTPPassive kSCPropNetProxiesFTPPassive

/*!
  @const kSCPropNetProxiesFTPPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesFTPPort                           API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesFTPPort kSCPropNetProxiesFTPPort

/*!
  @const kSCPropNetProxiesFTPProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesFTPProxy                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesFTPProxy kSCPropNetProxiesFTPProxy

/*!
  @const kSCPropNetProxiesFTPUser
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesFTPUser                           API_AVAILABLE(macos(15.0)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesFTPUser kSCPropNetProxiesFTPUser

/*!
  @const kSCPropNetProxiesGopherEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesGopherEnable                      API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesGopherEnable kSCPropNetProxiesGopherEnable

/*!
  @const kSCPropNetProxiesGopherPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesGopherPort                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesGopherPort kSCPropNetProxiesGopherPort

/*!
  @const kSCPropNetProxiesGopherProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesGopherProxy                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesGopherProxy kSCPropNetProxiesGopherProxy

/*!
  @const kSCPropNetProxiesGopherUser
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesGopherUser                        API_AVAILABLE(macos(15.0)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesGopherUser kSCPropNetProxiesGopherUser

/*!
  @const kSCPropNetProxiesHTTPEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesHTTPEnable                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesHTTPEnable kSCPropNetProxiesHTTPEnable

/*!
  @const kSCPropNetProxiesHTTPPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesHTTPPort                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesHTTPPort kSCPropNetProxiesHTTPPort

/*!
  @const kSCPropNetProxiesHTTPProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesHTTPProxy                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesHTTPProxy kSCPropNetProxiesHTTPProxy

/*!
  @const kSCPropNetProxiesHTTPUser
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesHTTPUser                          API_AVAILABLE(macos(15.0)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesHTTPUser kSCPropNetProxiesHTTPUser

/*!
  @const kSCPropNetProxiesHTTPSEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesHTTPSEnable                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesHTTPSEnable kSCPropNetProxiesHTTPSEnable

/*!
  @const kSCPropNetProxiesHTTPSPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesHTTPSPort                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesHTTPSPort kSCPropNetProxiesHTTPSPort

/*!
  @const kSCPropNetProxiesHTTPSProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesHTTPSProxy                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesHTTPSProxy kSCPropNetProxiesHTTPSProxy

/*!
  @const kSCPropNetProxiesHTTPSUser
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesHTTPSUser                         API_AVAILABLE(macos(15.0)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesHTTPSUser kSCPropNetProxiesHTTPSUser

/*!
  @const kSCPropNetProxiesRTSPEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesRTSPEnable                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesRTSPEnable kSCPropNetProxiesRTSPEnable

/*!
  @const kSCPropNetProxiesRTSPPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesRTSPPort                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesRTSPPort kSCPropNetProxiesRTSPPort

/*!
  @const kSCPropNetProxiesRTSPProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesRTSPProxy                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesRTSPProxy kSCPropNetProxiesRTSPProxy

/*!
  @const kSCPropNetProxiesRTSPUser
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesRTSPUser                          API_AVAILABLE(macos(15.0)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesRTSPUser kSCPropNetProxiesRTSPUser

/*!
  @const kSCPropNetProxiesSOCKSEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesSOCKSEnable                       API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesSOCKSEnable kSCPropNetProxiesSOCKSEnable

/*!
  @const kSCPropNetProxiesSOCKSPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesSOCKSPort                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesSOCKSPort kSCPropNetProxiesSOCKSPort

/*!
  @const kSCPropNetProxiesSOCKSProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesSOCKSProxy                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesSOCKSProxy kSCPropNetProxiesSOCKSProxy

/*!
  @const kSCPropNetProxiesSOCKSUser
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesSOCKSUser                         API_AVAILABLE(macos(15.0)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesSOCKSUser kSCPropNetProxiesSOCKSUser

/*!
  @const kSCPropNetProxiesProxyAutoConfigEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoConfigEnable             API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesProxyAutoConfigEnable kSCPropNetProxiesProxyAutoConfigEnable

/*!
  @const kSCPropNetProxiesProxyAutoConfigJavaScript
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoConfigJavaScript         API_AVAILABLE(macos(10.7)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesProxyAutoConfigJavaScript kSCPropNetProxiesProxyAutoConfigJavaScript

/*!
  @const kSCPropNetProxiesProxyAutoConfigURLString
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoConfigURLString          API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesProxyAutoConfigURLString kSCPropNetProxiesProxyAutoConfigURLString

/*!
  @const kSCPropNetProxiesProxyAutoDiscoveryEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoDiscoveryEnable          API_AVAILABLE(macos(10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetProxiesProxyAutoDiscoveryEnable kSCPropNetProxiesProxyAutoDiscoveryEnable

/*!
  @group kSCEntNetSMB Entity Keys
 */

/*!
  @const kSCPropNetSMBNetBIOSName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetSMBNetBIOSName                           API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetSMBNetBIOSName kSCPropNetSMBNetBIOSName

/*!
  @const kSCPropNetSMBNetBIOSNodeType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetSMBNetBIOSNodeType                       API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetSMBNetBIOSNodeType kSCPropNetSMBNetBIOSNodeType

/*!
  @const kSCPropNetSMBNetBIOSScope
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetSMBNetBIOSScope                          API_DEPRECATED("No longer supported", macos(10.5,10.7)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetSMBNetBIOSScope kSCPropNetSMBNetBIOSScope

/*!
  @const kSCPropNetSMBWINSAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetSMBWINSAddresses                         API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetSMBWINSAddresses kSCPropNetSMBWINSAddresses

/*!
  @const kSCPropNetSMBWorkgroup
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetSMBWorkgroup                             API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropNetSMBWorkgroup kSCPropNetSMBWorkgroup

/*!
  @const kSCValNetSMBNetBIOSNodeTypeBroadcast
 */
extern const CFStringRef kSCValNetSMBNetBIOSNodeTypeBroadcast               API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetSMBNetBIOSNodeTypeBroadcast kSCValNetSMBNetBIOSNodeTypeBroadcast

/*!
  @const kSCValNetSMBNetBIOSNodeTypePeer
 */
extern const CFStringRef kSCValNetSMBNetBIOSNodeTypePeer                    API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetSMBNetBIOSNodeTypePeer kSCValNetSMBNetBIOSNodeTypePeer

/*!
  @const kSCValNetSMBNetBIOSNodeTypeMixed
 */
extern const CFStringRef kSCValNetSMBNetBIOSNodeTypeMixed                   API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetSMBNetBIOSNodeTypeMixed kSCValNetSMBNetBIOSNodeTypeMixed

/*!
  @const kSCValNetSMBNetBIOSNodeTypeHybrid
 */
extern const CFStringRef kSCValNetSMBNetBIOSNodeTypeHybrid                  API_AVAILABLE(macos(10.5)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCValNetSMBNetBIOSNodeTypeHybrid kSCValNetSMBNetBIOSNodeTypeHybrid

/*!
  @group kSCCompUsers Entity Keys
 */

/*!
  @const kSCEntUsersConsoleUser
 */
extern const CFStringRef kSCEntUsersConsoleUser                             API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCEntUsersConsoleUser kSCEntUsersConsoleUser

/*!
  @group kSCCompSystem Properties
 */

/*!
  @const kSCPropSystemComputerName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropSystemComputerName                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropSystemComputerName kSCPropSystemComputerName

/*!
  @const kSCPropSystemComputerNameEncoding
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropSystemComputerNameEncoding                  API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropSystemComputerNameEncoding kSCPropSystemComputerNameEncoding

/*!
  @group SCDynamicStore "domain" prefixes
 */

/*!
  @const kSCDynamicStoreDomainFile
 */
extern const CFStringRef kSCDynamicStoreDomainFile                          API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStoreDomainFile kSCDynamicStoreDomainFile

/*!
  @const kSCDynamicStoreDomainPlugin
 */
extern const CFStringRef kSCDynamicStoreDomainPlugin                        API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStoreDomainPlugin kSCDynamicStoreDomainPlugin

/*!
  @const kSCDynamicStoreDomainSetup
 */
extern const CFStringRef kSCDynamicStoreDomainSetup                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStoreDomainSetup kSCDynamicStoreDomainSetup

/*!
  @const kSCDynamicStoreDomainState
 */
extern const CFStringRef kSCDynamicStoreDomainState                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStoreDomainState kSCDynamicStoreDomainState

/*!
  @const kSCDynamicStoreDomainPrefs
 */
extern const CFStringRef kSCDynamicStoreDomainPrefs                         API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStoreDomainPrefs kSCDynamicStoreDomainPrefs

/*!
  @group Preference ("location") Keys
 */

/*!
  @const kSCDynamicStorePropSetupCurrentSet
  @discussion Value is a CFString
 */
extern const CFStringRef kSCDynamicStorePropSetupCurrentSet                 API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStorePropSetupCurrentSet kSCDynamicStorePropSetupCurrentSet

/*!
  @const kSCDynamicStorePropSetupLastUpdated
 */
extern const CFStringRef kSCDynamicStorePropSetupLastUpdated                API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStorePropSetupLastUpdated kSCDynamicStorePropSetupLastUpdated

/*!
  @group Common/shared Keys
 */

/*!
  @const kSCDynamicStorePropNetInterfaces
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCDynamicStorePropNetInterfaces                   API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStorePropNetInterfaces kSCDynamicStorePropNetInterfaces

/*!
  @const kSCDynamicStorePropNetPrimaryInterface
  @discussion Value is a CFString
 */
extern const CFStringRef kSCDynamicStorePropNetPrimaryInterface             API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStorePropNetPrimaryInterface kSCDynamicStorePropNetPrimaryInterface

/*!
  @const kSCDynamicStorePropNetPrimaryService
  @discussion Value is a CFString
 */
extern const CFStringRef kSCDynamicStorePropNetPrimaryService               API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStorePropNetPrimaryService kSCDynamicStorePropNetPrimaryService

/*!
  @const kSCDynamicStorePropNetServiceIDs
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCDynamicStorePropNetServiceIDs                   API_AVAILABLE(macos(10.1)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCDynamicStorePropNetServiceIDs kSCDynamicStorePropNetServiceIDs

/*!
  @const kSCPropUsersConsoleUserName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropUsersConsoleUserName                        API_DEPRECATED("No longer supported", macos(10.1,10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropUsersConsoleUserName kSCPropUsersConsoleUserName

/*!
  @const kSCPropUsersConsoleUserUID
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropUsersConsoleUserUID                         API_DEPRECATED("No longer supported", macos(10.1,10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropUsersConsoleUserUID kSCPropUsersConsoleUserUID

/*!
  @const kSCPropUsersConsoleUserGID
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropUsersConsoleUserGID                         API_DEPRECATED("No longer supported", macos(10.1,10.4)) API_UNAVAILABLE(ios, tvos, watchos);
#define kSCPropUsersConsoleUserGID kSCPropUsersConsoleUserGID

CF_ASSUME_NONNULL_END

#endif	/* _SCSCHEMADEFINITIONS_H */
