//
//  IOBluetoothPasskeyDisplay.h
//  Copyright 2010, 2023 Apple, Inc.. All rights reserved.
//

#if __OBJC__

#import <Cocoa/Cocoa.h>
#import <Availability.h>

@class IOBluetoothDevice;

typedef enum {
    kBluetoothKeyboardANSIReturn,
	kBluetoothKeyboardISOReturn,
    kBluetoothKeyboardJISReturn,
    kBluetoothKeyboardNoReturn
} BluetoothKeyboardReturnType;

API_UNAVAILABLE_BEGIN(ios)
@interface IOBluetoothPasskeyDisplay : NSView
{
	IBOutlet NSImageView *		mReturnImageView;
	NSImage *					mReturnImage;
	NSImage *					mReturnHighlightImage;
	IBOutlet NSImageView *		mBackgroundImage;
	
	BOOL						usePasskeyNotifications;
    BOOL                        isIncomingRequest;
    BOOL						showFeedback;
    NSString *					passkey;
    IBOutlet NSTextField *		mPasskeyString;
    
	NSMutableArray *			mPasskeyCharacters;
	NSUInteger					mPasskeyIndex;
}

// Private
@property (assign)	BOOL			usePasskeyNotificaitons;
@property (assign)	BOOL			isIncomingRequest;
@property (copy)	NSString *		passkey;
@property (retain)	NSImage *		returnImage;
@property (retain)	NSImage *		returnHighlightImage;

@property (assign) IBOutlet NSView *centeredView;
@property (assign) IBOutlet NSLayoutConstraint *backgroundImageConstraint;


// Public
+ (IOBluetoothPasskeyDisplay *) sharedDisplayView;

- (void) setPasskey:(NSString *)inString forDevice:(IOBluetoothDevice *)device usingSSP:(BOOL)isSSP;

- (void) advancePasskeyIndicator;
- (void) retreatPasskeyIndicator;
- (void) resetPasskeyIndicator;



// Deprecated methods
- (void) setupUIForDevice:(IOBluetoothDevice *)device DEPRECATED_IN_MAC_OS_X_VERSION_10_8_AND_LATER;
- (void) setupUIForSSPDevice:(IOBluetoothDevice *)device DEPRECATED_IN_MAC_OS_X_VERSION_10_8_AND_LATER;

// Must be called after setupUIFor(SSP)Device is called
- (void) setPasskeyString:(NSString *)inString DEPRECATED_IN_MAC_OS_X_VERSION_10_8_AND_LATER;
- (void) setPasskeyIndicatorEnabled:(BOOL)inEnabled DEPRECATED_IN_MAC_OS_X_VERSION_10_8_AND_LATER;
- (void) resetAll DEPRECATED_IN_MAC_OS_X_VERSION_10_8_AND_LATER;

@end

// Accessiblity support
@interface IOBluetoothAccessibilityIgnoredTextFieldCell : NSTextFieldCell {}
@end

@interface IOBluetoothAccessibilityIgnoredImageCell: NSImageCell {}
@end
API_UNAVAILABLE_END

#endif // __OBJC__

