//
//  CLMonitorConfiguration.h
//  CoreLocation
//
//  Created by NivashRaaja on 1/26/23.
//

#pragma once
#import <Foundation/Foundation.h>
#import <CoreLocation/CLAvailability.h>
#import <CoreLocation/CLCondition.h>

NS_ASSUME_NONNULL_BEGIN

@class CLLocationManager;
@class CLMonitor;
@class CLMonitoringEvent;
/*
 *		`CLMonitorConfiguration` describes the configuration with which a `CLMonitor`
 *		instance can be created.
 *
 */
NS_REFINED_FOR_SWIFT NS_SWIFT_SENDABLE
CL_EXTERN
API_AVAILABLE(macos(14.0), ios(17.0)) API_UNAVAILABLE(watchos, tvos, visionos)
@interface CLMonitorConfiguration : NSObject

/*
 *	name
 *
 *	Discussion:
 *		Name of the Monitor instance to create or open.
 *
 */
@property (readonly) NSString *name;

/*
 *	queue
 *
 *	Discussion:
 *		Dispatch queue to which the instance of `CLMonitor` will be bound.
 *
 */
@property (readonly) dispatch_queue_t queue;

/*
 *	handler
 *
 *	Discussion:
 *		Handler block which will be used as the event handler for the `CLMonitor` instance.
 *
 */
@property (readonly, nonatomic) void(^eventHandler)(CLMonitor *monitor, CLMonitoringEvent *event);

/*
 *		Returns a configuration object which may be used to create or open
 *		an instance of `CLMonitor`.
 *
 *		name	: 	Identifies the instance of `CLMonitor` which should be created or opened.
 *					`name` should contain only alpha-numeric characters and cannot start with "_".
 *		queue	: 	Dispatch queue which should be used to synchronize access to the CLMonitor instance.
 *					All interactions related to the `CLMonitor` instance should be performed on this queue.
 *					Events generated by the `CLMonitor` instance will be delivered to the handler on this queue.
 *					Accessing `CLMonitor` outside of the queue will result in undefined behavior.
 *		handler	: 	The callback handler to be submitted to `queue`
 *					for each event.
 *
 */

+ (CLMonitorConfiguration *)configWithMonitorName:(NSString *)name
											queue:(dispatch_queue_t)queue
									 eventHandler:(void(^)(CLMonitor *monitor, CLMonitoringEvent *event))eventHandler;

@end


NS_ASSUME_NONNULL_END
