/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.LittleEndianByteArray;

@ElementTypesAreNonnullByDefault
final class FarmHashFingerprint64
extends AbstractNonStreamingHashFunction {
    static final HashFunction FARMHASH_FINGERPRINT_64 = new FarmHashFingerprint64();
    private static final long K0 = -4348849565147123417L;
    private static final long K1 = -5435081209227447693L;
    private static final long K2 = -7286425919675154353L;

    FarmHashFingerprint64() {
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        return HashCode.fromLong(FarmHashFingerprint64.fingerprint(input, off, len));
    }

    @Override
    public int bits() {
        return 64;
    }

    public String toString() {
        return "Hashing.farmHashFingerprint64()";
    }

    @VisibleForTesting
    static long fingerprint(byte[] bytes, int offset, int length) {
        if (length <= 32) {
            if (length <= 16) {
                return FarmHashFingerprint64.hashLength0to16(bytes, offset, length);
            }
            return FarmHashFingerprint64.hashLength17to32(bytes, offset, length);
        }
        if (length <= 64) {
            return FarmHashFingerprint64.hashLength33To64(bytes, offset, length);
        }
        return FarmHashFingerprint64.hashLength65Plus(bytes, offset, length);
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long hashLength16(long u11, long v11, long mul) {
        long a11 = (u11 ^ v11) * mul;
        a11 ^= a11 >>> 47;
        long b11 = (v11 ^ a11) * mul;
        b11 ^= b11 >>> 47;
        return b11 *= mul;
    }

    private static void weakHashLength32WithSeeds(byte[] bytes, int offset, long seedA, long seedB, long[] output) {
        long part1 = LittleEndianByteArray.load64(bytes, offset);
        long part2 = LittleEndianByteArray.load64(bytes, offset + 8);
        long part3 = LittleEndianByteArray.load64(bytes, offset + 16);
        long part4 = LittleEndianByteArray.load64(bytes, offset + 24);
        seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 21);
        long c11 = seedA;
        seedA += part2;
        output[0] = seedA + part4;
        output[1] = (seedB += Long.rotateRight(seedA += part3, 44)) + c11;
    }

    private static long hashLength0to16(byte[] bytes, int offset, int length) {
        if (length >= 8) {
            long mul = -7286425919675154353L + (long)length * 2L;
            long a11 = LittleEndianByteArray.load64(bytes, offset) + -7286425919675154353L;
            long b11 = LittleEndianByteArray.load64(bytes, offset + length - 8);
            long c11 = Long.rotateRight(b11, 37) * mul + a11;
            long d11 = (Long.rotateRight(a11, 25) + b11) * mul;
            return FarmHashFingerprint64.hashLength16(c11, d11, mul);
        }
        if (length >= 4) {
            long mul = -7286425919675154353L + (long)(length * 2);
            long a12 = (long)LittleEndianByteArray.load32(bytes, offset) & 0xFFFFFFFFL;
            return FarmHashFingerprint64.hashLength16((long)length + (a12 << 3), (long)LittleEndianByteArray.load32(bytes, offset + length - 4) & 0xFFFFFFFFL, mul);
        }
        if (length > 0) {
            byte a13 = bytes[offset];
            byte b12 = bytes[offset + (length >> 1)];
            byte c12 = bytes[offset + (length - 1)];
            int y11 = (a13 & 0xFF) + ((b12 & 0xFF) << 8);
            int z11 = length + ((c12 & 0xFF) << 2);
            return FarmHashFingerprint64.shiftMix((long)y11 * -7286425919675154353L ^ (long)z11 * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLength17to32(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)length * 2L;
        long a11 = LittleEndianByteArray.load64(bytes, offset) * -5435081209227447693L;
        long b11 = LittleEndianByteArray.load64(bytes, offset + 8);
        long c11 = LittleEndianByteArray.load64(bytes, offset + length - 8) * mul;
        long d11 = LittleEndianByteArray.load64(bytes, offset + length - 16) * -7286425919675154353L;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(a11 + b11, 43) + Long.rotateRight(c11, 30) + d11, a11 + Long.rotateRight(b11 + -7286425919675154353L, 18) + c11, mul);
    }

    private static long hashLength33To64(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)length * 2L;
        long a11 = LittleEndianByteArray.load64(bytes, offset) * -7286425919675154353L;
        long b11 = LittleEndianByteArray.load64(bytes, offset + 8);
        long c11 = LittleEndianByteArray.load64(bytes, offset + length - 8) * mul;
        long d11 = LittleEndianByteArray.load64(bytes, offset + length - 16) * -7286425919675154353L;
        long y11 = Long.rotateRight(a11 + b11, 43) + Long.rotateRight(c11, 30) + d11;
        long z11 = FarmHashFingerprint64.hashLength16(y11, a11 + Long.rotateRight(b11 + -7286425919675154353L, 18) + c11, mul);
        long e11 = LittleEndianByteArray.load64(bytes, offset + 16) * mul;
        long f11 = LittleEndianByteArray.load64(bytes, offset + 24);
        long g11 = (y11 + LittleEndianByteArray.load64(bytes, offset + length - 32)) * mul;
        long h11 = (z11 + LittleEndianByteArray.load64(bytes, offset + length - 24)) * mul;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(e11 + f11, 43) + Long.rotateRight(g11, 30) + h11, e11 + Long.rotateRight(f11 + a11, 18) + g11, mul);
    }

    private static long hashLength65Plus(byte[] bytes, int offset, int length) {
        int seed = 81;
        long x11 = seed;
        long y11 = (long)seed * -5435081209227447693L + 113L;
        long z11 = FarmHashFingerprint64.shiftMix(y11 * -7286425919675154353L + 113L) * -7286425919675154353L;
        long[] v11 = new long[2];
        long[] w11 = new long[2];
        x11 = x11 * -7286425919675154353L + LittleEndianByteArray.load64(bytes, offset);
        int end = offset + (length - 1) / 64 * 64;
        int last64offset = end + (length - 1 & 0x3F) - 63;
        do {
            x11 = Long.rotateRight(x11 + y11 + v11[0] + LittleEndianByteArray.load64(bytes, offset + 8), 37) * -5435081209227447693L;
            y11 = Long.rotateRight(y11 + v11[1] + LittleEndianByteArray.load64(bytes, offset + 48), 42) * -5435081209227447693L;
            z11 = Long.rotateRight(z11 + w11[0], 33) * -5435081209227447693L;
            FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset, v11[1] * -5435081209227447693L, (x11 ^= w11[1]) + w11[0], v11);
            FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset + 32, z11 + w11[1], (y11 += v11[0] + LittleEndianByteArray.load64(bytes, offset + 40)) + LittleEndianByteArray.load64(bytes, offset + 16), w11);
            long tmp = x11;
            x11 = z11;
            z11 = tmp;
        } while ((offset += 64) != end);
        long mul = -5435081209227447693L + ((z11 & 0xFFL) << 1);
        offset = last64offset;
        w11[0] = w11[0] + (long)(length - 1 & 0x3F);
        v11[0] = v11[0] + w11[0];
        w11[0] = w11[0] + v11[0];
        x11 = Long.rotateRight(x11 + y11 + v11[0] + LittleEndianByteArray.load64(bytes, offset + 8), 37) * mul;
        y11 = Long.rotateRight(y11 + v11[1] + LittleEndianByteArray.load64(bytes, offset + 48), 42) * mul;
        z11 = Long.rotateRight(z11 + w11[0], 33) * mul;
        FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset, v11[1] * mul, (x11 ^= w11[1] * 9L) + w11[0], v11);
        FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset + 32, z11 + w11[1], (y11 += v11[0] * 9L + LittleEndianByteArray.load64(bytes, offset + 40)) + LittleEndianByteArray.load64(bytes, offset + 16), w11);
        return FarmHashFingerprint64.hashLength16(FarmHashFingerprint64.hashLength16(v11[0], w11[0], mul) + FarmHashFingerprint64.shiftMix(y11) * -4348849565147123417L + x11, FarmHashFingerprint64.hashLength16(v11[1], w11[1], mul) + z11, mul);
    }
}

