/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.validation.SubValidator;
import java.util.zip.ZipFile;

public class SdkModulesConfigValidator
extends SubValidator {
    @Override
    public void validateSdkBundle(SdkBundle sdkBundle) {
        this.validateSdkModulesConfig(sdkBundle.getSdkModulesConfig());
    }

    @Override
    public void validateSdkModulesZipFile(ZipFile modulesFile) {
        SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig = BundleParser.readSdkModulesConfig(modulesFile);
        this.validateSdkModulesConfig(sdkModulesConfig);
    }

    private void validateSdkModulesConfig(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        this.validateSdkVersion(sdkModulesConfig);
        this.validateBundletoolVersion(sdkModulesConfig);
        this.validateSdkPackageName(sdkModulesConfig);
        this.validateSdkProviderClassName(sdkModulesConfig);
    }

    private void validateSdkVersion(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        SdkModulesConfigOuterClass.RuntimeEnabledSdkVersion sdkVersion = sdkModulesConfig.getSdkVersion();
        if (sdkVersion.getMajor() < 0 || sdkVersion.getMajor() > 199999) {
            throw InvalidBundleException.builder().withUserMessage("SDK major version must be an integer between 0 and %d", 199999).build();
        }
        if (sdkVersion.getMinor() < 0 || sdkVersion.getMinor() > 9999) {
            throw InvalidBundleException.builder().withUserMessage("SDK minor version must be an integer between 0 and %d", 9999).build();
        }
        if (sdkVersion.getPatch() < 0 || sdkVersion.getPatch() > 9999) {
            throw InvalidBundleException.builder().withUserMessage("SDK patch version must be an integer between 0 and %d", 9999).build();
        }
    }

    private void validateBundletoolVersion(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        try {
            Version.of(sdkModulesConfig.getBundletool().getVersion());
        }
        catch (InvalidBundleException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("Invalid Bundletool version in the SdkModulesConfig.pb file: '%s'", sdkModulesConfig.getBundletool().getVersion()).build();
        }
    }

    private void validateSdkPackageName(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        if (sdkModulesConfig.getSdkPackageName().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("SDK package name cannot be an empty string").build();
        }
    }

    private void validateSdkProviderClassName(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        if (sdkModulesConfig.getSdkProviderClassName().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("SDK provider class name cannot be an empty string").build();
        }
    }
}

