/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceGroupConfig;
import com.android.bundle.DeviceSelector;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.google.common.primitives.Ints;
import java.util.Optional;
import java.util.regex.Pattern;

public class DeviceTargetingUtils {
    private static final Pattern DEVICE_GROUP_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");
    private static final String GROUP_OTHER_NAME = "other";

    public static void validateDeviceTierForAssetsDirectory(String directory, String tierName) {
        Integer tier = Ints.tryParse(tierName);
        if (tier == null || tier < 0) {
            throw InvalidBundleException.builder().withUserMessage("Device tiers should be non-negative integers. Found tier '%s' for directory '%s'.", tierName, directory).build();
        }
    }

    public static void validateDeviceGroupForAssetsDirectory(String directory, String groupName) {
        if (!DEVICE_GROUP_PATTERN.matcher(groupName).matches()) {
            throw InvalidBundleException.builder().withUserMessage("Device group names should start with a letter and contain only letters, numbers and underscores. Found group named '%s' for directory '%s'.", groupName, directory).build();
        }
    }

    public static void validateDeviceGroupForConditionalModule(String groupName) {
        if (!DEVICE_GROUP_PATTERN.matcher(groupName).matches()) {
            throw InvalidBundleException.builder().withUserMessage("Device group names should start with a letter and contain only letters, numbers and underscores. Found group named '%s' in '<dist:%s>' element.", groupName, "device-group").build();
        }
    }

    public static DeviceGroupConfig addDeviceGroupOther(DeviceGroupConfig config) {
        if (config.getDeviceGroupsList().isEmpty()) {
            return config;
        }
        Optional<String> groupOther = config.getDeviceGroupsList().stream().map(DeviceGroup::getName).filter(name -> name.equals(GROUP_OTHER_NAME)).findFirst();
        if (groupOther.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("Device group '%s' is implicit. It must not be defined in the bundle metadata.", GROUP_OTHER_NAME).build();
        }
        return config.toBuilder().addDeviceGroups(DeviceGroup.newBuilder().setName(GROUP_OTHER_NAME).addDeviceSelectors(DeviceSelector.getDefaultInstance())).build();
    }

    private DeviceTargetingUtils() {
    }
}

