/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.targeting;

import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.AutoValue_DimensionKeyValue;
import com.google.auto.value.AutoValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoValue
public abstract class DimensionKeyValue {
    private static final Pattern DIMENSION_KEY_VALUE_PATTERN = Pattern.compile("(?<key>[a-z]+)_(?<value>.+)");

    public abstract String getDimensionKey();

    public abstract String getDimensionValue();

    public static DimensionKeyValue parse(String dimensionValue) {
        Matcher matcher = DIMENSION_KEY_VALUE_PATTERN.matcher(dimensionValue);
        if (matcher.matches()) {
            String key = matcher.group("key");
            return new AutoValue_DimensionKeyValue(key, matcher.group("value"));
        }
        throw InvalidBundleException.builder().withUserMessage("Cannot tokenize targeted directory segment '%s'. Expecting targeting dimension value in the '<key>_<value>' format.", dimensionValue).build();
    }
}

