/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AbiName;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.model.utils.TextureCompressionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.StringValue;
import java.util.Optional;

public final class DeviceSpecUtils {
    private static final String GL_ES_VERSION_FEATURE_PREFIX = "reqGlEsVersion=";

    public static boolean isAbiMissing(Devices.DeviceSpec deviceSpec) {
        return deviceSpec.getSupportedAbisList().isEmpty();
    }

    public static boolean isScreenDensityMissing(Devices.DeviceSpec deviceSpec) {
        return deviceSpec.getScreenDensity() == 0;
    }

    public static boolean isSdkVersionMissing(Devices.DeviceSpec deviceSpec) {
        return deviceSpec.getSdkVersion() == 0;
    }

    public static boolean isLocalesMissing(Devices.DeviceSpec deviceSpec) {
        return deviceSpec.getSupportedLocalesList().isEmpty();
    }

    public static boolean isTextureCompressionFormatMissing(Devices.DeviceSpec deviceSpec) {
        return deviceSpec.getGlExtensionsList().isEmpty() && !DeviceSpecUtils.getGlEsVersion(deviceSpec).isPresent();
    }

    public static boolean isDeviceTierMissing(Devices.DeviceSpec deviceSpec) {
        return !deviceSpec.hasDeviceTier();
    }

    public static boolean isDeviceGroupsMissing(Devices.DeviceSpec deviceSpec) {
        return deviceSpec.getDeviceGroupsList().isEmpty();
    }

    public static boolean isCountrySetMissing(Devices.DeviceSpec deviceSpec) {
        return !deviceSpec.hasCountrySet();
    }

    public static boolean isSdkRuntimeUnspecified(Devices.DeviceSpec deviceSpec) {
        return !deviceSpec.hasSdkRuntime();
    }

    public static Optional<Integer> getGlEsVersion(Devices.DeviceSpec deviceSpec) {
        try {
            return deviceSpec.getDeviceFeaturesList().stream().filter(deviceFeature -> deviceFeature.startsWith(GL_ES_VERSION_FEATURE_PREFIX)).map(deviceFeature -> Integer.decode(deviceFeature.substring(GL_ES_VERSION_FEATURE_PREFIX.length()))).max(Integer::compareTo);
        }
        catch (NumberFormatException e11) {
            System.err.println("WARNING: the OpenGL ES version in the device spec is not a valid number. It will be considered as missing for texture compression format matching with the device.");
            return Optional.empty();
        }
    }

    public static ImmutableSet<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias> getDeviceSupportedTextureCompressionFormats(Devices.DeviceSpec deviceSpec) {
        ImmutableSet glExtensionSupportedFormats = deviceSpec.getGlExtensionsList().stream().map(TextureCompressionUtils::textureCompressionFormat).flatMap(Streams::stream).collect(ImmutableSet.toImmutableSet());
        ImmutableList glVersionSupportedFormats = DeviceSpecUtils.getGlEsVersion(deviceSpec).map(TextureCompressionUtils::textureCompressionFormatsForGl).orElse(ImmutableList.of());
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)glExtensionSupportedFormats)).addAll((Iterable)glVersionSupportedFormats)).build();
    }

    public static class DeviceSpecFromTargetingBuilder {
        private final Devices.DeviceSpec.Builder deviceSpec;

        DeviceSpecFromTargetingBuilder(Devices.DeviceSpec deviceSpec) {
            this.deviceSpec = deviceSpec.toBuilder();
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setSdkVersion(Targeting.SdkVersionTargeting sdkVersionTargeting) {
            if (!sdkVersionTargeting.equals(Targeting.SdkVersionTargeting.getDefaultInstance())) {
                this.deviceSpec.setSdkVersion(Iterables.getOnlyElement(sdkVersionTargeting.getValueList()).getMin().getValue());
            }
            return this;
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setSupportedAbis(Targeting.AbiTargeting abiTargeting) {
            if (!abiTargeting.equals(Targeting.AbiTargeting.getDefaultInstance())) {
                this.deviceSpec.addSupportedAbis(AbiName.fromProto(Iterables.getOnlyElement(abiTargeting.getValueList()).getAlias()).getPlatformName());
            }
            return this;
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setScreenDensity(Targeting.ScreenDensityTargeting screenDensityTargeting) {
            TargetingProtoUtils.getScreenDensityDpi(screenDensityTargeting).ifPresent(this.deviceSpec::setScreenDensity);
            return this;
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setSupportedLocales(Targeting.LanguageTargeting languageTargeting) {
            if (!languageTargeting.equals(Targeting.LanguageTargeting.getDefaultInstance()) && languageTargeting.getValueCount() > 0) {
                this.deviceSpec.addSupportedLocales(Iterables.getOnlyElement(languageTargeting.getValueList()));
            }
            return this;
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setSupportedTextureCompressionFormats(Targeting.TextureCompressionFormatTargeting textureTargeting) {
            if (!textureTargeting.equals(Targeting.TextureCompressionFormatTargeting.getDefaultInstance())) {
                this.deviceSpec.addAllGlExtensions(textureTargeting.getValueList().stream().map(Targeting.TextureCompressionFormat::getAlias).filter(TextureCompressionUtils.TEXTURE_COMPRESSION_FORMAT_TO_MANIFEST_VALUE::containsKey).map(TextureCompressionUtils.TEXTURE_COMPRESSION_FORMAT_TO_MANIFEST_VALUE::get).collect(ImmutableSet.toImmutableSet()));
                textureTargeting.getValueList().stream().map(TextureCompressionUtils::getMinGlEsVersionRequired).flatMap(Streams::stream).max(Integer::compareTo).map(glEsVersion -> "reqGlEsVersion=0x" + Integer.toHexString(glEsVersion)).ifPresent(this.deviceSpec::addDeviceFeatures);
            }
            return this;
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setDeviceTier(Targeting.DeviceTierTargeting deviceTierTargeting) {
            if (!deviceTierTargeting.equals(Targeting.DeviceTierTargeting.getDefaultInstance())) {
                this.deviceSpec.setDeviceTier(Int32Value.of(Iterables.getOnlyElement(deviceTierTargeting.getValueList()).getValue()));
            }
            return this;
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setDeviceGroup(Targeting.DeviceGroupTargeting deviceGroupTargeting) {
            if (!deviceGroupTargeting.equals(Targeting.DeviceGroupTargeting.getDefaultInstance())) {
                this.deviceSpec.addDeviceGroups(Iterables.getOnlyElement(deviceGroupTargeting.getValueList(), ""));
            }
            return this;
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setCountrySet(Targeting.CountrySetTargeting countrySetTargeting) {
            if (!countrySetTargeting.equals(Targeting.CountrySetTargeting.getDefaultInstance())) {
                this.deviceSpec.setCountrySet(StringValue.of(Iterables.getOnlyElement(countrySetTargeting.getValueList(), "")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        DeviceSpecFromTargetingBuilder setSdkRuntime(Targeting.SdkRuntimeTargeting sdkRuntimeTargeting) {
            this.deviceSpec.setSdkRuntime(Devices.SdkRuntime.newBuilder().setSupported(sdkRuntimeTargeting.getRequiresSdkRuntime()).build());
            return this;
        }

        DeviceSpecFromTargetingBuilder setDeviceFeatures(Targeting.DeviceFeatureTargeting deviceFeatureTargeting) {
            throw new UnsupportedOperationException();
        }

        Devices.DeviceSpec build() {
            return this.deviceSpec.build();
        }
    }
}

