/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.build.bundletool.device.AdbShellCommandTask;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.device.DeviceFeaturesParser;
import com.android.tools.build.bundletool.device.GlExtensionsParser;
import com.android.tools.build.bundletool.device.LocalTestingPathResolver;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.FormatMethod;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class DdmlibDevice
extends Device {
    private static final String DENSITY_OUTPUT_PREFIX = "Physical density:";
    private final IDevice device;
    private final Clock clock;
    private static final int ADB_TIMEOUT_MS = 60000;
    private static final String DEVICE_FEATURES_COMMAND = "pm list features";
    private static final String GL_EXTENSIONS_COMMAND = "dumpsys SurfaceFlinger";
    private final DeviceFeaturesParser deviceFeaturesParser = new DeviceFeaturesParser();
    private final GlExtensionsParser glExtensionsParser = new GlExtensionsParser();

    public DdmlibDevice(IDevice device, Clock clock) {
        this.device = device;
        this.clock = clock;
    }

    public DdmlibDevice(IDevice device) {
        this(device, Clock.systemDefaultZone());
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.device.getState();
    }

    @Override
    public AndroidVersion getVersion() {
        return this.device.getVersion();
    }

    @Override
    public ImmutableList<String> getAbis() {
        return ImmutableList.copyOf(this.device.getAbis());
    }

    @Override
    public int getDensity() {
        int density = this.device.getDensity();
        if (density != -1) {
            return density;
        }
        try {
            final int[] parsedDensityFromShell = new int[]{-1};
            this.device.executeShellCommand("wm density", new MultiLineReceiver(){

                @Override
                public void processNewLines(String[] lines) {
                    Arrays.stream(lines).filter(string -> string.startsWith(DdmlibDevice.DENSITY_OUTPUT_PREFIX)).map(string -> string.substring(DdmlibDevice.DENSITY_OUTPUT_PREFIX.length()).trim()).map(Ints::tryParse).forEach(density -> {
                        parsedDensityFromShell2[0] = density != null ? density : -1;
                    });
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            }, 1L, TimeUnit.MINUTES);
            return parsedDensityFromShell[0];
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e11) {
            return -1;
        }
    }

    @Override
    public String getSerialNumber() {
        return this.device.getSerialNumber();
    }

    @Override
    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.device.getProperty(propertyName));
    }

    @Override
    public ImmutableList<String> getDeviceFeatures() {
        return this.deviceFeaturesParser.parse(new AdbShellCommandTask(this, DEVICE_FEATURES_COMMAND).execute(60000L, TimeUnit.MILLISECONDS));
    }

    private boolean canGetGlExtensions() {
        boolean isApi25 = this.getVersion().getApiLevel() == 25;
        boolean isWearable = this.getProperty("ro.build.characteristics").orElse("").contains("watch");
        return !isApi25 || !isWearable;
    }

    @Override
    public ImmutableList<String> getGlExtensions() {
        if (this.canGetGlExtensions()) {
            return this.glExtensionsParser.parse(new AdbShellCommandTask(this, GL_EXTENSIONS_COMMAND).execute(60000L, TimeUnit.MILLISECONDS));
        }
        return ImmutableList.of();
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.device.executeShellCommand(command, receiver, maxTimeToOutputResponse, maxTimeUnits);
    }

    @Override
    public void installApks(ImmutableList<Path> apks, Device.InstallOptions installOptions) {
        ImmutableList<File> apkFiles = apks.stream().map(Path::toFile).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder extraArgs = ImmutableList.builder();
        if (installOptions.getAllowDowngrade()) {
            extraArgs.add("-d");
        }
        if (installOptions.getAllowTestOnly()) {
            extraArgs.add("-t");
        }
        if (installOptions.getGrantRuntimePermissions() && this.device.getVersion().isGreaterOrEqualThan(23)) {
            extraArgs.add("-g");
        }
        try {
            if (this.getVersion().isGreaterOrEqualThan(AndroidVersion.ALLOW_SPLIT_APK_INSTALLATION.getApiLevel())) {
                this.device.installPackages(apkFiles, installOptions.getAllowReinstall(), (List<String>)((Object)extraArgs.build()), installOptions.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.device.installPackage(((File)Iterables.getOnlyElement(apkFiles)).toString(), installOptions.getAllowReinstall(), extraArgs.build().toArray(new String[0]));
            }
        }
        catch (InstallException e11) {
            throw CommandExecutionException.builder().withCause(e11).withInternalMessage("Installation of the app failed.").build();
        }
    }

    @Override
    public void push(ImmutableList<Path> files, Device.PushOptions pushOptions) {
        String splitsPath = pushOptions.getDestinationPath();
        Preconditions.checkArgument(!splitsPath.isEmpty(), "Splits path cannot be empty.");
        RemoteCommandExecutor commandExecutor = new RemoteCommandExecutor(this, pushOptions.getTimeout().toMillis(), System.err);
        DdmPreferences.setTimeOut((int)pushOptions.getTimeout().toMillis());
        try {
            splitsPath = LocalTestingPathResolver.resolveLocalTestingPath(splitsPath, pushOptions.getPackageName());
            if (pushOptions.getClearDestinationPath()) {
                commandExecutor.executeAndPrint("rm -rf %s", new String[]{splitsPath});
            }
            commandExecutor.executeAndPrint("mkdir -p %s && rmdir %1$s && mkdir -p %1$s", new String[]{splitsPath});
            this.pushFiles(commandExecutor, splitsPath, files);
            if (this.device.getVersion().getApiLevel() >= 31 || this.device.getVersion().isPreview()) {
                commandExecutor.executeAndPrint("chmod 775 %s", new String[]{splitsPath});
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | SyncException | TimeoutException | IOException e11) {
            throw CommandExecutionException.builder().withCause(e11).withInternalMessage("Pushing additional splits for local testing failed. Your app might still have been installed correctly, but you won't be able to test dynamic modules.").build();
        }
    }

    @Override
    public boolean supportsPrivacySandbox() {
        return this.device.services().containsKey("sdk_sandbox") && this.device.getVersion().isGreaterOrEqualThan(34);
    }

    private void pushFiles(RemoteCommandExecutor executor, String splitsPath, ImmutableList<Path> files) throws IOException, SyncException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
        try {
            this.pushFilesToLocation(splitsPath, files);
        }
        catch (SyncException e11) {
            if (!e11.getMessage().contains("fchown failed: Operation not permitted")) {
                throw e11;
            }
            String tempPath = String.format("/data/local/tmp/splits-%d", this.clock.millis());
            this.pushFilesToLocation(tempPath, files);
            executor.executeAndPrint("rm -rf %s && mv %s %s", new String[]{splitsPath, tempPath, splitsPath});
        }
    }

    private void pushFilesToLocation(String splitsPath, ImmutableList<Path> files) throws IOException, SyncException, TimeoutException, AdbCommandRejectedException {
        for (Path path : files) {
            this.device.pushFile(path.toFile().getAbsolutePath(), DdmlibDevice.joinUnixPaths(splitsPath, path.getFileName().toString()));
            System.err.printf("Pushed \"%s\"%n", DdmlibDevice.joinUnixPaths(splitsPath, path.getFileName().toString()));
        }
    }

    @Override
    public Path syncPackageToDevice(Path localFilePath) throws TimeoutException, AdbCommandRejectedException, SyncException, IOException {
        return Paths.get(this.device.syncPackageToDevice(localFilePath.toFile().getAbsolutePath()), new String[0]);
    }

    @Override
    public void removeRemotePath(String remoteFilePath, Optional<String> runAsPackageName, Duration timeout) throws IOException {
        RemoteCommandExecutor executor = new RemoteCommandExecutor(this, timeout.toMillis(), System.err);
        try {
            if (runAsPackageName.isPresent()) {
                executor.executeAndPrint("run-as %s rm -rf %s", new String[]{runAsPackageName.get(), remoteFilePath});
            } else {
                executor.executeAndPrint("rm -rf %s", new String[]{remoteFilePath});
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e11) {
            throw new IOException(String.format("Failed to remove '%s'", remoteFilePath), e11);
        }
    }

    @Override
    public void pull(ImmutableList<Device.FilePullParams> files) {
        files.forEach(file2 -> this.pullFile(file2.getPathOnDevice(), file2.getDestinationPath().toString()));
    }

    private void pullFile(String pathOnDevice, String destinationPath) {
        try {
            this.device.pullFile(pathOnDevice, destinationPath);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException | IOException e11) {
            throw new CommandExecutionException("Exception while pulling file from the device.", e11.getMessage(), e11.getCause());
        }
    }

    static String joinUnixPaths(String ... parts) {
        StringBuilder sb2 = new StringBuilder();
        for (String part : parts) {
            if (sb2.length() > 0 && sb2.charAt(sb2.length() - 1) != '/') {
                sb2.append('/');
            }
            sb2.append(part);
        }
        return sb2.toString();
    }

    static class RemoteCommandExecutor {
        private final Device device;
        private final MultiLineReceiver receiver;
        private final long timeout;
        private final PrintStream out;
        private String lastOutputLine;

        RemoteCommandExecutor(Device device, long timeout, final PrintStream out) {
            this.device = device;
            this.timeout = timeout;
            this.out = out;
            this.receiver = new MultiLineReceiver(){

                @Override
                public void processNewLines(String[] lines) {
                    for (String line : lines) {
                        if (line.isEmpty()) continue;
                        out.println("ADB >> " + line);
                        lastOutputLine = line;
                    }
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            };
        }

        @FormatMethod
        private void executeAndPrint(String commandFormat, String ... args2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
            String command = RemoteCommandExecutor.formatCommandWithArgs(commandFormat, args2);
            this.lastOutputLine = null;
            this.out.println("ADB << " + command);
            this.device.executeShellCommand(command + " && echo OK", this.receiver, this.timeout, TimeUnit.MILLISECONDS);
            if (!"OK".equals(this.lastOutputLine)) {
                throw new IOException("ADB command failed.");
            }
        }

        static String escapeAndSingleQuote(String string) {
            return "'" + string.replace("'", "'\\''") + "'";
        }

        @FormatMethod
        static String formatCommandWithArgs(String command, String ... args2) {
            return String.format(command, Arrays.stream(args2).map(RemoteCommandExecutor::escapeAndSingleQuote).toArray());
        }
    }
}

