/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.AbiMatcher;
import com.android.tools.build.bundletool.device.AutoValue_ApkMatcher_GeneratedApk;
import com.android.tools.build.bundletool.device.CountrySetApkMatcher;
import com.android.tools.build.bundletool.device.DeviceFeatureMatcher;
import com.android.tools.build.bundletool.device.DeviceGroupApkMatcher;
import com.android.tools.build.bundletool.device.DeviceGroupModuleMatcher;
import com.android.tools.build.bundletool.device.DeviceTierApkMatcher;
import com.android.tools.build.bundletool.device.LanguageMatcher;
import com.android.tools.build.bundletool.device.ModuleMatcher;
import com.android.tools.build.bundletool.device.MultiAbiMatcher;
import com.android.tools.build.bundletool.device.OpenGlFeatureMatcher;
import com.android.tools.build.bundletool.device.ScreenDensityMatcher;
import com.android.tools.build.bundletool.device.SdkRuntimeMatcher;
import com.android.tools.build.bundletool.device.SdkVersionMatcher;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.android.tools.build.bundletool.device.TextureCompressionFormatMatcher;
import com.android.tools.build.bundletool.device.VariantMatcher;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.IncompatibleDeviceException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ModuleDependenciesUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ApkMatcher {
    private final ImmutableList<? extends TargetingDimensionMatcher<?>> apkMatchers;
    private final Optional<ImmutableSet<String>> requestedModuleNames;
    private final boolean matchInstant;
    private final boolean includeInstallTimeAssetModules;
    private final ModuleMatcher moduleMatcher;
    private final VariantMatcher variantMatcher;
    private final boolean ensureDensityAndAbiApksMatched;

    public ApkMatcher(Devices.DeviceSpec deviceSpec) {
        this(deviceSpec, Optional.empty(), true, false, false);
    }

    public ApkMatcher(Devices.DeviceSpec deviceSpec, Optional<ImmutableSet<String>> requestedModuleNames, boolean includeInstallTimeAssetModules, boolean matchInstant, boolean ensureDensityAndAbiApksMatched) {
        Preconditions.checkArgument(!requestedModuleNames.isPresent() || !requestedModuleNames.get().isEmpty(), "Set of requested split modules cannot be empty.");
        SdkVersionMatcher sdkVersionMatcher = new SdkVersionMatcher(deviceSpec);
        AbiMatcher abiMatcher = new AbiMatcher(deviceSpec);
        MultiAbiMatcher multiAbiMatcher = new MultiAbiMatcher(deviceSpec);
        ScreenDensityMatcher screenDensityMatcher = new ScreenDensityMatcher(deviceSpec);
        LanguageMatcher languageMatcher = new LanguageMatcher(deviceSpec);
        DeviceFeatureMatcher deviceFeatureMatcher = new DeviceFeatureMatcher(deviceSpec);
        OpenGlFeatureMatcher openGlFeatureMatcher = new OpenGlFeatureMatcher(deviceSpec);
        TextureCompressionFormatMatcher textureCompressionFormatMatcher = new TextureCompressionFormatMatcher(deviceSpec);
        DeviceGroupApkMatcher deviceGroupApkMatcher = new DeviceGroupApkMatcher(deviceSpec);
        DeviceTierApkMatcher deviceTierApkMatcher = new DeviceTierApkMatcher(deviceSpec);
        CountrySetApkMatcher countrySetApkMatcher = new CountrySetApkMatcher(deviceSpec);
        DeviceGroupModuleMatcher deviceGroupModuleMatcher = new DeviceGroupModuleMatcher(deviceSpec);
        this.apkMatchers = ImmutableList.of(sdkVersionMatcher, abiMatcher, multiAbiMatcher, screenDensityMatcher, languageMatcher, textureCompressionFormatMatcher, deviceGroupApkMatcher, deviceTierApkMatcher, countrySetApkMatcher);
        this.requestedModuleNames = requestedModuleNames;
        this.includeInstallTimeAssetModules = includeInstallTimeAssetModules;
        this.matchInstant = matchInstant;
        this.ensureDensityAndAbiApksMatched = ensureDensityAndAbiApksMatched;
        this.moduleMatcher = new ModuleMatcher(sdkVersionMatcher, deviceFeatureMatcher, openGlFeatureMatcher, deviceGroupModuleMatcher);
        this.variantMatcher = new VariantMatcher(sdkVersionMatcher, abiMatcher, multiAbiMatcher, screenDensityMatcher, textureCompressionFormatMatcher, new SdkRuntimeMatcher(deviceSpec), matchInstant);
    }

    public ImmutableList<GeneratedApk> getMatchingApks(Commands.BuildApksResult buildApksResult) {
        Optional<Commands.Variant> matchingVariant = this.variantMatcher.getMatchingVariant(buildApksResult);
        matchingVariant.ifPresent(variant -> this.validateVariant((Commands.Variant)variant, buildApksResult));
        ImmutableList variantApks = matchingVariant.isPresent() ? this.getMatchingApksFromVariant(matchingVariant.get(), Version.of(buildApksResult.getBundletool().getVersion())) : ImmutableList.of();
        ImmutableList<GeneratedApk> assetModuleApks = this.getMatchingApksFromAssetModules(buildApksResult.getAssetSliceSetList());
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)variantApks)).addAll(assetModuleApks)).build();
    }

    public ImmutableList<GeneratedApk> getMatchingApksFromVariant(Commands.Variant variant, Version bundleVersion) {
        ImmutableSet<String> modulesToMatch = this.matchInstant ? this.getRequestedInstantModulesWithDependencies(variant) : this.getInstallTimeAndRequestedModulesWithDependencies(variant, bundleVersion);
        return variant.getApkSetList().stream().filter(apkSet -> modulesToMatch.contains(apkSet.getModuleMetadata().getName())).flatMap(apkSet -> this.getMatchingApksFromModule((Commands.ApkSet)apkSet).stream()).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<GeneratedApk> getMatchingApksFromModule(Commands.ApkSet moduleApks) {
        ImmutableSet<OptimizationDimension> matchedDimensions;
        ImmutableSet<OptimizationDimension> availableDimensions;
        String moduleName = moduleApks.getModuleMetadata().getName();
        ImmutableList<Commands.ApkDescription> matchedApks = moduleApks.getApkDescriptionList().stream().peek(apkDescription -> this.checkCompatibleWithApkTargeting(apkDescription.getTargeting())).filter(apkDescription -> this.matchesApkTargeting(apkDescription.getTargeting())).collect(ImmutableList.toImmutableList());
        if (this.ensureDensityAndAbiApksMatched && !(availableDimensions = ApkMatcher.getApkTargetingOnlyAbiAndDensity(moduleApks.getApkDescriptionList())).equals(matchedDimensions = ApkMatcher.getApkTargetingOnlyAbiAndDensity(matchedApks))) {
            throw IncompatibleDeviceException.builder().withUserMessage("Missing APKs for %s dimensions in the module '%s' for the provided device.", Sets.difference(availableDimensions, matchedDimensions), moduleName).build();
        }
        return matchedApks.stream().map(apkDescription -> GeneratedApk.create(ZipPath.create(apkDescription.getPath()), moduleName, moduleApks.getModuleMetadata().getDeliveryType())).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableSet<OptimizationDimension> getApkTargetingOnlyAbiAndDensity(Collection<Commands.ApkDescription> apks) {
        return apks.stream().map(Commands.ApkDescription::getTargeting).flatMap(targeting -> {
            Stream.Builder<OptimizationDimension> dimensions = Stream.builder();
            if (targeting.hasAbiTargeting()) {
                dimensions.add(OptimizationDimension.ABI);
            }
            if (targeting.hasScreenDensityTargeting()) {
                dimensions.add(OptimizationDimension.SCREEN_DENSITY);
            }
            return dimensions.build();
        }).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<String> getRequestedInstantModulesWithDependencies(Commands.Variant variant) {
        if (!this.requestedModuleNames.isPresent()) {
            return variant.getApkSetList().stream().map(apkSet -> apkSet.getModuleMetadata().getName()).collect(ImmutableSet.toImmutableSet());
        }
        return ModuleDependenciesUtils.getModulesIncludingDependencies(variant, (Set<String>)this.requestedModuleNames.get());
    }

    private ImmutableSet<String> getInstallTimeAndRequestedModulesWithDependencies(Commands.Variant variant, Version bundleVersion) {
        ImmutableSet<String> installTimeModules = this.buildModulesDeliveredInstallTime(variant, bundleVersion);
        ImmutableSet explicitlyRequested = this.requestedModuleNames.orElse(ImmutableSet.of());
        return ModuleDependenciesUtils.getModulesIncludingDependencies(variant, Sets.union(installTimeModules, explicitlyRequested));
    }

    private void validateVariant(Commands.Variant variant, Commands.BuildApksResult buildApksResult) {
        if (this.requestedModuleNames.isPresent()) {
            boolean isStandaloneVariant = variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).anyMatch(apkDescription -> apkDescription.hasStandaloneApkMetadata() || apkDescription.hasApexApkMetadata());
            if (isStandaloneVariant) {
                throw InvalidCommandException.builder().withInternalMessage("Cannot restrict modules when the device matches a non-split APK.").build();
            }
            Sets.SetView availableModules = Sets.union(Sets.union(variant.getApkSetList().stream().map(Commands.ApkSet::getModuleMetadata).map(Commands.ModuleMetadata::getName).collect(ImmutableSet.toImmutableSet()), buildApksResult.getAssetSliceSetList().stream().map(Commands.AssetSliceSet::getAssetModuleMetadata).map(Commands.AssetModuleMetadata::getName).collect(ImmutableSet.toImmutableSet())), buildApksResult.getPermanentlyFusedModulesList().stream().map(Commands.PermanentlyFusedModule::getName).collect(ImmutableSet.toImmutableSet()));
            Sets.SetView unknownModules = Sets.difference(this.requestedModuleNames.get(), availableModules);
            if (!unknownModules.isEmpty()) {
                throw InvalidCommandException.builder().withInternalMessage("The APK Set archive does not contain the following modules: %s", unknownModules).build();
            }
        }
    }

    private ImmutableSet<String> buildModulesDeliveredInstallTime(Commands.Variant variant, Version bundleVersion) {
        return variant.getApkSetList().stream().map(Commands.ApkSet::getModuleMetadata).filter(moduleMetadata -> this.willBeDeliveredInstallTime((Commands.ModuleMetadata)moduleMetadata, bundleVersion)).map(Commands.ModuleMetadata::getName).collect(ImmutableSet.toImmutableSet());
    }

    private boolean willBeDeliveredInstallTime(Commands.ModuleMetadata moduleMetadata, Version bundleVersion) {
        boolean installTime = VersionGuardedFeature.NEW_DELIVERY_TYPE_MANIFEST_TAG.enabledForVersion(bundleVersion) ? moduleMetadata.getDeliveryType().equals(Commands.DeliveryType.INSTALL_TIME) : !moduleMetadata.getOnDemandDeprecated();
        return installTime && this.moduleMatcher.matchesModuleTargeting(moduleMetadata.getTargeting());
    }

    private boolean matchesApkTargeting(Targeting.ApkTargeting apkTargeting) {
        return this.apkMatchers.stream().allMatch(matcher -> matcher.getApkTargetingPredicate().test(apkTargeting));
    }

    public boolean matchesModuleSplitByTargeting(ModuleSplit moduleSplit) {
        this.variantMatcher.checkCompatibleWithVariantTargeting(moduleSplit.getVariantTargeting());
        this.checkCompatibleWithApkTargeting(moduleSplit.getApkTargeting());
        return this.variantMatcher.matchesVariantTargeting(moduleSplit.getVariantTargeting()) && this.matchesApkTargeting(moduleSplit.getApkTargeting());
    }

    public void checkCompatibleWithApkTargeting(ModuleSplit moduleSplit) {
        this.checkCompatibleWithApkTargeting(moduleSplit.getApkTargeting());
    }

    private void checkCompatibleWithApkTargeting(Targeting.ApkTargeting apkTargeting) {
        this.apkMatchers.forEach((Consumer<TargetingDimensionMatcher<?>>)((Consumer<TargetingDimensionMatcher>)matcher -> ApkMatcher.checkCompatibleWithApkTargetingHelper(matcher, apkTargeting)));
    }

    private static <T> void checkCompatibleWithApkTargetingHelper(TargetingDimensionMatcher<T> matcher, Targeting.ApkTargeting apkTargeting) {
        matcher.checkDeviceCompatible(matcher.getTargetingValue(apkTargeting));
    }

    public ImmutableList<GeneratedApk> getMatchingApksFromAssetModules(Collection<Commands.AssetSliceSet> assetModules) {
        Sets.SetView assetModulesToMatch = Sets.union(this.requestedModuleNames.orElse(ImmutableSet.of()), this.includeInstallTimeAssetModules ? ApkMatcher.getUpfrontAssetModules(assetModules) : ImmutableSet.of());
        return assetModules.stream().filter(assetModule -> assetModulesToMatch.contains(assetModule.getAssetModuleMetadata().getName())).flatMap(assetModule -> assetModule.getApkDescriptionList().stream().filter(apkDescription -> this.matchesApkTargeting(apkDescription.getTargeting())).map(apkDescription -> GeneratedApk.create(ZipPath.create(apkDescription.getPath()), assetModule.getAssetModuleMetadata().getName(), assetModule.getAssetModuleMetadata().getDeliveryType()))).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableSet<String> getUpfrontAssetModules(Collection<Commands.AssetSliceSet> assetModules) {
        return assetModules.stream().filter(sliceSet -> sliceSet.getAssetModuleMetadata().getDeliveryType().equals(Commands.DeliveryType.INSTALL_TIME)).map(sliceSet -> sliceSet.getAssetModuleMetadata().getName()).collect(ImmutableSet.toImmutableSet());
    }

    @AutoValue
    public static abstract class GeneratedApk {
        public abstract ZipPath getPath();

        public abstract String getModuleName();

        public abstract Commands.DeliveryType getDeliveryType();

        public static GeneratedApk create(ZipPath path, String moduleName, Commands.DeliveryType deliveryType) {
            return new AutoValue_ApkMatcher_GeneratedApk(path, moduleName, deliveryType);
        }
    }
}

