/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

// This list is automatically generated by a python script at build time.
const eventList = require("resource://devtools/server/actors/events/event-list.json");

// Bug 1980978: Some events are missing from EventNameList.h
// We may revise the implementation of event-list.json.
eventList.push("DOMContentLoaded");

/**
 * Reports if a given DOM Event name is probably supported by Gecko.
 * If it isn't, it is most likely a custom event implemented by the web page.
 *
 * @param {String} name
 * @return {Boolean}
 */
exports.isUserDefinedEventName = function (name) {
  return !eventList.includes(name);
};
