const tests = [
  [-0x8000000000000000n, 0n, -0x8000000000000000n],
  [-0x7fffffffffffffffn, 0n, -0x7fffffffffffffffn],
  [-0x7ffffffffffffffen, 0n, -0x7ffffffffffffffen],
  [-0x100000001n, 0n, -0x100000001n],
  [-0x100000000n, 0n, -0x100000000n],
  [-0xffffffffn, 0n, -0xffffffffn],
  [-0xfffffffen, 0n, -0xfffffffen],
  [-0x80000001n, 0n, -0x80000001n],
  [-0x80000000n, 0n, -0x80000000n],
  [-0x7fffffffn, 0n, -0x7fffffffn],
  [-0x7ffffffen, 0n, -0x7ffffffen],
  [-9n, 0n, -9n],
  [-8n, 0n, -8n],
  [-7n, 0n, -7n],
  [-6n, 0n, -6n],
  [-5n, 0n, -5n],
  [-4n, 0n, -4n],
  [-3n, 0n, -3n],
  [-2n, 0n, -2n],
  [-1n, 0n, -1n],
  [0n, 0n, 0n],
  [1n, 0n, 1n],
  [2n, 0n, 2n],
  [3n, 0n, 3n],
  [4n, 0n, 4n],
  [5n, 0n, 5n],
  [6n, 0n, 6n],
  [7n, 0n, 7n],
  [8n, 0n, 8n],
  [9n, 0n, 9n],
  [0x7ffffffen, 0n, 0x7ffffffen],
  [0x7fffffffn, 0n, 0x7fffffffn],
  [0x80000000n, 0n, 0x80000000n],
  [0x80000001n, 0n, 0x80000001n],
  [0xfffffffen, 0n, 0xfffffffen],
  [0xffffffffn, 0n, 0xffffffffn],
  [0x100000000n, 0n, 0x100000000n],
  [0x100000001n, 0n, 0x100000001n],
  [0x7ffffffffffffffen, 0n, 0x7ffffffffffffffen],
  [0x7fffffffffffffffn, 0n, 0x7fffffffffffffffn],
  [-0x8000000000000000n, 1n, -0x4000000000000000n],
  [-0x7fffffffffffffffn, 1n, -0x4000000000000000n],
  [-0x7ffffffffffffffen, 1n, -0x3fffffffffffffffn],
  [-0x100000001n, 1n, -0x80000001n],
  [-0x100000000n, 1n, -0x80000000n],
  [-0xffffffffn, 1n, -0x80000000n],
  [-0xfffffffen, 1n, -0x7fffffffn],
  [-0x80000001n, 1n, -0x40000001n],
  [-0x80000000n, 1n, -0x40000000n],
  [-0x7fffffffn, 1n, -0x40000000n],
  [-0x7ffffffen, 1n, -0x3fffffffn],
  [-9n, 1n, -5n],
  [-8n, 1n, -4n],
  [-7n, 1n, -4n],
  [-6n, 1n, -3n],
  [-5n, 1n, -3n],
  [-4n, 1n, -2n],
  [-3n, 1n, -2n],
  [-2n, 1n, -1n],
  [-1n, 1n, -1n],
  [0n, 1n, 0n],
  [1n, 1n, 0n],
  [2n, 1n, 1n],
  [3n, 1n, 1n],
  [4n, 1n, 2n],
  [5n, 1n, 2n],
  [6n, 1n, 3n],
  [7n, 1n, 3n],
  [8n, 1n, 4n],
  [9n, 1n, 4n],
  [0x7ffffffen, 1n, 0x3fffffffn],
  [0x7fffffffn, 1n, 0x3fffffffn],
  [0x80000000n, 1n, 0x40000000n],
  [0x80000001n, 1n, 0x40000000n],
  [0xfffffffen, 1n, 0x7fffffffn],
  [0xffffffffn, 1n, 0x7fffffffn],
  [0x100000000n, 1n, 0x80000000n],
  [0x100000001n, 1n, 0x80000000n],
  [0x7ffffffffffffffen, 1n, 0x3fffffffffffffffn],
  [0x7fffffffffffffffn, 1n, 0x3fffffffffffffffn],
  [-0x8000000000000000n, 2n, -0x2000000000000000n],
  [-0x7fffffffffffffffn, 2n, -0x2000000000000000n],
  [-0x7ffffffffffffffen, 2n, -0x2000000000000000n],
  [-0x100000001n, 2n, -0x40000001n],
  [-0x100000000n, 2n, -0x40000000n],
  [-0xffffffffn, 2n, -0x40000000n],
  [-0xfffffffen, 2n, -0x40000000n],
  [-0x80000001n, 2n, -0x20000001n],
  [-0x80000000n, 2n, -0x20000000n],
  [-0x7fffffffn, 2n, -0x20000000n],
  [-0x7ffffffen, 2n, -0x20000000n],
  [-9n, 2n, -3n],
  [-8n, 2n, -2n],
  [-7n, 2n, -2n],
  [-6n, 2n, -2n],
  [-5n, 2n, -2n],
  [-4n, 2n, -1n],
  [-3n, 2n, -1n],
  [-2n, 2n, -1n],
  [-1n, 2n, -1n],
  [0n, 2n, 0n],
  [1n, 2n, 0n],
  [2n, 2n, 0n],
  [3n, 2n, 0n],
  [4n, 2n, 1n],
  [5n, 2n, 1n],
  [6n, 2n, 1n],
  [7n, 2n, 1n],
  [8n, 2n, 2n],
  [9n, 2n, 2n],
  [0x7ffffffen, 2n, 0x1fffffffn],
  [0x7fffffffn, 2n, 0x1fffffffn],
  [0x80000000n, 2n, 0x20000000n],
  [0x80000001n, 2n, 0x20000000n],
  [0xfffffffen, 2n, 0x3fffffffn],
  [0xffffffffn, 2n, 0x3fffffffn],
  [0x100000000n, 2n, 0x40000000n],
  [0x100000001n, 2n, 0x40000000n],
  [0x7ffffffffffffffen, 2n, 0x1fffffffffffffffn],
  [0x7fffffffffffffffn, 2n, 0x1fffffffffffffffn],
  [-0x8000000000000000n, 3n, -0x1000000000000000n],
  [-0x7fffffffffffffffn, 3n, -0x1000000000000000n],
  [-0x7ffffffffffffffen, 3n, -0x1000000000000000n],
  [-0x100000001n, 3n, -0x20000001n],
  [-0x100000000n, 3n, -0x20000000n],
  [-0xffffffffn, 3n, -0x20000000n],
  [-0xfffffffen, 3n, -0x20000000n],
  [-0x80000001n, 3n, -0x10000001n],
  [-0x80000000n, 3n, -0x10000000n],
  [-0x7fffffffn, 3n, -0x10000000n],
  [-0x7ffffffen, 3n, -0x10000000n],
  [-9n, 3n, -2n],
  [-8n, 3n, -1n],
  [-7n, 3n, -1n],
  [-6n, 3n, -1n],
  [-5n, 3n, -1n],
  [-4n, 3n, -1n],
  [-3n, 3n, -1n],
  [-2n, 3n, -1n],
  [-1n, 3n, -1n],
  [0n, 3n, 0n],
  [1n, 3n, 0n],
  [2n, 3n, 0n],
  [3n, 3n, 0n],
  [4n, 3n, 0n],
  [5n, 3n, 0n],
  [6n, 3n, 0n],
  [7n, 3n, 0n],
  [8n, 3n, 1n],
  [9n, 3n, 1n],
  [0x7ffffffen, 3n, 0xfffffffn],
  [0x7fffffffn, 3n, 0xfffffffn],
  [0x80000000n, 3n, 0x10000000n],
  [0x80000001n, 3n, 0x10000000n],
  [0xfffffffen, 3n, 0x1fffffffn],
  [0xffffffffn, 3n, 0x1fffffffn],
  [0x100000000n, 3n, 0x20000000n],
  [0x100000001n, 3n, 0x20000000n],
  [0x7ffffffffffffffen, 3n, 0xfffffffffffffffn],
  [0x7fffffffffffffffn, 3n, 0xfffffffffffffffn],
  [-0x8000000000000000n, 4n, -0x800000000000000n],
  [-0x7fffffffffffffffn, 4n, -0x800000000000000n],
  [-0x7ffffffffffffffen, 4n, -0x800000000000000n],
  [-0x100000001n, 4n, -0x10000001n],
  [-0x100000000n, 4n, -0x10000000n],
  [-0xffffffffn, 4n, -0x10000000n],
  [-0xfffffffen, 4n, -0x10000000n],
  [-0x80000001n, 4n, -0x8000001n],
  [-0x80000000n, 4n, -0x8000000n],
  [-0x7fffffffn, 4n, -0x8000000n],
  [-0x7ffffffen, 4n, -0x8000000n],
  [-9n, 4n, -1n],
  [-8n, 4n, -1n],
  [-7n, 4n, -1n],
  [-6n, 4n, -1n],
  [-5n, 4n, -1n],
  [-4n, 4n, -1n],
  [-3n, 4n, -1n],
  [-2n, 4n, -1n],
  [-1n, 4n, -1n],
  [0n, 4n, 0n],
  [1n, 4n, 0n],
  [2n, 4n, 0n],
  [3n, 4n, 0n],
  [4n, 4n, 0n],
  [5n, 4n, 0n],
  [6n, 4n, 0n],
  [7n, 4n, 0n],
  [8n, 4n, 0n],
  [9n, 4n, 0n],
  [0x7ffffffen, 4n, 0x7ffffffn],
  [0x7fffffffn, 4n, 0x7ffffffn],
  [0x80000000n, 4n, 0x8000000n],
  [0x80000001n, 4n, 0x8000000n],
  [0xfffffffen, 4n, 0xfffffffn],
  [0xffffffffn, 4n, 0xfffffffn],
  [0x100000000n, 4n, 0x10000000n],
  [0x100000001n, 4n, 0x10000000n],
  [0x7ffffffffffffffen, 4n, 0x7ffffffffffffffn],
  [0x7fffffffffffffffn, 4n, 0x7ffffffffffffffn],
  [-0x8000000000000000n, 0x1fn, -0x100000000n],
  [-0x7fffffffffffffffn, 0x1fn, -0x100000000n],
  [-0x7ffffffffffffffen, 0x1fn, -0x100000000n],
  [-0x100000001n, 0x1fn, -3n],
  [-0x100000000n, 0x1fn, -2n],
  [-0xffffffffn, 0x1fn, -2n],
  [-0xfffffffen, 0x1fn, -2n],
  [-0x80000001n, 0x1fn, -2n],
  [-0x80000000n, 0x1fn, -1n],
  [-0x7fffffffn, 0x1fn, -1n],
  [-0x7ffffffen, 0x1fn, -1n],
  [-9n, 0x1fn, -1n],
  [-8n, 0x1fn, -1n],
  [-7n, 0x1fn, -1n],
  [-6n, 0x1fn, -1n],
  [-5n, 0x1fn, -1n],
  [-4n, 0x1fn, -1n],
  [-3n, 0x1fn, -1n],
  [-2n, 0x1fn, -1n],
  [-1n, 0x1fn, -1n],
  [0n, 0x1fn, 0n],
  [1n, 0x1fn, 0n],
  [2n, 0x1fn, 0n],
  [3n, 0x1fn, 0n],
  [4n, 0x1fn, 0n],
  [5n, 0x1fn, 0n],
  [6n, 0x1fn, 0n],
  [7n, 0x1fn, 0n],
  [8n, 0x1fn, 0n],
  [9n, 0x1fn, 0n],
  [0x7ffffffen, 0x1fn, 0n],
  [0x7fffffffn, 0x1fn, 0n],
  [0x80000000n, 0x1fn, 1n],
  [0x80000001n, 0x1fn, 1n],
  [0xfffffffen, 0x1fn, 1n],
  [0xffffffffn, 0x1fn, 1n],
  [0x100000000n, 0x1fn, 2n],
  [0x100000001n, 0x1fn, 2n],
  [0x7ffffffffffffffen, 0x1fn, 0xffffffffn],
  [0x7fffffffffffffffn, 0x1fn, 0xffffffffn],
  [-0x8000000000000000n, 0x20n, -0x80000000n],
  [-0x7fffffffffffffffn, 0x20n, -0x80000000n],
  [-0x7ffffffffffffffen, 0x20n, -0x80000000n],
  [-0x100000001n, 0x20n, -2n],
  [-0x100000000n, 0x20n, -1n],
  [-0xffffffffn, 0x20n, -1n],
  [-0xfffffffen, 0x20n, -1n],
  [-0x80000001n, 0x20n, -1n],
  [-0x80000000n, 0x20n, -1n],
  [-0x7fffffffn, 0x20n, -1n],
  [-0x7ffffffen, 0x20n, -1n],
  [-9n, 0x20n, -1n],
  [-8n, 0x20n, -1n],
  [-7n, 0x20n, -1n],
  [-6n, 0x20n, -1n],
  [-5n, 0x20n, -1n],
  [-4n, 0x20n, -1n],
  [-3n, 0x20n, -1n],
  [-2n, 0x20n, -1n],
  [-1n, 0x20n, -1n],
  [0n, 0x20n, 0n],
  [1n, 0x20n, 0n],
  [2n, 0x20n, 0n],
  [3n, 0x20n, 0n],
  [4n, 0x20n, 0n],
  [5n, 0x20n, 0n],
  [6n, 0x20n, 0n],
  [7n, 0x20n, 0n],
  [8n, 0x20n, 0n],
  [9n, 0x20n, 0n],
  [0x7ffffffen, 0x20n, 0n],
  [0x7fffffffn, 0x20n, 0n],
  [0x80000000n, 0x20n, 0n],
  [0x80000001n, 0x20n, 0n],
  [0xfffffffen, 0x20n, 0n],
  [0xffffffffn, 0x20n, 0n],
  [0x100000000n, 0x20n, 1n],
  [0x100000001n, 0x20n, 1n],
  [0x7ffffffffffffffen, 0x20n, 0x7fffffffn],
  [0x7fffffffffffffffn, 0x20n, 0x7fffffffn],
  [-0x8000000000000000n, 0x3fn, -1n],
  [-0x7fffffffffffffffn, 0x3fn, -1n],
  [-0x7ffffffffffffffen, 0x3fn, -1n],
  [-0x100000001n, 0x3fn, -1n],
  [-0x100000000n, 0x3fn, -1n],
  [-0xffffffffn, 0x3fn, -1n],
  [-0xfffffffen, 0x3fn, -1n],
  [-0x80000001n, 0x3fn, -1n],
  [-0x80000000n, 0x3fn, -1n],
  [-0x7fffffffn, 0x3fn, -1n],
  [-0x7ffffffen, 0x3fn, -1n],
  [-9n, 0x3fn, -1n],
  [-8n, 0x3fn, -1n],
  [-7n, 0x3fn, -1n],
  [-6n, 0x3fn, -1n],
  [-5n, 0x3fn, -1n],
  [-4n, 0x3fn, -1n],
  [-3n, 0x3fn, -1n],
  [-2n, 0x3fn, -1n],
  [-1n, 0x3fn, -1n],
  [0n, 0x3fn, 0n],
  [1n, 0x3fn, 0n],
  [2n, 0x3fn, 0n],
  [3n, 0x3fn, 0n],
  [4n, 0x3fn, 0n],
  [5n, 0x3fn, 0n],
  [6n, 0x3fn, 0n],
  [7n, 0x3fn, 0n],
  [8n, 0x3fn, 0n],
  [9n, 0x3fn, 0n],
  [0x7ffffffen, 0x3fn, 0n],
  [0x7fffffffn, 0x3fn, 0n],
  [0x80000000n, 0x3fn, 0n],
  [0x80000001n, 0x3fn, 0n],
  [0xfffffffen, 0x3fn, 0n],
  [0xffffffffn, 0x3fn, 0n],
  [0x100000000n, 0x3fn, 0n],
  [0x100000001n, 0x3fn, 0n],
  [0x7ffffffffffffffen, 0x3fn, 0n],
  [0x7fffffffffffffffn, 0x3fn, 0n],
  [-0x8000000000000000n, 0x40n, -1n],
  [-0x7fffffffffffffffn, 0x40n, -1n],
  [-0x7ffffffffffffffen, 0x40n, -1n],
  [-0x100000001n, 0x40n, -1n],
  [-0x100000000n, 0x40n, -1n],
  [-0xffffffffn, 0x40n, -1n],
  [-0xfffffffen, 0x40n, -1n],
  [-0x80000001n, 0x40n, -1n],
  [-0x80000000n, 0x40n, -1n],
  [-0x7fffffffn, 0x40n, -1n],
  [-0x7ffffffen, 0x40n, -1n],
  [-9n, 0x40n, -1n],
  [-8n, 0x40n, -1n],
  [-7n, 0x40n, -1n],
  [-6n, 0x40n, -1n],
  [-5n, 0x40n, -1n],
  [-4n, 0x40n, -1n],
  [-3n, 0x40n, -1n],
  [-2n, 0x40n, -1n],
  [-1n, 0x40n, -1n],
  [0n, 0x40n, 0n],
  [1n, 0x40n, 0n],
  [2n, 0x40n, 0n],
  [3n, 0x40n, 0n],
  [4n, 0x40n, 0n],
  [5n, 0x40n, 0n],
  [6n, 0x40n, 0n],
  [7n, 0x40n, 0n],
  [8n, 0x40n, 0n],
  [9n, 0x40n, 0n],
  [0x7ffffffen, 0x40n, 0n],
  [0x7fffffffn, 0x40n, 0n],
  [0x80000000n, 0x40n, 0n],
  [0x80000001n, 0x40n, 0n],
  [0xfffffffen, 0x40n, 0n],
  [0xffffffffn, 0x40n, 0n],
  [0x100000000n, 0x40n, 0n],
  [0x100000001n, 0x40n, 0n],
  [0x7ffffffffffffffen, 0x40n, 0n],
  [0x7fffffffffffffffn, 0x40n, 0n],
  [-0x100000001n, -1n, -0x200000002n],
  [-0x100000000n, -1n, -0x200000000n],
  [-0xffffffffn, -1n, -0x1fffffffen],
  [-0xfffffffen, -1n, -0x1fffffffcn],
  [-0x80000001n, -1n, -0x100000002n],
  [-0x80000000n, -1n, -0x100000000n],
  [-0x7fffffffn, -1n, -0xfffffffen],
  [-0x7ffffffen, -1n, -0xfffffffcn],
  [-9n, -1n, -0x12n],
  [-8n, -1n, -0x10n],
  [-7n, -1n, -0xen],
  [-6n, -1n, -0xcn],
  [-5n, -1n, -0xan],
  [-4n, -1n, -8n],
  [-3n, -1n, -6n],
  [-2n, -1n, -4n],
  [-1n, -1n, -2n],
  [0n, -1n, 0n],
  [1n, -1n, 2n],
  [2n, -1n, 4n],
  [3n, -1n, 6n],
  [4n, -1n, 8n],
  [5n, -1n, 0xan],
  [6n, -1n, 0xcn],
  [7n, -1n, 0xen],
  [8n, -1n, 0x10n],
  [9n, -1n, 0x12n],
  [0x7ffffffen, -1n, 0xfffffffcn],
  [0x7fffffffn, -1n, 0xfffffffen],
  [0x80000000n, -1n, 0x100000000n],
  [0x80000001n, -1n, 0x100000002n],
  [0xfffffffen, -1n, 0x1fffffffcn],
  [0xffffffffn, -1n, 0x1fffffffen],
  [0x100000000n, -1n, 0x200000000n],
  [0x100000001n, -1n, 0x200000002n],
  [-0x100000001n, -2n, -0x400000004n],
  [-0x100000000n, -2n, -0x400000000n],
  [-0xffffffffn, -2n, -0x3fffffffcn],
  [-0xfffffffen, -2n, -0x3fffffff8n],
  [-0x80000001n, -2n, -0x200000004n],
  [-0x80000000n, -2n, -0x200000000n],
  [-0x7fffffffn, -2n, -0x1fffffffcn],
  [-0x7ffffffen, -2n, -0x1fffffff8n],
  [-9n, -2n, -0x24n],
  [-8n, -2n, -0x20n],
  [-7n, -2n, -0x1cn],
  [-6n, -2n, -0x18n],
  [-5n, -2n, -0x14n],
  [-4n, -2n, -0x10n],
  [-3n, -2n, -0xcn],
  [-2n, -2n, -8n],
  [-1n, -2n, -4n],
  [0n, -2n, 0n],
  [1n, -2n, 4n],
  [2n, -2n, 8n],
  [3n, -2n, 0xcn],
  [4n, -2n, 0x10n],
  [5n, -2n, 0x14n],
  [6n, -2n, 0x18n],
  [7n, -2n, 0x1cn],
  [8n, -2n, 0x20n],
  [9n, -2n, 0x24n],
  [0x7ffffffen, -2n, 0x1fffffff8n],
  [0x7fffffffn, -2n, 0x1fffffffcn],
  [0x80000000n, -2n, 0x200000000n],
  [0x80000001n, -2n, 0x200000004n],
  [0xfffffffen, -2n, 0x3fffffff8n],
  [0xffffffffn, -2n, 0x3fffffffcn],
  [0x100000000n, -2n, 0x400000000n],
  [0x100000001n, -2n, 0x400000004n],
  [-0x100000001n, -3n, -0x800000008n],
  [-0x100000000n, -3n, -0x800000000n],
  [-0xffffffffn, -3n, -0x7fffffff8n],
  [-0xfffffffen, -3n, -0x7fffffff0n],
  [-0x80000001n, -3n, -0x400000008n],
  [-0x80000000n, -3n, -0x400000000n],
  [-0x7fffffffn, -3n, -0x3fffffff8n],
  [-0x7ffffffen, -3n, -0x3fffffff0n],
  [-9n, -3n, -0x48n],
  [-8n, -3n, -0x40n],
  [-7n, -3n, -0x38n],
  [-6n, -3n, -0x30n],
  [-5n, -3n, -0x28n],
  [-4n, -3n, -0x20n],
  [-3n, -3n, -0x18n],
  [-2n, -3n, -0x10n],
  [-1n, -3n, -8n],
  [0n, -3n, 0n],
  [1n, -3n, 8n],
  [2n, -3n, 0x10n],
  [3n, -3n, 0x18n],
  [4n, -3n, 0x20n],
  [5n, -3n, 0x28n],
  [6n, -3n, 0x30n],
  [7n, -3n, 0x38n],
  [8n, -3n, 0x40n],
  [9n, -3n, 0x48n],
  [0x7ffffffen, -3n, 0x3fffffff0n],
  [0x7fffffffn, -3n, 0x3fffffff8n],
  [0x80000000n, -3n, 0x400000000n],
  [0x80000001n, -3n, 0x400000008n],
  [0xfffffffen, -3n, 0x7fffffff0n],
  [0xffffffffn, -3n, 0x7fffffff8n],
  [0x100000000n, -3n, 0x800000000n],
  [0x100000001n, -3n, 0x800000008n],
  [-0x100000001n, -4n, -0x1000000010n],
  [-0x100000000n, -4n, -0x1000000000n],
  [-0xffffffffn, -4n, -0xffffffff0n],
  [-0xfffffffen, -4n, -0xfffffffe0n],
  [-0x80000001n, -4n, -0x800000010n],
  [-0x80000000n, -4n, -0x800000000n],
  [-0x7fffffffn, -4n, -0x7fffffff0n],
  [-0x7ffffffen, -4n, -0x7ffffffe0n],
  [-9n, -4n, -0x90n],
  [-8n, -4n, -0x80n],
  [-7n, -4n, -0x70n],
  [-6n, -4n, -0x60n],
  [-5n, -4n, -0x50n],
  [-4n, -4n, -0x40n],
  [-3n, -4n, -0x30n],
  [-2n, -4n, -0x20n],
  [-1n, -4n, -0x10n],
  [0n, -4n, 0n],
  [1n, -4n, 0x10n],
  [2n, -4n, 0x20n],
  [3n, -4n, 0x30n],
  [4n, -4n, 0x40n],
  [5n, -4n, 0x50n],
  [6n, -4n, 0x60n],
  [7n, -4n, 0x70n],
  [8n, -4n, 0x80n],
  [9n, -4n, 0x90n],
  [0x7ffffffen, -4n, 0x7ffffffe0n],
  [0x7fffffffn, -4n, 0x7fffffff0n],
  [0x80000000n, -4n, 0x800000000n],
  [0x80000001n, -4n, 0x800000010n],
  [0xfffffffen, -4n, 0xfffffffe0n],
  [0xffffffffn, -4n, 0xffffffff0n],
  [0x100000000n, -4n, 0x1000000000n],
  [0x100000001n, -4n, 0x1000000010n],
  [-0x100000000n, -0x1fn, -0x8000000000000000n],
  [-0xffffffffn, -0x1fn, -0x7fffffff80000000n],
  [-0xfffffffen, -0x1fn, -0x7fffffff00000000n],
  [-0x80000001n, -0x1fn, -0x4000000080000000n],
  [-0x80000000n, -0x1fn, -0x4000000000000000n],
  [-0x7fffffffn, -0x1fn, -0x3fffffff80000000n],
  [-0x7ffffffen, -0x1fn, -0x3fffffff00000000n],
  [-9n, -0x1fn, -0x480000000n],
  [-8n, -0x1fn, -0x400000000n],
  [-7n, -0x1fn, -0x380000000n],
  [-6n, -0x1fn, -0x300000000n],
  [-5n, -0x1fn, -0x280000000n],
  [-4n, -0x1fn, -0x200000000n],
  [-3n, -0x1fn, -0x180000000n],
  [-2n, -0x1fn, -0x100000000n],
  [-1n, -0x1fn, -0x80000000n],
  [0n, -0x1fn, 0n],
  [1n, -0x1fn, 0x80000000n],
  [2n, -0x1fn, 0x100000000n],
  [3n, -0x1fn, 0x180000000n],
  [4n, -0x1fn, 0x200000000n],
  [5n, -0x1fn, 0x280000000n],
  [6n, -0x1fn, 0x300000000n],
  [7n, -0x1fn, 0x380000000n],
  [8n, -0x1fn, 0x400000000n],
  [9n, -0x1fn, 0x480000000n],
  [0x7ffffffen, -0x1fn, 0x3fffffff00000000n],
  [0x7fffffffn, -0x1fn, 0x3fffffff80000000n],
  [0x80000000n, -0x1fn, 0x4000000000000000n],
  [0x80000001n, -0x1fn, 0x4000000080000000n],
  [0xfffffffen, -0x1fn, 0x7fffffff00000000n],
  [0xffffffffn, -0x1fn, 0x7fffffff80000000n],
  [-0x80000000n, -0x20n, -0x8000000000000000n],
  [-0x7fffffffn, -0x20n, -0x7fffffff00000000n],
  [-0x7ffffffen, -0x20n, -0x7ffffffe00000000n],
  [-9n, -0x20n, -0x900000000n],
  [-8n, -0x20n, -0x800000000n],
  [-7n, -0x20n, -0x700000000n],
  [-6n, -0x20n, -0x600000000n],
  [-5n, -0x20n, -0x500000000n],
  [-4n, -0x20n, -0x400000000n],
  [-3n, -0x20n, -0x300000000n],
  [-2n, -0x20n, -0x200000000n],
  [-1n, -0x20n, -0x100000000n],
  [0n, -0x20n, 0n],
  [1n, -0x20n, 0x100000000n],
  [2n, -0x20n, 0x200000000n],
  [3n, -0x20n, 0x300000000n],
  [4n, -0x20n, 0x400000000n],
  [5n, -0x20n, 0x500000000n],
  [6n, -0x20n, 0x600000000n],
  [7n, -0x20n, 0x700000000n],
  [8n, -0x20n, 0x800000000n],
  [9n, -0x20n, 0x900000000n],
  [0x7ffffffen, -0x20n, 0x7ffffffe00000000n],
  [0x7fffffffn, -0x20n, 0x7fffffff00000000n],
  [-1n, -0x3fn, -0x8000000000000000n],
  [0n, -0x3fn, 0n],
  [0n, -0x40n, 0n],
];

// Cases not covered above.
tests.push(
  // Positive shift with sign-bit set when interpreted as pointer-sized value (32-bit).
  [-1n, 0xf000_0000n, -1n],
  [0n, 0xf000_0000n, 0n],
  [1n, 0xf000_0000n, 0n],
);

function f(tests) {
  for (let test of tests) {
    let lhs = test[0], rhs = test[1], expected = test[2];
    assertEq(BigInt.asIntN(64, lhs), lhs);
    assertEq(BigInt.asIntN(64, rhs), rhs);
    assertEq(BigInt.asIntN(64, expected), expected);

    let f = Function(`
      let lhs = ${lhs}n;
      let rhs = ${rhs}n;
      assertEq(lhs >> rhs, ${expected}n);
    `);

    for (let j = 0; j < 100; ++j) {
      f();
    }
  }
}

f(tests);
