// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar<p>extra",
    [["indent",""]],
    ["<blockquote>foo[]bar</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo[]bar</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span><p>extra",
    [["indent",""]],
    ["<blockquote><span>foo</span>{}<span>bar</span></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><span>foo</span>{}<span>bar</span></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span><p>extra",
    [["indent",""]],
    ["<blockquote><span>foo[</span><span>]bar</span></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><span>foo[</span><span>]bar</span></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo[bar]baz<p>extra",
    [["indent",""]],
    ["<blockquote>foo[bar]baz</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo[bar]baz</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p dir=rtl>פו[בר]בז<p dir=rtl>נוםף",
    [["indent",""]],
    ["<blockquote><p dir=\"rtl\">פו[בר]בז</p></blockquote><p dir=\"rtl\">נוםף</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p dir=\"rtl\">פו[בר]בז</p></blockquote><p dir=\"rtl\">נוםף</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p dir=rtl>פו[ברבז<p>Foobar]baz<p>Extra",
    [["indent",""]],
    ["<blockquote><p dir=\"rtl\">פו[ברבז</p><p>Foobar]baz</p></blockquote><p>Extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p dir=\"rtl\">פו[ברבז</p><p>Foobar]baz</p></blockquote><p>Extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>Foo[barbaz<p dir=rtl>פובר]בז<p>Extra",
    [["indent",""]],
    ["<blockquote><p>Foo[barbaz</p><p dir=\"rtl\">פובר]בז</p></blockquote><p>Extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>Foo[barbaz</p><p dir=\"rtl\">פובר]בז</p></blockquote><p>Extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<div><p>Foo[barbaz<p dir=rtl>פובר]בז</div><p>Extra",
    [["indent",""]],
    ["<blockquote><div><p>Foo[barbaz</p><p dir=\"rtl\">פובר]בז</p></div></blockquote><p>Extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><div><p>Foo[barbaz</p><p dir=\"rtl\">פובר]בז</p></div></blockquote><p>Extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo]bar[baz<p>extra",
    [["indent",""]],
    ["<blockquote>foo[bar]baz</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo[bar]baz</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["{<p><p> <p>foo</p>}<p>extra",
    [["indent",""]],
    ["<blockquote>{<p></p><p> </p><p>foo</p>}</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">{<p></p><p> </p><p>foo</p>}</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
    [["indent",""]],
    ["<blockquote>foo[bar<i>baz]qoz</i>quz</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo[bar<i>baz]qoz</i>quz</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["[]foo<p>extra",
    [["indent",""]],
    ["<blockquote>[]foo</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">[]foo</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo[]<p>extra",
    [["indent",""]],
    ["<blockquote>foo[]</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo[]</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[]foo<p>extra",
    [["indent",""]],
    ["<blockquote><p>[]foo</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[]foo</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo[]<p>extra",
    [["indent",""]],
    ["<blockquote><p>foo[]</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>{}<br>foo</p><p>extra",
    [["indent",""]],
    ["<blockquote>{}<br></blockquote><p>foo</p><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">{}<br></blockquote><p>foo</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<br>{}</p><p>extra",
    [["indent",""]],
    ["<blockquote><p>foo{}</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo{}</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<span>{}<br>foo</span>bar<p>extra",
    [["indent",""]],
    ["<blockquote>{}<br></blockquote><span>foo</span>bar<p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">{}<br></blockquote><span>foo</span>bar<p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<span>foo<br>{}</span>bar<p>extra",
    [["indent",""]],
    ["<span>foo{}</span><blockquote>bar</blockquote><p>extra</p>",
     "<span>foo{}</span><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">bar</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo</p>{}<p>bar</p>",
    [["indent",""]],
    "<p>foo</p>{}<p>bar</p>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
    [["indent",""]],
    ["<table><tbody><tr><td>foo</td><td><blockquote>b[a]r</blockquote></td><td>baz</td></tr></tbody></table><p>extra</p>",
     "<table><tbody><tr><td>foo</td><td><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">b[a]r</blockquote></td><td>baz</td></tr></tbody></table><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["indent",""]],
    ["<table><tbody><tr><td>foo</td>{<td><blockquote>bar</blockquote></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
     "<table><tbody><tr><td>foo</td>{<td><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">bar</blockquote></td>}<td>baz</td></tr></tbody></table><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["indent",""]],
    ["<table><tbody><tr>{<td><blockquote>foo</blockquote></td><td><blockquote>bar</blockquote></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
     "<table><tbody><tr>{<td><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo</blockquote></td><td><blockquote>bar</blockquote></td>}<td>baz</td></tr></tbody></table><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
    [["indent",""]],
    ["<blockquote><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
    [["indent",""]],
    ["<blockquote><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}<p>extra",
    [["indent",""]],
    ["<blockquote>{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo[bar]</p><p>baz</p><p>extra",
    [["indent",""]],
    ["<blockquote><p>foo[bar]</p></blockquote><p>baz</p><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foobar</p><p>ba]z</p><p>extra",
    [["indent",""]],
    ["<blockquote><p>[foobar</p><p>ba]z</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foobar</p><p>ba]z</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo[bar]<br>baz<p>extra",
    [["indent",""]],
    ["<blockquote>foo[bar]</blockquote>baz<p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo[bar]</blockquote>baz<p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo[bar]<br><br><br><br>baz<p>extra",
    [["indent",""]],
    ["<blockquote>foo[bar]</blockquote><br><br><br>baz<p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo[bar]</blockquote><br><br><br>baz<p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foobar<br>[ba]z<p>extra",
    [["indent",""]],
    ["foobar<blockquote>[ba]z</blockquote><p>extra</p>",
     "foobar<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">[ba]z</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foobar<br><br><br><br>[ba]z<p>extra",
    [["indent",""]],
    ["foobar<br><br><br><br><blockquote>[ba]z</blockquote><p>extra</p>",
     "foobar<br><br><br><br><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">[ba]z</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo[bar<br>ba]z<p>extra",
    [["indent",""]],
    ["<blockquote>foo[bar<br>ba]z</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo[bar<br>ba]z</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<div>foo<p>[bar]</p>baz</div><p>extra",
    [["indent",""]],
    ["<div>foo<blockquote><p>[bar]</p></blockquote>baz</div><p>extra</p>",
     "<div>foo<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"<p>[bar]</p></blockquote>baz</div><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>",
     "<blockquote><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>",
     "<blockquote><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>",
     "<blockquote><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>",
     "<blockquote><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo]</p><p>bar</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo]</p><p>bar</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote><p>b]ar</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo</p><blockquote><p>b]ar</p></blockquote></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo</p><blockquote><p>b]ar</p></blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote><p>bar</blockquote><p>[baz]<p>extra",
    [["indent",""]],
    ["<p>foo</p><blockquote><p>bar</p><p>[baz]</p></blockquote><p>extra</p>",
     "<p>foo</p><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p><p>[baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote><p>[bar</blockquote><p>baz]<p>extra",
    [["indent",""]],
    ["<p>foo</p><blockquote><blockquote><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
     "<p>foo</p><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote><p>bar</blockquote><p>baz]<p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo</p><blockquote><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo</p><blockquote><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo</blockquote><p>[bar]<blockquote><p>baz</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><p>foo</p><p>[bar]</p><p>baz</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo</p><p>[bar]</p><p>baz</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote>foo[bar]<br>baz</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote>foo[bar]</blockquote>baz</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote>foo[bar]</blockquote>baz</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote>foo[bar<br>b]az</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote>foo[bar<br>b]az</blockquote></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote>foo[bar<br>b]az</blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote>foo[bar]</blockquote>baz<p>extra",
    [["indent",""]],
    ["<blockquote><blockquote>foo[bar]</blockquote></blockquote>baz<p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote>foo[bar]</blockquote></blockquote>baz<p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote>foo[bar</blockquote>b]az<p>extra",
    [["indent",""]],
    ["<blockquote><blockquote>foo[bar</blockquote>b]az</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote>foo[bar</blockquote>b]az</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["[foo]<blockquote>bar</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote>[foo]<br>bar</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">[foo]<br>bar</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["[foo<blockquote>b]ar</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote>[foo<blockquote>b]ar</blockquote></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">[foo<blockquote>b]ar</blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo<blockquote>bar</blockquote>[baz]<p>extra",
    [["indent",""]],
    ["foo<blockquote>bar<br>[baz]</blockquote><p>extra</p>",
     "foo<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">bar<br>[baz]</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["[foo<blockquote>bar</blockquote>baz]<p>extra",
    [["indent",""]],
    ["<blockquote>[foo<blockquote>bar</blockquote>baz]</blockquote><p>extra</p>",
     "<blockquote>[foo<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">bar</blockquote>baz]</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote>foo</blockquote>[bar]<blockquote>baz</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote>foo<br>[bar]<br>baz</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo<br>[bar]<br>baz</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["indent",""]],
    ["<blockquote style=\"margin-right:0\" dir=\"ltr\"><blockquote><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin-right:0\" dir=\"ltr\"><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo]<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>bar</blockquote><p>extra",
    [["indent",""]],
    "<blockquote style=\"margin-right:0\" dir=\"ltr\"><p>[foo]</p><p>bar</p></blockquote><p>extra</p>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>b]ar</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo</p><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>b]ar</p></blockquote></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo</p><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>b]ar</p></blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>bar</blockquote><p>[baz]<p>extra",
    [["indent",""]],
    "<p>foo</p><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>bar</p><p>[baz]</p></blockquote><p>extra</p>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>[bar</blockquote><p>baz]<p>extra",
    [["indent",""]],
    ["<p>foo</p><blockquote><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
     "<p>foo</p><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>bar</blockquote><p>baz]<p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo</p><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo</p><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo</blockquote><p>[bar]<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>baz</blockquote><p>extra",
    [["stylewithcss","true"],["indent",""]],
    "<blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo</p><p>[bar]</p><p>baz</p></blockquote><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo</blockquote><p>[bar]<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>baz</blockquote><p>extra",
    [["stylewithcss","false"],["indent",""]],
    "<blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo</p><p>[bar]</p><p>baz</p></blockquote><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar]</p><p style=\"margin-left: 40px\">baz</p><p>extra",
    [["indent",""]],
    ["<blockquote><p style=\"margin-left:40px\">foo[bar]</p></blockquote><p style=\"margin-left:40px\">baz</p><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p style=\"margin-left:40px\">foo[bar]</p></blockquote><p style=\"margin-left:40px\">baz</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar</p><p style=\"margin-left: 40px\">b]az</p><p>extra",
    [["indent",""]],
    ["<blockquote><p style=\"margin-left:40px\">foo[bar</p><p style=\"margin-left:40px\">b]az</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p style=\"margin-left:40px\">foo[bar</p><p style=\"margin-left:40px\">b]az</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar]</p><p>baz</p><p>extra",
    [["indent",""]],
    ["<blockquote><p style=\"margin-left:40px\">foo[bar]</p></blockquote><p>baz</p><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p style=\"margin-left:40px\">foo[bar]</p></blockquote><p>baz</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar</p><p>b]az</p><p>extra",
    [["indent",""]],
    ["<blockquote><p style=\"margin-left:40px\">foo[bar</p><p>b]az</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p style=\"margin-left:40px\">foo[bar</p><p>b]az</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo]<p style=\"margin-left: 40px\">bar<p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo]</p></blockquote><p style=\"margin-left:40px\">bar</p><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo]</p></blockquote><p style=\"margin-left:40px\">bar</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo<p style=\"margin-left: 40px\">b]ar<p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo</p><p style=\"margin-left:40px\">b]ar</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo</p><p style=\"margin-left:40px\">b]ar</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<p style=\"margin-left: 40px\">bar<p>[baz]<p>extra",
    [["indent",""]],
    ["<p>foo</p><p style=\"margin-left:40px\">bar</p><blockquote><p>[baz]</p></blockquote><p>extra</p>",
     "<p>foo</p><p style=\"margin-left:40px\">bar</p><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<p style=\"margin-left: 40px\">[bar<p>baz]<p>extra",
    [["indent",""]],
    ["<p>foo</p><blockquote><p style=\"margin-left:40px\">[bar</p><p>baz]</p></blockquote><p>extra</p>",
     "<p>foo</p><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p style=\"margin-left:40px\">[bar</p><p>baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo<p style=\"margin-left: 40px\">bar<p>baz]<p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo</p><p style=\"margin-left:40px\">bar</p><p>baz]</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo</p><p style=\"margin-left:40px\">bar</p><p>baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo<p>[bar]<p style=\"margin-left: 40px\">baz<p>extra",
    [["indent",""]],
    ["<p style=\"margin-left:40px\">foo</p><blockquote><p>[bar]</p></blockquote><p style=\"margin-left:40px\">baz</p><p>extra</p>",
     "<p style=\"margin-left:40px\">foo</p><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[bar]</p></blockquote><p style=\"margin-left:40px\">baz</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["indent",""]],
    ["<blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>",
     "<blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo]<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>bar</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo]</p></blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo]</p></blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>b]ar</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>b]ar</p></blockquote></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>b]ar</p></blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>bar</blockquote><p>[baz]<p>extra",
    [["indent",""]],
    ["<p>foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><blockquote><p>[baz]</p></blockquote><p>extra</p>",
     "<p>foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>[bar</blockquote><p>baz]<p>extra",
    [["indent",""]],
    ["<p>foo</p><blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
     "<p>foo</p><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>bar</blockquote><p>baz]<p>extra",
    [["indent",""]],
    ["<blockquote><p>[foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo</blockquote><p>[bar]<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>baz</blockquote><p>extra",
    [["indent",""]],
    ["<blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo</p></blockquote><blockquote><p>[bar]</p></blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>baz</p></blockquote><p>extra</p>",
     "<blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo</p></blockquote><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[bar]</p></blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>baz</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote>f[oo<blockquote>b]ar</blockquote></blockquote><p>extra",
    [["indent",""]],
    ["<blockquote><blockquote>f[oo<blockquote>b]ar</blockquote></blockquote></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote>f[oo<blockquote>b]ar</blockquote></blockquote></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar]</li></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol data-start=1 data-end=2><li>foo<li>bar<li>baz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol>{<li>bar</li>}</ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[bar]",
    [["indent",""]],
    "<ol><li>foo</li></ol><blockquote>[bar]</blockquote>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
    [["indent",""]],
    "<ol><ol><li>[foo]<br>bar</li></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
    [["indent",""]],
    "<ol><ol><li>foo<br>[bar]</li></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
    [["indent",""]],
    "<ol><ol><li><div>[foo]</div>bar</li></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]<li>baz</ol><li>quz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><ol><li>[bar]</li></ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>[baz]</ol><li>quz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li><ol><li>[baz]</li></ol></ol><li>quz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>[bar]<li>baz</ol><li>quz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><ol><li>[bar]</li></ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol data-start=0 data-end=1><li>bar<li>baz</ol><li>quz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><ol>{<li>bar</li>}</ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>[baz]</ol><li>quz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li><ol><li>[baz]</li></ol></ol><li>quz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol data-start=1 data-end=2><li>bar<li>baz</ol><li>quz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li><ol>{<li>baz</li>}</ol></ol><li>quz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>b[a]r</ol><li>baz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><ol><li>b[a]r</li></ol></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>b[a]r</ol><li>baz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><ol><li>b[a]r</li></ol></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo{<ol><li>bar</ol>}<li>baz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol>{<ol><li>bar</li></ol>}</ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li>{<ol><li>bar</ol>}<li>baz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol>{<ol><li>bar</li></ol>}</ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
    [["indent",""]],
    "<ol><ol><li>[foo]</li><li>bar</li></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
    [["indent",""]],
    "<ol><ol><li>[foo]</li><li>bar</li></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar]</li><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar]</li><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li><li>baz</li><li>[quz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li><li>baz</li><li>[quz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><ol id=u1><li id=i1>foo</ol><li id=i2>[bar]</li><ol id=u3><li id=i3>baz</ol></ol>",
    [["indent",""]],
    "<ol><ol id=\"u1\"><li id=\"i1\">foo</li><li id=\"i2\">[bar]</li><li id=\"i3\">baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><ol><li id=i1>foo</ol><li id=i2>[bar]</li><ol id=u3><li id=i3>baz</ol></ol>",
    [["indent",""]],
    "<ol><ol><li id=\"i1\">foo</li><li id=\"i2\">[bar]</li><li id=\"i3\">baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><ol id=u1><li id=i1>foo</ol><li id=i2>[bar]</li><ol><li id=i3>baz</ol></ol>",
    [["indent",""]],
    "<ol><ol id=\"u1\"><li id=\"i1\">foo</li><li id=\"i2\">[bar]</li><li id=\"i3\">baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li id=i2>[bar]</li><ol id=u3><li id=i3>baz</ol></ol>",
    [["indent",""]],
    "<ol><ol id=\"u3\"><li id=\"i2\">[bar]</li><li id=\"i3\">baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><ol id=u1><li id=i1>foo</ol><li id=i2>[bar]</ol>",
    [["indent",""]],
    "<ol><ol id=\"u1\"><li id=\"i1\">foo</li><li id=\"i2\">[bar]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>b[ar<li>baz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>b[ar</li><li>baz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
    [["indent",""]],
    "<ol><ol><li>[foo</li><ol><li>bar]</li></ol></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo</li><ol><li>bar]</ol><li>baz</ol>",
    [["indent",""]],
    "<ol><ol><li>[foo</li><ol><li>bar]</li></ol></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><ol><li>b[ar</li></ol><li>b]az</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>b[ar</ol><li>b]az</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><ol><li>b[ar</li></ol><li>b]az</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
    [["indent",""]],
    ["<blockquote><ol><li>[foo</li><ol><li>bar</li></ol><li>baz]</li></ol></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><ol><li>[foo</li><ol><li>bar</li></ol><li>baz]</li></ol></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo</li><ol><li>bar</ol><li>baz]</ol><p>extra",
    [["indent",""]],
    ["<blockquote><ol><li>[foo</li><ol><li>bar</li></ol><li>baz]</li></ol></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><ol><li>[foo</li><ol><li>bar</li></ol><li>baz]</li></ol></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
    [["indent",""]],
    "<ol><ol><li>[foo]</li><li>bar</li></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]</ol>baz</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><ol><li>[bar]</li></ol></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
    [["indent",""]],
    "<ol><ol><li>foo<ol><li>bar</li></ol>[baz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
    [["indent",""]],
    "<ol><ol><li>[foo</li><ol><li>bar]</li></ol></ol><li>baz</li></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["foo<!--bar-->[baz]<p>extra",
    [["indent",""]],
    ["<blockquote>foo<!--bar-->[baz]</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">foo<!--bar-->[baz]</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["[foo]<!--bar-->baz<p>extra",
    [["indent",""]],
    ["<blockquote>[foo]<!--bar-->baz</blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">[foo]<!--bar-->baz</blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>foo<!--bar-->{}<p>extra",
    [["indent",""]],
    ["<blockquote><p>foo<!--bar-->{}</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo<!--bar-->{}</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>{}<!--foo-->bar<p>extra",
    [["indent",""]],
    ["<blockquote><p>{}<!--foo-->bar</p></blockquote><p>extra</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>{}<!--foo-->bar</p></blockquote><p>extra</p>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo</blockquote> <p>[bar]",
    [["indent",""]],
    ["<blockquote><p>foo</p> <p>[bar]</p></blockquote>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo</p> <p>[bar]</p></blockquote>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[foo]</p> <blockquote><p>bar</blockquote>",
    [["indent",""]],
    ["<blockquote><p>[foo]</p> <p>bar</p></blockquote>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[foo]</p> <p>bar</p></blockquote>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo</blockquote> <p>[bar]</p> <blockquote><p>baz</blockquote>",
    [["indent",""]],
    ["<blockquote><p>foo</p> <p>[bar]</p> <p>baz</p></blockquote>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo</p> <p>[bar]</p> <p>baz</p></blockquote>"],
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar</li> </ol><li>[baz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li> <li>[baz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar</li></ol> <li>[baz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li> <li>[baz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar</li> </ol> <li>[baz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li>  <li>[baz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</li> </ol></li><li>[baz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li> <li>[baz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</li></ol></li> <li>[baz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li> <li>[baz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</li> </ol></li> <li>[baz]</ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>bar</li>  <li>[baz]</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li> <ol><li>baz</ol></ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar]</li> <li>baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol> <li>baz</ol></ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar]</li> <li>baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li> <ol> <li>baz</ol></ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar]</li>  <li>baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar] <ol><li>baz</ol></ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar] </li><li>baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol> <li>baz</ol></ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar]</li> <li>baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar] <ol> <li>baz</ol></ol>",
    [["indent",""]],
    "<ol><li>foo</li><ol><li>[bar] </li> <li>baz</li></ol></ol>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<ul><li>a<br>{<br>}</li><li>b</li></ul>",
    [["indent",""]],
    "<ul><ul><li>a<br>{<br>}</li></ul><li>b</li></ul>",
    [true],
    {"indent":[false,false,"",false,false,""]}],
["<p>[abc]</p>",
    [["stylewithcss","true"],["indent",""]],
    ["<p style=\"margin-left:40px\">abc</p>",
     "<blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>abc</p></blockquote>"],
    [true,true],
    {"indent":[false,false,"",false,false,""]}],
["<div contenteditable=false><div contenteditable>[abc]</div></div>",
    [["stylewithcss","true"],["indent",""]],
    ["<div contenteditable=\"false\"><div contenteditable=\"\"><div style=\"margin-left:40px\">abc</div></div></div>",
     "<div contenteditable=\"false\"><div contenteditable=\"\"><blockquote style=\"margin:0 0 0 40px; border:none; padding:0px\">abc</blockquote></div></div>"],
    [true,true],
    {"indent":[false,false,"",false,false,""]}],
]
