CSS Grid Layout Module Level 1 Test Suite
-----------------------------------------

Directory containing the CSS Grid Layout spec test suite.

This suite is structured in different folders for each section of the spec
(the name of the folders corresponds to the "id" of each section):

* [3 Grid Containers](https://drafts.csswg.org/css-grid-1/#grid-model):
  `grid-model`
* [4 Grid Items](https://drafts.csswg.org/css-grid-1/#grid-items):
  `grid-items`
* [5 The Explicit Grid](https://drafts.csswg.org/css-grid-1/#grid-definition):
  `grid-definition`
* [6 The Implicit Grid](https://drafts.csswg.org/css-grid-1/#implicit-grids):
  `implicit-grids`
* [7 Grid Definition Shorthand](https://drafts.csswg.org/css-grid-1/#grid-shorthand):
  `grid-shorthand`
* [8 Clamping Overlarge Grids](https://drafts.csswg.org/css-grid-1/#overlarge-grids):
  `overlarge-grids`
* [9 Placing Grid Items](https://drafts.csswg.org/css-grid-1/#placement):
  `placement`
* [10 Absolute Positioning](https://drafts.csswg.org/css-grid-1/#abspos):
  `abspos`
* [11 Alignment and Spacing](https://drafts.csswg.org/css-grid-1/#alignment):
  `alignment`
* [12 Grid Sizing](https://drafts.csswg.org/css-grid-1/#layout-algorithm):
  `layout-algorithm`
* [13 Fragmenting Grid Layout](https://drafts.csswg.org/css-grid-1/#pagination):
  `pagination`

Links:

* [Spec Editor's Draft](https://drafts.csswg.org/css-grid-1/)
* [Test Plan](http://test.csswg.org/source/css-grid-1/test-plan/)
* [Test Suite](http://test.csswg.org/suites/css-grid-1_dev/nightly-unstable/)
